/*
 * Decompiled with CFR 0.152.
 */
package JGDS2;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;

public class GDSInput {
    public static void main(String[] args) {
        GDSInput.readFile(args[0]);
    }

    public static StringBuffer readFile(String args) {
        return new GDSInput().parse(args);
    }

    public StringBuffer parse(String args) {
        boolean ar = false;
        StringBuffer so = new StringBuffer("");
        try {
            FileInputStream fileIN = new FileInputStream(args);
            DataInputStream dataIN = new DataInputStream(fileIN);
            int c = 0;
            String sep = "  ";
            int i = 0;
            int t = 0;
            boolean more = true;
            while (more) {
                short b = dataIN.readShort();
                ++i;
                if (c == 0) {
                    so.append("\r\n");
                    i = 1;
                    c = b;
                    if (c < 0) {
                        c = c << 16 >>> 16;
                    }
                    b = dataIN.readShort();
                }
                if ((c -= 4) < 0) continue;
                byte[] ba = new byte[c];
                t += c + 4;
                dataIN.read(ba);
                switch (b) {
                    case 7173: {
                        so.append("ANGLE" + sep);
                        so.append(this.GDSlongTodouble(ba));
                        break;
                    }
                    case 2816: {
                        so.append("AREF" + sep);
                        ar = true;
                        break;
                    }
                    case 8966: {
                        so.append("ATTRTABLE" + sep);
                        so.append(this.showHex(ba));
                        break;
                    }
                    case 258: {
                        so.append("BGNLIB" + sep);
                        so.append(GDSInput.showNum(ba));
                        break;
                    }
                    case 1282: {
                        so.append("BGNSTR" + sep);
                        so.append(GDSInput.showNum(ba));
                        break;
                    }
                    case 2048: {
                        so.append("BOUNDARY" + sep);
                        break;
                    }
                    case 11520: {
                        so.append("BOX" + sep);
                        so.append(this.showHex(ba));
                        break;
                    }
                    case 11778: {
                        so.append("BOXTYPE" + sep);
                        so.append(this.showHex(ba));
                        break;
                    }
                    case 4866: {
                        so.append("COLROW" + sep);
                        so.append(this.showShort(ba));
                        if (ba.length != 4) {
                            String er = "GDSReader.parse COLROW must be 4 bytes, (byte[" + ba.length + "]) ";
                            so.append(er);
                            throw new UnParsableException(er);
                        }
                        if (this.getShort(ba, 0) != 0 && this.getShort(ba, 2) != 0) break;
                        String er = "GDSReader.parse COLROW must not contain 0";
                        so.append(er);
                        throw new UnParsableException(er);
                    }
                    case 3586: {
                        so.append("DATATYPE" + sep);
                        so.append(GDSInput.showNum(ba));
                        break;
                    }
                    case 9729: {
                        so.append("ELFLAGS" + sep);
                        so.append(this.showHex(ba));
                        break;
                    }
                    case 1024: {
                        so.append("ENDLIB" + sep);
                        break;
                    }
                    case 4352: {
                        so.append("ENDEL" + sep);
                        ar = false;
                        break;
                    }
                    case 14336: {
                        so.append("ENDMASK" + sep);
                        so.append(this.showHex(ba));
                        break;
                    }
                    case 1792: {
                        so.append("ENDSTR" + sep);
                        break;
                    }
                    case 8198: {
                        so.append("FONTS" + sep);
                        so.append(this.showHex(ba));
                        break;
                    }
                    case 13826: {
                        so.append("FORMAT" + sep);
                        so.append(this.showHex(ba));
                        break;
                    }
                    case 8706: {
                        so.append("GENERATIONS" + sep);
                        so.append(this.showHex(ba));
                        break;
                    }
                    case 2: {
                        so.append("HEADER" + sep);
                        so.append(GDSInput.showNum(ba));
                        break;
                    }
                    case 3330: {
                        so.append("LAYER" + sep);
                        so.append(GDSInput.showNum(ba));
                        break;
                    }
                    case 518: {
                        so.append("LIBNAME" + sep);
                        so.append(new String(ba, "US-ASCII"));
                        break;
                    }
                    case 6917: {
                        so.append("MAG" + sep);
                        so.append(this.GDSlongTodouble(ba));
                        break;
                    }
                    case 14086: {
                        so.append("MASK" + sep);
                        so.append(this.showHex(ba));
                        break;
                    }
                    case 5376: {
                        so.append("NODE" + sep);
                        so.append(this.showHex(ba));
                        break;
                    }
                    case 10754: {
                        so.append("NODETYPE" + sep);
                        so.append(this.showHex(ba));
                        break;
                    }
                    case 2304: {
                        ar = true;
                        so.append("PATH" + sep);
                        so.append(this.showHex(ba));
                        break;
                    }
                    case 8450: {
                        so.append("PATHTYPE" + sep);
                        so.append(this.showHex(ba));
                        break;
                    }
                    case 12035: {
                        so.append("PLEX" + sep);
                        so.append(this.showHex(ba));
                        break;
                    }
                    case 5889: {
                        so.append("PRESENTATION" + sep);
                        so.append(this.showHex(ba));
                        break;
                    }
                    case 11010: {
                        so.append("PROPATTR" + sep);
                        so.append(this.showHex(ba));
                        break;
                    }
                    case 11270: {
                        so.append("PROPVALUE" + sep);
                        so.append(this.showHex(ba));
                        break;
                    }
                    case 7942: {
                        so.append("REFLIBS" + sep);
                        so.append(this.showHex(ba));
                        break;
                    }
                    case 4614: {
                        so.append("SNAME" + sep);
                        so.append("\"" + new String(ba, "US-ASCII") + "\"");
                        break;
                    }
                    case 2560: {
                        so.append("SREF" + sep);
                        break;
                    }
                    case 6657: {
                        so.append("STRANS" + sep);
                        so.append(this.showHex(ba));
                        break;
                    }
                    case 6406: {
                        so.append("STRING" + sep);
                        break;
                    }
                    case 1542: {
                        so.append("STRNAME" + sep);
                        so.append("\"" + new String(ba, "US-ASCII") + "\"");
                        break;
                    }
                    case 12802: {
                        so.append("TAPENUM" + sep);
                        so.append(this.showHex(ba));
                        break;
                    }
                    case 13058: {
                        so.append("TAPECODE" + sep);
                        so.append(this.showHex(ba));
                        break;
                    }
                    case 3072: {
                        so.append("TEXT" + sep);
                        so.append(this.showHex(ba));
                        break;
                    }
                    case 5634: {
                        so.append("TEXTTYPE" + sep);
                        so.append(this.showHex(ba));
                        break;
                    }
                    case 773: {
                        so.append("UNITS" + sep);
                        so.append(this.GDSlongTodouble(ba));
                        break;
                    }
                    case 3843: {
                        so.append("WIDTH" + sep);
                        so.append(GDSInput.showNum(ba));
                        break;
                    }
                    case 4099: {
                        so.append("XY" + sep + c / 8 + " point(s)\r\n");
                        so.append(this.showInt(ba));
                        if (ba.length % 8 != 0) {
                            String er = "GDSReader.parse XY must be multiples of 8 bytes, (byte[" + ba.length + "]) ";
                            so.append(er);
                            throw new UnParsableException(er);
                        }
                        int x = this.getInt(ba, 0);
                        int y = this.getInt(ba, 4);
                        if (x == this.getInt(ba, ba.length - 8) && y == this.getInt(ba, ba.length - 4) || ar) break;
                        String er = "GDSReader.parse XY first and last point must be the same (point[1]=" + x + "," + y + " point[" + ba.length / 8 + "]=" + this.getInt(ba, ba.length - 8) + "," + this.getInt(ba, ba.length - 4) + ") ";
                        so.append(er);
                        throw new UnParsableException(er);
                    }
                    default: {
                        so.append("??????? " + b + sep);
                        so.append(this.showInt(ba));
                        throw new UnParsableException(" Unknown header = " + b + " record length = " + ba.length + " ");
                    }
                }
                c = 0;
                so.append("   (" + t + ")");
            }
            fileIN.close();
        }
        catch (IOException e) {
            System.out.println(e);
        }
        catch (UnParsableException e) {
            System.err.println(e);
            so.append("\r\n");
            so.append(e);
        }
        return so;
    }

    public static String showNum(byte[] b) {
        StringBuffer so = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            so.append(b[i] + " ");
        }
        return so.toString();
    }

    String showSort(byte[] b) throws UnParsableException {
        StringBuffer so = new StringBuffer();
        if (b.length % 2 != 0) {
            String er = "GDSReader.showHex(byte[" + b.length + "]) requires an even byte #";
            so.append(er);
            throw new UnParsableException(er);
        }
        for (int i = 0; i < b.length; i += 2) {
            so.append(b[i] + b[i + 1] + " ");
        }
        return so.toString();
    }

    String showHex(byte[] b) throws UnParsableException {
        StringBuffer so = new StringBuffer();
        if (b.length % 2 != 0) {
            String er = "GDSReader.showHex(byte[" + b.length + "]) requires an even byte #";
            so.append(er);
            throw new UnParsableException(er);
        }
        String f = "0000";
        for (int i = 0; i < b.length; i += 2) {
            int s = b[i];
            s = s << 8 | b[i + 1] & 0xFF;
            String temp = f + Long.toHexString(s);
            temp = temp.substring(temp.length() - 4, temp.length());
            so.append(temp);
        }
        return so.toString();
    }

    String GDSlongTodouble(byte[] b) throws UnParsableException {
        StringBuffer so = new StringBuffer();
        long c = 0L;
        if (b.length % 8 != 0) {
            String er = "GDSReader.GDSlongTodouble(byte[" + b.length + "] arg). arg.length%8!=0";
            so.append(er);
            throw new UnParsableException(er);
        }
        for (int j = 0; j < b.length; j += 8) {
            byte[] cn = new byte[]{b[j], b[j + 1], b[j + 2], b[j + 3], b[j + 4], b[j + 5], b[j + 6], b[j + 7]};
            c = new BigInteger(cn).longValue();
            int i = 1;
            long e = ((c >>> 56 & 0x7FL) - 64L & 0x3FFL) << 2;
            long out = c & Long.MIN_VALUE;
            long d = 0xFFFFFFFFFFFFFFL & c;
            while (d <= 0x100000000000000L & i < 20) {
                d <<= 1;
                ++i;
            }
            if (i > 18) {
                System.err.println("GDSReader GDSlongTodouble stuck " + b[0] + "," + b[1] + "," + b[2] + "," + b[3] + "," + b[4] + "," + b[5] + "," + b[6] + "," + b[7]);
                so.append("GDSReader GDSlongTodouble stuck " + b[0] + "" + b[1] + "" + b[2] + "" + b[3] + "" + b[4] + "" + b[5] + "" + b[6] + "" + b[7]);
                throw new UnParsableException("GDSReader.GDSlongTodouble(byte[" + b.length + "]  = " + b[0] + "," + b[1] + "," + b[2] + "," + b[3] + "," + b[4] + "," + b[5] + "," + b[6] + "," + b[7] + ") stuck");
            }
            e = e - (long)i + 1024L;
            out = out | e << 52 | (d -= 0x100000000000000L) >> 4;
            so.append("" + Double.longBitsToDouble(out) + " ");
        }
        return so.toString();
    }

    String GDSlongTofloat(byte[] b) throws UnParsableException {
        StringBuffer so = new StringBuffer();
        long c = 0L;
        if (b.length % 4 != 0) {
            String er = "GDSReader.GDSlongTofloat(byte[" + b.length + "] arg). arg.length%4!=0";
            so.append(er);
            throw new UnParsableException(er);
        }
        for (int j = 0; j < b.length; j += 4) {
            byte[] cn = new byte[]{b[j], b[j + 1], b[j + 2], b[j + 3]};
            c = new BigInteger(cn).longValue() << 32;
            c = new BigInteger(this.showHex(cn) + "00000000", 16).longValue();
            int i = 1;
            long e = (c >>> 56 & 0x3FL & 0x7FL) << 2;
            long out = c & Long.MIN_VALUE;
            long d = 0xFFFFFFFFFFFFFFL & c;
            while (d <= 0x100000000000000L & i < 20) {
                d <<= 1;
                ++i;
            }
            if (i > 18) {
                System.err.println("GDSReader GDSlongTofloat stuck");
            }
            e = e - (long)i + 1024L;
            out = out | e << 52 | (d -= 0x100000000000000L) >> 4;
            so.append("" + Double.longBitsToDouble(out) + " ");
        }
        return so.toString();
    }

    String showInt(byte[] b) throws UnParsableException {
        StringBuffer so = new StringBuffer();
        if (b.length % 4 != 0) {
            String er = "GDSReader.showInt(byte[" + b.length + "] arg). arg.length%4!=0";
            so.append(er);
            throw new UnParsableException(er);
        }
        for (int i = 0; i < b.length; i += 4) {
            so.append("" + this.getInt(b, i));
            so.append(" ");
        }
        return so.toString();
    }

    int getInt(byte[] b, int offset) throws UnParsableException {
        long s = 0L;
        if (b.length - offset < 4) {
            String er = "GDSReader.getInt(byte[" + b.length + "] offset=" + offset + ") needs 4 bytes above offset";
            throw new UnParsableException(er);
        }
        for (int j = 0; j < 4; ++j) {
            s = s << 8 | (long)(b[j + offset] & 0xFF);
        }
        return (int)s;
    }

    String showShort(byte[] b) throws UnParsableException {
        StringBuffer so = new StringBuffer();
        if (b.length % 2 != 0) {
            so.append("GDSReader.showShort(byte[" + b.length + "] arg). arg.length%2!=0");
            throw new UnParsableException("GDSReader.showShort(byte[" + b.length + "] arg). arg.length%2!=0");
        }
        for (int i = 0; i < b.length; i += 2) {
            so.append(this.getShort(b, i));
            so.append(" ");
        }
        return so.toString();
    }

    int getShort(byte[] b, int i) {
        int s = b[i];
        s = s << 8 | b[i + 1] & 0xFF;
        return s;
    }

    public int floatToGDSint(float n) {
        int c = Float.floatToRawIntBits(n);
        return c;
    }

    public long doubleToGDSLong(float n) {
        long c = Double.doubleToLongBits(n);
        return c;
    }

    public class UnParsableException
    extends Exception {
        public UnParsableException() {
        }

        public UnParsableException(String s) {
            super(s);
        }
    }

    public class Loc {
        double x;
        double y;

        public Loc(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }
}

