/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.shapeMethods;

import CNSTnanoToolbox.scripting.CNSTscriptingController;
import JGDS2.GArea;
import JGDS2.GDS2;
import JGDS2.Rect;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class PostScript {
    public static ArrayList<GArea> createPostScript(String s, int fractureSegments) {
        int layer = CNSTscriptingController.getGdsLayer();
        String[] arrayString = s.split("\\s+");
        Path2D.Double p2dTemp = new Path2D.Double();
        ArrayList<Double> al = new ArrayList<Double>();
        for (int i = 0; i < arrayString.length; ++i) {
            if (arrayString[i].equalsIgnoreCase("m") || arrayString[i].equalsIgnoreCase("l") || arrayString[i].equalsIgnoreCase("c") || arrayString[i].equalsIgnoreCase("h") || arrayString[i].equalsIgnoreCase("moveto") || arrayString[i].equalsIgnoreCase("lineto") || arrayString[i].equalsIgnoreCase("curveto") || arrayString[i].equalsIgnoreCase("closepath")) {
                p2dTemp = PostScript.parsePostScipt(al, arrayString[i], p2dTemp);
                al = new ArrayList();
                continue;
            }
            al.add(Double.parseDouble(arrayString[i]));
        }
        GArea postScript = new GArea(p2dTemp, layer);
        return PostScript.fracturePostScript(postScript, fractureSegments, layer);
    }

    public static Path2D.Double parsePostScipt(ArrayList<Double> al, String s, Path2D.Double p2d) {
        switch (s) {
            case "m": {
                p2d.moveTo(PostScript.rescalePSimage(al.get(0)), PostScript.rescalePSimage(al.get(1)));
                return p2d;
            }
            case "l": {
                p2d.lineTo(PostScript.rescalePSimage(al.get(0)), PostScript.rescalePSimage(al.get(1)));
                return p2d;
            }
            case "c": {
                p2d.curveTo(PostScript.rescalePSimage(al.get(0)), PostScript.rescalePSimage(al.get(1)), PostScript.rescalePSimage(al.get(2)), PostScript.rescalePSimage(al.get(3)), PostScript.rescalePSimage(al.get(4)), PostScript.rescalePSimage(al.get(5)));
                return p2d;
            }
            case "q": {
                p2d.quadTo(PostScript.rescalePSimage(al.get(0)), PostScript.rescalePSimage(al.get(1)), PostScript.rescalePSimage(al.get(2)), PostScript.rescalePSimage(al.get(3)));
                return p2d;
            }
            case "h": {
                p2d.closePath();
                return p2d;
            }
            case "moveto": {
                p2d.moveTo(PostScript.rescalePSimage(al.get(0)), PostScript.rescalePSimage(al.get(1)));
                return p2d;
            }
            case "lineto": {
                p2d.lineTo(PostScript.rescalePSimage(al.get(0)), PostScript.rescalePSimage(al.get(1)));
                return p2d;
            }
            case "curveto": {
                p2d.curveTo(PostScript.rescalePSimage(al.get(0)), PostScript.rescalePSimage(al.get(1)), PostScript.rescalePSimage(al.get(2)), PostScript.rescalePSimage(al.get(3)), PostScript.rescalePSimage(al.get(4)), PostScript.rescalePSimage(al.get(5)));
                return p2d;
            }
            case "quadto": {
                p2d.quadTo(PostScript.rescalePSimage(al.get(0)), PostScript.rescalePSimage(al.get(1)), PostScript.rescalePSimage(al.get(2)), PostScript.rescalePSimage(al.get(3)));
                return p2d;
            }
            case "closepath": {
                p2d.closePath();
                return p2d;
            }
        }
        return p2d;
    }

    public static ArrayList<GArea> fracturePostScript(GArea ga, int n, int layer) {
        double shapeReso = CNSTscriptingController.getShapeReso();
        ArrayList<GArea> gaAL = new ArrayList<GArea>();
        Area a = new Area(ga.getArea());
        Rectangle2D rec = a.getBounds2D();
        double width = rec.getWidth() / (double)n;
        GArea frac = new GArea(new Rect(0.0, 0.0, width, rec.getHeight(), layer), layer);
        GArea temp = new GArea(ga);
        GArea tempFrac = new GArea(frac);
        for (int i = 0; i < n; ++i) {
            GArea resolutionArea = new GArea((GArea)temp.and((GDS2)tempFrac.transform(AffineTransform.getTranslateInstance((double)i * width, 0.0))));
            resolutionArea.setRenderReso(shapeReso);
            gaAL.add(resolutionArea);
            temp = new GArea(ga);
            tempFrac = new GArea(frac);
        }
        return gaAL;
    }

    public static double rescalePSimage(double d) {
        double psPixelValue = CNSTscriptingController.getPixelValue();
        return (double)Math.round(psPixelValue * d * 1000.0) / 1000.0;
    }
}

