/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.shapeMethods;

import CNST.Scripting;
import CNSTnanoToolbox.scripting.CNSTscriptingController;
import CNSTnanoToolbox.shapeMethods.FractureShapes;
import CNSTnanoToolbox.shapeMethods.PrimitiveShapes;
import JGDS2.GArea;
import JGDS2.GDS2;
import JGDS2.Rect;
import JGDS2.Ref;
import JGDS2.Struct;
import JGDS2.Text;
import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class MISCobjects {
    public static GArea createRectangleTaper(double w1, double L1, double w2, double L2) {
        int layer = CNSTscriptingController.getGdsLayer();
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(0.0, -w1 / 2.0);
        poly.lineTo(L1, -w1 / 2.0);
        poly.lineTo(L1 + L2, -w2 / 2.0);
        poly.lineTo(L1 + L2, w2 / 2.0);
        poly.lineTo(L1, w1 / 2.0);
        poly.lineTo(0.0, w1 / 2.0);
        poly.closePath();
        GArea ga = new GArea(poly, layer);
        ga.setDataType(CNSTscriptingController.getDataType());
        return ga;
    }

    public static ArrayList<GArea> createArrowJunction(double w1, double w2, double L1, double L2, double rad, int numSides, double theta) {
        int layer = CNSTscriptingController.getGdsLayer();
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        double x = (rad + L1) * Math.cos(theta * Math.PI / 180.0);
        double y = (rad + L1) * Math.sin(theta * Math.PI / 180.0);
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(0.0, 0.0);
        poly.lineTo(-x, y);
        poly.lineTo(0.0, 2.0 * y);
        BasicStroke bs = new BasicStroke((float)w1, 0, 0);
        GArea ga = new GArea(bs.createStrokedShape(poly), layer);
        poly = new Path2D.Double();
        poly.moveTo(-x, y);
        poly.lineTo(-x + rad + L2, y);
        bs = new BasicStroke((float)w2, 0, 0);
        ga.or(new GArea(bs.createStrokedShape(poly), layer));
        GArea circ = PrimitiveShapes.createEllipse(0.0, 0.0, rad, rad, numSides, layer);
        ga.or(circ);
        GArea temp = new GArea(circ);
        ga.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(0.0, 2.0 * y)));
        temp = new GArea(circ);
        ga.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(-x + rad + L2, y)));
        alGA.add(ga);
        return alGA;
    }

    public static ArrayList<GArea> createHjunction(double w1, double w2, double L1, double L2, double rad, int numSides) {
        int layer = CNSTscriptingController.getGdsLayer();
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea ga = new GArea(new Rect(-w1 / 2.0, 0.0, w1 / 2.0, 2.0 * rad + L1, layer), layer);
        GArea temp = new GArea(ga);
        ga.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(w1 + L2, 0.0)));
        ga.or(new Rect(w1 / 2.0, rad + L1 / 2.0 - w2 / 2.0, w1 / 2.0 + L2, rad + L1 / 2.0 + w2 / 2.0, layer), layer);
        GArea circ = PrimitiveShapes.createEllipse(0.0, 0.0, rad, rad, numSides, layer);
        ga.or(circ);
        temp = new GArea(circ);
        ga.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(0.0, 2.0 * rad + L1)));
        temp = new GArea(circ);
        ga.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(w1 + L2, 0.0)));
        temp = new GArea(circ);
        ga.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(w1 + L2, 2.0 * rad + L1)));
        alGA.add(ga);
        return alGA;
    }

    public static ArrayList<GArea> createTjunction(double w1, double w2, double L1, double L2, double rad, int numSides) {
        int layer = CNSTscriptingController.getGdsLayer();
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea ga = new GArea(new Rect(-w1 / 2.0, 0.0, w1 / 2.0, 2.0 * rad + L1, layer), layer);
        ga.or(new Rect(w1 / 2.0, rad + L1 / 2.0 - w2 / 2.0, w1 / 2.0 + L2 + rad, rad + L1 / 2.0 + w2 / 2.0, layer), layer);
        GArea circ = PrimitiveShapes.createEllipse(0.0, 0.0, rad, rad, numSides, layer);
        ga.or(circ);
        GArea temp = new GArea(circ);
        ga.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(0.0, 2.0 * rad + L1)));
        temp = new GArea(circ);
        ga.or((GDS2)temp.transform(AffineTransform.getTranslateInstance(w1 / 2.0 + L2 + rad, rad + L1 / 2.0)));
        alGA.add(ga);
        return alGA;
    }

    public static ArrayList<GArea> createResoTestPatterns(double rad, double width, int n, boolean isPI) {
        int layer = CNSTscriptingController.getGdsLayer();
        n = n <= 0 ? 1 : n;
        width = isPI ? (double)n * Math.PI : width;
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(0.0, 0.0);
        poly.lineTo(rad, -width / 2.0);
        poly.lineTo(rad, width / 2.0);
        poly.closePath();
        GArea singleBar = new GArea(poly, layer);
        GArea ga = new GArea(singleBar);
        int numElements = (int)(Math.PI * 2 * rad / (2.0 * width));
        double dTheta = Math.PI * 2 / (double)numElements;
        for (int i = 0; i < numElements; ++i) {
            GArea temp = new GArea(singleBar);
            ga.or((GDS2)temp.transform(AffineTransform.getRotateInstance((double)i * dTheta)));
        }
        ArrayList<GArea> alGA = FractureShapes.fractureShapeQuadrants(ga);
        return alGA;
    }

    public static ArrayList<GArea> createInteElectrodesV1(double width1, double width2, double length1, double length2, double overlap, int numElectrodes, double pitch, double baseHeight, double baseWidth) {
        int layer = CNSTscriptingController.getGdsLayer();
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea ga = new GArea(new Rect(0.0, 0.0, baseWidth, baseHeight, layer), layer);
        ga.or(new Rect(baseWidth, 0.0, baseWidth + length2 + (double)(numElectrodes - 1) * pitch + width1, width2, layer), layer);
        double startX = baseWidth + length2;
        for (int i = 0; i < numElectrodes; ++i) {
            ga.or(new Rect((double)i * pitch + startX, width2, (double)i * pitch + startX + width1, width2 + length1, layer), layer);
        }
        if (overlap <= length1) {
            GArea temp = new GArea(ga);
            temp.transform(AffineTransform.getRotateInstance(Math.PI));
            double offsetX = (double)(numElectrodes - 1) * pitch + 2.0 * startX + width1 - pitch / 2.0;
            double offsetY = 2.0 * length1 + 2.0 * width2 - overlap;
            temp.transform(AffineTransform.getTranslateInstance(offsetX, offsetY));
            ga.or(temp);
        }
        alGA.add(ga);
        return alGA;
    }

    public static ArrayList<GArea> createInteElectrodesV2(double width1, double width2, double length1, double length2, double overlap, int numElectrodes, double pitch, double baseHeight, double baseWidth) {
        int layer = CNSTscriptingController.getGdsLayer();
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        double OFFSETY = -baseHeight + width2;
        GArea ga = new GArea(new Rect(0.0, OFFSETY, baseWidth, OFFSETY + baseHeight, layer), layer);
        ga.or(new Rect(baseWidth, 0.0, baseWidth + length2 + (double)(numElectrodes - 1) * pitch + width1, width2, layer), layer);
        double startX = baseWidth + length2;
        for (int i = 0; i < numElectrodes; ++i) {
            ga.or(new Rect((double)i * pitch + startX, width2, (double)i * pitch + startX + width1, width2 + length1, layer), layer);
        }
        if (overlap <= length1) {
            GArea temp = new GArea(ga);
            temp.transform(AffineTransform.getRotateInstance(Math.PI));
            double offsetX = (double)(numElectrodes - 1) * pitch + 2.0 * startX + width1 - pitch / 2.0;
            double offsetY = 2.0 * length1 + 2.0 * width2 - overlap;
            temp.transform(AffineTransform.getTranslateInstance(offsetX, offsetY));
            ga.or(temp);
        }
        alGA.add((GArea)ga.transform(AffineTransform.getTranslateInstance(0.0, -OFFSETY)));
        return alGA;
    }

    public static ArrayList<GArea> createInteElectrodesV3(double width1, double width2, double length1, double length2, double overlap, int numElectrodes, double pitch, double baseHeight, double baseWidth) {
        int layer = CNSTscriptingController.getGdsLayer();
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea bondPad = new GArea(new Rect(0.0, 0.0, baseWidth, baseHeight, layer), layer);
        GArea ga = new GArea(bondPad);
        ga.or(new Rect(baseWidth, 0.0, baseWidth + length2 + (double)(numElectrodes - 1) * pitch + width1, width2, layer), layer);
        double offsetY = 2.0 * length1 + 2.0 * width2 - baseHeight - overlap;
        ga.or((GDS2)bondPad.transform(AffineTransform.getTranslateInstance(0.0, offsetY)));
        ga.or(new Rect(baseWidth, offsetY + baseHeight - width2, baseWidth + length2 + (double)(numElectrodes - 1) * pitch + width1 + pitch / 2.0, offsetY + baseHeight, layer), layer);
        double startX = baseWidth + length2;
        for (int i = 0; i <= numElectrodes; ++i) {
            if (i < numElectrodes) {
                ga.or(new Rect((double)i * pitch + startX, width2, (double)i * pitch + startX + width1, width2 + length1, layer), layer);
            }
            ga.or(new Rect((double)i * pitch + startX - pitch / 2.0, width2 + length1 - overlap, (double)i * pitch + startX + width1 - pitch / 2.0, offsetY + baseHeight - width2, layer), layer);
        }
        alGA.add(ga);
        return alGA;
    }

    public static ArrayList<GArea> createInteElectrodesV4(double width1, double width2, double length1, double length2, double overlap, int numElectrodes, double pitch, double baseHeight, double baseWidth) {
        int layer = CNSTscriptingController.getGdsLayer();
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        double OFFSETY = -baseHeight + width2;
        GArea bondPad = new GArea(new Rect(0.0, OFFSETY, baseWidth, OFFSETY + baseHeight, layer), layer);
        GArea ga = new GArea(bondPad);
        ga.or(new Rect(baseWidth, 0.0, baseWidth + length2 + (double)(numElectrodes - 1) * pitch + width1, width2, layer), layer);
        double offsetY = 2.0 * length1 + 2.0 * width2 - baseHeight - overlap;
        ga.or((GDS2)bondPad.transform(AffineTransform.getTranslateInstance(0.0, offsetY - 2.0 * OFFSETY)));
        ga.or(new Rect(baseWidth, offsetY + baseHeight - width2, baseWidth + length2 + (double)(numElectrodes - 1) * pitch + width1 + pitch / 2.0, offsetY + baseHeight, layer), layer);
        double startX = baseWidth + length2;
        for (int i = 0; i <= numElectrodes; ++i) {
            if (i < numElectrodes) {
                ga.or(new Rect((double)i * pitch + startX, width2, (double)i * pitch + startX + width1, width2 + length1, layer), layer);
            }
            ga.or(new Rect((double)i * pitch + startX - pitch / 2.0, width2 + length1 - overlap, (double)i * pitch + startX + width1 - pitch / 2.0, offsetY + baseHeight - width2, layer), layer);
        }
        alGA.add((GArea)ga.transform(AffineTransform.getTranslateInstance(0.0, -OFFSETY)));
        return alGA;
    }

    public static ArrayList<GArea> createInteElectrodesV5(double width1, double width2, double length1, double length2, double overlap, int numElectrodes, double pitch, double baseHeight, double baseWidth) {
        int layer = CNSTscriptingController.getGdsLayer();
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea ga = new GArea(new Rect(0.0, 0.0, baseWidth, baseHeight, layer), layer);
        ga.or(new Rect(baseWidth, baseHeight / 2.0 - width2 / 2.0, baseWidth + length2 + width2, baseHeight / 2.0 + width2 / 2.0, layer), layer);
        double centerOffsetY = (2.0 * length1 + 2.0 * width2 - overlap) / 2.0;
        double startX = baseWidth + length2 + width2;
        double startY = baseHeight / 2.0 + width2 / 2.0;
        ga.or(new Rect(startX, baseHeight / 2.0 - centerOffsetY, startX + width2, startY, layer), layer);
        ga.or(new Rect(startX + width2, baseHeight / 2.0 - centerOffsetY, startX + width2 + (double)(numElectrodes - 1) * pitch + pitch, baseHeight / 2.0 - centerOffsetY + width2, layer), layer);
        startX = startX + width2 + pitch - width1;
        for (int i = 0; i < numElectrodes; ++i) {
            ga.or(new Rect((double)i * pitch + startX, baseHeight / 2.0 - centerOffsetY, (double)i * pitch + startX + width1, baseHeight / 2.0 - centerOffsetY + length1 + width2, layer), layer);
        }
        if (overlap <= length1) {
            GArea temp = new GArea(ga);
            temp.transform(AffineTransform.getRotateInstance(Math.PI));
            double offsetX = (double)(numElectrodes - 1) * pitch + 2.0 * startX + width1 - pitch / 2.0;
            temp.transform(AffineTransform.getTranslateInstance(offsetX, baseHeight));
            ga.or(temp);
        }
        alGA.add(ga);
        return alGA;
    }

    public static ArrayList<GArea> createRectangularSpiral(double width, double len, double pitch, int numTurns) {
        double x = 0.0;
        double y = 0.0;
        int layer = CNSTscriptingController.getGdsLayer();
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(x, y);
        for (int i = 0; i < 10; ++i) {
            poly.lineTo(x + len, y);
            poly.lineTo(x += len, y + len);
            y += len;
            poly.lineTo(x - (len += pitch), y);
            poly.lineTo(x -= len, y - len);
            y -= len;
            len += pitch;
        }
        BasicStroke bs = new BasicStroke((float)width, 0, 0);
        GArea ga = new GArea(bs.createStrokedShape(poly), layer);
        ArrayList<GArea> alGA = FractureShapes.fractureShapeQuadrants(ga);
        return alGA;
    }

    public static void createRandomPolygons(Struct currentStruct, String uniqueStructName, double x, double y, double width, double height, double radius, int numSides, double separation, int numElements, int iterations, boolean RANDOMROTATION) {
        Struct shape = new Struct(uniqueStructName, new GArea(PrimitiveShapes.createEllipse(0.0, 0.0, radius, radius, numSides, CNSTscriptingController.getGdsLayer())));
        TreeMap<Double, Double> coordinates = MISCobjects.generateCoordinates(width, height, radius, separation += 2.0 * radius, iterations, numElements);
        for (int i = 0; i < coordinates.size(); ++i) {
            if (RANDOMROTATION) {
                currentStruct.add(new Ref(shape, x + Double.parseDouble(coordinates.keySet().toArray()[i].toString()), y + Double.parseDouble(coordinates.values().toArray()[i].toString()), 0, Math.random() * 360.0));
                continue;
            }
            currentStruct.add(new Ref(shape, x + Double.parseDouble(coordinates.keySet().toArray()[i].toString()), y + Double.parseDouble(coordinates.values().toArray()[i].toString())));
        }
    }

    public static void createRandomEllipses(Struct currentStruct, String uniqueStructName, double x, double y, double width, double height, double radiusX, double radiusY, int numSides, double separation, int numElements, int iterations, boolean RANDOMROTATION) {
        Struct shape = new Struct(uniqueStructName, new GArea(PrimitiveShapes.createEllipse(0.0, 0.0, radiusX, radiusY, numSides, CNSTscriptingController.getGdsLayer())));
        TreeMap<Double, Double> coordinates = MISCobjects.generateCoordinates(width, height, radiusY, separation += 2.0 * radiusY, iterations, numElements);
        for (int i = 0; i < coordinates.size(); ++i) {
            if (RANDOMROTATION) {
                currentStruct.add(new Ref(shape, x + Double.parseDouble(coordinates.keySet().toArray()[i].toString()), y + Double.parseDouble(coordinates.values().toArray()[i].toString()), 0, Math.random() * 360.0));
                continue;
            }
            currentStruct.add(new Ref(shape, x + Double.parseDouble(coordinates.keySet().toArray()[i].toString()), y + Double.parseDouble(coordinates.values().toArray()[i].toString())));
        }
    }

    public static void createRandomEllipsesV(Struct currentStruct, String uniqueStructName, double x, double y, double width, double height, double radiusX, double radiusY, double separation, int numElements, int iterations, boolean RANDOMROTATION) {
        Ellipse2D.Double s = new Ellipse2D.Double(x - radiusX, y - radiusY, 2.0 * radiusX, 2.0 * radiusY);
        Area a = new Area(s);
        GArea v = new GArea(a, CNSTscriptingController.getGdsLayer());
        v.setRenderReso(CNSTscriptingController.getShapeReso());
        v.setDataType(CNSTscriptingController.getDataType());
        Struct shape = new Struct(uniqueStructName, v);
        TreeMap<Double, Double> coordinates = MISCobjects.generateCoordinates(width, height, radiusY, separation += 2.0 * radiusY, iterations, numElements);
        for (int i = 0; i < coordinates.size(); ++i) {
            if (RANDOMROTATION) {
                currentStruct.add(new Ref(shape, x + Double.parseDouble(coordinates.keySet().toArray()[i].toString()), y + Double.parseDouble(coordinates.values().toArray()[i].toString()), 0, Math.random() * 360.0));
                continue;
            }
            currentStruct.add(new Ref(shape, x + Double.parseDouble(coordinates.keySet().toArray()[i].toString()), y + Double.parseDouble(coordinates.values().toArray()[i].toString())));
        }
    }

    public static TreeMap<Double, Double> generateCoordinates(double xWidth, double yHeight, double radius, double separation, int iterations, int numberOfElements) {
        HashMap<Double, Double> hashMap = new HashMap<Double, Double>();
        TreeMap<Double, Double> treeMap = new TreeMap<Double, Double>(hashMap);
        int count = 0;
        hashMap.put(Math.random() * (xWidth - radius), Math.random() * (yHeight - radius));
        treeMap = new TreeMap(hashMap);
        for (int i = 1; i < numberOfElements; ++i) {
            SortedMap<Double, Double> subMap;
            double yVal;
            double xVal = Math.random() * xWidth;
            boolean testDistance = MISCobjects.testSeparation(xVal, yVal = Math.random() * yHeight, separation, subMap = treeMap.subMap(xVal - separation, xVal + separation));
            if (testDistance) {
                hashMap.put(xVal, yVal);
                treeMap = new TreeMap(hashMap);
                count = 0;
                continue;
            }
            --i;
            if (++count != iterations) continue;
            i = numberOfElements + 1;
        }
        return treeMap;
    }

    static boolean testSeparation(double xVal, double yVal, double separation, Map<Double, Double> subMap) {
        int count = 0;
        if (subMap.isEmpty()) {
            return true;
        }
        for (int i = 0; i < subMap.size(); ++i) {
            double y;
            double x = xVal - Double.parseDouble(subMap.keySet().toArray()[i].toString());
            double distance = Math.sqrt(x * x + (y = yVal - Double.parseDouble(subMap.values().toArray()[i].toString())) * y);
            if (distance > separation) {
                ++count;
                continue;
            }
            i = subMap.size() + 1;
        }
        return count == subMap.size();
    }

    public static ArrayList<GArea> createResoPatternRSA(double startW, double endW, double delta, double H, int columns, double space) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        double size = 0.0;
        for (double i = startW * 1000.0; i <= endW * 1000.0; i += delta * 1000.0) {
            GArea ga = MISCobjects.createResoPatternRS(i / 1000.0, H, columns);
            Area a = new Area(ga.getArea());
            Rectangle2D rec = a.getBounds2D();
            alGA.add((GArea)ga.transform(AffineTransform.getTranslateInstance(size, 0.0)));
            size = size + rec.getWidth() + space;
        }
        return alGA;
    }

    public static GArea createResoPatternRS(double W, double H, int numberOfLines) {
        int layer = CNSTscriptingController.getGdsLayer();
        double shapeReso = CNSTscriptingController.getShapeReso();
        GArea rect = new GArea(new Rect(0.0, 0.0, W, H, layer), layer);
        GArea temp = new GArea(rect);
        GArea ga = new GArea(rect);
        for (int i = 0; i < numberOfLines; ++i) {
            temp = new GArea(rect);
            ga.or((GDS2)temp.transform(AffineTransform.getTranslateInstance((double)(2 * i) * W, 0.0)));
            temp = new GArea(rect);
            ga.or((GDS2)temp.transform(AffineTransform.getTranslateInstance((double)(2 * i + 1) * W, H)));
        }
        Font font = new Font("Serif", 0, 1000);
        Text lb = new Text("" + W, layer, font);
        lb.setFontSize(2.0 * H);
        lb.setRenderReso(shapeReso);
        GArea text = new GArea(lb, layer);
        ga.or((GDS2)text.transform(AffineTransform.getTranslateInstance(0.0, 2.5 * H)));
        ga.setDataType(CNSTscriptingController.getDataType());
        return ga;
    }

    public static ArrayList<GArea> createResoPatternLSA(double startW, double endW, double delta, double H, int columns, double space) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        double size = 0.0;
        for (double i = startW * 1000.0; i <= endW * 1000.0; i += delta * 1000.0) {
            GArea ga = MISCobjects.createResoPatternLS(i / 1000.0, H, columns);
            Area a = new Area(ga.getArea());
            Rectangle2D rec = a.getBounds2D();
            alGA.add((GArea)ga.transform(AffineTransform.getTranslateInstance(size, 0.0)));
            size = size + rec.getWidth() + space;
        }
        return alGA;
    }

    public static GArea createResoPatternLS(double W, double H, int numberOfLines) {
        int layer = CNSTscriptingController.getGdsLayer();
        double shapeReso = CNSTscriptingController.getShapeReso();
        GArea ga = MISCobjects.createResoPatternLshapeSingle(W, H, layer);
        double height = H;
        for (int i = 1; i < numberOfLines; ++i) {
            if (W < height) {
                GArea temp = MISCobjects.createResoPatternLshapeSingle(W, height -= 2.0 * W, layer);
                ga.or((GDS2)temp.transform(AffineTransform.getTranslateInstance((double)(2 * i) * W, (double)(2 * i) * W)));
                continue;
            }
            i = numberOfLines;
        }
        Font font = new Font("Serif", 0, 1000);
        Text lb = new Text("" + W, layer, font);
        lb.setFontSize(H);
        lb.setRenderReso(shapeReso);
        GArea text = new GArea(lb, layer);
        ga.or((GDS2)text.transform(AffineTransform.getTranslateInstance(0.0, 1.5 * H)));
        ga.setDataType(CNSTscriptingController.getDataType());
        return ga;
    }

    public static GArea createResoPatternLshapeSingle(double W, double H, int layer) {
        GArea ga = new GArea(new Rect(0.0, 0.0, W, H, layer), layer);
        ga.or(new GArea(new Rect(0.0, 0.0, H, W, layer), layer));
        ga.setDataType(CNSTscriptingController.getDataType());
        return ga;
    }

    public static void arcSquareHexFill(Struct currentStruct, String uniqueStructName, double x, double y, double rIn, double rOut, double angleStart, double angleEnd, int numSides, double THETA, double rSmallObject, int numSidesSmallObject, double pitchX, boolean SQUARE, boolean ISVECTOR) {
        int gdsLayer = CNSTscriptingController.getGdsLayer();
        double shapeReso = CNSTscriptingController.getShapeReso();
        double radConstraintIn = rIn == 0.0 ? rIn : rIn + rSmallObject;
        double radConstraintOut = rOut - rSmallObject;
        GArea torusElement = Scripting.createTorus(x, y, rIn, rOut, angleStart, angleEnd, numSides, THETA, gdsLayer + 40);
        GArea torusElementSmall = Scripting.createTorus(x, y, radConstraintIn, radConstraintOut, angleStart, angleEnd, numSides, THETA, gdsLayer + 44);
        Area bigTorus = new Area(torusElement.getArea());
        Rectangle2D r2d = bigTorus.getBounds2D();
        Area modifiedTorus = new Area(torusElementSmall.getArea());
        Struct smallElement = new Struct(uniqueStructName);
        GArea gaSmallElement = ISVECTOR ? Scripting.createEllipseVector(0.0, 0.0, rSmallObject, rSmallObject, THETA, gdsLayer, shapeReso) : Scripting.createEllipse(0.0, 0.0, rSmallObject, rSmallObject, numSidesSmallObject, 0.0, gdsLayer);
        gaSmallElement.setDataType(CNSTscriptingController.getDataType());
        smallElement.add(gaSmallElement);
        int numElementsX = (int)((r2d.getMaxX() - r2d.getMinX()) / pitchX) + 1;
        int numElementsY = (int)((r2d.getMaxY() - r2d.getMinY()) / pitchX) + 1;
        if (SQUARE) {
            for (int i = 0; i < numElementsX; ++i) {
                for (int j = 0; j < numElementsY; ++j) {
                    double yPos;
                    double xPos = r2d.getMinX() + (double)i * pitchX;
                    if (!modifiedTorus.contains(new Point2D.Double(xPos, yPos = r2d.getMinY() + (double)j * pitchX))) continue;
                    currentStruct.add(new Ref(smallElement, xPos, yPos));
                }
            }
        } else {
            double pitchY = 2.0 * pitchX * Math.cos(0.5235987755982988);
            numElementsY = (int)(2.0 * (r2d.getMaxX() - r2d.getMinX()) / pitchY) + 1;
            for (int i = 0; i < numElementsX; ++i) {
                for (int j = 0; j < numElementsY; ++j) {
                    double yPos;
                    double xPos = r2d.getMinX() + (double)i * pitchX;
                    if (modifiedTorus.contains(new Point2D.Double(xPos, yPos = r2d.getMinY() + (double)j * pitchY))) {
                        currentStruct.add(new Ref(smallElement, xPos, yPos));
                    }
                    if (!modifiedTorus.contains(new Point2D.Double(xPos = pitchX / 2.0 + r2d.getMinX() + (double)i * pitchX, yPos = pitchY / 2.0 + r2d.getMinY() + (double)j * pitchY))) continue;
                    currentStruct.add(new Ref(smallElement, xPos, yPos));
                }
            }
        }
    }

    public static void arcRadialFill(Struct currentStruct, String uniqueStructName, double x, double y, double radTorus, double widthTorus, double circleRad, int numSides, double pitch, double edgeDistance, double thetaStart, double thetaEnd) {
        int gdsLayer = CNSTscriptingController.getGdsLayer();
        Struct circle = new Struct(uniqueStructName, Scripting.createEllipse(0.0, 0.0, circleRad, circleRad, numSides, 0.0, gdsLayer));
        double startPos = radTorus - widthTorus / 2.0 + edgeDistance;
        int numElements = (int)((widthTorus - 2.0 * edgeDistance) / pitch) + 1;
        for (int i = 0; i < numElements; ++i) {
            double arcRad = startPos + (double)i * pitch;
            double lengthRad = MISCobjects.degreeToRadians(thetaEnd - thetaStart) * arcRad;
            int numArcSeg = (int)(lengthRad / pitch);
            double deltaSegment = pitch + (lengthRad - (double)numArcSeg * pitch) / (double)numArcSeg;
            for (int j = 0; j <= numArcSeg; ++j) {
                currentStruct.add(new Ref(circle, x + arcRad * Math.cos(thetaStart + (double)j * deltaSegment / arcRad), y + arcRad * Math.sin(thetaStart + (double)j * deltaSegment / arcRad)));
            }
        }
    }

    public static void spinIceA(Struct currentStruct, String uniqueStructName, double x, double y, double radiusX, double radiusY, double space, double percentEmpty, int numSides, int numElementsX, int numElementsY, boolean ISVECTOR) {
        Struct ellipse = new Struct(uniqueStructName, MISCobjects.creatingEllipse(radiusX, radiusY, numSides, CNSTscriptingController.getGdsLayer(), CNSTscriptingController.getShapeReso(), ISVECTOR));
        double xPos = -space / 2.0 - 2.0 * radiusY - radiusX;
        double yPos = -space / 2.0 - radiusY;
        double arrayPitch = Math.abs(2.0 * xPos);
        Struct latticeVertical = new Struct(uniqueStructName + "V");
        Scripting.createArrayRectV1(ellipse, latticeVertical, 0.0, yPos, 1, 2, 0.0, 2.0 * radiusY + space);
        Struct latticeHorizontal = new Struct(uniqueStructName + "H");
        latticeHorizontal.add(new Ref(latticeVertical, 0.0, 0.0, 0, 90.0));
        Struct latticeCellEmpty = new Struct("latticeCellEmpty");
        ArrayList<Struct> al = new ArrayList<Struct>();
        al.add(latticeVertical);
        al.add(latticeHorizontal);
        al.add(latticeCellEmpty);
        Scripting.createArrayRectV1(latticeVertical, currentStruct, x + xPos, y, numElementsX + 1, numElementsY, arrayPitch, arrayPitch);
        Scripting.createArrayRectV1(latticeHorizontal, currentStruct, x, y + xPos, numElementsX, numElementsY + 1, arrayPitch, arrayPitch);
        percentEmpty /= 100.0;
        int empty = 0;
        for (int i = 0; i < numElementsX; ++i) {
            Struct s = i % 2 == 0 ? latticeHorizontal : latticeVertical;
            int zeroOne = i % 2 == 0 ? 0 : 1;
            for (int j = 0; j < numElementsY; ++j) {
                double rVal = Math.random();
                if (rVal <= percentEmpty) {
                    ++empty;
                } else {
                    currentStruct.add(new Ref((Struct)al.get(zeroOne), x + (double)i * arrayPitch, y + (double)j * arrayPitch));
                }
                zeroOne = zeroOne == 0 ? 1 : 0;
            }
        }
        DecimalFormat df2 = new DecimalFormat("#.##");
        double totalElements = numElementsX * numElementsY;
        String spinIcetype = ISVECTOR ? "spinIceVectorA:" : "spinIceA:\t";
        String s = spinIcetype + "\tempty Elements = " + empty + "\ttotalElements = " + (int)totalElements + "\tpercent Empty = " + df2.format((double)empty / totalElements * 100.0) + "%";
        CNSTscriptingController.logFileINFO.add(s);
    }

    public static GArea creatingEllipse(double radX, double radY, int numSides, int gdsLayer, double shapeReso, boolean ISVECTOR) {
        return ISVECTOR ? Scripting.createEllipseVector(0.0, 0.0, radX, radY, 0.0, gdsLayer, shapeReso) : Scripting.createEllipse(0.0, 0.0, radX, radY, numSides, 0.0, gdsLayer);
    }

    public static double degreeToRadians(double d) {
        return d * (Math.PI / 180);
    }
}

