/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.shapeMethods;

import CNSTnanoToolbox.shapeMethods.PrimitiveShapes;
import JGDS2.GArea;
import JGDS2.Rect;
import java.awt.geom.Path2D;
import java.util.ArrayList;

public class Grayscale {
    public static ArrayList<GArea> createGrayScaleLinearNGON(double radX, double radY, int numberOfSegments, int numSides) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        double deltaRadX = radX / (double)numberOfSegments;
        double deltaRadY = radY / (double)numberOfSegments;
        GArea mainGA = PrimitiveShapes.createEllipse(0.0, 0.0, radX, radY, numSides, 0);
        GArea temp = new GArea();
        for (int i = 1; i <= numberOfSegments; ++i) {
            temp = new GArea(PrimitiveShapes.createEllipse(0.0, 0.0, radX - (double)i * deltaRadX, radY - (double)i * deltaRadY, numSides, i % 256));
            mainGA.subtract(temp);
            alGA.add(mainGA);
            mainGA = new GArea(temp);
        }
        return alGA;
    }

    public static ArrayList<GArea> createGrayScaleCustomNGON(ArrayList<Double> al) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        int S = al.size();
        int numSides = al.get(S - 2).intValue();
        GArea mainGA = PrimitiveShapes.createEllipse(0.0, 0.0, al.get(2), al.get(3), numSides, 0);
        GArea temp = new GArea();
        for (int i = 4; i < al.size() - 3; i += 2) {
            temp = new GArea(PrimitiveShapes.createEllipse(0.0, 0.0, al.get(i), al.get(i + 1), numSides, (i / 2 - 1) % 256));
            mainGA.subtract(temp);
            alGA.add(mainGA);
            mainGA = new GArea(temp);
        }
        int lastLayer = (S - 4) / 2 - 1;
        temp = new GArea(PrimitiveShapes.createEllipse(0.0, 0.0, al.get(S - 4), al.get(S - 3), numSides, lastLayer % 256));
        alGA.add(temp);
        return alGA;
    }

    public static ArrayList<GArea> createGrayScaleLinearRECT(double L, double H, int numberOfSegments) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        double deltaL = L / (double)numberOfSegments;
        double deltaH = H / (double)numberOfSegments;
        GArea mainGA = new GArea(new Rect(-L, -H, L, H, 0), 0);
        GArea temp = new GArea();
        for (int i = 1; i <= numberOfSegments; ++i) {
            double newL = L - (double)i * deltaL;
            double newH = H - (double)i * deltaH;
            temp = new GArea(new Rect(-newL, -newH, newL, newH, i % 256), i % 256);
            mainGA.subtract(temp);
            alGA.add(mainGA);
            mainGA = new GArea(temp);
        }
        return alGA;
    }

    public static ArrayList<GArea> createGrayScaleCustomRECT(ArrayList<Double> al) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        GArea mainGA = new GArea(new Rect(-al.get(2).doubleValue(), -al.get(3).doubleValue(), al.get(2), al.get(3), 0), 0);
        GArea temp = new GArea();
        for (int i = 4; i < al.size() - 2; i += 2) {
            temp = new GArea(new Rect(-al.get(i).doubleValue(), -al.get(i + 1).doubleValue(), al.get(i), al.get(i + 1), (i / 2 - 1) % 256), (i / 2 - 1) % 256);
            mainGA.subtract(temp);
            alGA.add(mainGA);
            mainGA = new GArea(temp);
        }
        int S = al.size();
        int lastLayer = (S - 3) / 2 - 1;
        temp = new GArea(new Rect(-al.get(S - 3).doubleValue(), -al.get(S - 2).doubleValue(), al.get(S - 3), al.get(S - 2), lastLayer % 256), lastLayer % 256);
        alGA.add(temp);
        return alGA;
    }

    public static ArrayList<GArea> createGrayScaleLinearRAMPupDown(double L, double H, int numberOfSegments, boolean UP) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        double deltaL = L / (double)numberOfSegments;
        for (int i = 0; i < numberOfSegments; ++i) {
            int lyr = UP ? i : numberOfSegments - 1 - i;
            GArea mainGA = new GArea(new Rect((double)i * deltaL, 0.0, deltaL + (double)i * deltaL, H, lyr % 256), lyr % 256);
            alGA.add(mainGA);
        }
        return alGA;
    }

    public static ArrayList<GArea> createGrayScaleLinearRAMP(double L, double H, int numberOfSegments) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        double deltaL = L / (double)numberOfSegments;
        for (int i = 0; i < numberOfSegments; ++i) {
            int lyr = Math.abs(numberOfSegments / 2 - i);
            GArea mainGA = new GArea(new Rect((double)i * deltaL, 0.0, deltaL + (double)i * deltaL, H, lyr % 256), lyr % 256);
            alGA.add(mainGA);
        }
        return alGA;
    }

    public static ArrayList<GArea> createGrayScaleCustomRAMPupDown(ArrayList<Double> al, boolean UP) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        int numberOfSegments = al.size() - 5;
        for (int i = 2; i < al.size() - 4; ++i) {
            int lyr = UP ? i - 2 : numberOfSegments - i;
            GArea mainGA = new GArea(new Rect(al.get(i), 0.0, al.get(i + 1), al.get(al.size() - 3), lyr % 256), lyr % 256);
            alGA.add(mainGA);
        }
        return alGA;
    }

    public static ArrayList<GArea> createGrayScaleCustomRAMP(ArrayList<Double> al) {
        ArrayList<GArea> alGA = new ArrayList<GArea>();
        int numberOfSegments = al.size() - 4;
        for (int i = 2; i < al.size() - 3; ++i) {
            int lyr = Math.abs(numberOfSegments / 2 - i + 1);
            GArea mainGA = new GArea(new Rect(al.get(i), 0.0, al.get(i + 1), al.get(al.size() - 2), lyr % 256), lyr % 256);
            alGA.add(mainGA);
        }
        return alGA;
    }

    public static ArrayList<GArea> grayScaleOverlappingARCs(double ri, double ro, int segment2, int numSegments, int numSides) {
        ArrayList<GArea> alGa = new ArrayList<GArea>();
        double delta = Math.PI * 2 / (double)numSegments;
        for (int i = segment2; i < numSegments; ++i) {
            alGa.add(Grayscale.createTorus(0.0, 0.0, ri, ro, delta * (double)segment2, delta * (double)(segment2 + 1), numSides, i % 256));
        }
        return alGa;
    }

    public static ArrayList<GArea> grayScaleARCs(double ri, double ro, int numSegments, int numSides) {
        ArrayList<GArea> alGa = new ArrayList<GArea>();
        double delta = Math.PI * 2 / (double)numSegments;
        for (int i = 0; i < numSegments; ++i) {
            alGa.add(Grayscale.createTorus(0.0, 0.0, ri, ro, delta * (double)i, delta * (double)(i + 1), numSides, i % 256));
        }
        return alGa;
    }

    public static GArea createTorus(double x, double y, double rin, double rout, double angleStart, double angleStop, int numSides, int layer) {
        double angle = angleStop > angleStart ? Math.abs(angleStart - angleStop) : Math.PI * 2 - Math.abs(angleStart - angleStop);
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(x + rin * Math.cos(angleStart), y + rin * Math.sin(angleStart));
        int steps = numSides;
        double c = angle / (double)numSides;
        for (int i = 0; i <= steps; ++i) {
            poly.lineTo(x + rin * Math.cos((double)i * c + angleStart), y + rin * Math.sin((double)i * c + angleStart));
        }
        for (int j = steps; j >= 0; --j) {
            poly.lineTo(x + rout * Math.cos((double)j * c + angleStart), y + rout * Math.sin((double)j * c + angleStart));
        }
        poly.closePath();
        GArea v = new GArea(poly, layer);
        return v;
    }
}

