/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.shapeMethods;

import CNSTnanoToolbox.scripting.CNSTscriptingController;
import CNSTnanoToolbox.shapeMethods.AlignmentMarks;
import JGDS2.GArea;
import JGDS2.Rect;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.util.ArrayList;

public class AlignmentMarksCustom {
    public static GArea createCustomCross(double L1, double W1, double L2, double PL, double PW, double LX, double d, double BL, double BW, boolean INVERSE, double IL, double IW, int TYPE) {
        int gdsLayer = CNSTscriptingController.getGdsLayer();
        GArea g = new GArea();
        GArea gTmp = new GArea();
        GArea cross = new GArea();
        switch (TYPE) {
            case 1: {
                g = AlignmentMarks.createAlignCross(L1, W1, L2, W1, gdsLayer);
                cross = INVERSE ? AlignmentMarks.createAlignInverse(IL, IW, g, gdsLayer) : g;
                break;
            }
            case 2: {
                g = AlignmentMarks.createAlignCross(L1, W1, L1, W1, gdsLayer);
                gTmp = new GArea(new Rect(L1, -PW / 2.0, L1 + PL, PW / 2.0, gdsLayer), gdsLayer);
                g.or(AlignmentMarks.createAlignRotate90GAreas(gTmp));
                cross = INVERSE ? AlignmentMarks.createAlignInverse(IL, IW, g, gdsLayer) : g;
                break;
            }
            case 3: {
                g = AlignmentMarks.createAlignCross(L1, W1, L1, W1, gdsLayer);
                gTmp = new GArea(new Rect(L1, -PW / 2.0, L1 + PL, PW / 2.0, gdsLayer), gdsLayer);
                g.or(AlignmentMarks.createAlignRotate90GAreas(gTmp));
                gTmp = new GArea(new Rect(L1 + PL, -W1 / 2.0, L1 + PL + LX, W1 / 2.0, gdsLayer), gdsLayer);
                g.or(AlignmentMarks.createAlignRotate90GAreas(gTmp));
                cross = INVERSE ? AlignmentMarks.createAlignInverse(IL, IW, g, gdsLayer) : g;
                break;
            }
            case 4: {
                g = AlignmentMarks.createAlignCross(L1, W1, L2, W1, gdsLayer);
                g.or(new Rect(d += W1 / 2.0, d, d + BL, d + BW, gdsLayer), gdsLayer);
                g.or(new Rect(-d - BL, d, -d, d + BW, gdsLayer), gdsLayer);
                g.or(new Rect(-d - BL, -d - BW, -d, -d, gdsLayer), gdsLayer);
                g.or(new Rect(d, -d - BW, d + BL, -d, gdsLayer), gdsLayer);
                cross = INVERSE ? AlignmentMarks.createAlignInverse(IL, IW, g, gdsLayer) : g;
                break;
            }
            default: {
                g = AlignmentMarks.createAlignCross(L1, W1, L2, W1, gdsLayer);
                cross = INVERSE ? AlignmentMarks.createAlignInverse(IL, IW, g, gdsLayer) : g;
            }
        }
        return cross;
    }

    public static ArrayList<GArea> createCustomVerniers(int layer1, int layer2, double L, double W, double pitch, double vernReso, double spacing, boolean INVERSE1, boolean INVERSE2, double IL, double IW) {
        double s;
        ArrayList<GArea> gaAL = new ArrayList<GArea>();
        layer1 = layer1 < 0 || layer1 > 255 ? 1 : layer1;
        layer2 = layer2 < 0 || layer2 > 255 ? 2 : layer2;
        double pitch1 = s = pitch - W;
        double pitch2 = s + vernReso;
        GArea vern1tmp = AlignmentMarksCustom.createCustomVerniers(L, W, pitch1, layer1, 0.0);
        GArea vern2tmp = AlignmentMarksCustom.createCustomVerniers(L, W, pitch2, layer2, Math.PI);
        vern1tmp.transform(AffineTransform.getTranslateInstance(0.0, spacing / 2.0));
        vern2tmp.transform(AffineTransform.getTranslateInstance(0.0, -spacing / 2.0));
        GArea vern1 = INVERSE1 ? AlignmentMarks.createAlignInverse(IL, IW, vern1tmp, layer1) : vern1tmp;
        GArea vern2 = INVERSE2 ? AlignmentMarks.createAlignInverse(IL, IW, vern2tmp, layer2) : vern2tmp;
        gaAL.add(vern1);
        gaAL.add(vern2);
        return gaAL;
    }

    public static GArea createCustomVerniers(double L, double W, double pitch, int layerVern, double rotate) {
        double Lmid = 0.75 * L;
        double Lshort = L / 2.0;
        GArea g1 = new GArea();
        Area tmpA = new Area();
        Area a = new Area();
        for (int i = -10; i <= 10; ++i) {
            double tmpL = i % 5 == 0 ? Lmid : Lshort;
            tmpL = i == 0 ? L : tmpL;
            g1.or(new Rect((double)i * (W + pitch), 0.0, (double)i * (W + pitch) + W, tmpL, 4), 4);
            tmpA = new Area(g1.getArea());
            a.add(tmpA);
        }
        g1 = new GArea(a, layerVern);
        g1.transform(AffineTransform.getTranslateInstance(-W / 2.0, 0.0));
        g1.transform(AffineTransform.getRotateInstance(rotate, 0.0, 0.0));
        return g1;
    }
}

