/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.metrology;

import CNSTnanoToolbox.AboutActions;
import CNSTnanoToolbox.AboutInterface;
import CNSTnanoToolbox.shapeMethods.LabelColors;
import CNSTnanoToolbox.xml.CNSTdefaultParameters;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.paint.Paint;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;

public class Woollam2FilmetricsController
implements Initializable,
AboutInterface {
    static File file = null;
    Stage about = new Stage();
    String openDir;
    String saveToDir;
    String nF40;
    String kF40;
    String nkF50;
    ArrayList<Double> waveLength;
    ArrayList<Double> n;
    ArrayList<Double> k;
    int displayColor = 0;
    int displayColor2 = 0;
    String[] F50header = new String[]{"Version, 1", "Compat. Version, 1", "Material Type, ", "File Information, ", "Wavelength (nm), n, k"};
    String[] F40header = new String[]{"Version, 1", "Material Type, "};
    @FXML
    private TextField tfFileName;
    @FXML
    private TextField tfHeaderFileLength;
    @FXML
    private ComboBox<String> cbFilmetreicsType;
    @FXML
    private ComboBox<String> cbMaterialType;
    @FXML
    private Label lProcessFile;
    @FXML
    private Label lStatus;

    public void initialize(URL url, ResourceBundle rb) {
        AboutActions.hideAbout(this.about, "About:    Woollam To Filmetrics Module", "This module imports a Woollam generated optical constants file and exports files for the Filmetrics F40 and F50.");
        this.cbFilmetreicsType.getItems().addAll((Object[])new String[]{"F40", "F50"});
        this.cbFilmetreicsType.setValue((Object)"F40");
        this.cbFilmetreicsType.setVisibleRowCount(2);
        this.cbMaterialType.getItems().addAll((Object[])new String[]{"(1) Metal", "(2) Semiconductor", "(3) Insulator", "(4) Photoresist", "(5) Other"});
        this.cbMaterialType.setValue((Object)"(1) Metal");
        this.cbMaterialType.setVisibleRowCount(5);
        try {
            CNSTdefaultParameters.getFileParameters();
            this.openDir = CNSTdefaultParameters.openDir;
            this.saveToDir = CNSTdefaultParameters.saveToDir;
        }
        catch (Exception ex) {
            Logger.getLogger(Woollam2FilmetricsController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void convertFile(ActionEvent event) {
        if (file != null) {
            this.nF40 = this.tfFileName.getText() + ".nnn";
            this.kF40 = this.tfFileName.getText() + ".kkk";
            this.nkF50 = this.tfFileName.getText() + ".fitnk";
            String fileName = file.getPath();
            String filmetricsType = (String)this.cbFilmetreicsType.getValue();
            int materialType = this.cbMaterialType.getSelectionModel().getSelectedIndex() + 1;
            switch (filmetricsType) {
                case "F40": {
                    try {
                        FileWriter nFstream = new FileWriter(this.saveToDir + this.nF40);
                        BufferedWriter nOut = new BufferedWriter(nFstream);
                        FileWriter kFstream = new FileWriter(this.saveToDir + this.kF40);
                        BufferedWriter kOut = new BufferedWriter(kFstream);
                        nOut.write(this.F40header[0] + "\n");
                        kOut.write(this.F40header[0] + "\n");
                        nOut.write(this.F40header[1] + materialType + "\n");
                        kOut.write(this.F40header[1] + materialType + "\n");
                        for (int i = 0; i < this.waveLength.size(); ++i) {
                            nOut.write(this.waveLength.get(i).toString() + ", " + this.n.get(i).toString() + "\n");
                            kOut.write(this.waveLength.get(i).toString() + ", " + this.k.get(i).toString() + "\n");
                        }
                        nOut.close();
                        kOut.close();
                        this.lStatus.setText("Saved Files: " + this.nF40 + " and " + this.kF40);
                        this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor));
                        this.displayColor = this.displayColor == 0 ? 1 : 0;
                    }
                    catch (Exception e) {
                        System.err.println("Error: " + e.getMessage());
                    }
                    break;
                }
                case "F50": {
                    try {
                        int i;
                        FileWriter nkFstream = new FileWriter(this.saveToDir + this.nkF50);
                        BufferedWriter nkOut = new BufferedWriter(nkFstream);
                        for (i = 0; i < this.F50header.length; ++i) {
                            if (i == 2) {
                                nkOut.write(this.F50header[i] + materialType + "\n");
                                continue;
                            }
                            nkOut.write(this.F50header[i] + "\n");
                        }
                        for (i = 0; i < this.waveLength.size(); ++i) {
                            nkOut.write(this.waveLength.get(i).toString() + ", " + this.n.get(i).toString() + ", " + this.k.get(i).toString() + "\n");
                        }
                        nkOut.close();
                        this.lStatus.setText("Saved File: " + this.nkF50);
                        this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor));
                        this.displayColor = this.displayColor == 0 ? 1 : 0;
                        break;
                    }
                    catch (Exception e) {
                        System.err.println("Error: " + e.getMessage());
                    }
                }
            }
        } else {
            this.lStatus.setText("ERROR: Process file not loaded! ");
            this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor));
            this.displayColor = this.displayColor == 0 ? 1 : 0;
        }
    }

    @FXML
    private void loadFile(ActionEvent event) {
        FileChooser chooser = new FileChooser();
        chooser.setTitle("Load File - Woollam To Filmetrics Module");
        chooser.setInitialDirectory(new File(this.openDir));
        file = chooser.showOpenDialog((Window)new Stage());
        String fileName = file.getPath();
        if (fileName != null) {
            try {
                String line;
                FileInputStream fstream = new FileInputStream(fileName);
                DataInputStream in = new DataInputStream(fstream);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                String REGEX = "\\s+";
                Pattern p = Pattern.compile(REGEX);
                this.waveLength = new ArrayList();
                this.n = new ArrayList();
                this.k = new ArrayList();
                int headerFileLength = Integer.parseInt(this.tfHeaderFileLength.getText());
                for (int i = 0; i < headerFileLength; ++i) {
                    line = br.readLine();
                }
                while ((line = br.readLine()) != null) {
                    String[] theLine = p.split(line);
                    this.waveLength.add(Double.parseDouble(theLine[0]));
                    this.n.add(Double.parseDouble(theLine[1]));
                    this.k.add(Double.parseDouble(theLine[2]));
                }
                in.close();
                this.lProcessFile.setText("Process File: " + fileName);
                this.lProcessFile.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor2));
                this.displayColor2 = this.displayColor2 == 0 ? 1 : 0;
            }
            catch (Exception e) {
                System.err.println("Error: " + e.getMessage());
                this.lProcessFile.setText("Error: " + e.getMessage());
                this.lProcessFile.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor2));
                this.displayColor2 = this.displayColor2 == 0 ? 1 : 0;
            }
        }
    }

    @FXML
    private void exit(ActionEvent event) {
        System.exit(0);
    }

    @FXML
    private void about(ActionEvent event) {
        AboutActions.showAbout(this.about);
    }
}

