/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.machineResources;

import CNSTnanoToolbox.AboutActions;
import CNSTnanoToolbox.AboutInterface;
import java.io.FileNotFoundException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.stage.Stage;

public class JEOLMaxClockController
implements Initializable,
AboutInterface {
    Stage about = new Stage();
    @FXML
    private TextField tfBeamCurrent;
    @FXML
    private TextField tfDose;
    @FXML
    private TextField tfShotPitch;
    @FXML
    private TextField tfMaxClock;
    @FXML
    private TextField tfMinShotTime;
    @FXML
    private ComboBox<String> cbJEOLtool;

    public void initialize(URL url, ResourceBundle rb) {
        AboutActions.hideAbout(this.about, "About:    JEOL Max Clock Module", "This module calculates the clock speed for various ebeam lithography tools. Calculation is based on beam current, writing dose, shot pitch and tool type.");
        this.cbJEOLtool.getItems().addAll((Object[])new String[]{"6300 4th", "6300 5th", "9300"});
        this.cbJEOLtool.setValue((Object)"6300 4th");
        this.cbJEOLtool.setVisibleRowCount(3);
        ActionEvent event = new ActionEvent();
        try {
            this.calculateTime(event);
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(JEOLMaxClockController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void calculateTime(ActionEvent event) throws FileNotFoundException {
        DecimalFormat df0 = new DecimalFormat("#");
        DecimalFormat df2 = new DecimalFormat("#.##");
        double beamCurrent = Double.parseDouble(this.tfBeamCurrent.getText());
        double dose = Double.parseDouble(this.tfDose.getText());
        double shotPitch = Double.parseDouble(this.tfShotPitch.getText());
        double pixel = this.jeolTool();
        double pixelArea = Math.PI * (pixel * shotPitch / 2.0) * (pixel * shotPitch / 2.0);
        pixelArea = pixelArea * 1.0E-7 * 1.0E-7;
        double charge = dose * pixelArea;
        double time = charge * 1.0E-6 / (beamCurrent * 1.0E-9);
        double timeNanoSec = time / 1.0E-9;
        double frequency = 1.0 / time / 1000000.0;
        String minShotTime = df2.format(timeNanoSec);
        this.tfMinShotTime.setText(minShotTime);
        String maxClock = df2.format(frequency);
        this.tfMaxClock.setText(maxClock);
    }

    public double jeolTool() {
        String machineType;
        double num = 1.0;
        switch (machineType = (String)this.cbJEOLtool.getValue()) {
            case "6300 4th": {
                num = 1.0;
                break;
            }
            case "6300 5th": {
                num = 0.125;
                break;
            }
            case "9300": {
                num = 1.0;
            }
        }
        return num;
    }

    @FXML
    private void exit(ActionEvent event) {
        System.exit(0);
    }

    @FXML
    private void about(ActionEvent event) {
        AboutActions.showAbout(this.about);
    }
}

