/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.advancedCAD;

import CNSTnanoToolbox.AboutActions;
import CNSTnanoToolbox.AboutInterface;
import CNSTnanoToolbox.advancedCAD.PhotonicCrystalsController;
import CNSTnanoToolbox.advancedCAD.VerniersData;
import CNSTnanoToolbox.shapeMethods.LabelColors;
import CNSTnanoToolbox.shapeMethods.Verniers;
import CNSTnanoToolbox.xml.CNSTdefaultParameters;
import JGDS2.GArea;
import JGDS2.Lib;
import JGDS2.Ref;
import JGDS2.Struct;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.paint.Paint;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Callback;

public class VerniersController
implements AboutInterface {
    static File file = null;
    Stage about = new Stage();
    String openDir;
    String saveToDir;
    int displayColor = 0;
    final ObservableList<VerniersData> ol = FXCollections.observableArrayList();
    @FXML
    private TableView<VerniersData> tVerniers;
    @FXML
    private TextField tfFileName;
    @FXML
    private TextField tfFontSize;
    @FXML
    private TextField tfFontReso;
    @FXML
    private Label lStatus;

    @FXML
    private void createGDS(ActionEvent event) {
        String fileName = this.tfFileName.getText();
        Lib lib = new Lib();
        this.createGratings(lib);
        File f = lib.GDSOut(this.saveToDir + fileName + ".gds");
        this.lStatus.setText("Saved to " + f.getAbsolutePath());
        this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor));
        this.displayColor = this.displayColor == 0 ? 1 : 0;
    }

    @FXML
    private void loadVerniersTable(ActionEvent event) {
        FileChooser chooser = new FileChooser();
        chooser.setTitle("Load File - Vernier Table Module");
        chooser.setInitialDirectory(new File(this.openDir));
        file = chooser.showOpenDialog((Window)new Stage());
        String fileName = file.getPath();
        if (fileName != null) {
            try {
                FileInputStream fstream = new FileInputStream(fileName);
                DataInputStream in = new DataInputStream(fstream);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                String REGEX = "\\s+";
                Pattern p = Pattern.compile(REGEX);
                int cnt = 0;
                String line = br.readLine();
                while ((line = br.readLine()) != null) {
                    String[] theLine = p.split(line);
                    ((VerniersData)this.tVerniers.getItems().get(cnt)).setLayerA(theLine[0]);
                    ((VerniersData)this.tVerniers.getItems().get(cnt)).setLayerB(theLine[1]);
                    ((VerniersData)this.tVerniers.getItems().get(cnt)).setResolution(theLine[2]);
                    ((VerniersData)this.tVerniers.getItems().get(cnt)).setTicks(theLine[3]);
                    ((VerniersData)this.tVerniers.getItems().get(cnt)).setLabelA(theLine[4]);
                    ((VerniersData)this.tVerniers.getItems().get(cnt)).setLabelB(theLine[5]);
                    ((VerniersData)this.tVerniers.getItems().get(cnt)).setWidth(theLine[6]);
                    ((VerniersData)this.tVerniers.getItems().get(cnt)).setLength(theLine[7]);
                    ((VerniersData)this.tVerniers.getItems().get(cnt)).setPitch(theLine[8]);
                    ++cnt;
                }
                in.close();
                this.lStatus.setText("Verniers Table data loaded from " + fileName);
                this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor));
                this.displayColor = this.displayColor == 0 ? 1 : 0;
            }
            catch (Exception e) {
                System.err.println("Error: " + e.getMessage());
            }
        }
    }

    @FXML
    private void exit(ActionEvent event) {
        System.exit(0);
    }

    @FXML
    private void about(ActionEvent event) {
        AboutActions.showAbout(this.about);
    }

    public void createGratings(Lib lib) {
        for (int i = 0; i < this.tVerniers.getItems().size(); ++i) {
            if (!this.checkNullValues(((VerniersData)this.tVerniers.getItems().get(i)).getLayerA(), ((VerniersData)this.tVerniers.getItems().get(i)).getLayerB(), ((VerniersData)this.tVerniers.getItems().get(i)).getResolution(), ((VerniersData)this.tVerniers.getItems().get(i)).getTicks(), ((VerniersData)this.tVerniers.getItems().get(i)).getLabelA(), ((VerniersData)this.tVerniers.getItems().get(i)).getLabelB(), ((VerniersData)this.tVerniers.getItems().get(i)).getWidth(), ((VerniersData)this.tVerniers.getItems().get(i)).getLength(), ((VerniersData)this.tVerniers.getItems().get(i)).getPitch())) continue;
            int layerA = Integer.parseInt(((VerniersData)this.tVerniers.getItems().get(i)).getLayerA());
            int layerB = Integer.parseInt(((VerniersData)this.tVerniers.getItems().get(i)).getLayerB());
            double resolution = Double.parseDouble(((VerniersData)this.tVerniers.getItems().get(i)).getResolution());
            int ticks = Integer.parseInt(((VerniersData)this.tVerniers.getItems().get(i)).getTicks());
            String labelA = ((VerniersData)this.tVerniers.getItems().get(i)).getLabelA();
            String labelB = ((VerniersData)this.tVerniers.getItems().get(i)).getLabelB();
            double width = Double.parseDouble(((VerniersData)this.tVerniers.getItems().get(i)).getWidth());
            double length = Double.parseDouble(((VerniersData)this.tVerniers.getItems().get(i)).getLength());
            double pitch = Double.parseDouble(((VerniersData)this.tVerniers.getItems().get(i)).getPitch());
            double fontSize = Double.parseDouble(this.tfFontSize.getText());
            double fontReso = Double.parseDouble(this.tfFontReso.getText());
            String structName = "R" + this.rowNumberPrefix(i) + (i + 1) + "L" + layerA + "L" + layerB + "Reso" + (int)(resolution * 1000.0) + "nm";
            Struct verniers = new Struct(structName);
            ArrayList<GArea> alGA = Verniers.createVerniers(layerA, layerB, resolution, ticks, labelA, labelB, fontSize, fontReso, width, length, pitch);
            for (int j = 0; j < alGA.size(); ++j) {
                verniers.add(alGA.get(j));
            }
            lib.add(new Ref(verniers, 0.0, 0.0));
        }
    }

    public String rowNumberPrefix(int i) {
        boolean b = i < 10;
        return b ? "0" : "";
    }

    public boolean checkNullValues(String layerA, String layerB, String resolution, String ticks, String labelA, String labelB, String width, String length, String pitch) {
        return layerA != null && layerB != null && resolution != null && ticks != null && labelA != null && labelB != null && width != null && length != null && pitch != null;
    }

    @FXML
    private void initialize() {
        AboutActions.hideAbout(this.about, "About:    Verniers Module", "This module creates custom verniers to be used for calculating alignment offsets between various lithographic levels.");
        int numPhCs = 100;
        for (int i = 0; i < numPhCs; ++i) {
            this.ol.add((Object)new VerniersData(null, null, null, null, null, null, null, null, null));
        }
        this.tVerniers.setItems(this.ol);
        final TableColumn c1 = new TableColumn("LayerA");
        c1.setCellValueFactory((Callback)new PropertyValueFactory("layerA"));
        c1.setCellFactory((Callback)new TextFieldCellFactory());
        c1.setPrefWidth(50.0);
        c1.setSortable(false);
        c1.setResizable(false);
        final TableColumn c2 = new TableColumn("LayerB");
        c2.setCellValueFactory((Callback)new PropertyValueFactory("layerB"));
        c2.setCellFactory((Callback)new TextFieldCellFactory());
        c2.setPrefWidth(50.0);
        c2.setSortable(false);
        c2.setResizable(false);
        final TableColumn c3 = new TableColumn("Resolution(um)");
        c3.setCellValueFactory((Callback)new PropertyValueFactory("resolution"));
        c3.setCellFactory((Callback)new TextFieldCellFactory());
        c3.setPrefWidth(95.0);
        c3.setSortable(false);
        c3.setResizable(false);
        final TableColumn c4 = new TableColumn("Ticks");
        c4.setCellValueFactory((Callback)new PropertyValueFactory("ticks"));
        c4.setCellFactory((Callback)new TextFieldCellFactory());
        c4.setPrefWidth(40.0);
        c4.setSortable(false);
        c4.setResizable(false);
        final TableColumn c5 = new TableColumn("LabelA");
        c5.setCellValueFactory((Callback)new PropertyValueFactory("labelA"));
        c5.setCellFactory((Callback)new TextFieldCellFactory());
        c5.setPrefWidth(70.0);
        c5.setSortable(false);
        c5.setResizable(false);
        final TableColumn c6 = new TableColumn("LabelB");
        c6.setCellValueFactory((Callback)new PropertyValueFactory("labelB"));
        c6.setCellFactory((Callback)new TextFieldCellFactory());
        c6.setPrefWidth(70.0);
        c6.setSortable(false);
        c6.setResizable(false);
        final TableColumn c7 = new TableColumn("Width(um)");
        c7.setCellValueFactory((Callback)new PropertyValueFactory("width"));
        c7.setCellFactory((Callback)new TextFieldCellFactory());
        c7.setPrefWidth(70.0);
        c7.setSortable(false);
        c7.setResizable(false);
        final TableColumn c8 = new TableColumn("Length(um)");
        c8.setCellValueFactory((Callback)new PropertyValueFactory("length"));
        c8.setCellFactory((Callback)new TextFieldCellFactory());
        c8.setPrefWidth(77.0);
        c8.setSortable(false);
        c8.setResizable(false);
        final TableColumn c9 = new TableColumn("Pitch(um)");
        c9.setCellValueFactory((Callback)new PropertyValueFactory("pitch"));
        c9.setCellFactory((Callback)new TextFieldCellFactory());
        c9.setPrefWidth(70.0);
        c9.setSortable(false);
        c9.setResizable(false);
        this.tVerniers.getColumns().addAll((Object[])new TableColumn[]{c1, c2, c3, c4, c5, c6, c7, c8, c9});
        this.tVerniers.getColumns().addListener(new ListChangeListener(){
            public boolean suspended;

            public void onChanged(ListChangeListener.Change change) {
                change.next();
                if (change.wasReplaced() && !this.suspended) {
                    this.suspended = true;
                    VerniersController.this.tVerniers.getColumns().setAll((Object[])new TableColumn[]{c1, c2, c3, c4, c5, c6, c7, c8, c9});
                    this.suspended = false;
                }
            }
        });
        try {
            CNSTdefaultParameters.getFileParameters();
            this.openDir = CNSTdefaultParameters.openDir;
            this.saveToDir = CNSTdefaultParameters.saveToDir;
        }
        catch (Exception ex) {
            Logger.getLogger(PhotonicCrystalsController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static class TextFieldCellFactory
    implements Callback<TableColumn<VerniersData, String>, TableCell<VerniersData, String>> {
        public TableCell<VerniersData, String> call(TableColumn<VerniersData, String> param) {
            TextFieldCell textFieldCell = new TextFieldCell();
            return textFieldCell;
        }

        public static class TextFieldCell
        extends TableCell<VerniersData, String> {
            private TextField textField;
            private StringProperty boundToCurrently = null;

            public TextFieldCell() {
                String strCss = "-fx-padding: 0;";
                this.setStyle(strCss);
                this.textField = new TextField();
                strCss = "-fx-background-color: -fx-control-inner-background;-fx-background-insets: 0;-fx-background-radius: 0;-fx-padding: 3 5 3 5;-fx-prompt-text-fill: derive(-fx-control-inner-background,-30%);-fx-cursor: text;";
                this.textField.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                    public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                        TextField tf = (TextField)this.getGraphic();
                        String strStyleGotFocus = "-fx-background-color: purple, -fx-text-box-border, -fx-control-inner-background;-fx-background-insets: -0.4, 1, 2;-fx-background-radius: 3.4, 2, 2;";
                        String strStyleLostFocus = "-fx-background-color: -fx-control-inner-background;-fx-background-insets: 0;-fx-background-radius: 0;-fx-padding: 3 5 3 5;-fx-prompt-text-fill: derive(-fx-control-inner-background,-30%);-fx-cursor: text;";
                        if (newValue.booleanValue()) {
                            tf.setStyle(strStyleGotFocus);
                        } else {
                            tf.setStyle(strStyleLostFocus);
                        }
                    }
                });
                this.textField.hoverProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

                    public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                        TextField tf = (TextField)this.getGraphic();
                        String strStyleGotHover = "-fx-background-color: derive(purple,90%), -fx-text-box-border, derive(-fx-control-inner-background, 10%);-fx-background-insets: 1, 2.8, 3.8;-fx-background-radius: 3.4, 2, 2;";
                        String strStyleLostHover = "-fx-background-color: -fx-control-inner-background;-fx-background-insets: 0;-fx-background-radius: 0;-fx-padding: 3 5 3 5;-fx-prompt-text-fill: derive(-fx-control-inner-background,-30%);-fx-cursor: text;";
                        String strStyleHasFocus = "-fx-background-color: purple, -fx-text-box-border, -fx-control-inner-background;-fx-background-insets: -0.4, 1, 2;-fx-background-radius: 3.4, 2, 2;";
                        if (newValue.booleanValue()) {
                            tf.setStyle(strStyleGotHover);
                        } else if (!tf.focusedProperty().get()) {
                            tf.setStyle(strStyleLostHover);
                        } else {
                            tf.setStyle(strStyleHasFocus);
                        }
                    }
                });
                this.textField.setStyle(strCss);
                this.setGraphic((Node)this.textField);
            }

            protected void updateItem(String item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (!empty) {
                    this.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
                    ObservableValue ov = this.getTableColumn().getCellObservableValue(this.getIndex());
                    SimpleStringProperty sp = (SimpleStringProperty)ov;
                    if (this.boundToCurrently == null) {
                        this.boundToCurrently = sp;
                        this.textField.textProperty().bindBidirectional((Property)sp);
                    } else if (this.boundToCurrently != sp) {
                        this.textField.textProperty().unbindBidirectional((Property)this.boundToCurrently);
                        this.boundToCurrently = sp;
                        this.textField.textProperty().bindBidirectional((Property)this.boundToCurrently);
                    }
                } else {
                    this.setContentDisplay(ContentDisplay.TEXT_ONLY);
                }
            }
        }
    }
}

