/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.advancedCAD;

import CNSTnanoToolbox.AboutActions;
import CNSTnanoToolbox.AboutInterface;
import CNSTnanoToolbox.shapeMethods.LabelColors;
import CNSTnanoToolbox.xml.CNSTdefaultParameters;
import JGDS2.Lib;
import JGDS2.Rect;
import JGDS2.Ref;
import JGDS2.Struct;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.paint.Paint;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;

public class RandomRectArrayController
implements Initializable,
AboutInterface {
    Stage about = new Stage();
    String openDir;
    String saveToDir;
    int displayColor = 0;
    int displayColor2 = 0;
    int displayColor3 = 0;
    static File file = null;
    @FXML
    private TextField tfFileName;
    @FXML
    private TextField tfSizeX;
    @FXML
    private TextField tfSizeY;
    @FXML
    private TextField tfElementsX;
    @FXML
    private TextField tfElementsY;
    @FXML
    private TextField tfLayer;
    @FXML
    private TextField tfWeight;
    @FXML
    private CheckBox chbLoadFile;
    @FXML
    private Label lFileStatus;
    @FXML
    private Label lResultsStatus;
    @FXML
    private Label lStatus;

    public void initialize(URL url, ResourceBundle rb) {
        AboutActions.hideAbout(this.about, "About:    Random Square Array Module", "This module creates lattice of adjoining rectangular elements. Probability of occupation at each lattice is defined by a user defined 'Weight %' value.");
        try {
            CNSTdefaultParameters.getFileParameters();
            this.openDir = CNSTdefaultParameters.openDir;
            this.saveToDir = CNSTdefaultParameters.saveToDir;
        }
        catch (Exception ex) {
            Logger.getLogger(RandomRectArrayController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void createGDS(ActionEvent event) {
        double sizeX = Double.parseDouble(this.tfSizeX.getText());
        double sizeY = Double.parseDouble(this.tfSizeY.getText());
        double weight = Double.parseDouble(this.tfWeight.getText()) / 100.0;
        int elementsX = Integer.parseInt(this.tfElementsX.getText());
        int elementsY = Integer.parseInt(this.tfElementsY.getText());
        int layer = Integer.parseInt(this.tfLayer.getText());
        String fileName = this.tfFileName.getText();
        Lib lib = new Lib();
        Struct top = new Struct("top");
        int cntYES = 0;
        int cntNO = 0;
        if (this.chbLoadFile.isSelected()) {
            ArrayList<ArrayList> dataList = this.getDataFromFile();
            for (int i = 0; i < dataList.get(0).size(); ++i) {
                double xCoord = Double.parseDouble((String)dataList.get(0).get(i));
                double yCoord = Double.parseDouble((String)dataList.get(1).get(i));
                top.add(new Rect(xCoord, yCoord, xCoord + sizeX, yCoord + sizeY, layer));
            }
        } else {
            for (int i = 0; i < elementsY; ++i) {
                for (int j = 0; j < elementsX; ++j) {
                    double randomValue = Math.random();
                    if (randomValue <= weight) {
                        top.add(new Rect((double)j * sizeX, (double)i * sizeY, (double)j * sizeX + sizeX, (double)i * sizeY + sizeY, layer));
                        ++cntYES;
                        continue;
                    }
                    ++cntNO;
                }
            }
            DecimalFormat df2 = new DecimalFormat("#.##");
            double percentage = (double)cntYES * 100.0 / (double)(cntYES + cntNO);
            String resultOutput = "Drawn = " + cntYES + "    Skipped = " + cntNO + "    Total = " + (cntYES + cntNO) + "    Drawn = " + df2.format(percentage) + "%";
            this.lResultsStatus.setText("Results: " + resultOutput);
            this.lResultsStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor2));
            this.displayColor2 = this.displayColor2 == 0 ? 1 : 0;
        }
        lib.add(new Ref(top, 0.0, 0.0));
        File f = lib.GDSOut(this.saveToDir + fileName + ".gds");
        this.lStatus.setText("Saved to " + f.getAbsolutePath());
        this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor));
        this.displayColor = this.displayColor == 0 ? 1 : 0;
    }

    @FXML
    private void loadFile(ActionEvent event) {
        FileChooser chooser = new FileChooser();
        chooser.setTitle("Load File - Random Rectangular Array Module");
        chooser.setInitialDirectory(new File(this.openDir));
        file = chooser.showOpenDialog((Window)new Stage());
        this.lFileStatus.setText("File: " + file.getName());
        this.lFileStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor3));
        this.displayColor3 = this.displayColor3 == 0 ? 1 : 0;
    }

    public ArrayList<ArrayList> getDataFromFile() {
        ArrayList<ArrayList> arrayList = new ArrayList<ArrayList>();
        for (int i = 0; i < 2; ++i) {
            arrayList.add(new ArrayList());
        }
        String fileName = file.getPath();
        if (fileName != null) {
            try {
                FileInputStream fstream = new FileInputStream(fileName);
                DataInputStream in = new DataInputStream(fstream);
                BufferedReader br = new BufferedReader(new InputStreamReader(in));
                String REGEX = "\\s+";
                Pattern p = Pattern.compile(REGEX);
                String line = br.readLine();
                while ((line = br.readLine()) != null) {
                    String[] theline = p.split(line);
                    for (int i = 0; i < theline.length; ++i) {
                        ((ArrayList)arrayList.get(i)).add(theline[i]);
                    }
                }
                in.close();
            }
            catch (Exception e) {
                System.err.println("Error: " + e.getMessage());
            }
        } else {
            this.lResultsStatus.setText("Results: ERROR:  FILE NAME = NULL!!");
            this.lResultsStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor2));
            this.displayColor2 = this.displayColor2 == 0 ? 1 : 0;
        }
        this.lResultsStatus.setText("Results: " + ((ArrayList)arrayList.get(0)).size() + " shapes drawn from file.");
        this.lResultsStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor2));
        this.displayColor2 = this.displayColor2 == 0 ? 1 : 0;
        return arrayList;
    }

    @FXML
    private void exit(ActionEvent event) {
        System.exit(0);
    }

    @FXML
    private void about(ActionEvent event) {
        AboutActions.showAbout(this.about);
    }
}

