/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.advancedCAD;

import CNSTnanoToolbox.AboutActions;
import CNSTnanoToolbox.AboutInterface;
import CNSTnanoToolbox.shapeMethods.LabelColors;
import CNSTnanoToolbox.xml.CNSTdefaultParameters;
import JGDS2.GArea;
import JGDS2.Lib;
import JGDS2.Ref;
import JGDS2.Struct;
import java.awt.geom.Path2D;
import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.paint.Paint;
import javafx.stage.Stage;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class FunctionGeneratorController
implements Initializable,
AboutInterface {
    Stage about = new Stage();
    String openDir;
    String saveToDir;
    int displayColor = 0;
    @FXML
    private TextField tfFileName;
    @FXML
    private TextField tfFunction;
    @FXML
    private TextField tfLowerLimit;
    @FXML
    private TextField tfUpperLimit;
    @FXML
    private TextField tfIncrement;
    @FXML
    private TextField tfWidth;
    @FXML
    private TextField tfLayer;
    @FXML
    private Label lStatus;

    public void initialize(URL url, ResourceBundle rb) {
        AboutActions.hideAbout(this.about, "About:    Arbitrary Function Generator Module", "This module creates a GDS shapes from a user defined mathematical function. Shape is accordingly fractured so that the number of vertices does not exceed the maximum allowed by the GDS standard.");
        try {
            CNSTdefaultParameters.getFileParameters();
            this.openDir = CNSTdefaultParameters.openDir;
            this.saveToDir = CNSTdefaultParameters.saveToDir;
        }
        catch (Exception ex) {
            Logger.getLogger(FunctionGeneratorController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void createGDS(ActionEvent event) throws Exception {
        double lowerLimit = Double.parseDouble(this.tfLowerLimit.getText());
        double upperLimit = Double.parseDouble(this.tfUpperLimit.getText());
        double increment = Double.parseDouble(this.tfIncrement.getText());
        double width = Double.parseDouble(this.tfWidth.getText());
        int layer = Integer.parseInt(this.tfLayer.getText());
        String function = this.tfFunction.getText();
        String fileName = this.tfFileName.getText();
        int numPts = (int)(((upperLimit += increment) - lowerLimit) / increment) + 1;
        ScriptEngineManager manager = new ScriptEngineManager();
        ScriptEngine engine = manager.getEngineByName("nashorn");
        double[] delX = new double[numPts];
        double[] delY = new double[numPts];
        double[] angle = new double[numPts];
        double[] valY = new double[numPts + 1];
        double[] valX = new double[numPts + 1];
        double r = width / 2.0;
        for (int i = 0; i < numPts + 1; ++i) {
            engine.put("x", lowerLimit);
            valY[i] = Double.parseDouble(engine.eval(this.tfFunction.getText()).toString());
            valX[i] = lowerLimit;
            lowerLimit += increment;
        }
        Lib lib = new Lib();
        Struct top = new Struct("top");
        for (int i = 0; i < numPts; ++i) {
            delX[i] = valX[i + 1] - valX[i];
            delY[i] = valY[i + 1] - valY[i];
            angle[i] = Math.atan2(delY[i], delX[i]);
            double angleDeg = 57.29577951308232 * angle[i];
        }
        Path2D.Double pathOut = new Path2D.Double();
        Path2D.Double pathBack = new Path2D.Double();
        for (int i = 0; i < numPts - 1; ++i) {
            double y2;
            double x2;
            double y1;
            double x1;
            double theta1;
            double theta2;
            if (i == 0) {
                theta2 = angle[i] - 1.5707963267948966;
                theta1 = theta2 + Math.PI;
                x1 = valX[i] + FunctionGeneratorController.fX(r, theta1);
                y1 = valY[i] + FunctionGeneratorController.fY(r, theta1);
                x2 = valX[i] + FunctionGeneratorController.fX(r, theta2);
                y2 = valY[i] + FunctionGeneratorController.fY(r, theta2);
                pathOut.moveTo(x1, y1);
                pathBack.moveTo(x2, y2);
            } else {
                theta1 = (angle[i - 1] + Math.PI + angle[i] + Math.PI * 2) % (Math.PI * 2) / 2.0;
                theta2 = theta1 + Math.PI;
                x1 = valX[i] + FunctionGeneratorController.fX(r, theta1);
                y1 = valY[i] + FunctionGeneratorController.fY(r, theta1);
                x2 = valX[i] + FunctionGeneratorController.fX(r, theta2);
                y2 = valY[i] + FunctionGeneratorController.fY(r, theta2);
                pathOut.lineTo(x1, y1);
                pathBack.lineTo(x2, y2);
            }
            if (!(i % 100 == 0 | i == numPts - 2)) continue;
            pathOut.append(GArea.reversePath(pathBack), true);
            pathOut.closePath();
            top.add(new GArea(pathOut, layer));
            pathOut = new Path2D.Double();
            pathBack = new Path2D.Double();
            pathOut.moveTo(x1, y1);
            pathBack.moveTo(x2, y2);
        }
        lib.add(new Ref(top, 0.0, 0.0));
        File f = lib.GDSOut(this.saveToDir + fileName + ".gds");
        this.lStatus.setText("Saved to " + f.getAbsolutePath());
        this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor));
        this.displayColor = this.displayColor == 0 ? 1 : 0;
    }

    static void evaluateFunction() {
        System.out.println("BAM4444");
        ScriptEngineManager factory = new ScriptEngineManager();
        ScriptEngine engine = factory.getEngineByName("nashorn");
        try {
            engine.eval("print('Hello, World!');");
        }
        catch (ScriptException se) {
            se.printStackTrace();
        }
    }

    static double fX(double r, double theta) {
        return r * Math.cos(theta);
    }

    static double fY(double r, double theta) {
        return r * Math.sin(theta);
    }

    @FXML
    private void exit(ActionEvent event) {
        System.exit(0);
    }

    @FXML
    private void about(ActionEvent event) {
        AboutActions.showAbout(this.about);
    }
}

