/*
 * Decompiled with CFR 0.152.
 */
import JGDS2.Array;
import JGDS2.BarCode;
import JGDS2.Constants;
import JGDS2.GArea;
import JGDS2.Lib;
import JGDS2.RectArea;
import JGDS2.Ref;
import JGDS2.Struct;
import JGDS2.Text;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.io.File;

public class lens
implements Constants {
    static double lensRad = 1000000.0;
    static double MaxRad = 7000.0;
    static double maxDose = 8000.0;
    static double minDose = 0.0;
    static int NUMSTEPS = 64;
    static double Lambda = 0.248;
    static int DONE = 1;
    static double maxError = 0.05;
    static boolean goingDown;
    static boolean startDark;
    static int function;
    static final int lens = 0;
    static final int blaze = 1;

    static double resistHeight(double dose) {
        return (0.04366 * dose - 2.255E-6 * dose * dose + 8.206E-10 * dose * dose * dose) / 1000.0;
    }

    static double stepRadius(double depth) {
        return Math.sqrt(lensRad * lensRad - (lensRad - depth) * (lensRad - depth));
    }

    static Path2D.Double isoline(double depth) {
        Path2D.Double path = new Path2D.Double();
        switch (function) {
            case 0: {
                double rad = lens.stepRadius(depth);
                double angle = 0.39269908169872414;
                double x = rad;
                double y = 0.0;
                double t = 0.0;
                if (rad > MaxRad) {
                    DONE = -1;
                }
                path.moveTo(x, y);
                int points = rad <= maxError ? 1 : (int)Math.ceil(angle / (2.0 * Math.acos((rad - maxError) / rad)));
                System.out.println("isoline  #points = " + points);
                double delta = angle / (double)points;
                for (int i = 1; i <= points; ++i) {
                    x = rad * Math.cos((double)i * delta);
                    y = rad * Math.sin((double)i * delta);
                    path.lineTo(x, y);
                }
                break;
            }
            case 1: {
                double x = depth * 100.0;
                if (x * 8.0 > MaxRad) {
                    DONE = -1;
                }
                path.moveTo(x, 0.0);
                path.lineTo(x, 200.0);
            }
        }
        return path;
    }

    static double[] zoneDepths() {
        double[] depths = new double[NUMSTEPS];
        double doseStep = (maxDose - minDose) / (double)NUMSTEPS;
        for (int i = 0; i < NUMSTEPS; ++i) {
            depths[lens.goingDown ? i : lens.NUMSTEPS - i - 1] = lens.resistHeight(minDose + (double)i * doseStep);
            System.out.println("height=[" + (goingDown ? i : NUMSTEPS - i - 1) + "] =" + depths[goingDown ? i : NUMSTEPS - i - 1] + ", dose =" + (minDose + (double)i * doseStep));
        }
        return depths;
    }

    static Struct aLens() {
        int i;
        DONE = 1;
        Struct lens2 = new Struct("lens" + function);
        int step = -1;
        int pathsOpen = 0;
        int maskNum = Math.round((float)(Math.log(NUMSTEPS) / Math.log(2.0)));
        System.out.println("mask# " + maskNum);
        double[] depths = lens.zoneDepths();
        double devTime = (double)(NUMSTEPS - 1) / ((double)NUMSTEPS * depths[goingDown ? depths.length - 1 : 0]) * Lambda;
        Path2D.Double[] poly = new Path2D.Double[maskNum];
        for (i = 0; i < maskNum; ++i) {
            poly[i] = new Path2D.Double();
        }
        while (DONE != 0) {
            Path2D.Double path = lens.isoline((goingDown ? depths[step % NUMSTEPS] * devTime : Lambda - depths[++step % NUMSTEPS] * devTime) + Lambda * (double)(step / NUMSTEPS));
            for (i = 0; i < maskNum; ++i) {
                if (step % (1 << i) != 0) continue;
                if (!(step % (1 << i + 1) == 0 ^ startDark)) {
                    poly[i].append(GArea.reversePath(path), true);
                    poly[i].closePath();
                    if (DONE != -1 || (pathsOpen &= ~(1 << i)) != 0) continue;
                    DONE = 0;
                    i = maskNum;
                    continue;
                }
                poly[i].append(path, false);
                pathsOpen |= 1 << i;
            }
        }
        for (int t = 0; t < maskNum; ++t) {
            Struct maski = new Struct("mask_" + t + function, new GArea(poly[t], t));
            if (function == 0) {
                Struct kit = new Struct("kit_" + t + function);
                kit.add(new Ref(maski, 0.0, 0.0));
                kit.add(new Ref(maski, 0.0, 0.0, 0, 22.5));
                kit.add(new Ref(maski, 0.0, 0.0, 0, 45.0));
                kit.add(new Ref(maski, 0.0, 0.0, 0, 67.5));
                lens2.add(new Ref(kit, 0.0, 0.0));
            } else {
                lens2.add(new Ref(maski, 0.0, 0.0));
            }
            System.out.println("lens add mask" + t);
        }
        System.out.println("dev time " + devTime);
        return lens2;
    }

    public static void main(String[] args) {
        Lib lib = new Lib();
        Struct lns = lens.aLens();
        lib.add(new Ref(lns, 0.0, 0.0));
        function = 1;
        lib.add(new Ref(lens.aLens(), 10000.0, 0.0));
        File f = lib.GDSOut("lens");
        System.out.println(" Saved to " + f.getAbsolutePath());
    }

    public static Struct lineWidth(int[] size, int[] step, double duty, boolean DF, boolean VA, double length, int numLines) {
        int textSize = 25;
        String sDF = DF ? "N" : "";
        String sVia = VA ? "V" : "";
        int sizeMin = size[0];
        int sizeMax = size[size.length - 1];
        int sn = 0;
        int MinSep = 5;
        Struct f = new Struct(sDF + sVia + "G_" + sizeMin + "_" + sizeMax + "_" + numLines + "_" + (int)duty);
        int del = 0;
        for (int n = sizeMin; n <= sizeMax; n += step[sn]) {
            if (n < sizeMax && n >= size[sn + 1]) {
                ++sn;
            }
            double s = (double)n * 0.001;
            Struct text = new Struct("text_" + n, new Text("" + n, 2, textSize));
            if (VA) {
                GArea v = new GArea(new RectArea(0.0, 0.0, s, s, 2), 2);
                Struct via = new Struct("via_" + n, v);
                int num = (int)(length / (s * duty));
                System.out.println("num " + num + " len " + length + " n " + n + " duty " + duty);
                double len = (double)numLines * duty * s;
                double len2 = (double)num * (s * duty);
                double theta = Math.atan2(numLines, 1.1);
                if (numLines == 1) {
                    theta = 0.0;
                }
                Double angle = theta / 3.141592653589 * 180.0;
                Struct vLine = new Struct("vl_" + n + "_" + duty + "_" + numLines, new Array(via, 0.0, 0.0, numLines, 1, len * Math.cos(theta), len * Math.sin(theta), 0.0, 0.0, angle));
                if (DF) {
                    GArea nv = new GArea(new RectArea(-s * (duty - 1.0) * 0.75, -s * (duty - 1.0) * 0.75, s + s * (duty - 1.0) * 0.75, s + s * (duty - 1.0) * 0.75, 2), 2);
                    nv.subtract(v);
                    Struct nvia = new Struct("Nv_" + n + "_" + duty, nv);
                    Struct nvLine = new Struct("Nvl_" + n + "_" + duty + "_" + numLines, new Array(nvia, 0.0, 0.0, numLines, 1, len * Math.cos(theta), len * Math.sin(theta), 0.0, 0.0, angle));
                    f.add(new Array(nvLine, -length - 20.0, (double)del + (double)textSize / 3.0, num, 1, len2, 1.0));
                } else {
                    f.add(new Array(vLine, -length - 20.0, (double)del + (double)textSize / 3.0, num, 1, len2, 1.0));
                }
            } else if (DF) {
                GArea ng = new GArea(new RectArea(-10.0, -((duty - 1.0) * s) * 0.75, length + 10.0, s + (duty - 1.0) * s * 0.75, 2), 2);
                GArea g = new GArea(new RectArea(0.0, 0.0, length, s, 2), 2);
                ng.subtract(g);
                Struct nbar = new Struct("Nbar_" + n + "_" + (int)duty, ng);
                f.add(new Array(nbar, -length - 20.0, (double)del + (double)textSize / 3.0, 1, numLines, 1.0, s * (double)numLines * duty));
            } else {
                Struct bar = new Struct("bar_" + n, new RectArea(0.0, 0.0, length, (double)n / 1000.0, 2));
                f.add(new Array(bar, -length - 20.0, (double)del + (double)textSize / 3.0, 1, numLines, 1.0, s * (double)numLines * duty));
            }
            System.out.println("del " + del);
            f.add(new Ref(text, 0.0, del));
            del += duty * s * (double)numLines + 5.0 > (double)(textSize + MinSep) ? (int)(s * duty * (double)numLines + 5.0) : textSize + MinSep;
        }
        return f;
    }

    public static GArea torus(double inSize, double outSize) {
        int i;
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(inSize, 0.0);
        int points = 120;
        double delta = Math.PI * 2 / (double)points;
        for (i = 1; i < points; ++i) {
            poly.lineTo(inSize * Math.cos((double)i * delta), inSize * Math.sin((double)i * delta));
        }
        poly.moveTo(inSize, 0.0);
        poly.moveTo(outSize, 0.0);
        for (i = points - 1; i > 0; --i) {
            poly.lineTo(inSize * Math.cos((double)i * delta), inSize * Math.sin((double)i * delta));
        }
        poly.moveTo(outSize, 0.0);
        poly.moveTo(inSize, 0.0);
        poly.closePath();
        GArea v = new GArea(poly, 1);
        return v;
    }

    public static Struct star(double size, int numlines) {
        if (numlines < 2) {
            numlines = 2;
        }
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(0.0, 0.0);
        poly.lineTo(size, 0.0);
        double angle = Math.PI / (double)numlines;
        poly.lineTo(size * Math.cos(angle), size * Math.sin(angle));
        poly.closePath();
        GArea v = new GArea(poly, 1);
        Struct f = new Struct("star_bar" + (int)size + "_" + numlines, v);
        Struct lf = new Struct("star_" + (int)size + "_" + numlines);
        angle = 360.0 / (double)numlines;
        for (int i = 0; i < numlines; ++i) {
            lf.add(new Ref(f, 0.0, 0.0, 0, angle * (double)i));
        }
        return lf;
    }

    public static Struct frame(int tool, String barcode, String label) {
        Struct f = new Struct("frame");
        switch (tool) {
            case 1: {
                GArea pr = new GArea(new RectArea(-2500.0, -150.0, 2500.0, 150.0, 1), 1);
                pr.transform(AffineTransform.getRotateInstance(0.7853981633974483));
                RectArea r = new RectArea(-1750.0, -300.0, 1750.0, 300.0, 1);
                pr.or(r);
                Area a = new Area(pr.getArea());
                a.transform(AffineTransform.getRotateInstance(1.5707963267948966));
                pr.or(a);
                pr.and(new RectArea(-1750.0, -1750.0, 1750.0, 1750.0, 1));
                pr.subtract(new RectArea(-13.0, -3.0, 13.0, 3.0, 1));
                pr.subtract(new RectArea(-3.0, -13.0, 3.0, 13.0, 1));
                Struct pre = new Struct("preAlign", pr);
                Struct l = new Struct("l", new RectArea(80.0, 80.0, 736.0, 96.0, 1));
                Struct l2 = new Struct("l2", new RectArea(-97.6, 80.0, -80.0, 736.0, 1));
                Struct al = new Struct("al", new Array(l, 0.0, 0.0, 1, 21, 1.0, 672.0));
                Struct al2 = new Struct("al2", new Array(l2, 0.0, 0.0, 19, 1, -668.8, 1.0));
                GArea m = new GArea(al, 1);
                m.or(al2);
                a = new Area(al.getArea());
                a.transform(AffineTransform.getRotateInstance(-1.5707963267948966));
                m.or(a);
                a = new Area(al2.getArea());
                a.transform(AffineTransform.getRotateInstance(1.5707963267948966));
                m.or(a);
                m.or(new RectArea(-64.0, -64.0, 64.0, 64.0, 1));
                m.subtract(new RectArea(-10.0, -2.0, 10.0, 2.0, 1));
                m.subtract(new RectArea(-2.0, -10.0, 2.0, 10.0, 1));
                m.and(new RectArea(-731.2, -731.2, 736.0, 736.0, 1));
                Struct mx = new Struct("Mx", m);
                BarCode bc = new BarCode(barcode, 1, 1);
                a = new Area(bc.getArea());
                Rectangle2D rec = a.getBounds2D();
                a.transform(AffineTransform.getTranslateInstance(-rec.getCenterX(), -rec.getCenterY()));
                a.transform(AffineTransform.getRotateInstance(-1.5707963267948966));
                Struct brcd = new Struct("barcode", new GArea(a, 1));
                Text lb = new Text(label, 1, 3500.0);
                a = new Area(lb.getArea());
                rec = a.getBounds2D();
                a.transform(AffineTransform.getTranslateInstance(-rec.getCenterX(), -rec.getCenterY()));
                a.transform(AffineTransform.getRotateInstance(-1.5707963267948966));
                Struct lbl = new Struct("label", new GArea(a, 1));
                f.add(new Ref(pre, -67750.0, 69500.0));
                f.add(new Ref(pre, 67750.0, 69500.0));
                f.add(new Ref(mx, -65500.0, 0.0));
                f.add(new Ref(mx, 65500.0, 0.0));
                f.add(new Ref(brcd, 69000.0, 29150.0));
                f.add(new Ref(lbl, -69500.0, 37000.0));
                break;
            }
            case 0: {
                GArea pr = new GArea(new RectArea(-2500.0, -150.0, 2500.0, 150.0, 1), 1);
                pr.transform(AffineTransform.getRotateInstance(0.7853981633974483));
                RectArea r = new RectArea(-1750.0, -300.0, 1750.0, 300.0, 1);
                pr.or(r);
                Area a = new Area(pr.getArea());
                a.transform(AffineTransform.getRotateInstance(1.5707963267948966));
                pr.or(a);
                pr.and(new RectArea(-1750.0, -1750.0, 1750.0, 1750.0, 1));
                pr.subtract(new RectArea(-13.0, -3.0, 13.0, 3.0, 1));
                pr.subtract(new RectArea(-3.0, -13.0, 3.0, 13.0, 1));
                Struct pre = new Struct("preAlign", pr);
                Struct l = new Struct("l", new RectArea(80.0, 80.0, 736.0, 96.0, 1));
                Struct l2 = new Struct("l2", new RectArea(-97.6, 80.0, -80.0, 736.0, 1));
                Struct al = new Struct("al", new Array(l, 0.0, 0.0, 1, 21, 1.0, 672.0));
                Struct al2 = new Struct("al2", new Array(l2, 0.0, 0.0, 19, 1, -668.8, 1.0));
                GArea m = new GArea(al, 1);
                m.or(al2);
                a = new Area(al.getArea());
                a.transform(AffineTransform.getRotateInstance(-1.5707963267948966));
                m.or(a);
                a = new Area(al2.getArea());
                a.transform(AffineTransform.getRotateInstance(1.5707963267948966));
                m.or(a);
                m.or(new RectArea(-64.0, -64.0, 64.0, 64.0, 1));
                m.subtract(new RectArea(-10.0, -2.0, 10.0, 2.0, 1));
                m.subtract(new RectArea(-2.0, -10.0, 2.0, 10.0, 1));
                m.and(new RectArea(-731.2, -731.2, 736.0, 736.0, 1));
                Struct mx = new Struct("Mx", m);
                BarCode bc = new BarCode(barcode, 1, 1);
                a = new Area(bc.getArea());
                Rectangle2D rec = a.getBounds2D();
                a.transform(AffineTransform.getTranslateInstance(-rec.getCenterX(), -rec.getCenterY()));
                a.transform(AffineTransform.getRotateInstance(-1.5707963267948966));
                Struct brcd = new Struct("barcode", new GArea(a, 1));
                Text lb = new Text(label, 1, 3500.0);
                a = new Area(lb.getArea());
                rec = a.getBounds2D();
                a.transform(AffineTransform.getTranslateInstance(-rec.getCenterX(), -rec.getCenterY()));
                a.transform(AffineTransform.getRotateInstance(-1.5707963267948966));
                Struct lbl = new Struct("label", new GArea(a, 1));
                f.add(new Ref(pre, -67750.0, 69500.0));
                f.add(new Ref(pre, 67750.0, 69500.0));
                f.add(new Ref(mx, -65500.0, 0.0));
                f.add(new Ref(mx, 65500.0, 0.0));
                f.add(new Ref(brcd, 69000.0, 29150.0));
                f.add(new Ref(lbl, -69500.0, 37000.0));
            }
        }
        return f;
    }

    static {
        startDark = goingDown = true;
        function = 0;
    }
}

