/*
 * Decompiled with CFR 0.152.
 */
package PartLib;

import JGDS2.Array;
import JGDS2.Const;
import JGDS2.GArea;
import JGDS2.GDS2;
import JGDS2.GPath;
import JGDS2.Lib;
import JGDS2.RectArea;
import JGDS2.Ref;
import JGDS2.Struct;
import JGDS2.Text;
import PartLib.M;
import PartLib.PartsLib;
import java.awt.BasicStroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;

public class MoParts
implements Const {
    public static double l(double nl) {
        return Lib.lamda * nl;
    }

    public static String l() {
        return "" + GDS2.val(MoParts.l(1.0) / 10.0);
    }

    public static String ln() {
        return M.SHORT_NAME + MoParts.l();
    }

    public static Struct buffer(double w, double l, int f, int stages, double mag, int in) {
        in = (int)Math.signum(in);
        Struct b = new Struct("buf" + GDS2.val(w * 3.0 + l * 7.0 + mag * 11.0 + (double)(f * 13) + (double)(stages * 17)));
        double del = 0.0;
        mag = Math.pow(mag, 1.0 / (double)stages);
        for (int i = 0; i < stages; ++i) {
            double tw = Math.pow(mag, i);
            int tf = in >= 0 ? 1 + (int)((double)f * tw - 1.0E-4) * in : (int)((double)f * tw + 1.0E-5);
            tw = w * tw * (double)f / (double)tf;
            Struct t = MoParts.inverter(tw, l, tf);
            b.add(new Ref(t, del, 0.0));
            del += t.getArea(M.ACTIVE).getBounds2D().getWidth() + MoParts.l(M.R2_2);
        }
        return b;
    }

    public static Struct ringOsc(double w, double l, int n) {
        Struct inv = MoParts.inverter(w, l, 1);
        Rectangle2D space = inv.getArea(M.ACTIVE).getBounds2D().createUnion(inv.getArea(M.POLY).getBounds2D());
        Struct s = new Struct("$osc" + GDS2.val(w) + "l" + GDS2.val(l) + "n" + (n /= 2), new Array(inv, 0.0, -space.getY() + MoParts.l(M.R3_2), n + 1, 1, (double)(n + 1) * (space.getWidth() + MoParts.l(M.R2_2)), 1.0));
        Array ar = new Array(inv, 0.0, space.getY() - MoParts.l(M.R3_2), n, 1, (double)n * (space.getWidth() + MoParts.l(M.R2_2)), 1.0);
        ar.setAngle(180.0);
        Path2D.Double p = new Path2D.Double();
        p.moveTo(0.0, -space.getY() + MoParts.l(M.R3_2));
        double d = -MoParts.l(M.R5_1 + M.R7_3 / 2.0 + M.R6_4 + M.R2_3 + M.R6_2) - l / 2.0;
        p.lineTo(d, -space.getY() + MoParts.l(M.R3_2));
        p.lineTo(d, space.getY() - MoParts.l(M.R3_2));
        p.lineTo(-MoParts.l(M.R6_1 / 2.0 + M.R6_4) - l / 2.0, space.getY() - MoParts.l(M.R3_2));
        s.add(new GPath(p, MoParts.l(M.R7_1), M.M1));
        p = new Path2D.Double();
        w = d - MoParts.l(M.R7_1 + M.R7_2);
        double h = space.getHeight() + MoParts.l(M.R3_3 * 2.0 + M.R7_1 / 2.0);
        d = MoParts.l(M.R6_1 / 2.0 + M.R6_4 + M.R7_1 / 2.0) + l / 2.0;
        p.moveTo(MoParts.l(M.R7_1) - d + (double)n * (space.getWidth() + MoParts.l(M.R2_2)), h);
        p.lineTo(w, h);
        p.lineTo(w, -h);
        p.lineTo(d + (double)(n - 1) * (space.getWidth() + MoParts.l(M.R2_2)), -h);
        s.add(new GPath(p, MoParts.l(M.R7_1), M.M1));
        p = new Path2D.Double();
        p.moveTo(d + ((double)n - 0.5) * (space.getWidth() + MoParts.l(M.R2_2)), 0.0);
        p.lineTo(-d, 0.0);
        s.add(new GPath(p, MoParts.l(M.R7_1), M.M1));
        s.add(ar);
        s.add(new Ref(MoParts.pCt(), d + ((double)n - 0.5) * (space.getWidth() + MoParts.l(M.R2_2)), -MoParts.l(M.R7_1)));
        h = space.getHeight() - MoParts.l(M.R1_1 / 2.0);
        s.add(new Ref(MoParts.nCt(), w, h));
        s.add(new Ref(MoParts.nCt(), w, -h));
        p = new Path2D.Double();
        d = MoParts.l(M.R6_1 / 2.0 + M.R6_4) + l / 2.0 + (double)n * (space.getWidth() + MoParts.l(M.R2_2));
        p.moveTo(d + MoParts.l(M.R6_1 / 2.0 + M.R2_2 / 2.0 + M.R6_2 + M.R7_1 / 2.0), -MoParts.l(M.R2_3 + M.R3_2));
        p.lineTo(d + MoParts.l(M.R6_1 / 2.0 + M.R2_2 / 2.0 + M.R6_2 + M.R7_1 / 2.0), space.getY() - MoParts.l(M.R3_2));
        p.lineTo(MoParts.l(M.R6_1 / 2.0 + M.R6_4) + l / 2.0 + (double)(n - 1) * (space.getWidth() + MoParts.l(M.R2_2)), space.getY() - MoParts.l(M.R3_2));
        s.add(new GPath(p, MoParts.l(M.R7_1), M.M1));
        return s;
    }

    public static Struct inverter(double w, double l, int f) {
        Struct s = new Struct("inv" + GDS2.val(w) + "l" + GDS2.val(l) + "f" + f, new Ref(MoParts.pFet(w * 2.0, l, f), 0.0, MoParts.l(M.R2_3)));
        s.add(new Ref(MoParts.nFet(w, l, f), 0.0, -MoParts.l(M.R2_3), 32768, 0.0));
        Path2D.Double p = new Path2D.Double();
        double d = MoParts.l(M.R6_1 / 2.0 + M.R6_4) + l / 2.0;
        return s;
    }

    public static Struct nFet(double width, double len, int fingers) {
        return MoParts.xFet(width, len, fingers, true);
    }

    public static Struct bnFet(double width, double len, int fingers) {
        return MoParts.bxFet(width, len, fingers, true);
    }

    public static Struct pFet(double width, double len, int fingers) {
        return MoParts.xFet(width, len, fingers, false);
    }

    public static Struct bpFet(double width, double len, int fingers) {
        return MoParts.bxFet(width, len, fingers, false);
    }

    public static Struct nCt() {
        return MoParts.xCt(true);
    }

    public static Struct pCt() {
        return MoParts.xCt(false);
    }

    public static Struct xCt(boolean nfet) {
        double l = MoParts.l(M.R6_1 + 2.0 * M.R6_2) / 2.0;
        Struct c = new Struct(MoParts.type(nfet) + "sub", new RectArea(-l, -l, l, l, M.ACTIVE));
        c.add(new RectArea(-(l += MoParts.l(M.R4_2)), -l, l, l, MoParts.select(nfet)));
        c.add(new Ref(MoParts.ca(), 0.0, 0.0));
        c.add(new RectArea(-(l += MoParts.l(M.R2_3 - M.R4_2)), -l, l, l, MoParts.well(!nfet)));
        return c;
    }

    static String type(boolean nfet) {
        return nfet ? "n" : "p";
    }

    static int well(boolean nfet) {
        return nfet ? M.PWELL : M.NWELL;
    }

    static int select(boolean nfet) {
        return nfet ? M.NSELECT : M.PSELECT;
    }

    public static Struct bxFet(double width, double len, int fingers, boolean nfet) {
        double d;
        double w;
        double d2;
        double l = MoParts.l(M.R3_1);
        double ln = len < d2 ? l : len;
        l = MoParts.l(M.R2_1);
        double d3 = w = width < d ? l : width;
        if (fingers < 1) {
            fingers = 1;
        }
        l = (len + MoParts.l(2.0 * M.R6_4 + M.R6_1)) * (double)fingers + MoParts.l(M.R6_1 + 2.0 * M.R6_2);
        double off = len / 2.0 + MoParts.l(M.R6_1) + MoParts.l(M.R6_2 + M.R6_4);
        GArea act = new GArea(new Rectangle2D.Double(-off, 0.0, l, w), M.ACTIVE);
        Struct xf = new Struct(MoParts.type(nfet) + "FetL" + GDS2.val(ln) + "W" + GDS2.val(w) + "" + fingers);
        Struct rp = new Struct("rFetL" + GDS2.val(ln) + "W" + GDS2.val(w) + "" + fingers);
        rp.add(new RectArea(-ln / 2.0, -MoParts.l(M.R3_3), ln / 2.0, w + MoParts.l(M.R3_3), M.POLY));
        ln = ln / 2.0 + MoParts.l(M.R6_4 + M.R6_1 / 2.0);
        double dt = MoParts.l(M.R6_1 / 2.0 + M.R6_2);
        if (w < MoParts.l(M.R6_1 + 2.0 * M.R6_2)) {
            double lt = MoParts.l(M.R6_1 / 2.0 + M.R6_2);
            Area r = new Area(new Rectangle2D.Double(-lt, -lt, lt * 2.0, lt * 2.0));
            act.or(r.createTransformedArea(AffineTransform.getTranslateInstance(-ln, dt)));
            act.or(r.createTransformedArea(AffineTransform.getTranslateInstance(ln, dt)));
            w = lt * 2.0;
        }
        Struct mb = new Struct("M1b" + GDS2.val(w), new RectArea(-MoParts.l(M.R6_1 / 2.0 + M.R7_3), 0.0, MoParts.l(M.R6_1 / 2.0 + M.R7_3), w, M.M1));
        int i = (int)(1.0E-4 + w / MoParts.l(M.R6_3 + M.R6_1));
        i = i < 1 ? 1 : i;
        xf.add(new Array(MoParts.ca(), -ln, dt, fingers + 1, i, 2.0 * (ln * (double)(fingers + 1)), (double)i * (MoParts.l(M.R6_3) + MoParts.l(M.R6_1))));
        xf.add(new Array(mb, -ln, 0.0, fingers + 1, 1, 2.0 * (ln * (double)(fingers + 1)), 1.0));
        xf.add(act);
        xf.add(new Array(rp, 0.0, 0.0, fingers, 1, (len + MoParts.l(2.0 * M.R6_4 + M.R6_1)) * (double)fingers, 1.0));
        xf.add(new RectArea(-(off + MoParts.l(M.R4_2)), -MoParts.l(M.R4_2), l + MoParts.l(M.R4_2) - off, w + MoParts.l(M.R4_2), MoParts.select(nfet)));
        xf.add(new RectArea(-(off + MoParts.l(M.R2_3)), -MoParts.l(M.R2_3), l + MoParts.l(M.R2_3) - off, w + MoParts.l(M.R2_3), MoParts.well(nfet)));
        return xf;
    }

    public static Struct xFet(double width, double len, int fingers, boolean nfet) {
        double d;
        double w;
        double d2;
        double l = MoParts.l(M.R3_1);
        len = len < d2 ? l : len;
        l = MoParts.l(M.R2_1);
        double d3 = w = width < d ? l : width;
        if (fingers < 1) {
            fingers = 1;
        }
        l = (len + MoParts.l(2.0 * M.R6_4 + M.R6_1)) * (double)fingers + MoParts.l(M.R6_1 + 2.0 * M.R6_2);
        double off = len / 2.0 + MoParts.l(M.R6_1) + MoParts.l(M.R6_2 + M.R6_4);
        GArea act = new GArea(new Rectangle2D.Double(-off, 0.0, l, w), M.ACTIVE);
        Struct xf = new Struct(MoParts.type(nfet) + "FetL" + GDS2.val(len) + "W" + GDS2.val(w) + "" + fingers);
        Struct rp = new Struct("rFetL" + GDS2.val(len) + "W" + GDS2.val(w) + "" + fingers);
        rp.add(new RectArea(-len / 2.0, -MoParts.l(M.R2_3 + M.R7_1 / 2.0), len / 2.0, w + MoParts.l(M.R3_3), M.POLY));
        double ln = len / 2.0 + MoParts.l(M.R6_4 + M.R6_1 / 2.0);
        double dt = MoParts.l(M.R6_1 / 2.0 + M.R6_2);
        if (w < MoParts.l(M.R6_1 + 2.0 * M.R6_2)) {
            double lt = MoParts.l(M.R6_1 / 2.0 + M.R6_2);
            Area r = new Area(new Rectangle2D.Double(-lt, -lt, lt * 2.0, lt * 2.0));
            act.or(r.createTransformedArea(AffineTransform.getTranslateInstance(-ln, dt)));
            act.or(r.createTransformedArea(AffineTransform.getTranslateInstance(ln, dt)));
            w = lt * 2.0;
        }
        double d4 = Math.max(MoParts.l(M.R6_1 / 2.0 + M.R7_3), MoParts.l(M.R7_1 / 2.0));
        Struct mb = new Struct("M1b" + GDS2.val(w), new RectArea(-d4, 0.0, d4, w, M.M1));
        int i = (int)(1.0E-4 + w / MoParts.l(M.R6_3 + M.R6_1));
        i = i < 1 ? 1 : i;
        xf.add(new Array(MoParts.ca(), -ln, dt, fingers + 1, i, 2.0 * (ln * (double)(fingers + 1)), (double)i * (MoParts.l(M.R6_3) + MoParts.l(M.R6_1))));
        xf.add(new Array(mb, -ln, 0.0, fingers + 1, 1, 2.0 * (ln * (double)(fingers + 1)), 1.0));
        xf.add(act);
        dt = len + MoParts.l(2.0 * M.R6_4 + M.R6_1);
        Path2D.Double p = new Path2D.Double();
        if (fingers > 1) {
            p.moveTo(-len / 2.0, -MoParts.l(M.R2_3));
            p.lineTo(-dt + len / 2.0, -MoParts.l(M.R2_3));
            rp.add(new GPath(p, MoParts.l(M.R7_1), M.POLY));
        }
        p = new Path2D.Double();
        p.moveTo(len / 2.0 + MoParts.l(M.R6_4 + M.R6_1 / 2.0 - M.R7_1 / 2.0), -MoParts.l(M.R2_3));
        p.lineTo(l - off + MoParts.l(M.R2_2 / 2.0), -MoParts.l(M.R2_3));
        xf.add(new GPath(p, MoParts.l(M.R7_1), M.M1));
        d4 = MoParts.l(M.R6_1 / 2.0 + M.R6_4) + len / 2.0;
        p = new Path2D.Double();
        p.moveTo(0.0, 0.0);
        p.lineTo(0.0, -MoParts.l(M.R2_3 - M.R7_1 / 2.0));
        int k = (fingers + 1) / 2;
        Struct b = new Struct("M1Y" + M.SHORT_NAME + GDS2.val(d4), new GPath(p, MoParts.l(M.R7_1), M.M1));
        xf.add(new Array(b, d4, 0.0, k, 1, (double)(k * 2) * dt, 1.0));
        k = (fingers + 2) / 2;
        xf.add(new Array(b, -d4, w + MoParts.l(M.R2_3 - M.R7_1 / 2.0), k, 1, (double)(k * 2) * dt, 1.0));
        p = new Path2D.Double();
        p.moveTo(-(off + MoParts.l(M.R2_2 / 2.0)), -MoParts.l(M.R2_3));
        p.lineTo(0.0, -MoParts.l(M.R2_3));
        xf.add(new GPath(p, MoParts.l(M.R7_1), M.M1));
        xf.add(new Ref(MoParts.cp(), -MoParts.l(M.R6_1), -MoParts.l(M.R2_3)));
        xf.add(new Array(rp, 0.0, 0.0, fingers, 1, dt * (double)fingers, 1.0));
        xf.add(new RectArea(-(off + MoParts.l(M.R4_2)), -MoParts.l(M.R4_2), l + MoParts.l(M.R4_2) - off, w + MoParts.l(M.R4_2), MoParts.select(nfet)));
        xf.add(new RectArea(-(off + MoParts.l(M.R2_3)), -MoParts.l(M.R2_3), l + MoParts.l(M.R2_3) - off, w + MoParts.l(M.R2_3), MoParts.well(nfet)));
        return xf;
    }

    public static Struct cab(double ln) {
        int i = (int)(1.0E-4 + ln / MoParts.l(M.R6_3 + M.R6_1));
        i = i < 1 ? 1 : i;
        String name = "$cc" + i;
        Struct s = GDS2.getStructureNamed(name);
        Struct c = MoParts.ca();
        if (s == null) {
            double l = MoParts.l(M.R6_3 + M.R6_1);
            s = new Struct(name);
            for (int j = 0; j < i; ++j) {
                s.add(new Ref(c, 0.0, (double)j * l));
            }
        }
        return s;
    }

    public static Struct cab(int i) {
        i = i < 1 ? 1 : i;
        String name = "$cc" + i;
        Struct s = GDS2.getStructureNamed(name);
        Struct c = MoParts.ca();
        if (s == null) {
            double l = MoParts.l(M.R6_3 + M.R6_1);
            s = new Struct(name);
            for (int j = 0; j < i; ++j) {
                s.add(new Ref(c, 0.0, (double)j * l));
            }
        }
        return s;
    }

    public static Struct cab(int i, int k) {
        i = i < 1 ? 1 : i;
        k = k < 1 ? 1 : k;
        String name = "$cc" + i + "c" + k;
        Struct s = GDS2.getStructureNamed(name);
        Struct c = MoParts.ca();
        if (s == null) {
            double l = MoParts.l(M.R6_3 + M.R6_1);
            s = new Struct(name);
            for (int n = 0; n < k; ++n) {
                for (int j = 0; j < i; ++j) {
                    s.add(new Ref(c, (double)n * l, (double)j * l));
                }
            }
        }
        return s;
    }

    public static Struct cp() {
        Struct s = new Struct("$cp" + GDS2.val(MoParts.l(M.R5_1)));
        double l = MoParts.l(M.R5_1 / 2.0 + M.R5_2);
        s.add(new RectArea(-l, -l, l, l, M.POLY));
        s.add(new Ref(MoParts.ca(), 0.0, 0.0));
        return s;
    }

    public static Struct ca() {
        String name = "$ca" + GDS2.val(MoParts.l(M.R6_1));
        Struct s = GDS2.getStructureNamed(name);
        double l = MoParts.l(M.R5_1 / 2.0);
        if (s == null) {
            s = new Struct(name, new RectArea(-l, -l, l, l, M.CONTACT));
            l = Math.max(MoParts.l(M.R7_3) + l, MoParts.l(M.R7_1 / 2.0));
            s.add(new RectArea(-l, -l, l, l, M.M1));
        }
        return s;
    }

    public static Struct Resistor(double len, double width, int layer, int contacts) {
        RectArea ga;
        Struct ar = new Struct("AR" + MoParts.ln() + "L" + GDS2.val(len) + "W" + GDS2.val(width) + "N" + layer);
        double bendLen = 5.0;
        double hl = len - bendLen;
        Struct r = new Struct("R" + ar.getName());
        Struct pad = new Struct("pad" + ar.getName());
        if (layer == M.NWELL || layer == M.PWELL) {
            ga = new RectArea(-4.0 - MoParts.l(M.R2_3), -1.0 - MoParts.l(M.R2_3), hl + MoParts.l(M.R2_3) + width / 2.0, 9.0 + 3.0 * MoParts.l(M.R2_3), layer);
            ar.add(ga);
            layer = M.ACTIVE;
        }
        if (layer != M.M1) {
            ga = new RectArea(-2.0, -1.0, 0.0, 3.0, M.M1);
            pad.add(ga);
            pad.add(new Ref(MoParts.cab(contacts), -0.5, -0.5));
            ga = new RectArea(-4.0, -1.0, -2.5, 3.0, M.M1);
            pad.add(new Ref(MoParts.cab(6, 2), -3.5, -0.5));
            pad.add(ga);
        }
        Path2D.Double p = new Path2D.Double();
        p.moveTo(0.0, 0.0);
        p.lineTo(hl, 0.0);
        p.lineTo(hl, -bendLen);
        p.lineTo(0.0, -bendLen);
        GPath gp = new GPath(p, width, layer);
        pad.add(new RectArea(-4.0, -1.0, 0.0, 3.0, layer));
        r.add(gp);
        ar.add(new Array(pad, 0.0, 0.0, 1, 2, 1.0, 2.0 * (bendLen + 2.0)));
        ar.add(new Ref(r, 0.0, bendLen + 2.0));
        return ar;
    }

    public static Struct bufOsc(double w, double l, int n, double mag) {
        Struct os = MoParts.ringOsc(w, l, n);
        int stages = (int)Math.ceil(Math.log(mag) / Math.log(3.0));
        mag = (int)Math.pow(3.0, stages);
        Struct bos = new Struct("B" + os.getName() + (int)mag);
        Struct buf = MoParts.buffer(w, l, 1, stages, mag, 1);
        Rectangle2D r = buf.getArea(M.ACTIVE).getBounds2D();
        bos.add(new Ref(buf, MoParts.l(M.R2_2) - r.getMinX(), -r.getMaxY()));
        Path2D.Double p = new Path2D.Double();
        p.moveTo(-l - MoParts.l(M.R2_2 + M.R6_1 + 2.0 * M.R6_4), MoParts.l(M.R2_3));
        double ep = r.getMaxX() - r.getMinX() + MoParts.l(M.R2_2 - 1.5 * M.R6_1 - 2.0 * M.R6_4 - M.R6_2 + M.R7_1 / 2.0) - l;
        p.lineTo(ep, MoParts.l(M.R2_3));
        GPath gm = new GPath(p, MoParts.l(M.R7_1), M.M1);
        bos.add(gm);
        p = new Path2D.Double();
        p.moveTo(-l - MoParts.l(M.R2_2 + M.R6_1 + 2.0 * M.R6_4), r.getMinY() - r.getMaxY() - MoParts.l(M.R2_3));
        double epy = r.getMinY() - r.getMaxY() - MoParts.l(M.R2_3);
        p.lineTo(ep, epy);
        GPath gm2 = new GPath(p, MoParts.l(M.R7_1), M.M1);
        bos.add(gm2);
        r = os.getArea(M.ACTIVE).getBounds2D();
        bos.add(new Ref(os, -r.getMaxX(), -r.getMaxY()));
        p = new Path2D.Double();
        ep = -3.0 * w - MoParts.l(M.R2_3 * 2.0 + M.R3_3);
        p.moveTo(MoParts.l(M.R2_2 + M.R6_1 + 2.0 * M.R6_4), -2.0 * w - MoParts.l(M.R2_3));
        p.lineTo(MoParts.l(M.R2_2 / 2.0), -2.0 * w - MoParts.l(M.R2_3));
        p.lineTo(MoParts.l(M.R2_2 / 2.0), ep);
        GPath gp = new GPath(p, MoParts.l(M.R3_1), M.POLY);
        RectArea ra = new RectArea(MoParts.l(M.R2_2 / 2.0 - M.R3_1 / 2.0), epy - (ep - epy) - MoParts.l(M.R7_1), l + MoParts.l(M.R6_1 + M.R6_2 + M.R6_4 + M.R2_2), ep, M.POLY);
        bos.add(ra);
        bos.add(new Ref(MoParts.cp(), MoParts.l(M.R2_2), epy - (ep - epy) - MoParts.l(M.R7_1 + M.R5_1 / 2.0 + M.R5_2)));
        bos.add(gp);
        return bos;
    }

    public static Struct zero() {
        Struct s = new Struct("zero");
        Struct q = new Struct("zeroQ");
        Struct v2 = PartsLib.Vern(M.ACTIVE, 10, 0.01, 20, "active", "4");
        Struct v1 = PartsLib.Vern(10, M.ACTIVE, 0.01, 20, "4", "active");
        Struct v3 = PartsLib.Vern(M.ACTIVE, M.POLY, 0.01, 20, "active", "poly");
        Struct v4 = PartsLib.Vern(M.ACTIVE, M.CONTACT, 0.01, 20, "active", "CA");
        Struct v5 = PartsLib.Vern(M.ACTIVE, M.M1, 0.01, 20, "ACT", "M1");
        q.add(new Ref(v3, 4000.0, 4920.0));
        q.add(new Ref(v3, 4070.0, 4920.0, 0, 0.0, 90.0));
        q.add(new Ref(v4, 3500.0, 4920.0));
        q.add(new Ref(v4, 3570.0, 4920.0, 0, 0.0, 90.0));
        q.add(new Ref(v5, 3000.0, 4920.0));
        q.add(new Ref(v5, 3070.0, 4920.0, 0, 0.0, 90.0));
        s.add(new Ref(v1, 0.0, 5000.0));
        s.add(new Ref(v1, -5000.0, 0.0, 0, 0.0, 90.0));
        s.add(new Ref(v2, 0.0, -5000.0, 0, 0.0, 0.0));
        s.add(new Ref(v2, 5000.0, 0.0, 0, 0.0, 90.0));
        s.add(new Ref(q, 0.0, 0.0));
        s.add(new Ref(q, 0.0, 0.0, 0, 0.0, 90.0));
        s.add(new Ref(q, 0.0, 0.0, 0, 0.0, 180.0));
        s.add(new Ref(q, 0.0, 0.0, 0, 0.0, 270.0));
        return s;
    }

    public static Struct leads(double size, double rOut, boolean corn, boolean curved) {
        int i;
        int cols = 1;
        double ps = 125.0;
        Struct p = new Struct("pad", new RectArea(-ps, -ps, ps, ps, M.M1));
        Struct sp = new Struct("pm", new RectArea(-10.0, -10.0, 10.0, 10.0, M.M1));
        Struct oc = new Struct("oct" + (int)size);
        Struct gm = new Struct("globemrk", new RectArea(-3.0, -100.0, 3.0, 100.0, M.ACTIVE));
        gm.add(new RectArea(-100.0, -3.0, 100.0, 3.0, 1));
        Struct cm = new Struct("chipmrk", new RectArea(-2.0, -30.0, 2.0, 30.0, M.ACTIVE));
        cm.add(new RectArea(-30.0, -2.0, 30.0, 2.0, M.ACTIVE));
        Struct q = new Struct("quart" + (int)size);
        q.add(new Ref(oc, 0.0, 0.0));
        q.add(new Ref(oc, 0.0, 0.0, 32768, 1.0, 0.0));
        Struct s = new Struct("cell" + (int)size);
        int CnR = 2;
        double pos = -size / 2.0 + ps * 4.0;
        s.add(new Array(gm, pos, pos, CnR, CnR, -pos * 2.0 * (double)CnR, -pos * 2.0 * (double)CnR));
        pos = -size / 2.0 * rOut;
        s.add(new Array(cm, pos, pos, CnR, CnR, -pos * 2.0 * (double)CnR, -pos * 2.0 * (double)CnR));
        pos = -size / 2.0 * (rOut * 1.2);
        s.add(new Array(cm, pos, pos, CnR, CnR, -pos * 2.0 * (double)CnR, -pos * 2.0 * (double)CnR));
        int n = i = corn ? 0 : 1;
        while ((double)i < size / 1000.0) {
            Path2D.Double poly3 = new Path2D.Double();
            poly3.moveTo(-size / 2.0 + ps * 2.0, size / 2.0 - (double)(500 * i) - ps * 2.0);
            if (curved && i != 0) {
                poly3.curveTo((-size / 2.0 + ps * 2.0) * (1.0 + rOut) / 2.0, size / 2.0 - (double)(500 * i) - ps * 2.0, (-size / 2.0 + ps * 2.0) * (1.0 + rOut) / 2.0, (size / 2.0 - (double)(500 * i) - ps * 2.0) * rOut, (-size / 2.0 + ps * 2.0) * rOut, (size / 2.0 - (double)(500 * i) - ps * 2.0) * rOut);
            } else {
                poly3.lineTo((-size / 2.0 + ps * 2.0) * rOut, (size / 2.0 - (double)(500 * i) - ps * 2.0) * rOut);
            }
            BasicStroke bs = new BasicStroke(50.0f, 0, 0, 2.5f);
            GArea fa = new GArea(bs.createStrokedShape(poly3), M.M1);
            if (i == 0) {
                q.add(fa);
            } else {
                oc.add(fa);
            }
            ++i;
        }
        i = 1;
        while ((double)i < size / 500.0) {
            String sl = String.valueOf((char)(i + 64));
            Struct tl = new Struct(sl, new Text(sl, M.M1, 100.0));
            s.add(new Ref(tl, -size / 2.0 + ps * 2.0 - 50.0, size / 2.0 - 500.0 * ((double)i - 0.4) - ps * 2.0, 2));
            s.add(new Ref(tl, size / 2.0 - ps * 2.0 - 30.0, size / 2.0 - 500.0 * ((double)i - 0.4) - ps * 2.0, 2));
            String su = String.valueOf(i);
            Struct tu = new Struct(su, new Text(su, 2, 100.0));
            s.add(new Ref(tu, -(size / 2.0 - 500.0 * ((double)i - 0.6) - ps * 2.0), -size / 2.0 + ps * 2.0 - 50.0, 2));
            s.add(new Ref(tu, -(size / 2.0 - 500.0 * ((double)i - 0.6) - ps * 2.0), -(-size / 2.0 + ps * 2.0), 2));
            ++i;
        }
        q.add(new Array(p, -size / 2.0 + ps * 2.0, -size / 2.0 + ps * 2.0, cols, (int)(size / 500.0), 500 * cols, size));
        q.add(new Array(sp, -size / 2.0 + ps, -size / 2.0 + ps * 4.0, cols, (int)(size / 500.0) - 1, 500 * cols, size - 500.0));
        s.add(new Ref(q, 0.0, 0.0));
        s.add(new Ref(q, 0.0, 0.0, 0, 1.0, 90.0));
        s.add(new Ref(q, 0.0, 0.0, 0, 1.0, 180.0));
        s.add(new Ref(q, 0.0, 0.0, 0, 1.0, 270.0));
        return s;
    }

    public static Struct leads2(double size, double rOut, double gap) {
        int cols = 1;
        double ps = 125.0;
        Struct p = new Struct("pad", new RectArea(-ps, -ps, ps, ps, M.M1));
        Struct sp = new Struct("pm", new RectArea(-10.0, -10.0, 10.0, 10.0, M.M1));
        Struct gm = new Struct("EBglobemrk", new RectArea(-3.0, -100.0, 3.0, 100.0, M.ACTIVE));
        gm.add(new RectArea(-100.0, -3.0, 100.0, 3.0, M.ACTIVE));
        Struct cm = new Struct("EBchipmrk", new RectArea(-2.0, -30.0, 2.0, 30.0, M.ACTIVE));
        cm.add(new RectArea(-30.0, -2.0, 30.0, 2.0, M.ACTIVE));
        Struct s = new Struct("L2" + (int)size + "r" + GDS2.val(rOut) + "g" + GDS2.val(gap));
        Struct q = new Struct("q" + s.getName());
        Struct h = new Struct("h" + s.getName());
        Struct oc = new Struct("oct" + s.getName());
        q.add(new Ref(oc, 0.0, 0.0));
        q.add(new Ref(oc, 0.0, 0.0, 32768, 1.0, 0.0));
        int CnR = 2;
        double pos = -(size /= 2.0) + ps * 4.0;
        s.add(new Array(gm, pos, pos, CnR, CnR, -pos * 2.0 * (double)CnR, -pos * 2.0 * (double)CnR));
        pos = -size * rOut;
        s.add(new Array(cm, pos, pos, CnR, CnR, -pos * 2.0 * (double)CnR, -pos * 2.0 * (double)CnR));
        pos = -size * (rOut * 1.2);
        s.add(new Array(cm, pos, pos, CnR, CnR, -pos * 2.0 * (double)CnR, -pos * 2.0 * (double)CnR));
        double n = size / 250.0 - 1.0;
        double pathwidth = 20.0;
        Path2D.Double poly3 = new Path2D.Double();
        BasicStroke bs = new BasicStroke((float)pathwidth, 0, 0, 2.5f);
        int i = 0;
        while ((double)i < n) {
            poly3.moveTo(-size + ps * 2.0, size - (double)(500 * i) - ps * 2.0);
            poly3.quadTo((-size + ps * 2.0) * (1.0 + rOut) / 2.0, size * (0.5 - ((double)i + 0.5) / n) * rOut, (-size + ps * 2.0) * rOut, size * (0.5 - ((double)i + 0.5) / n) * rOut);
            GArea fa = new GArea(bs.createStrokedShape(poly3), M.M1);
            h.add(fa);
            int sgn = (double)i >= n / 2.0 ? -1 : 1;
            poly3 = new Path2D.Double();
            poly3.moveTo(-size + (double)(500 * (i + 1)) + ps * 2.0, size - ps * 2.0);
            poly3.quadTo((-size + ps * 2.0) * (1.0 + rOut) / 2.0 * (double)sgn, size * (0.5 + (sgn > 0 ? (double)i + 0.5 : n - ((double)i + 0.5)) / n) * rOut, (-size + ps * 2.0) * rOut * (double)sgn, size * (0.5 + (sgn > 0 ? (double)i + 0.5 : n - ((double)i + 0.5)) / n) * rOut);
            fa = new GArea(bs.createStrokedShape(poly3), M.M1);
            h.add(fa);
            ++i;
        }
        i = 1;
        while ((double)i < size / 250.0) {
            String sl = String.valueOf((char)(i + 64));
            Struct tl = new Struct(sl, new Text(sl, M.M1, 100.0));
            s.add(new Ref(tl, -size + ps * 2.0 - 50.0, size - 500.0 * ((double)i - 0.4) - ps * 2.0, 2));
            s.add(new Ref(tl, size - ps * 2.0 - 30.0, size - 500.0 * ((double)i - 0.4) - ps * 2.0, 2));
            String su = String.valueOf(i);
            Struct tu = new Struct(su, new Text(su, M.M1, 100.0));
            s.add(new Ref(tu, -(size - 500.0 * ((double)i - 0.6) - ps * 2.0), -size + ps * 2.0 - 50.0, 2));
            s.add(new Ref(tu, -(size - 500.0 * ((double)i - 0.6) - ps * 2.0), -(-size + ps * 2.0), 2));
            ++i;
        }
        GArea il = new GArea(new Rectangle2D.Double((-size + ps * 2.0) * rOut, -pathwidth / 8.0, (size - ps * 2.0) * rOut - gap / 2.0, pathwidth / 4.0), M.M1);
        il.or(new Area(new Rectangle2D.Double(-gap / 2.0 - pathwidth / 4.0, -pathwidth / 8.0, pathwidth / 4.0, 0.8 * size * rOut / n)));
        poly3 = new Path2D.Double();
        double x = -gap / 2.0 - pathwidth / 8.0;
        double y = -pathwidth / 8.0 + 0.8 * size * rOut / n;
        poly3.moveTo(x, y);
        poly3.lineTo(x, y + 2.0);
        poly3.lineTo(x + 5.0, y + 10.0);
        poly3.lineTo(x + 5.0, y + 12.0);
        bs = new BasicStroke((float)pathwidth / 4.0f, 0, 0, 2.5f);
        il.or(new Area(bs.createStrokedShape(poly3)));
        il.or(new Area(new Rectangle2D.Double((-size + ps * 2.0) * rOut, -pathwidth / 8.0, pathwidth / 4.0, 0.4 * size * rOut / n)));
        Struct sl = new Struct("i" + s.getName(), il);
        h.add(new Array(sl, 0.0, -size * rOut * (1.0 - 0.1 / n), 1, (int)n, 1.0, n * size * rOut / 2.0));
        Array a = new Array(sl, 0.0, -size * rOut * (1.0 - 1.9 / n), 1, (int)n, 1.0, n * size * rOut / 2.0);
        a.flip();
        h.add(a);
        q.add(new Array(p, -size + ps * 2.0, -size + ps * 2.0, cols, (int)(size / 250.0), 500 * cols, size * 2.0));
        q.add(new Array(sp, -size + ps, -size + ps * 4.0, cols, (int)(size / 250.0) - 1, 500 * cols, size * 2.0 - 500.0));
        h.add(new Ref(q, 0.0, 0.0));
        h.add(new Ref(q, 0.0, 0.0, 0, 1.0, 90.0));
        s.add(new Ref(h, 0.0, 0.0));
        s.add(new Ref(h, 0.0, 0.0, 1, 180.0));
        return s;
    }

    public static Struct leads3(double size, double gap) {
        int i;
        int cols = 1;
        double ps = 125.0;
        Struct p = new Struct("pad", new RectArea(-ps, -ps, ps, ps, M.M1));
        Struct sp = new Struct("pm", new RectArea(-10.0, -10.0, 10.0, 10.0, M.M1));
        Struct s = new Struct("L3" + (int)size + "r" + "g" + GDS2.val(gap));
        Struct q = new Struct("q" + s.getName());
        Struct h = new Struct("h" + s.getName());
        Struct oc = new Struct("oct" + s.getName());
        q.add(new Ref(oc, 0.0, 0.0));
        q.add(new Ref(oc, 0.0, 0.0, 32768, 1.0, 0.0));
        double pathwidth = 2.5;
        Path2D.Double poly3 = new Path2D.Double();
        BasicStroke bs = new BasicStroke((float)pathwidth, 0, 0, 2.5f);
        double[] x = new double[]{-500.0, -900.0, -950.0, -1000.0, -950.0, -900.0, -600.0, 0.0};
        double[] y = new double[]{-1000.0, -1000.0, -500.0, 0.0, 500.0, 1000.0, 900.0, 1000.0};
        double[] ye = new double[]{-size + (gap /= 2.0), -size / 2.0 - gap, -size / 2.0 + gap, -gap, gap, size / 2.0 - gap, size / 2.0 + gap, size - gap};
        for (i = 0; i < 8; ++i) {
            poly3.moveTo(x[i], y[i]);
            poly3.quadTo(-(1000.0 + size) / 2.0, ye[i], -size, ye[i]);
            poly3.lineTo(-gap, ye[i]);
            poly3.lineTo(-gap, ye[i] - (double)(i % 2) * (size / 2.0 - gap * 3.6) + size / 4.0 - gap * 1.8);
            poly3.lineTo(-gap / 4.0, ye[i] - (double)(i % 2) * (size / 2.0 - gap * 3.6) + size / 4.0 - gap * 1.8);
            GArea fa = new GArea(bs.createStrokedShape(poly3), M.M1);
            h.add(fa);
        }
        for (i = 1; i < 5; ++i) {
            String sl = String.valueOf((char)(i + 64));
            Struct tl = new Struct(sl, new Text(sl, M.M1, 100.0));
            s.add(new Ref(tl, -1050.0, 1000.0 - 500.0 * ((double)i - 0.4), 2));
            s.add(new Ref(tl, 970.0, 1000.0 - 500.0 * ((double)i - 0.4), 2));
            String su = String.valueOf(i);
            Struct tu = new Struct(su, new Text(su, M.M1, 100.0));
            s.add(new Ref(tu, 500.0 * ((double)i - 0.6) - 1000.0, -1050.0, 2));
            s.add(new Ref(tu, 500.0 * ((double)i - 0.6) - 1000.0, 1000.0, 2));
        }
        q.add(new Array(p, -1000.0, -1000.0, cols, 5, 500 * cols, 2500.0));
        q.add(new Array(sp, -1125.0, -750.0, cols, 4, 500 * cols, 2000.0));
        h.add(new Ref(q, 0.0, 0.0));
        h.add(new Ref(q, 0.0, 0.0, 0, 1.0, 90.0));
        s.add(new Ref(h, 0.0, 0.0));
        s.add(new Ref(h, 0.0, 0.0, 1, 180.0));
        return s;
    }
}

