/*
 * Decompiled with CFR 0.152.
 */
import JGDS2.Array;
import JGDS2.Const;
import JGDS2.GArea;
import JGDS2.GDS2;
import JGDS2.Lib;
import JGDS2.RectArea;
import JGDS2.Ref;
import JGDS2.Struct;
import PartLib.PartsLib;
import java.awt.geom.Path2D;
import java.io.File;

public class Current
implements Const {
    public static void main(String[] args) {
        Lib lib = new Lib();
        Struct a = Current.TestTop();
        lib.add(new Ref(a, 0.0, 0.0));
        File f = lib.GDSOut("path.gds");
        System.out.println(" Saved to " + f.getAbsolutePath());
    }

    static Struct TestTop() {
        Struct top = new Struct("bop");
        int s = 5;
        double dSize = 1500.0;
        double sep = 750.0;
        double off = (double)s * (dSize + sep) / 5.0;
        PartsLib.circle(dSize, s, s);
        double angle = 1.0471975511965976;
        for (int i = 0; i < s; ++i) {
            for (int j = 0; j < s; ++j) {
                double hPitch = (double)j * 0.02 + 0.22;
                int num = (int)(dSize / hPitch / 2.0);
                double duty = 1.0 + ((double)i - (double)(s - 1) / 2.0) / 10.0;
                System.out.println("duty" + duty);
                top.add(new Array(new Struct("LV" + i + "D" + j, new RectArea(0.0, 0.0, hPitch * duty, dSize, j)), -off * (double)(i + 1) + sep / 2.0, (double)j * off + sep / 2.0, num, 1, (double)(num * 2) * hPitch, 1.0));
                top.add(new Array(new Struct("LH" + i + "D" + j, new RectArea(0.0, 0.0, dSize, hPitch * duty, j)), (double)i * off + sep / 2.0, (double)j * off + sep / 2.0, 1, num, 1.0, (double)(num * 2) * hPitch));
                top.add(new Ref(Current.angledArray(hPitch, duty, angle, 1500.0, i), (double)i * off + sep / 2.0, (double)(-(j + 1)) * off + sep / 2.0));
                Struct c = new Struct("CR" + i + "D" + j, PartsLib.circle(hPitch / 2.0 * duty * 1.3, 65, j));
                double step = 4.0 * hPitch * Math.sin(angle);
                int numy = (int)(dSize / step);
                System.out.println("step" + step + " numy" + numy);
                top.add(new Array(c, (double)(-(i + 1)) * off + sep / 2.0, (double)(-(j + 1)) * off + sep / 2.0, num, numy, (double)(num * 2) * hPitch, (int)((double)numy * step)));
                top.add(new Array(c, (double)(-(i + 1)) * off + sep / 2.0 + hPitch, (double)(-(j + 1)) * off + sep / 2.0 + step / 2.0, num, numy, (double)(num * 2) * hPitch, (int)((double)numy * step)));
            }
        }
        return top;
    }

    static Struct TestK() {
        Struct top = new Struct("bop");
        int s = 5;
        double dSize = 1500.0;
        double sep = 750.0;
        PartsLib.circle(dSize, s, s);
        double hPitch = 0.22;
        int num = (int)(dSize / hPitch / 2.0);
        double duty = 1.0;
        double angle = 1.0471975511965976;
        System.out.println("duty" + duty);
        top.add(new Array(new Struct("LV", new RectArea(0.0, 0.0, hPitch * duty, dSize, 1)), sep / 2.0, sep / 2.0, num, 1, (double)(num * 2) * hPitch, 1.0));
        top.add(new Array(new Struct("LH", new RectArea(0.0, 0.0, dSize, hPitch * duty, 1)), sep / 2.0, sep / 2.0, 1, num, 1.0, (double)(num * 2) * hPitch));
        top.add(new Ref(Current.angledArray(hPitch, duty, angle, 1500.0, 2), sep / 2.0, sep / 2.0));
        Struct c = new Struct("CR", PartsLib.circle(hPitch / 2.0 * duty, 65, 3));
        hPitch = hPitch * Math.sin(angle) * 4.0 / 3.0;
        double step = 4.0 * hPitch * Math.sin(angle);
        int numy = (int)(dSize / step);
        System.out.println("step" + step + " numy" + numy);
        top.add(new Array(c, sep / 2.0, sep / 2.0, num, numy, (double)(num * 2) * hPitch, (int)((double)numy * step)));
        top.add(new Array(c, sep / 2.0 + hPitch, sep / 2.0 + step / 2.0, num, numy, (double)(num * 2) * hPitch, (int)((double)numy * step)));
        return top;
    }

    static Struct TestH() {
        Struct top = new Struct("Ar220");
        int s = 5;
        double dSize = 1500.0;
        double pitch = 0.22;
        int num = (int)(dSize / pitch);
        double duty = 1.0;
        double angle = 1.0471975511965976;
        System.out.println("duty" + duty);
        Struct c = new Struct("CR", PartsLib.circle(pitch / 4.0 * duty, 65, 3));
        double step = pitch * Math.sin(angle);
        System.out.println("step" + step + " numy" + num);
        top.add(new Array(c, 0.0, 0.0, num, num, (double)num * pitch, 0.0, (double)(-num) * pitch / 2.0, (double)num * step));
        return top;
    }

    static Struct angledArray(double hPitch, double duty, double angle, double extent, int layer) {
        Struct ar = new Struct("ar" + GDS2.val(hPitch) + "D" + GDS2.val(duty) + "A" + GDS2.val(angle) + "l" + layer);
        Path2D.Double path = new Path2D.Double();
        Double cosP = 1.0 / Math.cos(angle);
        Double sinP = 1.0 / Math.sin(angle);
        double pY = hPitch * 4.0;
        double pX = hPitch * 2.0 * sinP;
        path.moveTo(0.0, -hPitch * cosP / 2.0);
        path.lineTo(pX, 3.0 * hPitch * cosP / 2.0);
        path.lineTo(pX, 5.0 * hPitch * cosP / 2.0);
        path.lineTo(0.0, hPitch * cosP / 2.0);
        ar.add(new Array(new Struct("L" + GDS2.val(hPitch) + "D" + GDS2.val(duty) + "A" + GDS2.val(angle), new GArea(path, layer)), 0.0, 0.0, (int)(extent / pX), (int)(extent / pY), (double)((int)(extent / pX)) * pX, (double)((int)(extent / pY)) * pY));
        return ar;
    }
}

