/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.shapeMethods;

import CNSTnanoToolbox.scripting.CNSTscriptingController;
import JGDS2.GArea;
import JGDS2.Rect;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.util.ArrayList;

public class PhotonicsWaveGuides {
    public static GArea createWaveGuideExpander(double width, double length, double deltaLength, double a, double b, double angle, double w0, double lambda, double baseHeight) {
        int i;
        int layer = CNSTscriptingController.getGdsLayer();
        double w = w0 / Math.sin(angle * Math.PI / 180.0) * 1.0E-6;
        ArrayList<Double> xVals = new ArrayList<Double>();
        for (double i2 = -length / 2.0; i2 <= length / 2.0; i2 += deltaLength) {
            xVals.add(i2);
        }
        ArrayList<Double> gap = PhotonicsWaveGuides.calculateGap(xVals, a, b, w, lambda);
        GArea ga = new GArea(new Rect(-length / 2.0, -baseHeight, length / 2.0, 0.0, layer), layer);
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(xVals.get(0), -gap.get(0).doubleValue());
        for (i = 1; i < gap.size(); ++i) {
            poly.lineTo(xVals.get(i), -gap.get(i).doubleValue());
        }
        for (i = gap.size() - 1; i >= 0; --i) {
            poly.lineTo(xVals.get(i), -gap.get(i).doubleValue() - width);
        }
        poly.closePath();
        GArea waveGuide = new GArea(poly, layer);
        ga.subtract(waveGuide);
        return ga;
    }

    public static ArrayList<Double> calculateGap(ArrayList<Double> xVals, double a, double b, double w, double lambda) {
        ArrayList<Double> gap = new ArrayList<Double>();
        double d1 = 1.0 / b;
        double d2 = lambda * 1.0E-9 / a / 2.0 / w / Math.pow(Math.PI, 1.5);
        for (int i = 0; i < xVals.size(); ++i) {
            double d3 = Math.exp(-(xVals.get(i) * 1.0E-6 * xVals.get(i) * 1.0E-6) / (w * w));
            double d4 = 1.0 - PhotonicsWaveGuides.erf(xVals.get(i) * 1.0E-6 / w);
            gap.add(1000000.0 * d1 * Math.log(d2 * d3 / d4));
        }
        return gap;
    }

    public static double erf(double x) {
        double t = 1.0 / (1.0 + 0.5 * Math.abs(x));
        double ans = 1.0 - t * Math.exp(-x * x - 1.26551223 + t * (1.00002368 + t * (0.37409196 + t * (0.09678418 + t * (-0.18628806 + t * (0.27886807 + t * (-1.13520398 + t * (1.48851587 + t * (-0.82215223 + t * 0.17087277)))))))));
        if (x >= 0.0) {
            return ans;
        }
        return -ans;
    }

    public static ArrayList<GArea> createWgInvPhC(ArrayList<Double> al, int layer) {
        int len = (al.size() - 4) / 3;
        double x = al.get(al.size() - 4);
        double y = al.get(al.size() - 3);
        double pitch = al.get(al.size() - 2);
        double width = al.get(al.size() - 1);
        double deltaTx = (double)((len - 1) / 2) * pitch;
        double tY = y;
        ArrayList<GArea> ga = new ArrayList<GArea>();
        for (int i = 0; i < len; ++i) {
            double rX = al.get(i * 3);
            double rY = al.get(i * 3 + 1);
            int nS = al.get(i * 3 + 2).intValue();
            double tX = (double)i * pitch - deltaTx + x;
            ga.add(PhotonicsWaveGuides.createInverseWaveGuidePhC(rX, rY, nS, layer, pitch, width, tX, tY));
        }
        return ga;
    }

    public static ArrayList<GArea> createWgInvPhCvary(ArrayList<Double> al, int layer) {
        int len = (al.size() - 3) / 4;
        double x = al.get(al.size() - 3);
        double y = al.get(al.size() - 2);
        double w = al.get(al.size() - 1);
        ArrayList<Double> r = new ArrayList<Double>();
        ArrayList<Double> a = new ArrayList<Double>();
        ArrayList<Integer> n = new ArrayList<Integer>();
        ArrayList<GArea> ga = new ArrayList<GArea>();
        double tY = y;
        for (int i = 0; i < len; ++i) {
            r.add(al.get(i * 4));
            r.add(al.get(i * 4 + 1));
            a.add(al.get(i * 4 + 2));
            n.add(al.get(i * 4 + 3).intValue());
        }
        double halfPitch = PhotonicsWaveGuides.getTotalPitch(a) / 2.0;
        double aTot = 0.0;
        for (int i = 0; i < a.size(); ++i) {
            double tX = x - halfPitch + aTot + a.get(i) / 2.0;
            aTot += a.get(i).doubleValue();
            ga.add(PhotonicsWaveGuides.createInverseWaveGuidePhC((Double)r.get(i * 2), (Double)r.get(i * 2 + 1), (Integer)n.get(i), layer, a.get(i), w, tX, tY));
        }
        return ga;
    }

    public static ArrayList<GArea> createWgPhC(ArrayList<Double> al, int layer) {
        int len = (al.size() - 6) / 3;
        double x = al.get(al.size() - 6);
        double y = al.get(al.size() - 5);
        double pitch = al.get(al.size() - 4);
        double w = al.get(al.size() - 3);
        double sqOX = al.get(al.size() - 2);
        double sqY = al.get(al.size() - 1);
        double deltaTx = (double)((len - 1) / 2) * pitch;
        double tX = 0.0;
        double tY = y;
        ArrayList<GArea> ga = new ArrayList<GArea>();
        for (int i = 0; i < len; ++i) {
            double rX = al.get(i * 3);
            double rY = al.get(i * 3 + 1);
            int nS = al.get(i * 3 + 2).intValue();
            tX = (double)i * pitch - deltaTx + x;
            ga.add(PhotonicsWaveGuides.createWgPhCelement(rX, rY, nS, layer, tX, tY));
        }
        double rectLx = -deltaTx + x - pitch / 2.0 - sqOX;
        double rectLy = tY;
        double rectRx = tX + pitch / 2.0 + sqOX;
        double rectRy = tY;
        ga.add(new GArea(new Rect(rectLx, rectLy + w / 2.0, rectRx, rectRy + sqY + w / 2.0, layer), layer));
        ga.add(new GArea(new Rect(rectLx, rectLy - sqY - w / 2.0, rectRx, rectRy - w / 2.0, layer), layer));
        return ga;
    }

    public static ArrayList<GArea> createWgPhCvary(ArrayList<Double> al, int layer) {
        int len = (al.size() - 5) / 4;
        double x = al.get(al.size() - 5);
        double y = al.get(al.size() - 4);
        double w = al.get(al.size() - 3);
        double sqOX = al.get(al.size() - 2);
        double sqY = al.get(al.size() - 1);
        ArrayList<Double> r = new ArrayList<Double>();
        ArrayList<Double> a = new ArrayList<Double>();
        ArrayList<Integer> n = new ArrayList<Integer>();
        ArrayList<GArea> ga = new ArrayList<GArea>();
        double tX = 0.0;
        double tY = y;
        for (int i = 0; i < len; ++i) {
            r.add(al.get(i * 4));
            r.add(al.get(i * 4 + 1));
            a.add(al.get(i * 4 + 2));
            n.add(al.get(i * 4 + 3).intValue());
        }
        double halfPitch = PhotonicsWaveGuides.getTotalPitch(a) / 2.0;
        double aTot = 0.0;
        for (int i = 0; i < a.size(); ++i) {
            tX = x - halfPitch + aTot + a.get(i) / 2.0;
            aTot += a.get(i).doubleValue();
            ga.add(PhotonicsWaveGuides.createWgPhCelement((Double)r.get(i * 2), (Double)r.get(i * 2 + 1), (Integer)n.get(i), layer, tX, tY));
        }
        double rectLx = -halfPitch + x - sqOX;
        double rectLy = tY;
        double rectRx = tX + a.get(a.size() - 1) / 2.0 + sqOX;
        double rectRy = tY;
        ga.add(new GArea(new Rect(rectLx, rectLy + w / 2.0, rectRx, rectRy + sqY + w / 2.0, layer), layer));
        ga.add(new GArea(new Rect(rectLx, rectLy - sqY - w / 2.0, rectRx, rectRy - w / 2.0, layer), layer));
        return ga;
    }

    public static ArrayList<GArea> createWgInvRectPhC(ArrayList<Double> al, int layer) {
        int len = (al.size() - 4) / 2;
        double x = al.get(al.size() - 4);
        double y = al.get(al.size() - 3);
        double a = al.get(al.size() - 2);
        double w = al.get(al.size() - 1);
        double deltaTx = (double)((len - 1) / 2) * a;
        double tY = y;
        ArrayList<GArea> ga = new ArrayList<GArea>();
        for (int i = 0; i < len; ++i) {
            double Lx = al.get(i * 2);
            double Ly = al.get(i * 2 + 1);
            double tX = (double)i * a - deltaTx + x;
            ga.add(PhotonicsWaveGuides.createInverseRectCenteredWgPhC(Lx, Ly, layer, a, w, tX, tY));
        }
        return ga;
    }

    public static ArrayList<GArea> createWgInvRectPhCvary(ArrayList<Double> al, int layer) {
        int len = (al.size() - 3) / 3;
        double x = al.get(al.size() - 3);
        double y = al.get(al.size() - 2);
        double w = al.get(al.size() - 1);
        ArrayList<Double> L = new ArrayList<Double>();
        ArrayList<Double> a = new ArrayList<Double>();
        ArrayList<GArea> ga = new ArrayList<GArea>();
        double tY = y;
        for (int i = 0; i < len; ++i) {
            L.add(al.get(i * 3));
            L.add(al.get(i * 3 + 1));
            a.add(al.get(i * 3 + 2));
        }
        double halfPitch = PhotonicsWaveGuides.getTotalPitch(a) / 2.0;
        double aTot = 0.0;
        for (int i = 0; i < a.size(); ++i) {
            double tX = x - halfPitch + aTot + a.get(i) / 2.0;
            aTot += a.get(i).doubleValue();
            ga.add(PhotonicsWaveGuides.createInverseRectCenteredWgPhC((Double)L.get(i * 2), (Double)L.get(i * 2 + 1), layer, a.get(i), w, tX, tY));
        }
        return ga;
    }

    public static ArrayList<GArea> createWgRectPhC(ArrayList<Double> al, int layer) {
        int len = (al.size() - 6) / 2;
        double x = al.get(al.size() - 6);
        double y = al.get(al.size() - 5);
        double pitch = al.get(al.size() - 4);
        double w = al.get(al.size() - 3);
        double sqOX = al.get(al.size() - 2);
        double sqY = al.get(al.size() - 1);
        double deltaTx = (double)((len - 1) / 2) * pitch;
        double tX = 0.0;
        double tY = y;
        ArrayList<GArea> ga = new ArrayList<GArea>();
        for (int i = 0; i < len; ++i) {
            double Lx = al.get(i * 2);
            double Ly = al.get(i * 2 + 1);
            tX = (double)i * pitch - deltaTx + x;
            ga.add(PhotonicsWaveGuides.createRectCenteredWgPhC(Lx, Ly, layer, pitch, w, tX, tY));
        }
        double rectLx = -deltaTx + x - pitch / 2.0 - sqOX;
        double rectLy = tY;
        double rectRx = tX + pitch / 2.0 + sqOX;
        double rectRy = tY;
        ga.add(new GArea(new Rect(rectLx, rectLy + w / 2.0, rectRx, rectRy + sqY + w / 2.0, layer), layer));
        ga.add(new GArea(new Rect(rectLx, rectLy - sqY - w / 2.0, rectRx, rectRy - w / 2.0, layer), layer));
        return ga;
    }

    public static ArrayList<GArea> createWgRectPhCvary(ArrayList<Double> al, int layer) {
        int len = (al.size() - 5) / 3;
        double x = al.get(al.size() - 5);
        double y = al.get(al.size() - 4);
        double w = al.get(al.size() - 3);
        double sqOX = al.get(al.size() - 2);
        double sqY = al.get(al.size() - 1);
        ArrayList<Double> L = new ArrayList<Double>();
        ArrayList<Double> a = new ArrayList<Double>();
        ArrayList<GArea> ga = new ArrayList<GArea>();
        double tX = 0.0;
        double tY = y;
        for (int i = 0; i < len; ++i) {
            L.add(al.get(i * 3));
            L.add(al.get(i * 3 + 1));
            a.add(al.get(i * 3 + 2));
        }
        double halfPitch = PhotonicsWaveGuides.getTotalPitch(a) / 2.0;
        double aTot = 0.0;
        for (int i = 0; i < a.size(); ++i) {
            tX = x - halfPitch + aTot + a.get(i) / 2.0;
            aTot += a.get(i).doubleValue();
            ga.add(PhotonicsWaveGuides.createRectCenteredWgPhC((Double)L.get(i * 2), (Double)L.get(i * 2 + 1), layer, a.get(i), w, tX, tY));
        }
        double rectLx = -halfPitch + x - sqOX;
        double rectLy = tY;
        double rectRx = tX + a.get(a.size() - 1) / 2.0 + sqOX;
        double rectRy = tY;
        ga.add(new GArea(new Rect(rectLx, rectLy + w / 2.0, rectRx, rectRy + sqY + w / 2.0, layer), layer));
        ga.add(new GArea(new Rect(rectLx, rectLy - sqY - w / 2.0, rectRx, rectRy - w / 2.0, layer), layer));
        return ga;
    }

    public static ArrayList<GArea> createWgInvRectFlushPhC(ArrayList<Double> s, int layer) {
        int len = (s.size() - 4) / 3;
        double x = s.get(s.size() - 4);
        double y = s.get(s.size() - 3);
        double w = s.get(s.size() - 2);
        double d = s.get(s.size() - 1);
        ArrayList<Double> L = new ArrayList<Double>();
        ArrayList<Double> a = new ArrayList<Double>();
        ArrayList<GArea> ga = new ArrayList<GArea>();
        double tY = y;
        for (int i = 0; i < len; ++i) {
            L.add(s.get(i * 3));
            L.add(s.get(i * 3 + 1));
            a.add(s.get(i * 3 + 2));
        }
        double halfPitch = PhotonicsWaveGuides.getTotalPitch(a) / 2.0;
        double aTot = 0.0;
        for (int i = 0; i < a.size(); ++i) {
            double tX = x - halfPitch + aTot + a.get(i) / 2.0;
            aTot += a.get(i).doubleValue();
            ga.add(PhotonicsWaveGuides.createInverseRectFlushWgPhC((Double)L.get(i * 2), (Double)L.get(i * 2 + 1), layer, a.get(i), w, d, tX, tY));
        }
        return ga;
    }

    public static ArrayList<GArea> createWgRectFlushPhC(ArrayList<Double> al, int layer) {
        int len = (al.size() - 6) / 3;
        double x = al.get(al.size() - 6);
        double y = al.get(al.size() - 5);
        double w = al.get(al.size() - 4);
        double d = al.get(al.size() - 3);
        double sqOX = al.get(al.size() - 2);
        double sqY = al.get(al.size() - 1);
        ArrayList<Double> L = new ArrayList<Double>();
        ArrayList<Double> a = new ArrayList<Double>();
        ArrayList<GArea> ga = new ArrayList<GArea>();
        double tX = 0.0;
        double tY = y;
        for (int i = 0; i < len; ++i) {
            L.add(al.get(i * 3));
            L.add(al.get(i * 3 + 1));
            a.add(al.get(i * 3 + 2));
        }
        double halfPitch = PhotonicsWaveGuides.getTotalPitch(a) / 2.0;
        double aTot = 0.0;
        for (int i = 0; i < a.size(); ++i) {
            tX = x - halfPitch + aTot + a.get(i) / 2.0;
            aTot += a.get(i).doubleValue();
            ga.add(PhotonicsWaveGuides.createRectFlushWgPhC((Double)L.get(i * 2), (Double)L.get(i * 2 + 1), layer, a.get(i), w, d, tX, tY));
        }
        double rectLx = -halfPitch + x - sqOX;
        double rectLy = tY;
        double rectRx = tX + a.get(a.size() - 1) / 2.0 + sqOX;
        double rectRy = tY;
        ga.add(new GArea(new Rect(rectLx, rectLy + w / 2.0, rectRx, rectRy + sqY + w / 2.0, layer), layer));
        ga.add(new GArea(new Rect(rectLx, rectLy - sqY - w / 2.0, rectRx, rectRy - w / 2.0, layer), layer));
        return ga;
    }

    public static GArea createInverseWaveGuidePhC(double rX, double rY, int nSides, int layer, double a, double w, double tX, double tY) {
        GArea cir = PhotonicsWaveGuides.CircleEllipseArea(0.0, 0.0, rX, rY, nSides, layer);
        GArea rectangle = new GArea(new Rect(-a / 2.0, -w / 2.0, a / 2.0, w / 2.0, layer), layer);
        rectangle.subtract(cir);
        rectangle.transform(AffineTransform.getTranslateInstance(tX, tY));
        return rectangle;
    }

    public static GArea createInverseRectCenteredWgPhC(double LX, double LY, int layer, double a, double w, double tX, double tY) {
        GArea rectBig = new GArea(new Rect(-a / 2.0, -w / 2.0, a / 2.0, w / 2.0, layer), layer);
        GArea rect = new GArea(new Rect(-LX / 2.0, -LY / 2.0, LX / 2.0, LY / 2.0, layer), layer);
        rectBig.subtract(rect);
        rectBig.transform(AffineTransform.getTranslateInstance(tX, tY));
        return rectBig;
    }

    public static GArea createInverseRectFlushWgPhC(double LX, double LY, int layer, double a, double w, double d, double tX, double tY) {
        GArea rectBig = new GArea(new Rect(-a / 2.0, -w / 2.0, a / 2.0, w / 2.0, layer), layer);
        GArea rect = new GArea(new Rect(-LX / 2.0, w / 2.0 - d - LY, LX / 2.0, w / 2.0 - d, layer), layer);
        rectBig.subtract(rect);
        rectBig.transform(AffineTransform.getTranslateInstance(tX, tY));
        return rectBig;
    }

    static GArea createRectFlushWgPhC(double LX, double LY, int layer, double a, double w, double d, double tX, double tY) {
        GArea rect = new GArea(new Rect(-LX / 2.0, w / 2.0 - d - LY, LX / 2.0, w / 2.0 - d, layer), layer);
        rect.transform(AffineTransform.getTranslateInstance(tX, tY));
        return rect;
    }

    public static GArea createRectCenteredWgPhC(double WX, double LY, int layer, double a, double w, double tX, double tY) {
        GArea rect = new GArea(new Rect(-WX / 2.0, -LY / 2.0, WX / 2.0, LY / 2.0, layer), layer);
        rect.transform(AffineTransform.getTranslateInstance(tX, tY));
        return rect;
    }

    public static GArea createWgPhCelement(double rX, double rY, int nSides, int layer, double tX, double tY) {
        GArea cir = PhotonicsWaveGuides.CircleEllipseArea(0.0, 0.0, rX, rY, nSides, layer);
        cir.transform(AffineTransform.getTranslateInstance(tX, tY));
        return cir;
    }

    public static double getTotalPitch(ArrayList<Double> a) {
        double total = 0.0;
        for (int i = 0; i < a.size(); ++i) {
            total += a.get(i).doubleValue();
        }
        return total;
    }

    public static GArea createRaceTrack(double x, double y, double length, double width, double radiusInner, double THETA, int nS, int layer) {
        GArea g = new GArea(new Rect(-(length + radiusInner + Math.abs(x)) * 10.0, -(width + radiusInner + Math.abs(y)) * 10.0, 10.0 * (length + radiusInner + Math.abs(x)), 10.0 * (width + radiusInner + Math.abs(y)), layer), layer);
        Area a = new Area();
        a.add(new Area(PhotonicsWaveGuides.createTorus(length, width, radiusInner, length / 2.0, 0.0, 270.0, 90.0, nS, layer).getArea()));
        a.add(new Area(PhotonicsWaveGuides.createRectangle(length, width, layer, 0.0, -(radiusInner + width / 2.0)).getArea()));
        a.add(new Area(PhotonicsWaveGuides.createRectangle(length, width, layer, 0.0, radiusInner + width / 2.0).getArea()));
        a.add(new Area(PhotonicsWaveGuides.createTorus(length, width, radiusInner, -length / 2.0, 0.0, 90.0, 270.0, nS, layer).getArea()));
        g.and(a);
        g.transform(AffineTransform.getRotateInstance(PhotonicsWaveGuides.degreeToRadians(THETA)));
        g.transform(AffineTransform.getTranslateInstance(x, y));
        return g;
    }

    public static GArea createRectangle(double l, double w, int layer, double tX, double tY) {
        GArea ga = new GArea(new Rect(-l / 2.0, -w / 2.0, l / 2.0, w / 2.0, layer), layer);
        ga.transform(AffineTransform.getTranslateInstance(tX, tY));
        return ga;
    }

    public static GArea createTorus(double l, double w, double rin, double x, double y, double angleStart, double angleStop, int numSides, int layer) {
        double rOut = rin + w;
        double angle = angleStop > angleStart ? Math.abs(angleStart - angleStop) : 360.0 - Math.abs(angleStart - angleStop);
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(x + rin * Math.cos(PhotonicsWaveGuides.degreeToRadians(angleStart)), y + rin * Math.sin(PhotonicsWaveGuides.degreeToRadians(angleStart)));
        int steps = numSides;
        double c = angle * (Math.PI / 180) / (double)numSides;
        for (int i = 0; i <= steps; ++i) {
            poly.lineTo(x + rin * Math.cos((double)i * c + PhotonicsWaveGuides.degreeToRadians(angleStart)), y + rin * Math.sin((double)i * c + PhotonicsWaveGuides.degreeToRadians(angleStart)));
        }
        for (int j = steps; j >= 0; --j) {
            poly.lineTo(x + rOut * Math.cos((double)j * c + PhotonicsWaveGuides.degreeToRadians(angleStart)), y + rOut * Math.sin((double)j * c + PhotonicsWaveGuides.degreeToRadians(angleStart)));
        }
        poly.closePath();
        GArea v = new GArea(poly, layer);
        return v;
    }

    public static GArea CircleEllipseArea(double x, double y, double radiusX, double radiusY, int NumSides, int layer) {
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(x + radiusX, y);
        int steps = NumSides;
        double c = Math.PI * 2 / (double)NumSides;
        for (int i = 0; i < steps; ++i) {
            poly.lineTo(radiusX * Math.cos((double)i * c), radiusY * Math.sin((double)i * c));
        }
        poly.closePath();
        GArea v = new GArea(poly, layer);
        return v;
    }

    public static double degreeToRadians(double d) {
        return d * (Math.PI / 180);
    }
}

