/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.shapeMethods;

import CNST.Scripting;
import CNSTnanoToolbox.scripting.CNSTscriptingController;
import CNSTnanoToolbox.shapeMethods.PrimitiveShapes;
import JGDS2.GArea;
import JGDS2.GDS2;
import JGDS2.Rect;
import java.awt.BasicStroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.util.ArrayList;

public class PhotonicsGratingCouplers {
    public static ArrayList<GArea> createGratingCouplerWaveguideEC(double wgWidth, double Length, double Height, double sleeve, double lambda0, double nEff, double nCladding, double thetaC, double R1, double gratingPeriod, double ratio, int numberOfElements, int numSides, int layerWG, int layerGR, boolean WGINV, boolean ENDCAPS) {
        GArea v;
        BasicStroke bs;
        int i;
        Path2D.Double poly;
        int layer = CNSTscriptingController.getGdsLayer();
        double shapeReso = CNSTscriptingController.getShapeReso();
        int Q1 = (int)Math.ceil(nEff * R1 / lambda0);
        double theta = Math.acos(nEff - lambda0 / gratingPeriod);
        ArrayList<GArea> gaAL = new ArrayList<GArea>();
        int CAP = ENDCAPS ? 1 : 0;
        int JOIN = ENDCAPS ? 1 : 0;
        double angleStart = -Math.abs(thetaC) / 2.0;
        double c = thetaC * (Math.PI / 180) / (double)numSides;
        if (ENDCAPS) {
            for (int k = Q1 - numberOfElements; k < Q1; ++k) {
                poly = new Path2D.Double();
                double r = (double)k * lambda0 / (nEff - nCladding * Math.cos(PrimitiveShapes.degreeToRadians(angleStart)) * Math.cos(theta)) - gratingPeriod * ratio / 2.0;
                poly.moveTo(r * Math.cos(PrimitiveShapes.degreeToRadians(angleStart)), r * Math.sin(PrimitiveShapes.degreeToRadians(angleStart)));
                for (i = 0; i <= numSides; ++i) {
                    r = (double)k * lambda0 / (nEff - nCladding * Math.cos((double)i * c + PrimitiveShapes.degreeToRadians(angleStart)) * Math.cos(theta)) - gratingPeriod * ratio / 2.0;
                    poly.lineTo(r * Math.cos((double)i * c + PrimitiveShapes.degreeToRadians(angleStart)), r * Math.sin((double)i * c + PrimitiveShapes.degreeToRadians(angleStart)));
                }
                bs = new BasicStroke((float)(gratingPeriod * ratio), CAP, JOIN, 1.0f);
                v = new GArea(bs.createStrokedShape(poly), layerGR);
                v.setRenderReso(shapeReso);
                gaAL.add(v);
            }
        } else {
            for (int k = Q1 - numberOfElements; k < Q1; ++k) {
                poly = new Path2D.Double();
                double r = (double)k * lambda0 / (nEff - nCladding * Math.cos(PrimitiveShapes.degreeToRadians(angleStart)) * Math.cos(theta));
                poly.moveTo(r * Math.cos(PrimitiveShapes.degreeToRadians(angleStart)), r * Math.sin(PrimitiveShapes.degreeToRadians(angleStart)));
                for (i = 0; i <= numSides; ++i) {
                    r = (double)k * lambda0 / (nEff - nCladding * Math.cos((double)i * c + PrimitiveShapes.degreeToRadians(angleStart)) * Math.cos(theta));
                    poly.lineTo(r * Math.cos((double)i * c + PrimitiveShapes.degreeToRadians(angleStart)), r * Math.sin((double)i * c + PrimitiveShapes.degreeToRadians(angleStart)));
                }
                for (int j = numSides; j >= 0; --j) {
                    r = (double)k * lambda0 / (nEff - nCladding * Math.cos((double)j * c + PrimitiveShapes.degreeToRadians(angleStart)) * Math.cos(theta)) - gratingPeriod * ratio;
                    poly.lineTo(r * Math.cos((double)j * c + PrimitiveShapes.degreeToRadians(angleStart)), r * Math.sin((double)j * c + PrimitiveShapes.degreeToRadians(angleStart)));
                }
                poly.closePath();
                gaAL.add(new GArea(poly, layerGR));
            }
        }
        poly = new Path2D.Double();
        poly.moveTo(0.0, 0.0);
        poly.curveTo(-Length / 2.0, 0.0, -Length / 2.0, Height, -Length, Height);
        if (WGINV) {
            bs = new BasicStroke((float)wgWidth, 0, 0);
            v = new GArea(bs.createStrokedShape(poly), layerWG);
            Path2D.Double poly2 = new Path2D.Double();
            poly.moveTo(0.0, 0.0);
            poly.curveTo(-Length / 2.0, 0.0, -Length / 2.0, Height, -Length, Height);
            bs = new BasicStroke((float)(wgWidth + 2.0 * sleeve), 0, 0);
            GArea tmp = new GArea(bs.createStrokedShape(poly), layerWG);
            tmp.subtract(v);
            if (ENDCAPS) {
                v = new GArea(PrimitiveShapes.createEllipse(0.0, (wgWidth + sleeve) / 2.0, sleeve / 2.0, sleeve / 2.0, numSides, layerWG));
                tmp.or(v);
                v = new GArea(PrimitiveShapes.createEllipse(0.0, -(wgWidth + sleeve) / 2.0, sleeve / 2.0, sleeve / 2.0, numSides, layerWG));
                tmp.or(v);
                v = new GArea(PrimitiveShapes.createEllipse(-Length, Height + (wgWidth + sleeve) / 2.0, sleeve / 2.0, sleeve / 2.0, numSides, layerWG));
                tmp.or(v);
                v = new GArea(PrimitiveShapes.createEllipse(-Length, Height - (wgWidth + sleeve) / 2.0, sleeve / 2.0, sleeve / 2.0, numSides, layerWG));
                tmp.or(v);
            }
            gaAL.add(tmp);
        } else {
            bs = new BasicStroke((float)wgWidth, CAP, JOIN);
            v = new GArea(bs.createStrokedShape(poly), layerWG);
            gaAL.add(v);
        }
        return gaAL;
    }

    public static GArea createApodizedGrating(double gratingLength, double increment, double height, double dutyCycleCutoff, double p1, double p2, double p3, double p4, double d1, double d2, double d3, double d4, double d5) {
        int layer = CNSTscriptingController.getGdsLayer();
        double[] p = new double[]{p1, p2, p3, p4};
        double[] d = new double[]{d1, d2, d3, d4, d5};
        int arraySize = (int)Math.ceil((gratingLength *= 1.0E-6) / (increment *= 1.0E-6)) + 1;
        double[] x = new double[arraySize];
        int cnt = 0;
        for (double i = -gratingLength / 2.0; i <= gratingLength / 2.0; i += 1.0E-8) {
            x[cnt] = i;
            ++cnt;
        }
        double[][] widthPitch0 = PhotonicsGratingCouplers.apodizedGrating(x, d, p, gratingLength, dutyCycleCutoff);
        int numPeriods = (int)Math.round(gratingLength / PhotonicsGratingCouplers.meanArrayValue(widthPitch0, 1));
        double[] xLL = new double[arraySize];
        double[] xUR = new double[arraySize];
        double[] yLL = new double[arraySize];
        double[] yUR = new double[arraySize];
        xLL[0] = x[0];
        double[] xLLtemp = new double[]{xLL[0]};
        yLL[0] = 0.0;
        yUR[0] = 300.0;
        double[][] widthPitch = PhotonicsGratingCouplers.apodizedGrating(xLLtemp, d, p, gratingLength, dutyCycleCutoff);
        xUR[0] = xLL[0] + widthPitch[0][0];
        GArea ga = new GArea(new Rect(xLL[0] * 1000000.0, yLL[0], xUR[0] * 1000000.0, yUR[0], layer), layer);
        for (int i = 1; i < numPeriods; ++i) {
            xLL[i] = xLL[i - 1] + widthPitch[1][0];
            yLL[i] = 0.0;
            yUR[i] = 300.0;
            xLLtemp[0] = xLL[i];
            widthPitch = PhotonicsGratingCouplers.apodizedGrating(xLLtemp, d, p, gratingLength, dutyCycleCutoff);
            xUR[i] = xLL[i] + widthPitch[0][0];
            ga.or(new Rect(xLL[i] * 1000000.0, yLL[i], xUR[i] * 1000000.0, yUR[i], layer), layer);
        }
        return ga;
    }

    public static double[][] apodizedGrating(double[] x, double[] d, double[] p, double length, double cutoff) {
        double[][] widthPitch = new double[2][x.length];
        double[] duty = new double[x.length];
        for (int i = 0; i < x.length; ++i) {
            double xOverL = x[i] / length;
            double dutyCalc = d[0] + d[1] * xOverL + d[2] * xOverL * xOverL + d[3] * xOverL * xOverL * xOverL + d[4] * xOverL * xOverL * xOverL * xOverL;
            duty[i] = dutyCalc <= cutoff ? cutoff : dutyCalc;
            widthPitch[1][i] = p[0] * (1.0 + p[1] * xOverL + p[2] * xOverL * xOverL + p[3] * xOverL * xOverL * xOverL);
            widthPitch[0][i] = duty[i] * widthPitch[1][i];
        }
        return widthPitch;
    }

    public static double meanArrayValue(double[][] arr, int index) {
        double sum = 0.0;
        for (int i = 0; i < arr[index].length; ++i) {
            sum += arr[index][i];
        }
        double average = sum / (double)arr[index].length;
        return average;
    }

    public static GArea createDirectionalCoupler1(double L1, double w1, double we1, double L2, double L3, double w2, double we2, double g, double r, int numSides) {
        int layer = CNSTscriptingController.getGdsLayer();
        GArea ga = Scripting.createRectangleC(0.0, 0.0, L1, w1 + 2.0 * we1, 0.0, layer);
        GArea lower = Scripting.createRectangleC(L2 / 4.0, -w1 / 2.0 - g - w2 / 2.0, L2 / 2.0, w2 + 2.0 * we2, 0.0, layer);
        lower.or(Scripting.createTorusW(L2 / 2.0, -w1 / 2.0 - g - w2 / 2.0 - r, r, w2 + 2.0 * we2, 0.0, 90.0, numSides, 0.0, layer));
        GArea rect = new GArea(Scripting.createRectangle(0.0, -L3, 2.0 * we2 + w2, 0.0, 0.0, layer));
        lower.or((GDS2)rect.transform(AffineTransform.getTranslateInstance(L2 / 2.0 + r - w2 / 2.0 - we2, -w1 / 2.0 - g - w2 / 2.0 - r)));
        GArea temp = new GArea(lower);
        AffineTransform at = new AffineTransform(new double[]{-1.0, 0.0, 0.0, 1.0});
        lower.or((GDS2)temp.transform(at));
        ga.or(lower);
        ga.subtract(Scripting.createRectangleC(0.0, 0.0, L1, w1, 0.0, layer));
        GArea lowerWaveguide = Scripting.createRectangleC(0.0, -w1 / 2.0 - g - w2 / 2.0, L2, w2, 0.0, layer);
        lowerWaveguide.or(Scripting.createTorusW(L2 / 2.0, -w1 / 2.0 - g - w2 / 2.0 - r, r, w2, 0.0, 91.0, numSides, 0.0, layer));
        GArea rectWaveguide = new GArea(Scripting.createRectangle(we2, -L3, we2 + w2, 0.0, 0.0, layer));
        lowerWaveguide.or((GDS2)rectWaveguide.transform(AffineTransform.getTranslateInstance(L2 / 2.0 + r - w2 / 2.0 - we2, -w1 / 2.0 - g - w2 / 2.0 - r)));
        temp = new GArea(lowerWaveguide);
        lowerWaveguide.or((GDS2)temp.transform(at));
        ga.subtract(lowerWaveguide);
        return ga;
    }

    public static GArea createDirectionalCoupler2(double L1, double w1, double we1, double L2, double L3, double w2, double we2, double g, double r, int numSides) {
        int layer = CNSTscriptingController.getGdsLayer();
        GArea ga = Scripting.createRectangleC(0.0, 0.0, L1, w1 + 2.0 * we1, 0.0, layer);
        GArea lower = Scripting.createRectangleC(L2 / 4.0, -w1 / 2.0 - g - w2 / 2.0, L2 / 2.0, w2 + 2.0 * we2, 0.0, layer);
        lower.or(Scripting.createTorusW(L2 / 2.0, -w1 / 2.0 - g - w2 / 2.0 - r, r, w2 + 2.0 * we2, 0.0, 90.0, numSides, 0.0, layer));
        GArea rect = new GArea(Scripting.createRectangle(0.0, -L3, 2.0 * we2 + w2, 0.0, 0.0, layer));
        lower.or((GDS2)rect.transform(AffineTransform.getTranslateInstance(L2 / 2.0 + r - w2 / 2.0 - we2, -w1 / 2.0 - g - w2 / 2.0 - r)));
        GArea temp = new GArea(lower);
        AffineTransform at = new AffineTransform(new double[]{-1.0, 0.0, 0.0, 1.0});
        lower.or((GDS2)temp.transform(at));
        temp = new GArea(lower);
        lower.or((GDS2)temp.transform(AffineTransform.getRotateInstance(Math.PI)));
        ga.or(lower);
        ga.subtract(Scripting.createRectangleC(0.0, 0.0, L1, w1, 0.0, layer));
        GArea lowerWaveguide = Scripting.createRectangleC(0.0, -w1 / 2.0 - g - w2 / 2.0, L2, w2, 0.0, layer);
        lowerWaveguide.or(Scripting.createTorusW(L2 / 2.0, -w1 / 2.0 - g - w2 / 2.0 - r, r, w2, 0.0, 91.0, numSides, 0.0, layer));
        GArea rectWaveguide = new GArea(Scripting.createRectangle(we2, -L3, we2 + w2, 0.0, 0.0, layer));
        lowerWaveguide.or((GDS2)rectWaveguide.transform(AffineTransform.getTranslateInstance(L2 / 2.0 + r - w2 / 2.0 - we2, -w1 / 2.0 - g - w2 / 2.0 - r)));
        temp = new GArea(lowerWaveguide);
        lowerWaveguide.or((GDS2)temp.transform(at));
        temp = new GArea(lowerWaveguide);
        lowerWaveguide.or((GDS2)temp.transform(AffineTransform.getRotateInstance(Math.PI)));
        ga.subtract(lowerWaveguide);
        return ga;
    }

    public static GArea createDirectionalCoupler3(double w, double wE, double g, double L1, double L2, double r, int numSides) {
        GArea ga = PhotonicsGratingCouplers.createDirectionalCouplerUshape(w + 2.0 * wE, g, L1, L2, r, numSides);
        GArea temp = new GArea(ga);
        temp.transform(AffineTransform.getRotateInstance(Math.PI));
        temp.transform(AffineTransform.getTranslateInstance(0.0, g + w));
        ga.or(temp);
        GArea waveguide = PhotonicsGratingCouplers.createDirectionalCouplerUshape(w, g, L1, L2, r, numSides);
        ga.subtract(waveguide);
        temp = new GArea(waveguide);
        temp.transform(AffineTransform.getRotateInstance(Math.PI));
        temp.transform(AffineTransform.getTranslateInstance(0.0, g + w));
        ga.subtract(temp);
        ga.transform(AffineTransform.getTranslateInstance(0.0, -w / 2.0 - g / 2.0));
        return ga;
    }

    public static GArea createDirectionalCouplerUshape(double w, double g, double L1, double L2, double r, int numSides) {
        int layer = CNSTscriptingController.getGdsLayer();
        GArea uShape = Scripting.createRectangle(0.0, -w / 2.0, L1 / 2.0, w / 2.0, 0.0, layer);
        uShape.or(Scripting.createTorusW(L1 / 2.0, -r, r, w, 0.0, 90.0, numSides, 0.0, layer));
        uShape.or(Scripting.createRectangle(L1 / 2.0 + r - w / 2.0, -r - L2, L1 / 2.0 + r + w / 2.0, -r, 0.0, layer));
        GArea temp = new GArea(uShape);
        AffineTransform mirrorY = new AffineTransform(new double[]{-1.0, 0.0, 0.0, 1.0});
        temp.transform(mirrorY);
        uShape.or(temp);
        return uShape;
    }

    public static GArea createDirectionalCoupler4(double w, double wE, double g, double L1, double LB, double HB) {
        GArea ga = PhotonicsGratingCouplers.createDirectionalCouplerSbend(w + 2.0 * wE, g, L1, LB, HB);
        GArea temp = new GArea(ga);
        temp.transform(AffineTransform.getRotateInstance(Math.PI));
        temp.transform(AffineTransform.getTranslateInstance(0.0, g + w));
        ga.or(temp);
        GArea waveguide = PhotonicsGratingCouplers.createDirectionalCouplerSbend(w, g, L1, LB, HB);
        ga.subtract(waveguide);
        temp = new GArea(waveguide);
        temp.transform(AffineTransform.getRotateInstance(Math.PI));
        temp.transform(AffineTransform.getTranslateInstance(0.0, g + w));
        ga.subtract(temp);
        ga.transform(AffineTransform.getTranslateInstance(0.0, -w / 2.0 - g / 2.0));
        return ga;
    }

    public static GArea createDirectionalCouplerSbend(double w, double g, double L1, double LB, double HB) {
        int layer = CNSTscriptingController.getGdsLayer();
        double shapeReso = CNSTscriptingController.getShapeReso();
        GArea sShape = Scripting.createRectangle(0.0, -w / 2.0, L1 / 2.0, w / 2.0, 0.0, layer);
        sShape.or(Scripting.createSbend(L1 / 2.0, 0.0, L1 / 2.0 + LB, -HB, w, 0.0, layer, shapeReso));
        GArea temp = new GArea(sShape);
        AffineTransform mirrorY = new AffineTransform(new double[]{-1.0, 0.0, 0.0, 1.0});
        temp.transform(mirrorY);
        sShape.or(temp);
        return sShape;
    }
}

