/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.shapeMethods;

import CNSTnanoToolbox.scripting.CNSTscriptingController;
import JGDS2.GArea;
import JGDS2.Rect;
import JGDS2.Struct;
import java.awt.BasicStroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class PhotonicsDiscRingPulleys {
    public static void createInfiniteRingDisc(Struct s, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideLength, double waveguideWidth, boolean DISC, boolean ENDCAP, int layer) {
        waveguideLength /= 2.0;
        if (DISC) {
            GArea gD = PhotonicsDiscRingPulleys.createDisc(x, y, radius, numberOfSidesDiscRing, layer);
            gD.or(new Rect(x - waveguideLength, y + radius + gap, x + waveguideLength, y + radius + gap + waveguideWidth, layer));
            gD.setDataType(CNSTscriptingController.getDataType());
            s.add(gD);
        } else {
            GArea gR = PhotonicsDiscRingPulleys.createRing(x, y, ringWidth, (radius += ringWidth) - ringWidth, 0.0, 360.0, numberOfSidesDiscRing, layer);
            gR.or(new Rect(x - waveguideLength, y + radius + gap, x + waveguideLength, y + radius + gap + waveguideWidth, layer));
            gR.setDataType(CNSTscriptingController.getDataType());
            s.add(gR);
        }
        if (ENDCAP) {
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength, y + radius + gap + waveguideWidth / 2.0, waveguideWidth, 0.0));
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength, y + radius + gap + waveguideWidth / 2.0, waveguideWidth, 180.0));
        }
    }

    public static void createInfRingDiscDS(Struct s, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideLength, double waveguideWidth, double gap2, double length2, double width2, boolean DISC, boolean ENDCAP, int layer) {
        waveguideLength /= 2.0;
        length2 /= 2.0;
        if (DISC) {
            GArea gDDS = PhotonicsDiscRingPulleys.createDisc(x, y, radius, numberOfSidesDiscRing, layer);
            gDDS.or(new Rect(x - waveguideLength, y + radius + gap, x + waveguideLength, y + radius + gap + waveguideWidth, layer));
            gDDS.or(new Rect(x - length2, y - radius - gap2 - width2, x + length2, y - radius - gap2, layer));
            gDDS.setDataType(CNSTscriptingController.getDataType());
            s.add(gDDS);
        } else {
            GArea gRDS = PhotonicsDiscRingPulleys.createRing(x, y, ringWidth, (radius += ringWidth) - ringWidth, 0.0, 360.0, numberOfSidesDiscRing, layer);
            gRDS.or(new Rect(x - waveguideLength, y + radius + gap, x + waveguideLength, y + radius + gap + waveguideWidth, layer));
            gRDS.or(new Rect(x - length2, y - radius - gap2 - width2, x + length2, y - radius - gap2, layer));
            gRDS.setDataType(CNSTscriptingController.getDataType());
            s.add(gRDS);
        }
        if (ENDCAP) {
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength, y + radius + gap + waveguideWidth / 2.0, waveguideWidth, 0.0));
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength, y + radius + gap + waveguideWidth / 2.0, waveguideWidth, 180.0));
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, y - radius - gap2 - width2 / 2.0, width2, 0.0));
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, y - radius - gap2 - width2 / 2.0, width2, 180.0));
        }
    }

    public static void createInfiniteRingDiscInverse(Struct s, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideLength, double waveguideWidth, double sleeveWidth, boolean DISC, boolean ENDCAP, int layer) {
        waveguideLength /= 2.0;
        if (DISC) {
            GArea gD = PhotonicsDiscRingPulleys.createDisc(x, y, radius, numberOfSidesDiscRing, layer);
            gD.or(new Rect(x - waveguideLength, y + radius + gap, x + waveguideLength, y + radius + gap + sleeveWidth, layer));
            gD.or(new Rect(x - waveguideLength, y + radius + gap + waveguideWidth + sleeveWidth, x + waveguideLength, y + radius + gap + waveguideWidth + 2.0 * sleeveWidth, layer));
            gD.setDataType(CNSTscriptingController.getDataType());
            s.add(gD);
        } else {
            GArea gR = PhotonicsDiscRingPulleys.createRing(x, y, ringWidth, (radius += ringWidth) - ringWidth, 0.0, 360.0, numberOfSidesDiscRing, layer);
            gR.or(new Rect(x - waveguideLength, y + radius + gap, x + waveguideLength, y + radius + gap + sleeveWidth, layer));
            gR.or(new Rect(x - waveguideLength, y + radius + gap + waveguideWidth + sleeveWidth, x + waveguideLength, y + radius + gap + waveguideWidth + 2.0 * sleeveWidth, layer));
            gR.setDataType(CNSTscriptingController.getDataType());
            s.add(gR);
        }
        if (ENDCAP) {
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength, y + radius + gap + sleeveWidth / 2.0, sleeveWidth, 0.0));
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength, y + radius + gap + sleeveWidth / 2.0, sleeveWidth, 180.0));
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength, y + radius + gap + waveguideWidth + sleeveWidth * 3.0 / 2.0, sleeveWidth, 0.0));
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength, y + radius + gap + waveguideWidth + sleeveWidth * 3.0 / 2.0, sleeveWidth, 180.0));
        }
    }

    public static void createInfRingDiscInvDS(Struct s, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideLength, double waveguideWidth, double sleeveWidth, double gap2, double length2, double width2, double sleeve2, boolean DISC, boolean ENDCAP, int layer) {
        waveguideLength /= 2.0;
        length2 /= 2.0;
        if (DISC) {
            GArea gDDS = PhotonicsDiscRingPulleys.createDisc(x, y, radius, numberOfSidesDiscRing, layer);
            gDDS.or(new Rect(x - waveguideLength, y + radius + gap, x + waveguideLength, y + radius + gap + sleeveWidth, layer));
            gDDS.or(new Rect(x - waveguideLength, y + radius + gap + waveguideWidth + sleeveWidth, x + waveguideLength, y + radius + gap + waveguideWidth + 2.0 * sleeveWidth, layer));
            gDDS.or(new Rect(x - length2, y - radius - gap2 - sleeve2, x + length2, y - radius - gap2, layer));
            gDDS.or(new Rect(x - length2, y - radius - gap2 - width2 - 2.0 * sleeve2, x + length2, y - radius - gap2 - width2 - sleeve2, layer));
            gDDS.setDataType(CNSTscriptingController.getDataType());
            s.add(gDDS);
        } else {
            GArea gRDS = PhotonicsDiscRingPulleys.createRing(x, y, ringWidth, (radius += ringWidth) - ringWidth, 0.0, 360.0, numberOfSidesDiscRing, layer);
            gRDS.or(new Rect(x - waveguideLength, y + radius + gap, x + waveguideLength, y + radius + gap + sleeveWidth, layer));
            gRDS.or(new Rect(x - waveguideLength, y + radius + gap + waveguideWidth + sleeveWidth, x + waveguideLength, y + radius + gap + waveguideWidth + 2.0 * sleeveWidth, layer));
            gRDS.or(new Rect(x - length2, y - radius - gap2 - sleeve2, x + length2, y - radius - gap2, layer));
            gRDS.or(new Rect(x - length2, y - radius - gap2 - width2 - 2.0 * sleeve2, x + length2, y - radius - gap2 - width2 - sleeve2, layer));
            gRDS.setDataType(CNSTscriptingController.getDataType());
            s.add(gRDS);
        }
        if (ENDCAP) {
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength, y + radius + gap + sleeveWidth / 2.0, sleeveWidth, 0.0));
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength, y + radius + gap + sleeveWidth / 2.0, sleeveWidth, 180.0));
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength, y + radius + gap + waveguideWidth + sleeveWidth * 3.0 / 2.0, sleeveWidth, 0.0));
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength, y + radius + gap + waveguideWidth + sleeveWidth * 3.0 / 2.0, sleeveWidth, 180.0));
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, y - radius - gap2 - sleeve2 / 2.0, sleeve2, 0.0));
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, y - radius - gap2 - sleeve2 / 2.0, sleeve2, 180.0));
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, y - radius - gap2 - width2 - sleeve2 * 3.0 / 2.0, sleeve2, 0.0));
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, y - radius - gap2 - width2 - sleeve2 * 3.0 / 2.0, sleeve2, 180.0));
        }
    }

    public static void createInfiniteRingDiscInversePos(Struct s, double x, double y, double radius, double ringWidth, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double waveguideLength, double waveguideWidth, double sleeveWidth, boolean DISC, boolean ENDCAP, int layer) {
        waveguideLength /= 2.0;
        if (DISC) {
            GArea discInv = PhotonicsDiscRingPulleys.createRing(x, y, ringDiscSleeveWidth, (radius += ringDiscSleeveWidth) - ringDiscSleeveWidth, 0.0, 360.0, numberOfSidesDiscRing, layer);
            double wgLowerBottom = y + radius - ringDiscSleeveWidth + gap - sleeveWidth;
            GArea waveGuideBottom = new GArea(new Rect(x - waveguideLength, wgLowerBottom, x + waveguideLength, wgLowerBottom + 2.0 * sleeveWidth + waveguideWidth, layer), layer);
            discInv.or(waveGuideBottom);
            GArea waveGuide = new GArea(new Rect(x - waveguideLength, wgLowerBottom += sleeveWidth, x + waveguideLength, wgLowerBottom + waveguideWidth, layer), layer);
            GArea innerDisc = PhotonicsDiscRingPulleys.createDisc(x, y, radius - ringDiscSleeveWidth, numberOfSidesDiscRing, layer);
            discInv.subtract(waveGuide);
            discInv.subtract(innerDisc);
            discInv.setDataType(CNSTscriptingController.getDataType());
            s.add(discInv);
            if (ENDCAP) {
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength, wgLowerBottom + sleeveWidth / 2.0 + waveguideWidth, sleeveWidth, 0.0));
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength, wgLowerBottom + sleeveWidth / 2.0 + waveguideWidth, sleeveWidth, 180.0));
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength, wgLowerBottom - sleeveWidth / 2.0, sleeveWidth, 0.0));
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength, wgLowerBottom - sleeveWidth / 2.0, sleeveWidth, 180.0));
            }
        } else {
            double totalRingWidth = 2.0 * ringDiscSleeveWidth + ringWidth;
            GArea ringBIG = PhotonicsDiscRingPulleys.createRing(x, y, totalRingWidth, (radius += ringDiscSleeveWidth) - totalRingWidth, 0.0, 360.0, numberOfSidesDiscRing, layer);
            GArea ringSMALL = PhotonicsDiscRingPulleys.createRing(x, y, ringWidth, radius - ringDiscSleeveWidth - ringWidth, 0.0, 360.0, numberOfSidesDiscRing, layer);
            double wgLowerY = y + radius - ringDiscSleeveWidth + gap - sleeveWidth;
            double totalWgWidth = 2.0 * sleeveWidth + waveguideWidth;
            GArea waveGuideBIG = new GArea(new Rect(x - waveguideLength, wgLowerY, x + waveguideLength, wgLowerY + totalWgWidth, layer), layer);
            GArea waveGuideSMALL = new GArea(new Rect(x - waveguideLength, wgLowerY + sleeveWidth, x + waveguideLength, wgLowerY + sleeveWidth + waveguideWidth, layer), layer);
            GArea innerDisc = PhotonicsDiscRingPulleys.createDisc(x, y, radius - 2.0 * ringDiscSleeveWidth - ringWidth, numberOfSidesDiscRing, layer);
            ringBIG.or(waveGuideBIG);
            ringSMALL.or(waveGuideSMALL);
            ringBIG.subtract(ringSMALL);
            ringBIG.subtract(innerDisc);
            ringBIG.setDataType(CNSTscriptingController.getDataType());
            s.add(ringBIG);
            if (ENDCAP) {
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength, wgLowerY + sleeveWidth / 2.0, sleeveWidth, 0.0));
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength, wgLowerY + sleeveWidth / 2.0, sleeveWidth, 180.0));
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength, wgLowerY + sleeveWidth * 3.0 / 2.0 + waveguideWidth, sleeveWidth, 0.0));
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength, wgLowerY + sleeveWidth * 3.0 / 2.0 + waveguideWidth, sleeveWidth, 180.0));
            }
        }
    }

    public static void createInfRingDiscInvPosDS(Struct s, double x, double y, double radius, double ringWidth, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double waveguideLength, double waveguideWidth, double sleeveWidth, double gap2, double length2, double width2, double sleeve2, boolean DISC, boolean ENDCAP, int layer) {
        waveguideLength /= 2.0;
        length2 /= 2.0;
        if (DISC) {
            GArea discInv = PhotonicsDiscRingPulleys.createRing(x, y, ringDiscSleeveWidth, (radius += ringDiscSleeveWidth) - ringDiscSleeveWidth, 0.0, 360.0, numberOfSidesDiscRing, layer);
            double wgLowerBottom = y + radius - ringDiscSleeveWidth + gap - sleeveWidth;
            GArea waveGuideBottom = new GArea(new Rect(x - waveguideLength, wgLowerBottom, x + waveguideLength, wgLowerBottom + 2.0 * sleeveWidth + waveguideWidth, layer), layer);
            double wgLowerBottom2 = y - radius + ringDiscSleeveWidth - gap2 - width2 - sleeve2;
            GArea waveGuideBottom2 = new GArea(new Rect(x - length2, wgLowerBottom2, x + length2, wgLowerBottom2 + 2.0 * sleeve2 + width2, layer), layer);
            discInv.or(waveGuideBottom);
            discInv.or(waveGuideBottom2);
            GArea waveGuide = new GArea(new Rect(x - waveguideLength, wgLowerBottom += sleeveWidth, x + waveguideLength, wgLowerBottom + waveguideWidth, layer), layer);
            GArea waveGuide2 = new GArea(new Rect(x - length2, wgLowerBottom2 += sleeve2, x + length2, wgLowerBottom2 + width2, layer), layer);
            GArea innerDisc = PhotonicsDiscRingPulleys.createDisc(x, y, radius - ringDiscSleeveWidth, numberOfSidesDiscRing, layer);
            discInv.subtract(waveGuide);
            discInv.subtract(waveGuide2);
            discInv.subtract(innerDisc);
            discInv.setDataType(CNSTscriptingController.getDataType());
            s.add(discInv);
            if (ENDCAP) {
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength, wgLowerBottom + sleeveWidth / 2.0 + waveguideWidth, sleeveWidth, 0.0));
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength, wgLowerBottom + sleeveWidth / 2.0 + waveguideWidth, sleeveWidth, 180.0));
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength, wgLowerBottom - sleeveWidth / 2.0, sleeveWidth, 0.0));
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength, wgLowerBottom - sleeveWidth / 2.0, sleeveWidth, 180.0));
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, wgLowerBottom2 + sleeve2 / 2.0 + width2, sleeve2, 0.0));
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, wgLowerBottom2 + sleeve2 / 2.0 + width2, sleeve2, 180.0));
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, wgLowerBottom2 - sleeve2 / 2.0, sleeve2, 0.0));
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, wgLowerBottom2 - sleeve2 / 2.0, sleeve2, 180.0));
            }
        } else {
            double totalRingWidth = 2.0 * ringDiscSleeveWidth + ringWidth;
            GArea ringBIG = PhotonicsDiscRingPulleys.createRing(x, y, totalRingWidth, (radius += ringDiscSleeveWidth) - totalRingWidth, 0.0, 360.0, numberOfSidesDiscRing, layer);
            GArea ringSMALL = PhotonicsDiscRingPulleys.createRing(x, y, ringWidth, radius - ringDiscSleeveWidth - ringWidth, 0.0, 360.0, numberOfSidesDiscRing, layer);
            double wgLowerY = y + radius - ringDiscSleeveWidth + gap - sleeveWidth;
            double totalWgWidth = 2.0 * sleeveWidth + waveguideWidth;
            GArea waveGuideBIG = new GArea(new Rect(x - waveguideLength, wgLowerY, x + waveguideLength, wgLowerY + totalWgWidth, layer), layer);
            GArea waveGuideSMALL = new GArea(new Rect(x - waveguideLength, wgLowerY + sleeveWidth, x + waveguideLength, wgLowerY + sleeveWidth + waveguideWidth, layer), layer);
            double wgLowerY2 = y - radius + ringDiscSleeveWidth - gap2 - width2 - sleeve2;
            GArea waveGuideBIG2 = new GArea(new Rect(x - length2, wgLowerY2, x + length2, wgLowerY2 + width2 + 2.0 * sleeve2, layer), layer);
            GArea waveGuideSMALL2 = new GArea(new Rect(x - length2, wgLowerY2 + sleeve2, x + length2, wgLowerY2 + sleeve2 + width2, layer), layer);
            GArea innerDisc = PhotonicsDiscRingPulleys.createDisc(x, y, radius - 2.0 * ringDiscSleeveWidth - ringWidth, numberOfSidesDiscRing, layer);
            ringBIG.or(waveGuideBIG);
            ringSMALL.or(waveGuideSMALL);
            ringBIG.or(waveGuideBIG2);
            ringSMALL.or(waveGuideSMALL2);
            ringBIG.subtract(ringSMALL);
            ringBIG.subtract(innerDisc);
            ringBIG.setDataType(CNSTscriptingController.getDataType());
            s.add(ringBIG);
            if (ENDCAP) {
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength, wgLowerY + sleeveWidth / 2.0, sleeveWidth, 0.0));
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength, wgLowerY + sleeveWidth / 2.0, sleeveWidth, 180.0));
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength, wgLowerY + sleeveWidth * 3.0 / 2.0 + waveguideWidth, sleeveWidth, 0.0));
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength, wgLowerY + sleeveWidth * 3.0 / 2.0 + waveguideWidth, sleeveWidth, 180.0));
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, wgLowerY2 + sleeve2 / 2.0, sleeve2, 0.0));
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, wgLowerY2 + sleeve2 / 2.0, sleeve2, 180.0));
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, wgLowerY2 + sleeve2 * 3.0 / 2.0 + width2, sleeve2, 0.0));
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, wgLowerY2 + sleeve2 * 3.0 / 2.0 + width2, sleeve2, 180.0));
            }
        }
    }

    public static void createSymmetricRingDisc(Struct s, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double waveguideHeight, boolean DISC, boolean ENDCAP, int layer) {
        if (DISC) {
            GArea gD = PhotonicsDiscRingPulleys.createDisc(x, y, radius, numberOfSidesDiscRing, layer);
            GArea dSymmetricArr = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth, radius, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth, radius, waveguideAngle, waveguideLength, waveguideHeight, layer), layer);
            if (ENDCAP) {
                dSymmetricArr.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength + (radius + waveguideWidth / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight + (radius + waveguideWidth / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), waveguideWidth, 0.0));
                dSymmetricArr.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength - (radius + waveguideWidth / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight + (radius + waveguideWidth / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), waveguideWidth, 180.0));
            }
            Area aSymmArr = new Area(dSymmetricArr.getArea());
            aSymmArr.transform(AffineTransform.getRotateInstance(Math.PI));
            aSymmArr.transform(AffineTransform.getTranslateInstance(2.0 * x, 2.0 * y + 2.0 * radius + gap + waveguideWidth));
            GArea gaDSymmArr = new GArea(aSymmArr, layer);
            gaDSymmArr.or(gD);
            gaDSymmArr.setDataType(CNSTscriptingController.getDataType());
            s.add(gaDSymmArr);
        } else {
            GArea gR = PhotonicsDiscRingPulleys.createRing(x, y, ringWidth, (radius += ringWidth) - ringWidth, 0.0, 360.0, numberOfSidesDiscRing, layer);
            GArea rSymmetricArray = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth, radius, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth, radius, waveguideAngle, waveguideLength, waveguideHeight, layer), layer);
            if (ENDCAP) {
                rSymmetricArray.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength + (radius + waveguideWidth / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight + (radius + waveguideWidth / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), waveguideWidth, 0.0));
                rSymmetricArray.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength - (radius + waveguideWidth / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight + (radius + waveguideWidth / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), waveguideWidth, 180.0));
            }
            Area rSymmArr = new Area(rSymmetricArray.getArea());
            rSymmArr.transform(AffineTransform.getRotateInstance(Math.PI));
            rSymmArr.transform(AffineTransform.getTranslateInstance(2.0 * x, 2.0 * y + 2.0 * radius + gap + waveguideWidth));
            GArea gaRSymmArr = new GArea(rSymmArr, layer);
            gaRSymmArr.or(gR);
            gaRSymmArr.setDataType(CNSTscriptingController.getDataType());
            s.add(gaRSymmArr);
        }
    }

    public static void createSymRingDiscDSPul(Struct s, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double waveguideHeight, double gap2, double angle2, double width2, double length2, double height2, boolean WAVEGUIDE, boolean DISC, boolean ENDCAP, int layer) {
        length2 /= 2.0;
        if (DISC) {
            double wgLower = y - radius - gap2 - width2;
            GArea gD = PhotonicsDiscRingPulleys.createDisc(x, y, radius, numberOfSidesDiscRing, layer);
            GArea dSymmetricArr = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth, radius, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth, radius, waveguideAngle, waveguideLength, waveguideHeight, layer), layer);
            if (ENDCAP) {
                dSymmetricArr.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength + (radius + waveguideWidth / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight + (radius + waveguideWidth / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), waveguideWidth, 0.0));
                dSymmetricArr.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength - (radius + waveguideWidth / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight + (radius + waveguideWidth / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), waveguideWidth, 180.0));
            }
            Area aSymmArr = new Area(dSymmetricArr.getArea());
            aSymmArr.transform(AffineTransform.getRotateInstance(Math.PI));
            aSymmArr.transform(AffineTransform.getTranslateInstance(2.0 * x, 2.0 * y + 2.0 * radius + gap + waveguideWidth));
            GArea gaDSymmArr = new GArea(aSymmArr, layer);
            if (WAVEGUIDE) {
                GArea wg = new GArea(new Rect(x - length2, wgLower, x + length2, wgLower + width2, layer), layer);
                if (ENDCAP) {
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, wgLower + width2 / 2.0, width2, 0.0));
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, wgLower + width2 / 2.0, width2, 180.0));
                }
                gaDSymmArr.or(wg);
            } else {
                GArea dSymmPUL = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, width2, radius + gap2, angle2 - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, width2, radius + gap2, angle2, length2 *= 2.0, waveguideHeight, layer), layer);
                if (ENDCAP) {
                    dSymmPUL.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2 + (radius + gap2 + width2 / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), y - height2 + (radius + gap2 + width2 / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), width2, 0.0));
                    dSymmPUL.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2 - (radius + gap2 + width2 / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), y - height2 + (radius + gap2 + width2 / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), width2, 180.0));
                }
                Area aSymmArr2 = new Area(dSymmPUL.getArea());
                aSymmArr2.transform(AffineTransform.getRotateInstance(Math.PI));
                aSymmArr2.transform(AffineTransform.getTranslateInstance(2.0 * x, 2.0 * y));
                GArea gaDSymmArr2 = new GArea(aSymmArr2, layer);
                gaDSymmArr.or(gaDSymmArr2);
            }
            gaDSymmArr.or(gD);
            gaDSymmArr.setDataType(CNSTscriptingController.getDataType());
            s.add(gaDSymmArr);
        } else {
            double wgLower = y - (radius += ringWidth) - gap2 - width2;
            GArea gR = PhotonicsDiscRingPulleys.createRing(x, y, ringWidth, radius - ringWidth, 0.0, 360.0, numberOfSidesDiscRing, layer);
            GArea rSymmetricArray = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth, radius, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth, radius, waveguideAngle, waveguideLength, waveguideHeight, layer), layer);
            if (ENDCAP) {
                rSymmetricArray.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength + (radius + waveguideWidth / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight + (radius + waveguideWidth / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), waveguideWidth, 0.0));
                rSymmetricArray.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength - (radius + waveguideWidth / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight + (radius + waveguideWidth / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), waveguideWidth, 180.0));
            }
            Area rSymmArr = new Area(rSymmetricArray.getArea());
            rSymmArr.transform(AffineTransform.getRotateInstance(Math.PI));
            rSymmArr.transform(AffineTransform.getTranslateInstance(2.0 * x, 2.0 * y + 2.0 * radius + gap + waveguideWidth));
            GArea gaRSymmArr = new GArea(rSymmArr, layer);
            if (WAVEGUIDE) {
                GArea wg = new GArea(new Rect(x - length2, wgLower, x + length2, wgLower + width2, layer), layer);
                if (ENDCAP) {
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, wgLower + width2 / 2.0, width2, 0.0));
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, wgLower + width2 / 2.0, width2, 180.0));
                }
                gaRSymmArr.or(wg);
            } else {
                GArea rSymmPUL = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, width2, radius + gap2, angle2 - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, width2, radius + gap2, angle2, length2 *= 2.0, waveguideHeight, layer), layer);
                if (ENDCAP) {
                    rSymmPUL.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2 + (radius + gap2 + width2 / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), y - height2 + (radius + gap2 + width2 / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), width2, 0.0));
                    rSymmPUL.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2 - (radius + gap2 + width2 / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), y - height2 + (radius + gap2 + width2 / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), width2, 180.0));
                }
                Area aSymmArr2 = new Area(rSymmPUL.getArea());
                aSymmArr2.transform(AffineTransform.getRotateInstance(Math.PI));
                aSymmArr2.transform(AffineTransform.getTranslateInstance(2.0 * x, 2.0 * y));
                GArea gaRSymmArr2 = new GArea(aSymmArr2, layer);
                gaRSymmArr.or(gaRSymmArr2);
            }
            gaRSymmArr.or(gR);
            gaRSymmArr.setDataType(CNSTscriptingController.getDataType());
            s.add(gaRSymmArr);
        }
    }

    public static void createSymmetricRingDiscInverse(Struct s, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, boolean DISC, boolean ENDCAP, int layer) {
        if (DISC) {
            s.add(PhotonicsDiscRingPulleys.createDisc(x, y, radius, numberOfSidesDiscRing, layer));
            GArea dSymmetricArrBIG = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth + 2.0 * sleeveWidth, radius, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth + 2.0 * sleeveWidth, radius, waveguideAngle, waveguideLength, waveguideHeight, layer), layer);
            GArea dSymmetricArrSMALL = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth, radius + sleeveWidth, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth, radius + sleeveWidth, waveguideAngle, waveguideLength, waveguideHeight, layer), layer);
            dSymmetricArrBIG.subtract(dSymmetricArrSMALL);
            if (ENDCAP) {
                dSymmetricArrBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight + (waveguideWidth + sleeveWidth) / 2.0 + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 0.0));
                dSymmetricArrBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight - (waveguideWidth + sleeveWidth) / 2.0 + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 0.0));
                dSymmetricArrBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength - (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight + (waveguideWidth + sleeveWidth) / 2.0 + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 180.0));
                dSymmetricArrBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength - (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight - (waveguideWidth + sleeveWidth) / 2.0 + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 180.0));
            }
            Area aSymmArr = new Area(dSymmetricArrBIG.getArea());
            aSymmArr.transform(AffineTransform.getRotateInstance(Math.PI));
            aSymmArr.transform(AffineTransform.getTranslateInstance(2.0 * x, 2.0 * y + 2.0 * radius + gap + waveguideWidth + 2.0 * sleeveWidth));
            GArea gaDSymmArr = new GArea(aSymmArr, layer);
            gaDSymmArr.setDataType(CNSTscriptingController.getDataType());
            s.add(gaDSymmArr);
        } else {
            s.add(PhotonicsDiscRingPulleys.createRing(x, y, ringWidth, (radius += ringWidth) - ringWidth, 0.0, 360.0, numberOfSidesDiscRing, layer));
            GArea rSymmetricArrayBIG = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth + 2.0 * sleeveWidth, radius, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth + 2.0 * sleeveWidth, radius, waveguideAngle, waveguideLength, waveguideHeight, layer), layer);
            GArea rSymmetricArraySMALL = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth, radius + sleeveWidth, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth, radius + sleeveWidth, waveguideAngle, waveguideLength, waveguideHeight, layer), layer);
            rSymmetricArrayBIG.subtract(rSymmetricArraySMALL);
            if (ENDCAP) {
                rSymmetricArrayBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight + (waveguideWidth + sleeveWidth) / 2.0 + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 0.0));
                rSymmetricArrayBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight - (waveguideWidth + sleeveWidth) / 2.0 + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 0.0));
                rSymmetricArrayBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength - (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight + (waveguideWidth + sleeveWidth) / 2.0 + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 180.0));
                rSymmetricArrayBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength - (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight - (waveguideWidth + sleeveWidth) / 2.0 + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 180.0));
            }
            Area rSymmArr = new Area(rSymmetricArrayBIG.getArea());
            rSymmArr.transform(AffineTransform.getRotateInstance(Math.PI));
            rSymmArr.transform(AffineTransform.getTranslateInstance(2.0 * x, 2.0 * y + 2.0 * radius + gap + waveguideWidth + 2.0 * sleeveWidth));
            GArea gaRSymmArr = new GArea(rSymmArr, layer);
            gaRSymmArr.setDataType(CNSTscriptingController.getDataType());
            s.add(gaRSymmArr);
        }
    }

    public static void createSymRingDiscInvDSPul(Struct s, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, double gap2, double angle2, double width2, double sleeve2, double length2, double height2, boolean WAVEGUIDE, boolean DISC, boolean ENDCAP, int layer) {
        if (DISC) {
            s.add(PhotonicsDiscRingPulleys.createDisc(x, y, radius, numberOfSidesDiscRing, layer));
            GArea dSymmetricArrBIG = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth + 2.0 * sleeveWidth, radius, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth + 2.0 * sleeveWidth, radius, waveguideAngle, waveguideLength, waveguideHeight, layer), layer);
            GArea dSymmetricArrSMALL = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth, radius + sleeveWidth, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth, radius + sleeveWidth, waveguideAngle, waveguideLength, waveguideHeight, layer), layer);
            dSymmetricArrBIG.subtract(dSymmetricArrSMALL);
            if (ENDCAP) {
                dSymmetricArrBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight + (waveguideWidth + sleeveWidth) / 2.0 + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 0.0));
                dSymmetricArrBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight - (waveguideWidth + sleeveWidth) / 2.0 + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 0.0));
                dSymmetricArrBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength - (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight + (waveguideWidth + sleeveWidth) / 2.0 + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 180.0));
                dSymmetricArrBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength - (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight - (waveguideWidth + sleeveWidth) / 2.0 + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 180.0));
            }
            if (WAVEGUIDE) {
                double wgLower = y - radius - gap2 - width2 - 2.0 * sleeve2;
                GArea wg = new GArea(new Rect(x - (length2 /= 2.0), wgLower, x + length2, y - radius - gap2, layer), layer);
                GArea gRsmall = new GArea(new Rect(x - length2, wgLower + sleeve2, x + length2, y - radius - gap2 - sleeve2, layer), layer);
                wg.subtract(gRsmall);
                if (ENDCAP) {
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, wgLower + sleeve2 / 2.0, sleeve2, 0.0));
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, wgLower + sleeve2 / 2.0, sleeve2, 180.0));
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, wgLower + width2 + 3.0 * sleeve2 / 2.0, sleeve2, 0.0));
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, wgLower + width2 + 3.0 * sleeve2 / 2.0, sleeve2, 180.0));
                    wg.setRenderReso(CNSTscriptingController.getShapeReso());
                }
                wg.setDataType(CNSTscriptingController.getDataType());
                s.add(wg);
            } else {
                GArea pulBIG = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, width2 + 2.0 * sleeve2, radius += gap2, angle2 - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, width2 + 2.0 * sleeve2, radius, angle2, length2, height2, layer), layer);
                GArea pulSmall = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, width2, radius + sleeve2, angle2 - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, width2, radius + sleeve2, angle2, length2, height2, layer), layer);
                pulBIG.subtract(pulSmall);
                if (ENDCAP) {
                    pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2 + (radius + (width2 + 2.0 * sleeve2) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), y - height2 + (width2 + sleeve2) / 2.0 + (radius + (width2 + 2.0 * sleeve2) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), sleeve2, 0.0));
                    pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2 + (radius + (width2 + 2.0 * sleeve2) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), y - height2 - (width2 + sleeve2) / 2.0 + (radius + (width2 + 2.0 * sleeve2) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), sleeve2, 0.0));
                    pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2 - (radius + (width2 + 2.0 * sleeve2) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), y - height2 + (width2 + sleeve2) / 2.0 + (radius + (width2 + 2.0 * sleeve2) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), sleeve2, 180.0));
                    pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2 - (radius + (width2 + 2.0 * sleeve2) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), y - height2 - (width2 + sleeve2) / 2.0 + (radius + (width2 + 2.0 * sleeve2) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), sleeve2, 180.0));
                }
                Area aSymmArr2 = new Area(pulBIG.getArea());
                aSymmArr2.transform(AffineTransform.getRotateInstance(Math.PI));
                aSymmArr2.transform(AffineTransform.getTranslateInstance(2.0 * x, 2.0 * y));
                GArea gaDSymmArr2 = new GArea(aSymmArr2, layer);
                gaDSymmArr2.setDataType(CNSTscriptingController.getDataType());
                s.add(gaDSymmArr2);
                radius -= gap2;
            }
            Area aSymmArr = new Area(dSymmetricArrBIG.getArea());
            aSymmArr.transform(AffineTransform.getRotateInstance(Math.PI));
            aSymmArr.transform(AffineTransform.getTranslateInstance(2.0 * x, 2.0 * y + 2.0 * radius + gap + waveguideWidth + 2.0 * sleeveWidth));
            GArea gaDSymmArr = new GArea(aSymmArr, layer);
            gaDSymmArr.setDataType(CNSTscriptingController.getDataType());
            s.add(gaDSymmArr);
        } else {
            s.add(PhotonicsDiscRingPulleys.createRing(x, y, ringWidth, (radius += ringWidth) - ringWidth, 0.0, 360.0, numberOfSidesDiscRing, layer));
            GArea rSymmetricArrayBIG = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth + 2.0 * sleeveWidth, radius, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth + 2.0 * sleeveWidth, radius, waveguideAngle, waveguideLength, waveguideHeight, layer), layer);
            GArea rSymmetricArraySMALL = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth, radius + sleeveWidth, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth, radius + sleeveWidth, waveguideAngle, waveguideLength, waveguideHeight, layer), layer);
            rSymmetricArrayBIG.subtract(rSymmetricArraySMALL);
            if (ENDCAP) {
                rSymmetricArrayBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight + (waveguideWidth + sleeveWidth) / 2.0 + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 0.0));
                rSymmetricArrayBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight - (waveguideWidth + sleeveWidth) / 2.0 + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 0.0));
                rSymmetricArrayBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength - (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight + (waveguideWidth + sleeveWidth) / 2.0 + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 180.0));
                rSymmetricArrayBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength - (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight - (waveguideWidth + sleeveWidth) / 2.0 + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 180.0));
            }
            if (WAVEGUIDE) {
                double wgLower = y - radius - gap2 - width2 - 2.0 * sleeve2;
                GArea wg = new GArea(new Rect(x - (length2 /= 2.0), wgLower, x + length2, y - radius - gap2, layer), layer);
                GArea gRsmall = new GArea(new Rect(x - length2, wgLower + sleeve2, x + length2, y - radius - gap2 - sleeve2, layer), layer);
                wg.subtract(gRsmall);
                if (ENDCAP) {
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, wgLower + sleeve2 / 2.0, sleeve2, 0.0));
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, wgLower + sleeve2 / 2.0, sleeve2, 180.0));
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, wgLower + width2 + 3.0 * sleeve2 / 2.0, sleeve2, 0.0));
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, wgLower + width2 + 3.0 * sleeve2 / 2.0, sleeve2, 180.0));
                }
                wg.setDataType(CNSTscriptingController.getDataType());
                s.add(wg);
            } else {
                GArea pulBIG = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, width2 + 2.0 * sleeve2, radius += gap2, angle2 - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, width2 + 2.0 * sleeve2, radius, angle2, length2, height2, layer), layer);
                GArea pulSMALL = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, width2, radius + sleeve2, angle2 - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, width2, radius + sleeve2, angle2, length2, height2, layer), layer);
                pulBIG.subtract(pulSMALL);
                if (ENDCAP) {
                    pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2 + (radius + (width2 + 2.0 * sleeve2) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), y - height2 + (width2 + sleeve2) / 2.0 + (radius + (width2 + 2.0 * sleeve2) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), sleeve2, 0.0));
                    pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2 + (radius + (width2 + 2.0 * sleeve2) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), y - height2 - (width2 + sleeve2) / 2.0 + (radius + (width2 + 2.0 * sleeve2) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), sleeve2, 0.0));
                    pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2 - (radius + (width2 + 2.0 * sleeve2) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), y - height2 + (width2 + sleeve2) / 2.0 + (radius + (width2 + 2.0 * sleeve2) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), sleeve2, 180.0));
                    pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2 - (radius + (width2 + 2.0 * sleeve2) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), y - height2 - (width2 + sleeve2) / 2.0 + (radius + (width2 + 2.0 * sleeve2) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), sleeve2, 180.0));
                }
                Area aSymmArr2 = new Area(pulBIG.getArea());
                aSymmArr2.transform(AffineTransform.getRotateInstance(Math.PI));
                aSymmArr2.transform(AffineTransform.getTranslateInstance(2.0 * x, 2.0 * y));
                GArea gaDSymmArr2 = new GArea(aSymmArr2, layer);
                gaDSymmArr2.setDataType(CNSTscriptingController.getDataType());
                s.add(gaDSymmArr2);
                radius -= gap2;
            }
            Area rSymmArr = new Area(rSymmetricArrayBIG.getArea());
            rSymmArr.transform(AffineTransform.getRotateInstance(Math.PI));
            rSymmArr.transform(AffineTransform.getTranslateInstance(2.0 * x, 2.0 * y + 2.0 * radius + gap + waveguideWidth + 2.0 * sleeveWidth));
            GArea gaRSymmArr = new GArea(rSymmArr, layer);
            gaRSymmArr.setDataType(CNSTscriptingController.getDataType());
            s.add(gaRSymmArr);
        }
    }

    public static void createSymmetricRingDiscInversePos(Struct s, double x, double y, double radius, double ringWidth, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, boolean DISC, boolean ENDCAP, int layer) {
        if (DISC) {
            GArea discInv = PhotonicsDiscRingPulleys.createRing(x, y, ringDiscSleeveWidth, (radius += ringDiscSleeveWidth) - ringDiscSleeveWidth, 0.0, 360.0, numberOfSidesDiscRing, layer);
            GArea dSymmetricArrBIG = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth + 2.0 * sleeveWidth, radius, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth + 2.0 * sleeveWidth, radius, waveguideAngle, waveguideLength, waveguideHeight, layer), layer);
            GArea dSymmetricArrSMALL = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth, radius + sleeveWidth, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth, radius + sleeveWidth, waveguideAngle, waveguideLength, waveguideHeight, layer), layer);
            if (ENDCAP) {
                dSymmetricArrBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight + (waveguideWidth + sleeveWidth) / 2.0 + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 0.0));
                dSymmetricArrBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight - (waveguideWidth + sleeveWidth) / 2.0 + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 0.0));
                dSymmetricArrBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength - (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight + (waveguideWidth + sleeveWidth) / 2.0 + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 180.0));
                dSymmetricArrBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength - (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight - (waveguideWidth + sleeveWidth) / 2.0 + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 180.0));
            }
            Area aSymmArrBIG = new Area(dSymmetricArrBIG.getArea());
            aSymmArrBIG.transform(AffineTransform.getRotateInstance(Math.PI));
            aSymmArrBIG.transform(AffineTransform.getTranslateInstance(2.0 * x, 2.0 * y + 2.0 * radius + sleeveWidth + waveguideWidth - ringDiscSleeveWidth + gap));
            GArea gaDSymmArrBIG = new GArea(aSymmArrBIG, layer);
            Area aSymmArrSMALL = new Area(dSymmetricArrSMALL.getArea());
            aSymmArrSMALL.transform(AffineTransform.getRotateInstance(Math.PI));
            aSymmArrSMALL.transform(AffineTransform.getTranslateInstance(2.0 * x, 2.0 * y + 2.0 * radius + sleeveWidth + waveguideWidth - ringDiscSleeveWidth + gap));
            GArea gaDSymmArrSMALL = new GArea(aSymmArrSMALL, layer);
            GArea innerDisc = PhotonicsDiscRingPulleys.createDisc(x, y, radius - ringDiscSleeveWidth, numberOfSidesDiscRing, layer);
            gaDSymmArrBIG.or(discInv);
            gaDSymmArrBIG.subtract(innerDisc);
            gaDSymmArrBIG.subtract(gaDSymmArrSMALL);
            gaDSymmArrBIG.setDataType(CNSTscriptingController.getDataType());
            s.add(gaDSymmArrBIG);
        } else {
            double totalRingWidth = 2.0 * ringDiscSleeveWidth + ringWidth;
            GArea ringBIG = PhotonicsDiscRingPulleys.createRing(x, y, totalRingWidth, (radius += ringDiscSleeveWidth) - totalRingWidth, 0.0, 360.0, numberOfSidesDiscRing, layer);
            GArea ringSMALL = PhotonicsDiscRingPulleys.createRing(x, y, ringWidth, radius - ringDiscSleeveWidth - ringWidth, 0.0, 360.0, numberOfSidesDiscRing, layer);
            GArea rSymmetricArrayBIG = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth + 2.0 * sleeveWidth, radius, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth + 2.0 * sleeveWidth, radius, waveguideAngle, waveguideLength, waveguideHeight, layer), layer);
            GArea rSymmetricArraySMALL = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth, radius + sleeveWidth, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth, radius + sleeveWidth, waveguideAngle, waveguideLength, waveguideHeight, layer), layer);
            if (ENDCAP) {
                rSymmetricArrayBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight + (waveguideWidth + sleeveWidth) / 2.0 + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 0.0));
                rSymmetricArrayBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight - (waveguideWidth + sleeveWidth) / 2.0 + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 0.0));
                rSymmetricArrayBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength - (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight + (waveguideWidth + sleeveWidth) / 2.0 + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 180.0));
                rSymmetricArrayBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength - (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight - (waveguideWidth + sleeveWidth) / 2.0 + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 180.0));
            }
            Area rSymmArrBIG = new Area(rSymmetricArrayBIG.getArea());
            rSymmArrBIG.transform(AffineTransform.getRotateInstance(Math.PI));
            rSymmArrBIG.transform(AffineTransform.getTranslateInstance(2.0 * x, 2.0 * y + 2.0 * radius + sleeveWidth + waveguideWidth - ringDiscSleeveWidth + gap));
            GArea gaRSymmArrBIG = new GArea(rSymmArrBIG, layer);
            Area rSymmArrSMALL = new Area(rSymmetricArraySMALL.getArea());
            rSymmArrSMALL.transform(AffineTransform.getRotateInstance(Math.PI));
            rSymmArrSMALL.transform(AffineTransform.getTranslateInstance(2.0 * x, 2.0 * y + 2.0 * radius + sleeveWidth + waveguideWidth - ringDiscSleeveWidth + gap));
            GArea gaRSymmArrSMALL = new GArea(rSymmArrSMALL, layer);
            gaRSymmArrBIG.or(ringBIG);
            gaRSymmArrBIG.subtract(ringSMALL);
            gaRSymmArrBIG.subtract(rSymmArrSMALL);
            GArea innerDisc = PhotonicsDiscRingPulleys.createDisc(x, y, radius - 2.0 * ringDiscSleeveWidth - ringWidth, numberOfSidesDiscRing, layer);
            gaRSymmArrBIG.subtract(innerDisc);
            gaRSymmArrBIG.setDataType(CNSTscriptingController.getDataType());
            s.add(gaRSymmArrBIG);
        }
    }

    public static void createSymRingDiscInvPosDSPul(Struct s, double x, double y, double radius, double ringWidth, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, double gap2, double angle2, double width2, double sleeve2, double length2, double height2, boolean WAVEGUIDE, boolean DISC, boolean ENDCAP, int layer) {
        if (DISC) {
            GArea discInv = PhotonicsDiscRingPulleys.createRing(x, y, ringDiscSleeveWidth, (radius += ringDiscSleeveWidth) - ringDiscSleeveWidth, 0.0, 360.0, numberOfSidesDiscRing, layer);
            GArea dSymmetricArrBIG = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth + 2.0 * sleeveWidth, radius, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth + 2.0 * sleeveWidth, radius, waveguideAngle, waveguideLength, waveguideHeight, layer), layer);
            GArea dSymmetricArrSMALL = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth, radius + sleeveWidth, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth, radius + sleeveWidth, waveguideAngle, waveguideLength, waveguideHeight, layer), layer);
            if (ENDCAP) {
                dSymmetricArrBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight + (waveguideWidth + sleeveWidth) / 2.0 + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 0.0));
                dSymmetricArrBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight - (waveguideWidth + sleeveWidth) / 2.0 + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 0.0));
                dSymmetricArrBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength - (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight + (waveguideWidth + sleeveWidth) / 2.0 + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 180.0));
                dSymmetricArrBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength - (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight - (waveguideWidth + sleeveWidth) / 2.0 + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 180.0));
            }
            Area aSymmArrBIG = new Area(dSymmetricArrBIG.getArea());
            aSymmArrBIG.transform(AffineTransform.getRotateInstance(Math.PI));
            aSymmArrBIG.transform(AffineTransform.getTranslateInstance(2.0 * x, 2.0 * y + 2.0 * radius + sleeveWidth + waveguideWidth - ringDiscSleeveWidth + gap));
            GArea gaDSymmArrBIG = new GArea(aSymmArrBIG, layer);
            Area aSymmArrSMALL = new Area(dSymmetricArrSMALL.getArea());
            aSymmArrSMALL.transform(AffineTransform.getRotateInstance(Math.PI));
            aSymmArrSMALL.transform(AffineTransform.getTranslateInstance(2.0 * x, 2.0 * y + 2.0 * radius + sleeveWidth + waveguideWidth - ringDiscSleeveWidth + gap));
            GArea gaDSymmArrSMALL = new GArea(aSymmArrSMALL, layer);
            GArea innerDisc = PhotonicsDiscRingPulleys.createDisc(x, y, radius - ringDiscSleeveWidth, numberOfSidesDiscRing, layer);
            gaDSymmArrBIG.or(discInv);
            if (WAVEGUIDE) {
                double lower = y - (radius - ringDiscSleeveWidth) - gap2 - width2 - sleeve2;
                GArea wg = new GArea(new Rect(x - (length2 /= 2.0), lower, x + length2, lower + 2.0 * sleeve2 + width2, layer), layer);
                GArea gRsmall = new GArea(new Rect(x - length2, lower + sleeve2, x + length2, lower + sleeve2 + width2, layer), layer);
                if (ENDCAP) {
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, lower + sleeve2 / 2.0, sleeve2, 0.0));
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, lower + sleeve2 / 2.0, sleeve2, 180.0));
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, lower + width2 + 3.0 * sleeve2 / 2.0, sleeve2, 0.0));
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, lower + width2 + 3.0 * sleeve2 / 2.0, sleeve2, 180.0));
                    wg.setRenderReso(CNSTscriptingController.getShapeReso());
                }
                gaDSymmArrBIG.or(wg);
                gaDSymmArrBIG.subtract(gRsmall);
            } else {
                GArea pulBIG = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, width2 + 2.0 * sleeve2, radius - ringDiscSleeveWidth + gap2 - sleeve2, angle2 - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, width2 + 2.0 * sleeve2, radius - ringDiscSleeveWidth + gap2 - sleeve2, angle2, length2, height2, layer), layer);
                if (ENDCAP) {
                    double radPul = radius - ringDiscSleeveWidth + gap2 - sleeve2;
                    pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2 + (radPul + (width2 + 2.0 * sleeve2) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), y - height2 + (width2 + sleeve2) / 2.0 + (radPul + (width2 + 2.0 * sleeve2) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), sleeve2, 0.0));
                    pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2 + (radPul + (width2 + 2.0 * sleeve2) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), y - height2 - (width2 + sleeve2) / 2.0 + (radPul + (width2 + 2.0 * sleeve2) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), sleeve2, 0.0));
                    pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2 - (radPul + (width2 + 2.0 * sleeve2) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), y - height2 + (width2 + sleeve2) / 2.0 + (radPul + (width2 + 2.0 * sleeve2) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), sleeve2, 180.0));
                    pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2 - (radPul + (width2 + 2.0 * sleeve2) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), y - height2 - (width2 + sleeve2) / 2.0 + (radPul + (width2 + 2.0 * sleeve2) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), sleeve2, 180.0));
                }
                Area aPulBIG = new Area(pulBIG.getArea());
                aPulBIG.transform(AffineTransform.getRotateInstance(Math.PI));
                aPulBIG.transform(AffineTransform.getTranslateInstance(2.0 * x, 2.0 * y));
                GArea gaPulBIG = new GArea(aPulBIG, layer);
                gaDSymmArrBIG.or(gaPulBIG);
            }
            gaDSymmArrBIG.subtract(innerDisc);
            if (!WAVEGUIDE) {
                GArea pulSMALL = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, width2, radius - ringDiscSleeveWidth + gap2, angle2 - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, width2, radius - ringDiscSleeveWidth + gap2, angle2, length2, height2, layer), layer);
                Area aPulSMALL = new Area(pulSMALL.getArea());
                aPulSMALL.transform(AffineTransform.getRotateInstance(Math.PI));
                aPulSMALL.transform(AffineTransform.getTranslateInstance(2.0 * x, 2.0 * y));
                GArea gaPulSMALL = new GArea(aPulSMALL, layer);
                gaDSymmArrBIG.subtract(gaPulSMALL);
            }
            gaDSymmArrBIG.subtract(gaDSymmArrSMALL);
            gaDSymmArrBIG.setDataType(CNSTscriptingController.getDataType());
            s.add(gaDSymmArrBIG);
        } else {
            double totalRingWidth = 2.0 * ringDiscSleeveWidth + ringWidth;
            GArea ringBIG = PhotonicsDiscRingPulleys.createRing(x, y, totalRingWidth, (radius += ringDiscSleeveWidth) - totalRingWidth, 0.0, 360.0, numberOfSidesDiscRing, layer);
            GArea ringSMALL = PhotonicsDiscRingPulleys.createRing(x, y, ringWidth, radius - ringDiscSleeveWidth - ringWidth, 0.0, 360.0, numberOfSidesDiscRing, layer);
            GArea rSymmetricArrayBIG = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth + 2.0 * sleeveWidth, radius, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth + 2.0 * sleeveWidth, radius, waveguideAngle, waveguideLength, waveguideHeight, layer), layer);
            GArea rSymmetricArraySMALL = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth, radius + sleeveWidth, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth, radius + sleeveWidth, waveguideAngle, waveguideLength, waveguideHeight, layer), layer);
            if (ENDCAP) {
                rSymmetricArrayBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight + (waveguideWidth + sleeveWidth) / 2.0 + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 0.0));
                rSymmetricArrayBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight - (waveguideWidth + sleeveWidth) / 2.0 + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 0.0));
                rSymmetricArrayBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength - (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight + (waveguideWidth + sleeveWidth) / 2.0 + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 180.0));
                rSymmetricArrayBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength - (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight - (waveguideWidth + sleeveWidth) / 2.0 + (radius + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 180.0));
            }
            Area rSymmArrBIG = new Area(rSymmetricArrayBIG.getArea());
            rSymmArrBIG.transform(AffineTransform.getRotateInstance(Math.PI));
            rSymmArrBIG.transform(AffineTransform.getTranslateInstance(2.0 * x, 2.0 * y + 2.0 * radius + sleeveWidth + waveguideWidth - ringDiscSleeveWidth + gap));
            GArea gaRSymmArrBIG = new GArea(rSymmArrBIG, layer);
            Area rSymmArrSMALL = new Area(rSymmetricArraySMALL.getArea());
            rSymmArrSMALL.transform(AffineTransform.getRotateInstance(Math.PI));
            rSymmArrSMALL.transform(AffineTransform.getTranslateInstance(2.0 * x, 2.0 * y + 2.0 * radius + sleeveWidth + waveguideWidth - ringDiscSleeveWidth + gap));
            GArea gaRSymmArrSMALL = new GArea(rSymmArrSMALL, layer);
            gaRSymmArrBIG.or(ringBIG);
            if (WAVEGUIDE) {
                double lower = y - (radius - ringDiscSleeveWidth) - gap2 - width2 - sleeve2;
                GArea wg = new GArea(new Rect(x - (length2 /= 2.0), lower, x + length2, lower + 2.0 * sleeve2 + width2, layer), layer);
                GArea gRsmall = new GArea(new Rect(x - length2, lower + sleeve2, x + length2, lower + sleeve2 + width2, layer), layer);
                if (ENDCAP) {
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, lower + sleeve2 / 2.0, sleeve2, 0.0));
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, lower + sleeve2 / 2.0, sleeve2, 180.0));
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, lower + width2 + 3.0 * sleeve2 / 2.0, sleeve2, 0.0));
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, lower + width2 + 3.0 * sleeve2 / 2.0, sleeve2, 180.0));
                    wg.setRenderReso(CNSTscriptingController.getShapeReso());
                }
                gaRSymmArrBIG.or(wg);
                gaRSymmArrBIG.subtract(gRsmall);
            } else {
                GArea pulBIG = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, width2 + 2.0 * sleeve2, radius - ringDiscSleeveWidth + gap2 - sleeve2, angle2 - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, width2 + 2.0 * sleeve2, radius - ringDiscSleeveWidth + gap2 - sleeve2, angle2, length2, height2, layer), layer);
                if (ENDCAP) {
                    double radPul = radius - ringDiscSleeveWidth + gap2 - sleeve2;
                    pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2 + (radPul + (width2 + 2.0 * sleeve2) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), y - height2 + (width2 + sleeve2) / 2.0 + (radPul + (width2 + 2.0 * sleeve2) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), sleeve2, 0.0));
                    pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2 + (radPul + (width2 + 2.0 * sleeve2) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), y - height2 - (width2 + sleeve2) / 2.0 + (radPul + (width2 + 2.0 * sleeve2) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), sleeve2, 0.0));
                    pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2 - (radPul + (width2 + 2.0 * sleeve2) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), y - height2 + (width2 + sleeve2) / 2.0 + (radPul + (width2 + 2.0 * sleeve2) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), sleeve2, 180.0));
                    pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2 - (radPul + (width2 + 2.0 * sleeve2) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), y - height2 - (width2 + sleeve2) / 2.0 + (radPul + (width2 + 2.0 * sleeve2) / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), sleeve2, 180.0));
                }
                Area aPulBIG = new Area(pulBIG.getArea());
                aPulBIG.transform(AffineTransform.getRotateInstance(Math.PI));
                aPulBIG.transform(AffineTransform.getTranslateInstance(2.0 * x, 2.0 * y));
                GArea gaPulBIG = new GArea(aPulBIG, layer + 44);
                gaRSymmArrBIG.or(gaPulBIG);
            }
            gaRSymmArrBIG.subtract(ringSMALL);
            gaRSymmArrBIG.subtract(rSymmArrSMALL);
            GArea innerDisc = PhotonicsDiscRingPulleys.createDisc(x, y, radius - 2.0 * ringDiscSleeveWidth - ringWidth, numberOfSidesDiscRing, layer);
            if (!WAVEGUIDE) {
                GArea pulSMALL = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, width2, radius - ringDiscSleeveWidth + gap2, angle2 - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, width2, radius - ringDiscSleeveWidth + gap2, angle2, length2, height2, layer), layer);
                Area aPulSMALL = new Area(pulSMALL.getArea());
                aPulSMALL.transform(AffineTransform.getRotateInstance(Math.PI));
                aPulSMALL.transform(AffineTransform.getTranslateInstance(2.0 * x, 2.0 * y));
                GArea gaPulSMALL = new GArea(aPulSMALL, layer + 50);
                gaRSymmArrBIG.subtract(gaPulSMALL);
            }
            gaRSymmArrBIG.subtract(innerDisc);
            gaRSymmArrBIG.setDataType(CNSTscriptingController.getDataType());
            s.add(gaRSymmArrBIG);
        }
    }

    public static void createPulleyRingDisc(Struct s, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double waveguideHeight, boolean DISC, boolean ENDCAP, int layer) {
        double rin = radius + gap;
        if (DISC) {
            s.add(PhotonicsDiscRingPulleys.createDisc(x, y, radius, numberOfSidesDiscRing, layer));
            s.add(PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth, rin, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth, rin, waveguideAngle, waveguideLength, waveguideHeight, layer), layer));
        } else {
            s.add(PhotonicsDiscRingPulleys.createRing(x, y, ringWidth, (radius += ringWidth) - ringWidth, 0.0, 360.0, numberOfSidesDiscRing, layer));
            s.add(PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth, rin += ringWidth, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth, rin, waveguideAngle, waveguideLength, waveguideHeight, layer), layer));
        }
        if (ENDCAP) {
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength + (rin + waveguideWidth / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight + (rin + waveguideWidth / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), waveguideWidth, 0.0));
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength - (rin + waveguideWidth / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight + (rin + waveguideWidth / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), waveguideWidth, 180.0));
        }
    }

    public static void createPulRingDiscDSPul(Struct s, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double waveguideHeight, double gap2, double angle2, double width2, double length2, double heigth2, boolean WAVEGUIDE, boolean DISC, boolean ENDCAP, int layer) {
        double rin = radius + gap;
        if (DISC) {
            s.add(PhotonicsDiscRingPulleys.createDisc(x, y, radius, numberOfSidesDiscRing, layer));
            s.add(PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth, rin, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth, rin, waveguideAngle, waveguideLength, waveguideHeight, layer), layer));
            if (WAVEGUIDE) {
                double wgLower = y - radius - gap2 - width2;
                GArea wg = new GArea(new Rect(x - (length2 /= 2.0), wgLower, x + length2, wgLower + width2, layer), layer);
                if (ENDCAP) {
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, wgLower + width2 / 2.0, width2, 0.0));
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, wgLower + width2 / 2.0, width2, 180.0));
                }
                wg.setDataType(CNSTscriptingController.getDataType());
                s.add(wg);
            } else {
                GArea pulBOT = new GArea(PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, width2, rin, angle2 - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, width2, rin, angle2, length2, heigth2, layer), layer));
                if (ENDCAP) {
                    pulBOT.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2 + (rin + width2 / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), y - heigth2 + (rin + width2 / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), width2, 0.0));
                    pulBOT.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2 - (rin + width2 / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), y - heigth2 + (rin + width2 / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), width2, 180.0));
                }
                pulBOT.transform(AffineTransform.getRotateInstance(Math.PI, x, y));
                pulBOT.setDataType(CNSTscriptingController.getDataType());
                s.add(pulBOT);
            }
        } else {
            s.add(PhotonicsDiscRingPulleys.createRing(x, y, ringWidth, (radius += ringWidth) - ringWidth, 0.0, 360.0, numberOfSidesDiscRing, layer));
            s.add(PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth, rin += ringWidth, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth, rin, waveguideAngle, waveguideLength, waveguideHeight, layer), layer));
            if (WAVEGUIDE) {
                double wgLower = y - radius - gap2 - width2;
                GArea wg = new GArea(new Rect(x - (length2 /= 2.0), wgLower, x + length2, wgLower + width2, layer), layer);
                if (ENDCAP) {
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, wgLower + width2 / 2.0, width2, 0.0));
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, wgLower + width2 / 2.0, width2, 180.0));
                }
                wg.setDataType(CNSTscriptingController.getDataType());
                s.add(wg);
            } else {
                GArea pulBOT = new GArea(PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, width2, rin, angle2 - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, width2, rin, angle2, length2, heigth2, layer), layer));
                if (ENDCAP) {
                    pulBOT.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2 + (rin + width2 / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), y - heigth2 + (rin + width2 / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), width2, 0.0));
                    pulBOT.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2 - (rin + width2 / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), y - heigth2 + (rin + width2 / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), width2, 180.0));
                }
                pulBOT.transform(AffineTransform.getRotateInstance(Math.PI, x, y));
                pulBOT.setDataType(CNSTscriptingController.getDataType());
                s.add(pulBOT);
            }
        }
        if (ENDCAP) {
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength + (rin + waveguideWidth / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight + (rin + waveguideWidth / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), waveguideWidth, 0.0));
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength - (rin + waveguideWidth / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight + (rin + waveguideWidth / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), waveguideWidth, 180.0));
        }
    }

    public static void createPulleyRingDiscInverse(Struct s, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, boolean DISC, boolean ENDCAP, int layer) {
        double rin = radius + gap;
        if (DISC) {
            s.add(PhotonicsDiscRingPulleys.createDisc(x, y, radius, numberOfSidesDiscRing, layer));
            GArea dPulleyBIG = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth + 2.0 * sleeveWidth, rin, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth + 2.0 * sleeveWidth, rin, waveguideAngle, waveguideLength, waveguideHeight, layer), layer);
            GArea dPulleySMALL = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth, rin + sleeveWidth, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth, rin + sleeveWidth, waveguideAngle, waveguideLength, waveguideHeight, layer), layer);
            dPulleyBIG.subtract(dPulleySMALL);
            dPulleyBIG.setDataType(CNSTscriptingController.getDataType());
            s.add(dPulleyBIG);
        } else {
            s.add(PhotonicsDiscRingPulleys.createRing(x, y, ringWidth, (radius += ringWidth) - ringWidth, 0.0, 360.0, numberOfSidesDiscRing, layer));
            GArea rPulleyBIG = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth + 2.0 * sleeveWidth, rin += ringWidth, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth + 2.0 * sleeveWidth, rin, waveguideAngle, waveguideLength, waveguideHeight, layer), layer);
            GArea rPulleySMALL = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth, rin + sleeveWidth, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth, rin + sleeveWidth, waveguideAngle, waveguideLength, waveguideHeight, layer), layer);
            rPulleyBIG.subtract(rPulleySMALL);
            rPulleyBIG.setDataType(CNSTscriptingController.getDataType());
            s.add(rPulleyBIG);
        }
        if (ENDCAP) {
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength + (rin + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight + (sleeveWidth + waveguideWidth) / 2.0 + (rin + sleeveWidth + waveguideWidth / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 0.0));
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength - (rin + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight + (sleeveWidth + waveguideWidth) / 2.0 + (rin + sleeveWidth + waveguideWidth / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 180.0));
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength + (rin + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight - (sleeveWidth + waveguideWidth) / 2.0 + (rin + sleeveWidth + waveguideWidth / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 0.0));
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength - (rin + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight - (sleeveWidth + waveguideWidth) / 2.0 + (rin + sleeveWidth + waveguideWidth / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 180.0));
        }
    }

    public static void createPulRDInvDSPul(Struct s, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, double gap2, double angle2, double width2, double sleeve2, double length2, double height2, boolean WAVEGUIDE, boolean DISC, boolean ENDCAP, int layer) {
        double rin = radius + gap;
        if (DISC) {
            s.add(PhotonicsDiscRingPulleys.createDisc(x, y, radius, numberOfSidesDiscRing, layer));
            GArea dPulleyBIG = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth + 2.0 * sleeveWidth, rin, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth + 2.0 * sleeveWidth, rin, waveguideAngle, waveguideLength, waveguideHeight, layer), layer);
            GArea dPulleySMALL = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth, rin + sleeveWidth, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth, rin + sleeveWidth, waveguideAngle, waveguideLength, waveguideHeight, layer), layer);
            dPulleyBIG.subtract(dPulleySMALL);
            dPulleyBIG.setDataType(CNSTscriptingController.getDataType());
            s.add(dPulleyBIG);
        } else {
            s.add(PhotonicsDiscRingPulleys.createRing(x, y, ringWidth, (radius += ringWidth) - ringWidth, 0.0, 360.0, numberOfSidesDiscRing, layer));
            GArea rPulleyBIG = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth + 2.0 * sleeveWidth, rin += ringWidth, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth + 2.0 * sleeveWidth, rin, waveguideAngle, waveguideLength, waveguideHeight, layer), layer);
            GArea rPulleySMALL = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth, rin + sleeveWidth, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth, rin + sleeveWidth, waveguideAngle, waveguideLength, waveguideHeight, layer), layer);
            rPulleyBIG.subtract(rPulleySMALL);
            rPulleyBIG.setDataType(CNSTscriptingController.getDataType());
            s.add(rPulleyBIG);
        }
        if (ENDCAP) {
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength + (rin + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight + (sleeveWidth + waveguideWidth) / 2.0 + (rin + sleeveWidth + waveguideWidth / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 0.0));
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength - (rin + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight + (sleeveWidth + waveguideWidth) / 2.0 + (rin + sleeveWidth + waveguideWidth / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 180.0));
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength + (rin + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight - (sleeveWidth + waveguideWidth) / 2.0 + (rin + sleeveWidth + waveguideWidth / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 0.0));
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength - (rin + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight - (sleeveWidth + waveguideWidth) / 2.0 + (rin + sleeveWidth + waveguideWidth / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 180.0));
        }
        if (WAVEGUIDE) {
            double wgLower = y - radius - gap2 - width2 - 2.0 * sleeve2;
            GArea wg = new GArea(new Rect(x - (length2 /= 2.0), wgLower, x + length2, y - radius - gap2, layer), layer);
            GArea gRsmall = new GArea(new Rect(x - length2, wgLower + sleeve2, x + length2, y - radius - gap2 - sleeve2, layer), layer);
            wg.subtract(gRsmall);
            if (ENDCAP) {
                wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, wgLower + sleeve2 / 2.0, sleeve2, 0.0));
                wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, wgLower + sleeve2 / 2.0, sleeve2, 180.0));
                wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, wgLower + width2 + 3.0 * sleeve2 / 2.0, sleeve2, 0.0));
                wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, wgLower + width2 + 3.0 * sleeve2 / 2.0, sleeve2, 180.0));
                wg.setRenderReso(CNSTscriptingController.getShapeReso());
            }
            wg.setDataType(CNSTscriptingController.getDataType());
            s.add(wg);
            length2 *= 2.0;
        } else {
            rin = rin - gap + gap2;
            GArea pulBIG = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, width2 + 2.0 * sleeve2, rin, angle2 - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, width2 + 2.0 * sleeve2, rin, angle2, length2, height2, layer), layer);
            GArea pulSMALL = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, width2, rin + sleeve2, angle2 - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, width2, rin + sleeve2, angle2, length2, height2, layer), layer);
            pulBIG.subtract(pulSMALL);
            if (ENDCAP) {
                pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2 + (rin + (width2 + 2.0 * sleeve2) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), y - height2 + (sleeve2 + width2) / 2.0 + (rin + sleeve2 + width2 / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), sleeve2, 0.0));
                pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2 - (rin + (width2 + 2.0 * sleeve2) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), y - height2 + (sleeve2 + width2) / 2.0 + (rin + sleeve2 + width2 / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), sleeve2, 180.0));
                pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2 + (rin + (width2 + 2.0 * sleeve2) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), y - height2 - (sleeve2 + width2) / 2.0 + (rin + sleeve2 + width2 / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), sleeve2, 0.0));
                pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2 - (rin + (width2 + 2.0 * sleeve2) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), y - height2 - (sleeve2 + width2) / 2.0 + (rin + sleeve2 + width2 / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), sleeve2, 180.0));
            }
            pulBIG.transform(AffineTransform.getRotateInstance(Math.PI, x, y));
            pulBIG.setDataType(CNSTscriptingController.getDataType());
            s.add(pulBIG);
        }
    }

    public static void createPulleyRingDiscInversePos(Struct s, double x, double y, double radius, double ringWidth, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, boolean DISC, boolean ENDCAP, int layer) {
        double rin = radius - ringDiscSleeveWidth - sleeveWidth + gap;
        if (DISC) {
            GArea discInv = PhotonicsDiscRingPulleys.createRing(x, y, ringDiscSleeveWidth, (radius += ringDiscSleeveWidth) - ringDiscSleeveWidth, 0.0, 360.0, numberOfSidesDiscRing, layer);
            GArea dPulleyBIG = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth + 2.0 * sleeveWidth, rin += ringDiscSleeveWidth, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth + 2.0 * sleeveWidth, rin, waveguideAngle, waveguideLength, waveguideHeight, layer), layer);
            GArea dPulleySMALL = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth, rin + sleeveWidth, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth, rin + sleeveWidth, waveguideAngle, waveguideLength, waveguideHeight, layer), layer);
            GArea innerDisc = PhotonicsDiscRingPulleys.createDisc(x, y, radius - ringDiscSleeveWidth, numberOfSidesDiscRing, layer);
            dPulleyBIG.or(discInv);
            dPulleyBIG.subtract(dPulleySMALL);
            dPulleyBIG.subtract(innerDisc);
            dPulleyBIG.setDataType(CNSTscriptingController.getDataType());
            s.add(dPulleyBIG);
        } else {
            double totalRingWidth = 2.0 * ringDiscSleeveWidth + ringWidth;
            GArea ringBIG = PhotonicsDiscRingPulleys.createRing(x, y, totalRingWidth, (radius += ringDiscSleeveWidth) - totalRingWidth, 0.0, 360.0, numberOfSidesDiscRing, layer);
            GArea ringSMALL = PhotonicsDiscRingPulleys.createRing(x, y, ringWidth, radius - ringDiscSleeveWidth - ringWidth, 0.0, 360.0, numberOfSidesDiscRing, layer);
            GArea rPulleyBIG = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth + 2.0 * sleeveWidth, rin += ringDiscSleeveWidth, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth + 2.0 * sleeveWidth, rin, waveguideAngle, waveguideLength, waveguideHeight, layer), layer);
            GArea rPulleySMALL = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth, rin + sleeveWidth, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth, rin + sleeveWidth, waveguideAngle, waveguideLength, waveguideHeight, layer), layer);
            GArea innerDisc = PhotonicsDiscRingPulleys.createDisc(x, y, radius - 2.0 * ringDiscSleeveWidth - ringWidth, numberOfSidesDiscRing, layer);
            rPulleyBIG.or(ringBIG);
            rPulleyBIG.subtract(ringSMALL);
            rPulleyBIG.subtract(rPulleySMALL);
            rPulleyBIG.subtract(innerDisc);
            rPulleyBIG.setDataType(CNSTscriptingController.getDataType());
            s.add(rPulleyBIG);
        }
        if (ENDCAP) {
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength + (rin + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight + (sleeveWidth + waveguideWidth) / 2.0 + (rin + sleeveWidth + waveguideWidth / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 0.0));
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength - (rin + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight + (sleeveWidth + waveguideWidth) / 2.0 + (rin + sleeveWidth + waveguideWidth / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 180.0));
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength + (rin + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight - (sleeveWidth + waveguideWidth) / 2.0 + (rin + sleeveWidth + waveguideWidth / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 0.0));
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength - (rin + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight - (sleeveWidth + waveguideWidth) / 2.0 + (rin + sleeveWidth + waveguideWidth / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 180.0));
        }
    }

    public static void createPulRDInvPosDSPul(Struct s, double x, double y, double radius, double ringWidth, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double waveguideHeight, double gap2, double angle2, double width2, double sleeve2, double length2, double height2, boolean WAVEGUIDE, boolean DISC, boolean ENDCAP, int layer) {
        double rin = radius - ringDiscSleeveWidth - sleeveWidth + gap;
        if (DISC) {
            GArea discInv = PhotonicsDiscRingPulleys.createRing(x, y, ringDiscSleeveWidth, (radius += ringDiscSleeveWidth) - ringDiscSleeveWidth, 0.0, 360.0, numberOfSidesDiscRing, layer);
            GArea dPulleyBIG = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth + 2.0 * sleeveWidth, rin += ringDiscSleeveWidth, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth + 2.0 * sleeveWidth, rin, waveguideAngle, waveguideLength, waveguideHeight, layer), layer);
            GArea dPulleySMALL = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth, rin + sleeveWidth, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth, rin + sleeveWidth, waveguideAngle, waveguideLength, waveguideHeight, layer), layer);
            GArea innerDisc = PhotonicsDiscRingPulleys.createDisc(x, y, radius - ringDiscSleeveWidth, numberOfSidesDiscRing, layer);
            dPulleyBIG.or(discInv);
            if (WAVEGUIDE) {
                double wgLower = y - (radius - ringDiscSleeveWidth) - gap2 - width2 - sleeve2;
                GArea wg = new GArea(new Rect(x - (length2 /= 2.0), wgLower, x + length2, wgLower + width2 + 2.0 * sleeve2, layer), layer);
                GArea gRsmall = new GArea(new Rect(x - length2, wgLower + sleeve2, x + length2, wgLower + sleeve2 + width2, layer), layer);
                if (ENDCAP) {
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, wgLower + sleeve2 / 2.0, sleeve2, 0.0));
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, wgLower + sleeve2 / 2.0, sleeve2, 180.0));
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, wgLower + width2 + 3.0 * sleeve2 / 2.0, sleeve2, 0.0));
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, wgLower + width2 + 3.0 * sleeve2 / 2.0, sleeve2, 180.0));
                    wg.setRenderReso(CNSTscriptingController.getShapeReso());
                }
                dPulleyBIG.or(wg);
                dPulleyBIG.subtract(gRsmall);
                length2 *= 2.0;
            } else {
                double rin2 = radius - ringDiscSleeveWidth - sleeve2 + gap2;
                GArea pulBIG = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, width2 + 2.0 * sleeve2, rin2, angle2 - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, width2 + 2.0 * sleeve2, rin2, angle2, length2, height2, layer), layer);
                GArea pulSMALL = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, width2, rin2 + sleeve2, angle2 - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, width2, rin2 + sleeve2, angle2, length2, height2, layer), layer);
                if (ENDCAP) {
                    pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2 + (rin2 + (width2 + 2.0 * sleeve2) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), y - height2 + (sleeve2 + width2) / 2.0 + (rin2 + sleeve2 + width2 / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), sleeve2, 0.0));
                    pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2 - (rin2 + (width2 + 2.0 * sleeve2) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), y - height2 + (sleeve2 + width2) / 2.0 + (rin2 + sleeve2 + width2 / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), sleeve2, 180.0));
                    pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2 + (rin2 + (width2 + 2.0 * sleeve2) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), y - height2 - (sleeve2 + width2) / 2.0 + (rin2 + sleeve2 + width2 / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), sleeve2, 0.0));
                    pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2 - (rin2 + (width2 + 2.0 * sleeve2) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), y - height2 - (sleeve2 + width2) / 2.0 + (rin2 + sleeve2 + width2 / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), sleeve2, 180.0));
                }
                pulBIG.transform(AffineTransform.getRotateInstance(Math.PI, x, y));
                pulSMALL.transform(AffineTransform.getRotateInstance(Math.PI, x, y));
                dPulleyBIG.or(pulBIG);
                dPulleyBIG.subtract(pulSMALL);
            }
            dPulleyBIG.subtract(dPulleySMALL);
            dPulleyBIG.subtract(innerDisc);
            dPulleyBIG.setDataType(CNSTscriptingController.getDataType());
            s.add(dPulleyBIG);
        } else {
            double totalRingWidth = 2.0 * ringDiscSleeveWidth + ringWidth;
            GArea ringBIG = PhotonicsDiscRingPulleys.createRing(x, y, totalRingWidth, (radius += ringDiscSleeveWidth) - totalRingWidth, 0.0, 360.0, numberOfSidesDiscRing, layer);
            GArea ringSMALL = PhotonicsDiscRingPulleys.createRing(x, y, ringWidth, radius - ringDiscSleeveWidth - ringWidth, 0.0, 360.0, numberOfSidesDiscRing, layer);
            GArea rPulleyBIG = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth + 2.0 * sleeveWidth, rin += ringDiscSleeveWidth, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth + 2.0 * sleeveWidth, rin, waveguideAngle, waveguideLength, waveguideHeight, layer), layer);
            GArea rPulleySMALL = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, waveguideWidth, rin + sleeveWidth, waveguideAngle - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, waveguideWidth, rin + sleeveWidth, waveguideAngle, waveguideLength, waveguideHeight, layer), layer);
            GArea innerDisc = PhotonicsDiscRingPulleys.createDisc(x, y, radius - 2.0 * ringDiscSleeveWidth - ringWidth, numberOfSidesDiscRing, layer);
            rPulleyBIG.or(ringBIG);
            if (WAVEGUIDE) {
                double wgLower = y - (radius - ringDiscSleeveWidth) - gap2 - width2 - sleeve2;
                GArea wg = new GArea(new Rect(x - (length2 /= 2.0), wgLower, x + length2, wgLower + width2 + 2.0 * sleeve2, layer), layer);
                GArea gRsmall = new GArea(new Rect(x - length2, wgLower + sleeve2, x + length2, wgLower + sleeve2 + width2, layer), layer);
                if (ENDCAP) {
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, wgLower + sleeve2 / 2.0, sleeve2, 0.0));
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, wgLower + sleeve2 / 2.0, sleeve2, 180.0));
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, wgLower + width2 + 3.0 * sleeve2 / 2.0, sleeve2, 0.0));
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, wgLower + width2 + 3.0 * sleeve2 / 2.0, sleeve2, 180.0));
                    wg.setRenderReso(CNSTscriptingController.getShapeReso());
                }
                rPulleyBIG.or(wg);
                rPulleyBIG.subtract(gRsmall);
                length2 *= 2.0;
            } else {
                double rin2 = radius - ringDiscSleeveWidth - sleeve2 + gap2;
                GArea pulBIG = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, width2 + 2.0 * sleeve2, rin2, angle2 - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, width2 + 2.0 * sleeve2, rin2, angle2, length2, height2, layer), layer);
                GArea pulSMALL = PhotonicsDiscRingPulleys.combineGarea(PhotonicsDiscRingPulleys.createSymmetricTorus(x, y, width2, rin2 + sleeve2, angle2 - 0.1, numberOfSidesCouplingRegion, layer), PhotonicsDiscRingPulleys.createBezier(x, y, width2, rin2 + sleeve2, angle2, length2, height2, layer), layer);
                if (ENDCAP) {
                    pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2 + (rin2 + (width2 + 2.0 * sleeve2) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), y - height2 + (sleeve2 + width2) / 2.0 + (rin2 + sleeve2 + width2 / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), sleeve2, 0.0));
                    pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2 - (rin2 + (width2 + 2.0 * sleeve2) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), y - height2 + (sleeve2 + width2) / 2.0 + (rin2 + sleeve2 + width2 / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), sleeve2, 180.0));
                    pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2 + (rin2 + (width2 + 2.0 * sleeve2) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), y - height2 - (sleeve2 + width2) / 2.0 + (rin2 + sleeve2 + width2 / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), sleeve2, 0.0));
                    pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2 - (rin2 + (width2 + 2.0 * sleeve2) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), y - height2 - (sleeve2 + width2) / 2.0 + (rin2 + sleeve2 + width2 / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(angle2)), sleeve2, 180.0));
                }
                pulBIG.transform(AffineTransform.getRotateInstance(Math.PI, x, y));
                pulSMALL.transform(AffineTransform.getRotateInstance(Math.PI, x, y));
                rPulleyBIG.or(pulBIG);
                rPulleyBIG.subtract(pulSMALL);
            }
            rPulleyBIG.subtract(ringSMALL);
            rPulleyBIG.subtract(rPulleySMALL);
            rPulleyBIG.subtract(innerDisc);
            rPulleyBIG.setDataType(CNSTscriptingController.getDataType());
            s.add(rPulleyBIG);
        }
        if (ENDCAP) {
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength + (rin + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight + (sleeveWidth + waveguideWidth) / 2.0 + (rin + sleeveWidth + waveguideWidth / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 0.0));
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength - (rin + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight + (sleeveWidth + waveguideWidth) / 2.0 + (rin + sleeveWidth + waveguideWidth / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 180.0));
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + waveguideLength + (rin + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight - (sleeveWidth + waveguideWidth) / 2.0 + (rin + sleeveWidth + waveguideWidth / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 0.0));
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - waveguideLength - (rin + (waveguideWidth + 2.0 * sleeveWidth) / 2.0) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), y - waveguideHeight - (sleeveWidth + waveguideWidth) / 2.0 + (rin + sleeveWidth + waveguideWidth / 2.0) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle)), sleeveWidth, 180.0));
        }
    }

    public static void createRDPulleyA(Struct s, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, boolean DISC, boolean ENDCAP, int layer) {
        double rin = radius + gap;
        if (DISC) {
            s.add(PhotonicsDiscRingPulleys.createDisc(x, y, radius, numberOfSidesDiscRing, layer));
        } else {
            s.add(PhotonicsDiscRingPulleys.createRing(x, y, ringWidth, radius, 0.0, 360.0, numberOfSidesDiscRing, layer));
            rin += ringWidth;
        }
        s.add(PhotonicsDiscRingPulleys.createPulleyA(x, y, rin, rin + waveguideWidth, waveguideAngle, 90.0, waveguideLength, numberOfSidesCouplingRegion, layer));
        if (ENDCAP) {
            Point2D.Double pEC = PhotonicsDiscRingPulleys.calculateArcEndCapPosition(rin, rin + waveguideWidth, waveguideAngle, waveguideWidth, waveguideLength);
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + pEC.x, y + pEC.y, waveguideWidth, 0.0));
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - pEC.x, y + pEC.y, waveguideWidth, 180.0));
        }
    }

    public static void createRDPulADSPul(Struct s, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double gap2, double angle2, double width2, double length2, boolean WAVEGUIDE, boolean DISC, boolean ENDCAP, int layer) {
        double rin = radius + gap;
        if (DISC) {
            s.add(PhotonicsDiscRingPulleys.createDisc(x, y, radius, numberOfSidesDiscRing, layer));
        } else {
            s.add(PhotonicsDiscRingPulleys.createRing(x, y, ringWidth, radius, 0.0, 360.0, numberOfSidesDiscRing, layer));
            rin += ringWidth;
        }
        s.add(PhotonicsDiscRingPulleys.createPulleyA(x, y, rin, rin + waveguideWidth, waveguideAngle, 90.0, waveguideLength, numberOfSidesCouplingRegion, layer));
        if (WAVEGUIDE) {
            double wgLower = y - rin + gap - gap2 - width2;
            GArea wg = new GArea(new Rect(x - (length2 /= 2.0), wgLower, x + length2, wgLower + width2, layer), layer);
            if (ENDCAP) {
                wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, wgLower + width2 / 2.0, width2, 0.0));
                wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, wgLower + width2 / 2.0, width2, 180.0));
            }
            wg.setDataType(CNSTscriptingController.getDataType());
            s.add(wg);
        } else {
            double rin2 = DISC ? radius + gap2 : radius + gap2 + ringWidth;
            GArea pul = PhotonicsDiscRingPulleys.createPulleyA(x, y, rin2, rin2 + width2, angle2, 90.0, length2, numberOfSidesCouplingRegion, layer);
            if (ENDCAP) {
                Point2D.Double pEC = PhotonicsDiscRingPulleys.calculateArcEndCapPosition(rin2, rin2 + width2, angle2, width2, length2);
                pul.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + pEC.x, y + pEC.y, width2, 0.0));
                pul.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - pEC.x, y + pEC.y, width2, 180.0));
            }
            pul.transform(AffineTransform.getRotateInstance(Math.PI, x, y));
            pul.setDataType(CNSTscriptingController.getDataType());
            s.add(pul);
        }
        if (ENDCAP) {
            Point2D.Double pEC = PhotonicsDiscRingPulleys.calculateArcEndCapPosition(rin, rin + waveguideWidth, waveguideAngle, waveguideWidth, waveguideLength);
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + pEC.x, y + pEC.y, waveguideWidth, 0.0));
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - pEC.x, y + pEC.y, waveguideWidth, 180.0));
        }
    }

    public static void createRDSymmetricA(Struct s, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, boolean DISC, boolean ENDCAP, int layer) {
        double rin = radius + gap;
        if (DISC) {
            s.add(PhotonicsDiscRingPulleys.createDisc(x, y, radius, numberOfSidesDiscRing, layer));
        } else {
            s.add(PhotonicsDiscRingPulleys.createRing(x, y, ringWidth, radius, 0.0, 360.0, numberOfSidesDiscRing, layer));
            rin += ringWidth;
        }
        s.add(PhotonicsDiscRingPulleys.createSymmetricA(x, y, rin, rin + waveguideWidth, waveguideAngle, 90.0, waveguideLength, numberOfSidesCouplingRegion, layer));
        if (ENDCAP) {
            Point2D.Double pEC = PhotonicsDiscRingPulleys.calculateArcEndCapPosition(rin, rin + waveguideWidth, waveguideAngle, waveguideWidth, waveguideLength);
            GArea s0 = PhotonicsDiscRingPulleys.createLeftEndCap(pEC.x, pEC.y, waveguideWidth, 0.0);
            GArea s1 = PhotonicsDiscRingPulleys.createLeftEndCap(-pEC.x, pEC.y, waveguideWidth, 180.0);
            s0.or(s1);
            s0.transform(AffineTransform.getRotateInstance(Math.PI));
            s0.transform(AffineTransform.getTranslateInstance(x, y + 2.0 * rin + waveguideWidth));
            s0.setDataType(CNSTscriptingController.getDataType());
            s.add(s0);
        }
    }

    public static void createRDSymADSPul(Struct s, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double waveguideLength, double gap2, double angle2, double width2, double length2, boolean WAVEGUIDE, boolean DISC, boolean ENDCAP, int layer) {
        GArea s1;
        GArea s0;
        Point2D.Double pEC;
        double rin = radius + gap;
        if (DISC) {
            s.add(PhotonicsDiscRingPulleys.createDisc(x, y, radius, numberOfSidesDiscRing, layer));
        } else {
            s.add(PhotonicsDiscRingPulleys.createRing(x, y, ringWidth, radius, 0.0, 360.0, numberOfSidesDiscRing, layer));
            rin += ringWidth;
        }
        s.add(PhotonicsDiscRingPulleys.createSymmetricA(x, y, rin, rin + waveguideWidth, waveguideAngle, 90.0, waveguideLength, numberOfSidesCouplingRegion, layer));
        if (ENDCAP) {
            pEC = PhotonicsDiscRingPulleys.calculateArcEndCapPosition(rin, rin + waveguideWidth, waveguideAngle, waveguideWidth, waveguideLength);
            s0 = PhotonicsDiscRingPulleys.createLeftEndCap(pEC.x, pEC.y, waveguideWidth, 0.0);
            s1 = PhotonicsDiscRingPulleys.createLeftEndCap(-pEC.x, pEC.y, waveguideWidth, 180.0);
            s0.or(s1);
            s0.transform(AffineTransform.getRotateInstance(Math.PI));
            s0.transform(AffineTransform.getTranslateInstance(x, y + 2.0 * rin + waveguideWidth));
            s0.setDataType(CNSTscriptingController.getDataType());
            s.add(s0);
        }
        if (WAVEGUIDE) {
            rin = rin - gap + gap2;
            GArea v = new GArea(new Rect(x - (length2 /= 2.0), y - rin - width2, x + length2, y - rin, layer), layer);
            v.setDataType(CNSTscriptingController.getDataType());
            s.add(v);
            if (ENDCAP) {
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, y - rin - width2 + width2 / 2.0, width2, 0.0));
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, y - rin - width2 + width2 / 2.0, width2, 180.0));
            }
        } else {
            rin = rin - gap + gap2;
            s.add(PhotonicsDiscRingPulleys.createSymmetricA(x, y - 2.0 * rin - width2, rin, rin + width2, angle2, 90.0, length2, numberOfSidesCouplingRegion, layer));
            if (ENDCAP) {
                pEC = PhotonicsDiscRingPulleys.calculateArcEndCapPosition(rin, rin + width2, angle2, width2, length2);
                s0 = PhotonicsDiscRingPulleys.createLeftEndCap(pEC.x, pEC.y, width2, 0.0);
                s1 = PhotonicsDiscRingPulleys.createLeftEndCap(-pEC.x, pEC.y, width2, 180.0);
                s0.or(s1);
                s0.transform(AffineTransform.getRotateInstance(Math.PI));
                s0.transform(AffineTransform.getTranslateInstance(x, y));
                s0.setDataType(CNSTscriptingController.getDataType());
                s.add(s0);
            }
        }
    }

    public static void createRDPulleyInvA(Struct s, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, boolean DISC, boolean ENDCAP, int layer) {
        double rin = radius + gap;
        if (DISC) {
            s.add(PhotonicsDiscRingPulleys.createDisc(x, y, radius, numberOfSidesDiscRing, layer));
        } else {
            s.add(PhotonicsDiscRingPulleys.createRing(x, y, ringWidth, radius, 0.0, 360.0, numberOfSidesDiscRing, layer));
            rin += ringWidth;
        }
        GArea bigD = PhotonicsDiscRingPulleys.createPulleyA(x, y, rin, rin + 2.0 * sleeveWidth + waveguideWidth, waveguideAngle, 90.0, waveguideLength, numberOfSidesCouplingRegion, layer);
        GArea smallD = PhotonicsDiscRingPulleys.createPulleyA(x, y, rin + sleeveWidth, rin + sleeveWidth + waveguideWidth, waveguideAngle, 90.0, waveguideLength, numberOfSidesCouplingRegion, layer);
        bigD.subtract(smallD);
        bigD.setDataType(CNSTscriptingController.getDataType());
        s.add(bigD);
        if (ENDCAP) {
            Point2D.Double pEC = PhotonicsDiscRingPulleys.calculateArcEndCapPosition(rin, rin + 2.0 * sleeveWidth + waveguideWidth, waveguideAngle, waveguideWidth, waveguideLength);
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + pEC.x, y + pEC.y + (sleeveWidth - waveguideWidth) / 2.0, sleeveWidth, 0.0));
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - pEC.x, y + pEC.y + (sleeveWidth - waveguideWidth) / 2.0, sleeveWidth, 180.0));
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + pEC.x, y + pEC.y + (3.0 * sleeveWidth + waveguideWidth) / 2.0, sleeveWidth, 0.0));
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - pEC.x, y + pEC.y + (3.0 * sleeveWidth + waveguideWidth) / 2.0, sleeveWidth, 180.0));
        }
    }

    public static void createRDPulInvADSPul(Struct s, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double gap2, double angle2, double width2, double sleeve2, double length2, boolean WAVEGUIDE, boolean DISC, boolean ENDCAP, int layer) {
        double rin = radius + gap;
        if (DISC) {
            s.add(PhotonicsDiscRingPulleys.createDisc(x, y, radius, numberOfSidesDiscRing, layer));
        } else {
            s.add(PhotonicsDiscRingPulleys.createRing(x, y, ringWidth, radius, 0.0, 360.0, numberOfSidesDiscRing, layer));
            rin += ringWidth;
        }
        GArea bigD = PhotonicsDiscRingPulleys.createPulleyA(x, y, rin, rin + 2.0 * sleeveWidth + waveguideWidth, waveguideAngle, 90.0, waveguideLength, numberOfSidesCouplingRegion, layer);
        GArea smallD = PhotonicsDiscRingPulleys.createPulleyA(x, y, rin + sleeveWidth, rin + sleeveWidth + waveguideWidth, waveguideAngle, 90.0, waveguideLength, numberOfSidesCouplingRegion, layer);
        bigD.subtract(smallD);
        bigD.setDataType(CNSTscriptingController.getDataType());
        s.add(bigD);
        if (ENDCAP) {
            Point2D.Double pEC = PhotonicsDiscRingPulleys.calculateArcEndCapPosition(rin, rin + 2.0 * sleeveWidth + waveguideWidth, waveguideAngle, waveguideWidth, waveguideLength);
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + pEC.x, y + pEC.y + (sleeveWidth - waveguideWidth) / 2.0, sleeveWidth, 0.0));
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - pEC.x, y + pEC.y + (sleeveWidth - waveguideWidth) / 2.0, sleeveWidth, 180.0));
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + pEC.x, y + pEC.y + (3.0 * sleeveWidth + waveguideWidth) / 2.0, sleeveWidth, 0.0));
            s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - pEC.x, y + pEC.y + (3.0 * sleeveWidth + waveguideWidth) / 2.0, sleeveWidth, 180.0));
        }
        if (WAVEGUIDE) {
            double wgLower = y - radius - gap2 - width2 - 2.0 * sleeve2;
            wgLower = DISC ? wgLower : wgLower - ringWidth;
            GArea wg = new GArea(new Rect(x - (length2 /= 2.0), wgLower, x + length2, wgLower + width2 + 2.0 * sleeve2, layer), layer);
            GArea gRsmall = new GArea(new Rect(x - length2, wgLower + sleeve2, x + length2, wgLower + sleeve2 + width2, layer), layer);
            wg.subtract(gRsmall);
            if (ENDCAP) {
                wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, wgLower + sleeve2 / 2.0, sleeve2, 0.0));
                wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, wgLower + sleeve2 / 2.0, sleeve2, 180.0));
                wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, wgLower + width2 + 3.0 * sleeve2 / 2.0, sleeve2, 0.0));
                wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, wgLower + width2 + 3.0 * sleeve2 / 2.0, sleeve2, 180.0));
                wg.setRenderReso(CNSTscriptingController.getShapeReso());
            }
            wg.setDataType(CNSTscriptingController.getDataType());
            s.add(wg);
            length2 *= 2.0;
        } else {
            rin = rin - gap + gap2;
            GArea pulBIG = PhotonicsDiscRingPulleys.createPulleyA(x, y, rin, rin + 2.0 * sleeve2 + width2, angle2, 90.0, length2, numberOfSidesCouplingRegion, layer);
            GArea pulSMALL = PhotonicsDiscRingPulleys.createPulleyA(x, y, rin + sleeve2, rin + sleeve2 + width2, angle2, 90.0, length2, numberOfSidesCouplingRegion, layer);
            pulBIG.subtract(pulSMALL);
            if (ENDCAP) {
                Point2D.Double pEC = PhotonicsDiscRingPulleys.calculateArcEndCapPosition(rin, rin + 2.0 * sleeve2 + width2, angle2, width2, length2);
                pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + pEC.x, y + pEC.y + (sleeve2 - width2) / 2.0, sleeve2, 0.0));
                pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - pEC.x, y + pEC.y + (sleeve2 - width2) / 2.0, sleeve2, 180.0));
                pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + pEC.x, y + pEC.y + (3.0 * sleeve2 + width2) / 2.0, sleeve2, 0.0));
                pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - pEC.x, y + pEC.y + (3.0 * sleeve2 + width2) / 2.0, sleeve2, 180.0));
            }
            pulBIG.transform(AffineTransform.getRotateInstance(Math.PI, x, y));
            pulBIG.setDataType(CNSTscriptingController.getDataType());
            s.add(pulBIG);
        }
    }

    public static void createRDSymmetricInvA(Struct s, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, boolean DISC, boolean ENDCAP, int layer) {
        double rin = radius + gap;
        if (DISC) {
            s.add(PhotonicsDiscRingPulleys.createDisc(x, y, radius, numberOfSidesDiscRing, layer));
        } else {
            s.add(PhotonicsDiscRingPulleys.createRing(x, y, ringWidth, radius, 0.0, 360.0, numberOfSidesDiscRing, layer));
            rin += ringWidth;
        }
        GArea bigD = PhotonicsDiscRingPulleys.createSymmetricA(x, y, rin, rin + 2.0 * sleeveWidth + waveguideWidth, waveguideAngle, 90.0, waveguideLength, numberOfSidesCouplingRegion, layer);
        GArea smallD = PhotonicsDiscRingPulleys.createSymmetricA(x, y, rin + sleeveWidth, rin + sleeveWidth + waveguideWidth, waveguideAngle, 90.0, waveguideLength, numberOfSidesCouplingRegion, layer);
        bigD.subtract(smallD);
        bigD.setDataType(CNSTscriptingController.getDataType());
        s.add(bigD);
        if (ENDCAP) {
            Point2D.Double pEC = PhotonicsDiscRingPulleys.calculateArcEndCapPosition(rin, rin + 2.0 * sleeveWidth + waveguideWidth, waveguideAngle, waveguideWidth, waveguideLength);
            GArea s0 = PhotonicsDiscRingPulleys.createLeftEndCap(pEC.x, pEC.y - (sleeveWidth - waveguideWidth) / 2.0, sleeveWidth, 0.0);
            GArea s1 = PhotonicsDiscRingPulleys.createLeftEndCap(-pEC.x, pEC.y - (sleeveWidth - waveguideWidth) / 2.0, sleeveWidth, 180.0);
            GArea s2 = PhotonicsDiscRingPulleys.createLeftEndCap(pEC.x, pEC.y - (3.0 * sleeveWidth + waveguideWidth) / 2.0, sleeveWidth, 0.0);
            GArea s3 = PhotonicsDiscRingPulleys.createLeftEndCap(-pEC.x, pEC.y - (3.0 * sleeveWidth + waveguideWidth) / 2.0, sleeveWidth, 180.0);
            s0.or(s1);
            s0.or(s2);
            s0.or(s3);
            s0.transform(AffineTransform.getRotateInstance(Math.PI));
            s0.transform(AffineTransform.getTranslateInstance(x, y + 2.0 * rin + waveguideWidth));
            s0.setDataType(CNSTscriptingController.getDataType());
            s.add(s0);
        }
    }

    public static void createRDSymInvADSPul(Struct s, double x, double y, double radius, double ringWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double gap2, double angle2, double width2, double sleeve2, double length2, boolean WAVEGUIDE, boolean DISC, boolean ENDCAP, int layer) {
        double rin = radius + gap;
        if (DISC) {
            s.add(PhotonicsDiscRingPulleys.createDisc(x, y, radius, numberOfSidesDiscRing, layer));
        } else {
            s.add(PhotonicsDiscRingPulleys.createRing(x, y, ringWidth, radius, 0.0, 360.0, numberOfSidesDiscRing, layer));
            rin += ringWidth;
        }
        GArea bigD = PhotonicsDiscRingPulleys.createSymmetricA(x, y, rin, rin + 2.0 * sleeveWidth + waveguideWidth, waveguideAngle, 90.0, waveguideLength, numberOfSidesCouplingRegion, layer);
        GArea smallD = PhotonicsDiscRingPulleys.createSymmetricA(x, y, rin + sleeveWidth, rin + sleeveWidth + waveguideWidth, waveguideAngle, 90.0, waveguideLength, numberOfSidesCouplingRegion, layer);
        bigD.subtract(smallD);
        bigD.setDataType(CNSTscriptingController.getDataType());
        s.add(bigD);
        if (ENDCAP) {
            Point2D.Double pEC = PhotonicsDiscRingPulleys.calculateArcEndCapPosition(rin, rin + 2.0 * sleeveWidth + waveguideWidth, waveguideAngle, waveguideWidth, waveguideLength);
            GArea s0 = PhotonicsDiscRingPulleys.createLeftEndCap(pEC.x, pEC.y - (sleeveWidth - waveguideWidth) / 2.0, sleeveWidth, 0.0);
            GArea s1 = PhotonicsDiscRingPulleys.createLeftEndCap(-pEC.x, pEC.y - (sleeveWidth - waveguideWidth) / 2.0, sleeveWidth, 180.0);
            GArea s2 = PhotonicsDiscRingPulleys.createLeftEndCap(pEC.x, pEC.y - (3.0 * sleeveWidth + waveguideWidth) / 2.0, sleeveWidth, 0.0);
            GArea s3 = PhotonicsDiscRingPulleys.createLeftEndCap(-pEC.x, pEC.y - (3.0 * sleeveWidth + waveguideWidth) / 2.0, sleeveWidth, 180.0);
            s0.or(s1);
            s0.or(s2);
            s0.or(s3);
            s0.transform(AffineTransform.getRotateInstance(Math.PI));
            s0.transform(AffineTransform.getTranslateInstance(x, y + 2.0 * rin + waveguideWidth));
            s0.setRenderReso(CNSTscriptingController.getShapeReso());
            s0.setDataType(CNSTscriptingController.getDataType());
            s.add(s0);
        }
        if (WAVEGUIDE) {
            double lower = radius + gap2 + 2.0 * sleeve2 + width2;
            lower = DISC ? lower : lower + ringWidth;
            GArea wg = new GArea(new Rect(x - (length2 /= 2.0), y - lower, x + length2, y - lower + 2.0 * sleeve2 + width2, layer), layer);
            GArea wgSmall = new GArea(new Rect(x - length2, y - lower + sleeve2, x + length2, y - lower + sleeve2 + width2, layer), layer);
            wg.subtract(wgSmall);
            if (ENDCAP) {
                wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, y - lower + sleeve2 / 2.0, sleeve2, 0.0));
                wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, y - lower + sleeve2 / 2.0, sleeve2, 180.0));
                wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, y - lower + width2 + 3.0 * sleeve2 / 2.0, sleeve2, 0.0));
                wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, y - lower + width2 + 3.0 * sleeve2 / 2.0, sleeve2, 180.0));
                wg.setRenderReso(CNSTscriptingController.getShapeReso());
            }
            wg.setDataType(CNSTscriptingController.getDataType());
            s.add(wg);
        } else {
            rin = DISC ? radius + gap2 : radius + gap2 + ringWidth;
            GArea pulleyBIG = PhotonicsDiscRingPulleys.createSymmetricA(x, y, rin, rin + 2.0 * sleeve2 + width2, angle2, 90.0, length2, numberOfSidesCouplingRegion, layer);
            GArea pulleySmall = PhotonicsDiscRingPulleys.createSymmetricA(x, y, rin + sleeve2, rin + sleeve2 + width2, angle2, 90.0, length2, numberOfSidesCouplingRegion, layer);
            pulleyBIG.subtract(pulleySmall);
            pulleyBIG.transform(AffineTransform.getTranslateInstance(0.0, -2.0 * rin - 2.0 * sleeve2 - width2));
            s.add(pulleyBIG);
            if (ENDCAP) {
                Point2D.Double pEC = PhotonicsDiscRingPulleys.calculateArcEndCapPosition(rin, rin + 2.0 * sleeve2 + width2, angle2, width2, length2);
                GArea s0 = PhotonicsDiscRingPulleys.createLeftEndCap(pEC.x, pEC.y - (sleeve2 - width2) / 2.0, sleeve2, 0.0);
                GArea s1 = PhotonicsDiscRingPulleys.createLeftEndCap(-pEC.x, pEC.y - (sleeve2 - width2) / 2.0, sleeve2, 180.0);
                GArea s2 = PhotonicsDiscRingPulleys.createLeftEndCap(pEC.x, pEC.y - (3.0 * sleeve2 + width2) / 2.0, sleeve2, 0.0);
                GArea s3 = PhotonicsDiscRingPulleys.createLeftEndCap(-pEC.x, pEC.y - (3.0 * sleeve2 + width2) / 2.0, sleeve2, 180.0);
                s0.or(s1);
                s0.or(s2);
                s0.or(s3);
                s0.transform(AffineTransform.getRotateInstance(Math.PI));
                s0.transform(AffineTransform.getTranslateInstance(x, y - 2.0 * sleeve2));
                s0.setRenderReso(CNSTscriptingController.getShapeReso());
                s0.setDataType(CNSTscriptingController.getDataType());
                s.add(s0);
            }
        }
    }

    public static void createRDPulleyInvPosA(Struct s, double x, double y, double radius, double ringWidth, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, boolean DISC, boolean ENDCAP, int layer) {
        double rin = radius - ringDiscSleeveWidth - sleeveWidth + gap;
        if (DISC) {
            GArea discInv = PhotonicsDiscRingPulleys.createRing(x, y, ringDiscSleeveWidth, (radius += ringDiscSleeveWidth) - ringDiscSleeveWidth, 0.0, 360.0, numberOfSidesDiscRing, layer);
            GArea bigD = PhotonicsDiscRingPulleys.createPulleyA(x, y, rin += ringDiscSleeveWidth, rin + 2.0 * sleeveWidth + waveguideWidth, waveguideAngle, 90.0, waveguideLength, numberOfSidesCouplingRegion, layer);
            GArea smallD = PhotonicsDiscRingPulleys.createPulleyA(x, y, rin + sleeveWidth, rin + sleeveWidth + waveguideWidth, waveguideAngle, 90.0, waveguideLength, numberOfSidesCouplingRegion, layer);
            GArea innerDisc = PhotonicsDiscRingPulleys.createDisc(x, y, radius - ringDiscSleeveWidth, numberOfSidesDiscRing, layer);
            bigD.or(discInv);
            bigD.subtract(smallD);
            bigD.subtract(innerDisc);
            bigD.setDataType(CNSTscriptingController.getDataType());
            s.add(bigD);
            if (ENDCAP) {
                Point2D.Double pEC = PhotonicsDiscRingPulleys.calculateArcEndCapPosition(rin, rin + 2.0 * sleeveWidth + waveguideWidth, waveguideAngle, waveguideWidth, waveguideLength);
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + pEC.x, y + pEC.y + (sleeveWidth - waveguideWidth) / 2.0, sleeveWidth, 0.0));
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - pEC.x, y + pEC.y + (sleeveWidth - waveguideWidth) / 2.0, sleeveWidth, 180.0));
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + pEC.x, y + pEC.y + (3.0 * sleeveWidth + waveguideWidth) / 2.0, sleeveWidth, 0.0));
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - pEC.x, y + pEC.y + (3.0 * sleeveWidth + waveguideWidth) / 2.0, sleeveWidth, 180.0));
            }
        } else {
            double totalRingWidth = 2.0 * ringDiscSleeveWidth + ringWidth;
            rin += ringDiscSleeveWidth;
            GArea ringBIG = PhotonicsDiscRingPulleys.createRing(x, y, totalRingWidth, (radius += ringDiscSleeveWidth) - totalRingWidth, 0.0, 360.0, numberOfSidesDiscRing, layer);
            GArea ringSMALL = PhotonicsDiscRingPulleys.createRing(x, y, ringWidth, radius - ringDiscSleeveWidth - ringWidth, 0.0, 360.0, numberOfSidesDiscRing, layer);
            GArea rSymmetricArrayBIG = PhotonicsDiscRingPulleys.createPulleyA(x, y, radius - ringDiscSleeveWidth + gap - sleeveWidth, radius - ringDiscSleeveWidth + gap + waveguideWidth + sleeveWidth, waveguideAngle, 90.0, waveguideLength, numberOfSidesCouplingRegion, layer);
            GArea rSymmetricArraySMALL = PhotonicsDiscRingPulleys.createPulleyA(x, y, radius - ringDiscSleeveWidth + gap, radius - ringDiscSleeveWidth + gap + waveguideWidth, waveguideAngle, 90.0, waveguideLength, numberOfSidesCouplingRegion, layer);
            GArea innerDisc = PhotonicsDiscRingPulleys.createDisc(x, y, radius - 2.0 * ringDiscSleeveWidth - ringWidth, numberOfSidesDiscRing, layer);
            rSymmetricArrayBIG.or(ringBIG);
            rSymmetricArrayBIG.subtract(innerDisc);
            rSymmetricArrayBIG.subtract(ringSMALL);
            rSymmetricArrayBIG.subtract(rSymmetricArraySMALL);
            rSymmetricArrayBIG.setDataType(CNSTscriptingController.getDataType());
            s.add(rSymmetricArrayBIG);
            if (ENDCAP) {
                Point2D.Double pEC = PhotonicsDiscRingPulleys.calculateArcEndCapPosition(radius - ringDiscSleeveWidth + gap - sleeveWidth, radius - ringDiscSleeveWidth + gap + waveguideWidth + sleeveWidth, waveguideAngle, waveguideWidth, waveguideLength);
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + pEC.x, y + pEC.y + (sleeveWidth - waveguideWidth) / 2.0, sleeveWidth, 0.0));
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - pEC.x, y + pEC.y + (sleeveWidth - waveguideWidth) / 2.0, sleeveWidth, 180.0));
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + pEC.x, y + pEC.y + (3.0 * sleeveWidth + waveguideWidth) / 2.0, sleeveWidth, 0.0));
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - pEC.x, y + pEC.y + (3.0 * sleeveWidth + waveguideWidth) / 2.0, sleeveWidth, 180.0));
            }
        }
    }

    public static void createRDPulInvPosADSPul(Struct s, double x, double y, double radius, double ringWidth, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double gap2, double angle2, double width2, double sleeve2, double length2, boolean WAVEGUIDE, boolean DISC, boolean ENDCAP, int layer) {
        double rin = radius - ringDiscSleeveWidth - sleeveWidth + gap;
        if (DISC) {
            GArea discInv = PhotonicsDiscRingPulleys.createRing(x, y, ringDiscSleeveWidth, (radius += ringDiscSleeveWidth) - ringDiscSleeveWidth, 0.0, 360.0, numberOfSidesDiscRing, layer);
            GArea bigD = PhotonicsDiscRingPulleys.createPulleyA(x, y, rin += ringDiscSleeveWidth, rin + 2.0 * sleeveWidth + waveguideWidth, waveguideAngle, 90.0, waveguideLength, numberOfSidesCouplingRegion, layer);
            GArea smallD = PhotonicsDiscRingPulleys.createPulleyA(x, y, rin + sleeveWidth, rin + sleeveWidth + waveguideWidth, waveguideAngle, 90.0, waveguideLength, numberOfSidesCouplingRegion, layer);
            GArea innerDisc = PhotonicsDiscRingPulleys.createDisc(x, y, radius - ringDiscSleeveWidth, numberOfSidesDiscRing, layer);
            bigD.or(discInv);
            if (WAVEGUIDE) {
                double wgLower = y - (radius - ringDiscSleeveWidth) - gap2 - width2 - sleeve2;
                GArea wg = new GArea(new Rect(x - (length2 /= 2.0), wgLower, x + length2, wgLower + width2 + 2.0 * sleeve2, layer), layer);
                GArea gRsmall = new GArea(new Rect(x - length2, wgLower + sleeve2, x + length2, wgLower + sleeve2 + width2, layer), layer);
                if (ENDCAP) {
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, wgLower + sleeve2 / 2.0, sleeve2, 0.0));
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, wgLower + sleeve2 / 2.0, sleeve2, 180.0));
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, wgLower + width2 + 3.0 * sleeve2 / 2.0, sleeve2, 0.0));
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, wgLower + width2 + 3.0 * sleeve2 / 2.0, sleeve2, 180.0));
                    wg.setRenderReso(CNSTscriptingController.getShapeReso());
                }
                bigD.or(wg);
                bigD.subtract(gRsmall);
                length2 *= 2.0;
            } else {
                double rin2 = radius - ringDiscSleeveWidth - sleeve2 + gap2;
                GArea pulBIG = PhotonicsDiscRingPulleys.createPulleyA(x, y, rin2, rin2 + 2.0 * sleeve2 + width2, angle2, 90.0, length2, numberOfSidesCouplingRegion, layer);
                GArea pulSMALL = PhotonicsDiscRingPulleys.createPulleyA(x, y, rin2 + sleeve2, rin2 + sleeve2 + width2, angle2, 90.0, length2, numberOfSidesCouplingRegion, layer);
                if (ENDCAP) {
                    Point2D.Double pEC = PhotonicsDiscRingPulleys.calculateArcEndCapPosition(rin2, rin2 + 2.0 * sleeve2 + width2, angle2, width2, length2);
                    pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + pEC.x, y + pEC.y + (sleeve2 - width2) / 2.0, sleeve2, 0.0));
                    pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - pEC.x, y + pEC.y + (sleeve2 - width2) / 2.0, sleeve2, 180.0));
                    pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + pEC.x, y + pEC.y + (3.0 * sleeve2 + width2) / 2.0, sleeve2, 0.0));
                    pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - pEC.x, y + pEC.y + (3.0 * sleeve2 + width2) / 2.0, sleeve2, 180.0));
                }
                pulBIG.transform(AffineTransform.getRotateInstance(Math.PI, x, y));
                pulSMALL.transform(AffineTransform.getRotateInstance(Math.PI, x, y));
                bigD.or(pulBIG);
                bigD.subtract(pulSMALL);
            }
            bigD.subtract(smallD);
            bigD.subtract(innerDisc);
            bigD.setDataType(CNSTscriptingController.getDataType());
            s.add(bigD);
            if (ENDCAP) {
                Point2D.Double pEC = PhotonicsDiscRingPulleys.calculateArcEndCapPosition(rin, rin + 2.0 * sleeveWidth + waveguideWidth, waveguideAngle, waveguideWidth, waveguideLength);
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + pEC.x, y + pEC.y + (sleeveWidth - waveguideWidth) / 2.0, sleeveWidth, 0.0));
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - pEC.x, y + pEC.y + (sleeveWidth - waveguideWidth) / 2.0, sleeveWidth, 180.0));
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + pEC.x, y + pEC.y + (3.0 * sleeveWidth + waveguideWidth) / 2.0, sleeveWidth, 0.0));
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - pEC.x, y + pEC.y + (3.0 * sleeveWidth + waveguideWidth) / 2.0, sleeveWidth, 180.0));
            }
        } else {
            double totalRingWidth = 2.0 * ringDiscSleeveWidth + ringWidth;
            rin += ringDiscSleeveWidth;
            GArea ringBIG = PhotonicsDiscRingPulleys.createRing(x, y, totalRingWidth, (radius += ringDiscSleeveWidth) - totalRingWidth, 0.0, 360.0, numberOfSidesDiscRing, layer);
            GArea ringSMALL = PhotonicsDiscRingPulleys.createRing(x, y, ringWidth, radius - ringDiscSleeveWidth - ringWidth, 0.0, 360.0, numberOfSidesDiscRing, layer);
            GArea rSymmetricArrayBIG = PhotonicsDiscRingPulleys.createPulleyA(x, y, radius - ringDiscSleeveWidth + gap - sleeveWidth, radius - ringDiscSleeveWidth + gap + waveguideWidth + sleeveWidth, waveguideAngle, 90.0, waveguideLength, numberOfSidesCouplingRegion, layer);
            GArea rSymmetricArraySMALL = PhotonicsDiscRingPulleys.createPulleyA(x, y, radius - ringDiscSleeveWidth + gap, radius - ringDiscSleeveWidth + gap + waveguideWidth, waveguideAngle, 90.0, waveguideLength, numberOfSidesCouplingRegion, layer);
            GArea innerDisc = PhotonicsDiscRingPulleys.createDisc(x, y, radius - 2.0 * ringDiscSleeveWidth - ringWidth, numberOfSidesDiscRing, layer);
            rSymmetricArrayBIG.or(ringBIG);
            if (WAVEGUIDE) {
                double wgLower = y - (radius - ringDiscSleeveWidth) - gap2 - width2 - sleeve2;
                GArea wg = new GArea(new Rect(x - (length2 /= 2.0), wgLower, x + length2, wgLower + width2 + 2.0 * sleeve2, layer), layer);
                GArea gRsmall = new GArea(new Rect(x - length2, wgLower + sleeve2, x + length2, wgLower + sleeve2 + width2, layer), layer);
                if (ENDCAP) {
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, wgLower + sleeve2 / 2.0, sleeve2, 0.0));
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, wgLower + sleeve2 / 2.0, sleeve2, 180.0));
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, wgLower + width2 + 3.0 * sleeve2 / 2.0, sleeve2, 0.0));
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, wgLower + width2 + 3.0 * sleeve2 / 2.0, sleeve2, 180.0));
                    wg.setRenderReso(CNSTscriptingController.getShapeReso());
                }
                rSymmetricArrayBIG.or(wg);
                rSymmetricArrayBIG.subtract(gRsmall);
                length2 *= 2.0;
            } else {
                double rin2 = radius - ringDiscSleeveWidth - sleeve2 + gap2;
                GArea pulBIG = PhotonicsDiscRingPulleys.createPulleyA(x, y, radius - ringDiscSleeveWidth + gap2 - sleeve2, radius - ringDiscSleeveWidth + gap2 + width2 + sleeve2, angle2, 90.0, length2, numberOfSidesCouplingRegion, layer);
                GArea pulSMALL = PhotonicsDiscRingPulleys.createPulleyA(x, y, radius - ringDiscSleeveWidth + gap2, radius - ringDiscSleeveWidth + gap2 + width2, angle2, 90.0, length2, numberOfSidesCouplingRegion, layer);
                if (ENDCAP) {
                    Point2D.Double pEC = PhotonicsDiscRingPulleys.calculateArcEndCapPosition(radius - ringDiscSleeveWidth + gap2 - sleeve2, radius - ringDiscSleeveWidth + gap2 + width2 + sleeve2, angle2, width2, length2);
                    pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + pEC.x, y + pEC.y + (sleeve2 - width2) / 2.0, sleeve2, 0.0));
                    pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - pEC.x, y + pEC.y + (sleeve2 - width2) / 2.0, sleeve2, 180.0));
                    pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + pEC.x, y + pEC.y + (3.0 * sleeve2 + width2) / 2.0, sleeve2, 0.0));
                    pulBIG.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - pEC.x, y + pEC.y + (3.0 * sleeve2 + width2) / 2.0, sleeve2, 180.0));
                }
                pulBIG.transform(AffineTransform.getRotateInstance(Math.PI, x, y));
                pulSMALL.transform(AffineTransform.getRotateInstance(Math.PI, x, y));
                rSymmetricArrayBIG.or(pulBIG);
                rSymmetricArrayBIG.subtract(pulSMALL);
            }
            rSymmetricArrayBIG.subtract(innerDisc);
            rSymmetricArrayBIG.subtract(ringSMALL);
            rSymmetricArrayBIG.subtract(rSymmetricArraySMALL);
            rSymmetricArrayBIG.setDataType(CNSTscriptingController.getDataType());
            s.add(rSymmetricArrayBIG);
            if (ENDCAP) {
                Point2D.Double pEC = PhotonicsDiscRingPulleys.calculateArcEndCapPosition(radius - ringDiscSleeveWidth + gap - sleeveWidth, radius - ringDiscSleeveWidth + gap + waveguideWidth + sleeveWidth, waveguideAngle, waveguideWidth, waveguideLength);
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + pEC.x, y + pEC.y + (sleeveWidth - waveguideWidth) / 2.0, sleeveWidth, 0.0));
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - pEC.x, y + pEC.y + (sleeveWidth - waveguideWidth) / 2.0, sleeveWidth, 180.0));
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x + pEC.x, y + pEC.y + (3.0 * sleeveWidth + waveguideWidth) / 2.0, sleeveWidth, 0.0));
                s.add(PhotonicsDiscRingPulleys.createLeftEndCap(x - pEC.x, y + pEC.y + (3.0 * sleeveWidth + waveguideWidth) / 2.0, sleeveWidth, 180.0));
            }
        }
    }

    public static void createRDSymmetricInvPosA(Struct s, double x, double y, double radius, double ringWidth, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, boolean DISC, boolean ENDCAP, int layer) {
        double rin = radius;
        if (DISC) {
            GArea discBig = PhotonicsDiscRingPulleys.createRing(x, y, ringDiscSleeveWidth, (radius += ringDiscSleeveWidth) - ringDiscSleeveWidth, 0.0, 360.0, numberOfSidesDiscRing, layer);
            GArea bigSymm = PhotonicsDiscRingPulleys.createSymmetricA(x, y, rin + gap - sleeveWidth, rin + gap + sleeveWidth + waveguideWidth, waveguideAngle, 90.0, waveguideLength, numberOfSidesCouplingRegion, layer);
            GArea smallSymm = PhotonicsDiscRingPulleys.createSymmetricA(x, y, rin + gap, rin + gap + waveguideWidth, waveguideAngle, 90.0, waveguideLength, numberOfSidesCouplingRegion, layer);
            GArea discSmall = PhotonicsDiscRingPulleys.createDisc(x, y, rin, numberOfSidesDiscRing, layer);
            bigSymm.or(discBig);
            bigSymm.subtract(smallSymm);
            bigSymm.subtract(discSmall);
            bigSymm.setDataType(CNSTscriptingController.getDataType());
            s.add(bigSymm);
        } else {
            GArea ringBig = PhotonicsDiscRingPulleys.createRing(x, y, 2.0 * ringDiscSleeveWidth + ringWidth, rin - ringDiscSleeveWidth - ringWidth, 0.0, 360.0, numberOfSidesDiscRing, layer);
            GArea ringSmall = PhotonicsDiscRingPulleys.createRing(x, y, ringWidth, rin - ringWidth, 0.0, 360.0, numberOfSidesDiscRing, layer);
            GArea bigSymm = PhotonicsDiscRingPulleys.createSymmetricA(x, y, rin + gap - sleeveWidth, rin + gap + sleeveWidth + waveguideWidth, waveguideAngle, 90.0, waveguideLength, numberOfSidesCouplingRegion, layer);
            GArea smallSymm = PhotonicsDiscRingPulleys.createSymmetricA(x, y, rin + gap, rin + gap + waveguideWidth, waveguideAngle, 90.0, waveguideLength, numberOfSidesCouplingRegion, layer);
            GArea discSmall = PhotonicsDiscRingPulleys.createDisc(x, y, rin - ringDiscSleeveWidth - ringWidth, numberOfSidesDiscRing, layer);
            bigSymm.or(ringBig);
            bigSymm.subtract(smallSymm);
            bigSymm.subtract(ringSmall);
            bigSymm.subtract(discSmall);
            bigSymm.setDataType(CNSTscriptingController.getDataType());
            s.add(bigSymm);
        }
        if (ENDCAP) {
            Point2D.Double pEC = PhotonicsDiscRingPulleys.calculateArcEndCapPosition(rin + gap - sleeveWidth, rin + gap + sleeveWidth + waveguideWidth, waveguideAngle, waveguideWidth, waveguideLength);
            GArea s0 = PhotonicsDiscRingPulleys.createLeftEndCap(pEC.x, pEC.y - (sleeveWidth - waveguideWidth) / 2.0, sleeveWidth, 0.0);
            GArea s1 = PhotonicsDiscRingPulleys.createLeftEndCap(-pEC.x, pEC.y - (sleeveWidth - waveguideWidth) / 2.0, sleeveWidth, 180.0);
            GArea s2 = PhotonicsDiscRingPulleys.createLeftEndCap(pEC.x, pEC.y - (3.0 * sleeveWidth + waveguideWidth) / 2.0, sleeveWidth, 0.0);
            GArea s3 = PhotonicsDiscRingPulleys.createLeftEndCap(-pEC.x, pEC.y - (3.0 * sleeveWidth + waveguideWidth) / 2.0, sleeveWidth, 180.0);
            s0.or(s1);
            s0.or(s2);
            s0.or(s3);
            s0.transform(AffineTransform.getRotateInstance(Math.PI));
            s0.transform(AffineTransform.getTranslateInstance(x, y + 2.0 * (rin + gap - sleeveWidth) + waveguideWidth));
            s0.setDataType(CNSTscriptingController.getDataType());
            s.add(s0);
        }
    }

    public static void createRDSymInvPosADSPul(Struct s, double x, double y, double radius, double ringWidth, double ringDiscSleeveWidth, int numberOfSidesDiscRing, double gap, double waveguideAngle, int numberOfSidesCouplingRegion, double waveguideWidth, double sleeveWidth, double waveguideLength, double gap2, double angle2, double width2, double sleeve2, double length2, boolean WAVEGUIDE, boolean DISC, boolean ENDCAP, int layer) {
        double rin = radius;
        if (DISC) {
            GArea discBig = PhotonicsDiscRingPulleys.createRing(x, y, ringDiscSleeveWidth, (radius += ringDiscSleeveWidth) - ringDiscSleeveWidth, 0.0, 360.0, numberOfSidesDiscRing, layer);
            GArea bigSymm = PhotonicsDiscRingPulleys.createSymmetricA(x, y, rin + gap - sleeveWidth, rin + gap + sleeveWidth + waveguideWidth, waveguideAngle, 90.0, waveguideLength, numberOfSidesCouplingRegion, layer);
            GArea smallSymm = PhotonicsDiscRingPulleys.createSymmetricA(x, y, rin + gap, rin + gap + waveguideWidth, waveguideAngle, 90.0, waveguideLength, numberOfSidesCouplingRegion, layer);
            GArea discSmall = PhotonicsDiscRingPulleys.createDisc(x, y, rin, numberOfSidesDiscRing, layer);
            bigSymm.or(discBig);
            if (WAVEGUIDE) {
                double lower = y - (radius - ringDiscSleeveWidth) - gap2 - width2 - sleeve2;
                GArea wg = new GArea(new Rect(x - (length2 /= 2.0), lower, x + length2, lower + 2.0 * sleeve2 + width2, layer), layer);
                GArea gRsmall = new GArea(new Rect(x - length2, lower + sleeve2, x + length2, lower + sleeve2 + width2, layer), layer);
                if (ENDCAP) {
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, lower + sleeve2 / 2.0, sleeve2, 0.0));
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, lower + sleeve2 / 2.0, sleeve2, 180.0));
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, lower + width2 + 3.0 * sleeve2 / 2.0, sleeve2, 0.0));
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, lower + width2 + 3.0 * sleeve2 / 2.0, sleeve2, 180.0));
                    wg.setRenderReso(CNSTscriptingController.getShapeReso());
                }
                bigSymm.or(wg);
                bigSymm.subtract(gRsmall);
            } else {
                GArea pulBIG = PhotonicsDiscRingPulleys.createSymmetricA(x, y, rin + gap2 - sleeve2, rin + gap2 + sleeve2 + width2, angle2, 90.0, length2, numberOfSidesCouplingRegion, layer);
                GArea pulSMALL = PhotonicsDiscRingPulleys.createSymmetricA(x, y, rin + gap2, rin + gap2 + width2, angle2, 90.0, length2, numberOfSidesCouplingRegion, layer);
                if (ENDCAP) {
                    Point2D.Double pEC = PhotonicsDiscRingPulleys.calculateArcEndCapPosition(rin + gap2 - sleeve2, rin + gap2 + sleeve2 + width2, angle2, width2, length2);
                    GArea s0 = PhotonicsDiscRingPulleys.createLeftEndCap(pEC.x, pEC.y - (sleeve2 - width2) / 2.0, sleeve2, 0.0);
                    GArea s1 = PhotonicsDiscRingPulleys.createLeftEndCap(-pEC.x, pEC.y - (sleeve2 - width2) / 2.0, sleeve2, 180.0);
                    GArea s2 = PhotonicsDiscRingPulleys.createLeftEndCap(pEC.x, pEC.y - (3.0 * sleeve2 + width2) / 2.0, sleeve2, 0.0);
                    GArea s3 = PhotonicsDiscRingPulleys.createLeftEndCap(-pEC.x, pEC.y - (3.0 * sleeve2 + width2) / 2.0, sleeve2, 180.0);
                    s0.or(s1);
                    s0.or(s2);
                    s0.or(s3);
                    s0.transform(AffineTransform.getRotateInstance(Math.PI));
                    s0.transform(AffineTransform.getTranslateInstance(x, y + 2.0 * (rin + gap2 - sleeve2) + width2));
                    pulBIG.or(s0);
                }
                pulBIG.transform(AffineTransform.getTranslateInstance(0.0, -2.0 * (rin + gap2 + width2 / 2.0)));
                pulSMALL.transform(AffineTransform.getTranslateInstance(0.0, -2.0 * (rin + gap2 + width2 / 2.0)));
                bigSymm.or(pulBIG);
                bigSymm.subtract(pulSMALL);
            }
            bigSymm.subtract(smallSymm);
            bigSymm.subtract(discSmall);
            bigSymm.setDataType(CNSTscriptingController.getDataType());
            s.add(bigSymm);
        } else {
            GArea ringBig = PhotonicsDiscRingPulleys.createRing(x, y, 2.0 * ringDiscSleeveWidth + ringWidth, rin - ringDiscSleeveWidth - ringWidth, 0.0, 360.0, numberOfSidesDiscRing, layer);
            GArea ringSmall = PhotonicsDiscRingPulleys.createRing(x, y, ringWidth, rin - ringWidth, 0.0, 360.0, numberOfSidesDiscRing, layer);
            GArea bigSymm = PhotonicsDiscRingPulleys.createSymmetricA(x, y, rin + gap - sleeveWidth, rin + gap + sleeveWidth + waveguideWidth, waveguideAngle, 90.0, waveguideLength, numberOfSidesCouplingRegion, layer);
            GArea smallSymm = PhotonicsDiscRingPulleys.createSymmetricA(x, y, rin + gap, rin + gap + waveguideWidth, waveguideAngle, 90.0, waveguideLength, numberOfSidesCouplingRegion, layer);
            GArea discSmall = PhotonicsDiscRingPulleys.createDisc(x, y, rin - ringDiscSleeveWidth - ringWidth, numberOfSidesDiscRing, layer);
            bigSymm.or(ringBig);
            if (WAVEGUIDE) {
                double lower = y - radius - gap2 - width2 - sleeve2;
                GArea wg = new GArea(new Rect(x - (length2 /= 2.0), lower, x + length2, lower + 2.0 * sleeve2 + width2, layer), layer);
                GArea gRsmall = new GArea(new Rect(x - length2, lower + sleeve2, x + length2, lower + sleeve2 + width2, layer), layer);
                if (ENDCAP) {
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, lower + sleeve2 / 2.0, sleeve2, 0.0));
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, lower + sleeve2 / 2.0, sleeve2, 180.0));
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x + length2, lower + width2 + 3.0 * sleeve2 / 2.0, sleeve2, 0.0));
                    wg.or(PhotonicsDiscRingPulleys.createLeftEndCap(x - length2, lower + width2 + 3.0 * sleeve2 / 2.0, sleeve2, 180.0));
                    wg.setRenderReso(CNSTscriptingController.getShapeReso());
                }
                bigSymm.or(wg);
                bigSymm.subtract(gRsmall);
            } else {
                GArea pulBIG = PhotonicsDiscRingPulleys.createSymmetricA(x, y, radius + gap2 - sleeve2, radius + gap2 + sleeve2 + width2, angle2, 90.0, length2, numberOfSidesCouplingRegion, layer);
                GArea pulSMALL = PhotonicsDiscRingPulleys.createSymmetricA(x, y, radius + gap2, radius + gap2 + width2, angle2, 90.0, length2, numberOfSidesCouplingRegion, layer);
                if (ENDCAP) {
                    Point2D.Double pEC = PhotonicsDiscRingPulleys.calculateArcEndCapPosition(rin + gap2 - sleeve2, rin + gap2 + sleeve2 + width2, angle2, width2, length2);
                    GArea s0 = PhotonicsDiscRingPulleys.createLeftEndCap(pEC.x, pEC.y - (sleeve2 - width2) / 2.0, sleeve2, 0.0);
                    GArea s1 = PhotonicsDiscRingPulleys.createLeftEndCap(-pEC.x, pEC.y - (sleeve2 - width2) / 2.0, sleeve2, 180.0);
                    GArea s2 = PhotonicsDiscRingPulleys.createLeftEndCap(pEC.x, pEC.y - (3.0 * sleeve2 + width2) / 2.0, sleeve2, 0.0);
                    GArea s3 = PhotonicsDiscRingPulleys.createLeftEndCap(-pEC.x, pEC.y - (3.0 * sleeve2 + width2) / 2.0, sleeve2, 180.0);
                    s0.or(s1);
                    s0.or(s2);
                    s0.or(s3);
                    s0.transform(AffineTransform.getRotateInstance(Math.PI));
                    s0.transform(AffineTransform.getTranslateInstance(x, y + 2.0 * (rin + gap2 - sleeve2) + width2));
                    pulBIG.or(s0);
                }
                pulBIG.transform(AffineTransform.getTranslateInstance(0.0, -2.0 * (radius + gap2 + width2 / 2.0)));
                pulSMALL.transform(AffineTransform.getTranslateInstance(0.0, -2.0 * (radius + gap2 + width2 / 2.0)));
                bigSymm.or(pulBIG);
                bigSymm.subtract(pulSMALL);
            }
            bigSymm.subtract(smallSymm);
            bigSymm.subtract(ringSmall);
            bigSymm.subtract(discSmall);
            bigSymm.setDataType(CNSTscriptingController.getDataType());
            s.add(bigSymm);
        }
        if (ENDCAP) {
            Point2D.Double pEC = PhotonicsDiscRingPulleys.calculateArcEndCapPosition(rin + gap - sleeveWidth, rin + gap + sleeveWidth + waveguideWidth, waveguideAngle, waveguideWidth, waveguideLength);
            GArea s0 = PhotonicsDiscRingPulleys.createLeftEndCap(pEC.x, pEC.y - (sleeveWidth - waveguideWidth) / 2.0, sleeveWidth, 0.0);
            GArea s1 = PhotonicsDiscRingPulleys.createLeftEndCap(-pEC.x, pEC.y - (sleeveWidth - waveguideWidth) / 2.0, sleeveWidth, 180.0);
            GArea s2 = PhotonicsDiscRingPulleys.createLeftEndCap(pEC.x, pEC.y - (3.0 * sleeveWidth + waveguideWidth) / 2.0, sleeveWidth, 0.0);
            GArea s3 = PhotonicsDiscRingPulleys.createLeftEndCap(-pEC.x, pEC.y - (3.0 * sleeveWidth + waveguideWidth) / 2.0, sleeveWidth, 180.0);
            s0.or(s1);
            s0.or(s2);
            s0.or(s3);
            s0.transform(AffineTransform.getRotateInstance(Math.PI));
            s0.transform(AffineTransform.getTranslateInstance(x, y + 2.0 * (rin + gap - sleeveWidth) + waveguideWidth));
            s0.setDataType(CNSTscriptingController.getDataType());
            s.add(s0);
        }
    }

    public static GArea createPulleyA(double x, double y, double rin, double rout, double angleStart, double angleStop, double length, int numSides, int layer) {
        GArea sShape = PhotonicsDiscRingPulleys.createSshapeArc(rin, rout, angleStart, angleStop, numSides, rout - rin, length, layer);
        sShape.transform(AffineTransform.getTranslateInstance(x, y));
        sShape.setDataType(CNSTscriptingController.getDataType());
        return sShape;
    }

    public static GArea createSymmetricA(double x, double y, double rin, double rout, double angleStart, double angleStop, double length, int numSides, int layer) {
        GArea sShape = PhotonicsDiscRingPulleys.createSshapeArc(rin, rout, angleStart, angleStop, numSides, rout - rin, length, layer);
        sShape.transform(AffineTransform.getRotateInstance(Math.PI));
        sShape.transform(AffineTransform.getTranslateInstance(x, y + 2.0 * rin + (rout - rin)));
        sShape.setDataType(CNSTscriptingController.getDataType());
        return sShape;
    }

    public static GArea createSshapeArc(double rin, double rout, double angleStart, double angleStop, int numSides, double width, double length, int layer) {
        int j;
        int i;
        double angleStart2 = angleStart + 180.0;
        double angleStop2 = angleStop + 180.0;
        double angle = angleStop > angleStart ? Math.abs(angleStart - angleStop) : 360.0 - Math.abs(angleStart - angleStop);
        double angle2 = angleStop2 > angleStart2 ? Math.abs(angleStart2 - angleStop2) : 360.0 - Math.abs(angleStart2 - angleStop2);
        double x2 = (rin + rout) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(angleStart));
        double y2 = (rin + rout) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(angleStart));
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(rin * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(angleStart)), rin * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(angleStart)));
        int steps = numSides;
        double c = angle * (Math.PI / 180) / (double)numSides;
        double c2 = angle2 * (Math.PI / 180) / (double)numSides;
        for (i = 0; i <= steps; ++i) {
            poly.lineTo(rin * Math.cos((double)i * c + PhotonicsDiscRingPulleys.degreeToRadians(angleStart)), rin * Math.sin((double)i * c + PhotonicsDiscRingPulleys.degreeToRadians(angleStart)));
        }
        for (j = steps; j >= 0; --j) {
            poly.lineTo(rout * Math.cos((double)j * c + PhotonicsDiscRingPulleys.degreeToRadians(angleStart)), rout * Math.sin((double)j * c + PhotonicsDiscRingPulleys.degreeToRadians(angleStart)));
        }
        for (i = 0; i <= steps; ++i) {
            poly.lineTo(x2 + rin * Math.cos((double)i * c2 + PhotonicsDiscRingPulleys.degreeToRadians(angleStart2)), y2 + rin * Math.sin((double)i * c2 + PhotonicsDiscRingPulleys.degreeToRadians(angleStart2)));
        }
        for (j = steps; j >= 0; --j) {
            poly.lineTo(x2 + rout * Math.cos((double)j * c2 + PhotonicsDiscRingPulleys.degreeToRadians(angleStart2)), y2 + rout * Math.sin((double)j * c2 + PhotonicsDiscRingPulleys.degreeToRadians(angleStart2)));
        }
        poly.closePath();
        GArea v = new GArea(poly, layer);
        double xLL = x2 + rout * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(270.0));
        double yLL = y2 + rout * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(270.0));
        v.or(new Rect(xLL, yLL, xLL + length, yLL + width, layer));
        GArea v2 = new GArea(v);
        AffineTransform mirrorY = new AffineTransform(new double[]{-1.0, 0.0, 0.0, 1.0});
        v2.transform(mirrorY);
        v.or(v2);
        v.setDataType(CNSTscriptingController.getDataType());
        return v;
    }

    public static GArea createDisc(double x, double y, double radius, int numSides, int layer) {
        double radiusX = radius;
        double radiusY = radius;
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(x + radiusX, y);
        int steps = numSides;
        double c = Math.PI * 2 / (double)numSides;
        for (int i = 0; i < steps; ++i) {
            poly.lineTo(x + radiusX * Math.cos((double)i * c), y + radiusY * Math.sin((double)i * c));
        }
        poly.closePath();
        GArea v = new GArea(poly, layer);
        v.setDataType(CNSTscriptingController.getDataType());
        return v;
    }

    public static GArea createRing(double x, double y, double ringWidth, double rin, double angleStart, double angleStop, int numSides, int layer) {
        double rOut = rin + ringWidth;
        double angle = angleStop > angleStart ? Math.abs(angleStart - angleStop) : 360.0 - Math.abs(angleStart - angleStop);
        angleStart = PhotonicsDiscRingPulleys.degreeToRadians(angleStart);
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(x + rin * Math.cos(angleStart), y + rin * Math.sin(angleStart));
        int steps = numSides;
        double c = angle * (Math.PI / 180) / (double)numSides;
        for (int i = 0; i <= steps; ++i) {
            poly.lineTo(x + rin * Math.cos((double)i * c + angleStart), y + rin * Math.sin((double)i * c + angleStart));
        }
        for (int j = steps; j >= 0; --j) {
            poly.lineTo(x + rOut * Math.cos((double)j * c + angleStart), y + rOut * Math.sin((double)j * c + angleStart));
        }
        poly.closePath();
        GArea v = new GArea(poly, layer);
        v.setDataType(CNSTscriptingController.getDataType());
        return v;
    }

    public static GArea createSymmetricTorus(double x, double y, double width, double rin, double angleStart, int numSides, int layer) {
        double rOut = rin + width;
        double angle = 90.0 - angleStart;
        angleStart = PhotonicsDiscRingPulleys.degreeToRadians(angleStart);
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(x + rin * Math.cos(angleStart), y + rin * Math.sin(angleStart));
        int steps = numSides;
        double c = angle * (Math.PI / 180) / (double)numSides;
        for (int i = 0; i <= steps; ++i) {
            poly.lineTo(x + rin * Math.cos((double)i * c + angleStart), y + rin * Math.sin((double)i * c + angleStart));
        }
        for (int j = steps; j >= 0; --j) {
            poly.lineTo(x + rOut * Math.cos((double)j * c + angleStart), y + rOut * Math.sin((double)j * c + angleStart));
        }
        poly.closePath();
        GArea v = new GArea(poly, layer);
        v.setDataType(CNSTscriptingController.getDataType());
        return v;
    }

    public static GArea createBezier(double x, double y, double width, double rin, double angleStart, double L, double H, int layer) {
        double R = Math.sqrt(H * H + L * L);
        double AR = 4.0;
        double r = rin + width / 2.0;
        double angle = PhotonicsDiscRingPulleys.degreeToRadians(90.0 - angleStart);
        angleStart = PhotonicsDiscRingPulleys.degreeToRadians(angleStart);
        Point2D.Double p0 = new Point2D.Double(x + r * Math.cos(angleStart), y + r * Math.sin(angleStart));
        Point2D.Double p1 = new Point2D.Double(p0.x + R / AR * Math.cos(angle), p0.y - R / AR * Math.sin(angle));
        Point2D.Double p3 = new Point2D.Double(p0.x + L, p0.y - H);
        Point2D.Double p2 = new Point2D.Double(p3.x - L / 2.0, p3.y);
        Path2D.Double poly = new Path2D.Double();
        poly.moveTo(p0.x, p0.y);
        poly.curveTo(p1.x, p1.y, p2.x, p2.y, p3.x, p3.y);
        BasicStroke bs = new BasicStroke((float)width, 0, 1);
        GArea v = new GArea(bs.createStrokedShape(poly), layer);
        v.setDataType(CNSTscriptingController.getDataType());
        return v;
    }

    public static GArea createLeftEndCap(double x, double y, double w, double theta) {
        Arc2D.Double s1 = new Arc2D.Double(0.0, 0.0, w, w, -90.0, 180.0, 2);
        Path2D.Double p2dTemp = new Path2D.Double();
        PathIterator pi = s1.getPathIterator(null);
        while (!pi.isDone()) {
            p2dTemp = CNSTscriptingController.describeCurrentSegment(pi, p2dTemp, false);
            pi.next();
        }
        GArea v = new GArea(p2dTemp, CNSTscriptingController.getGdsLayer());
        v.transform(AffineTransform.getTranslateInstance(-w / 2.0, -w / 2.0));
        v.transform(AffineTransform.getTranslateInstance(x, y));
        v.transform(AffineTransform.getRotateInstance(PhotonicsDiscRingPulleys.degreeToRadians(theta), x, y));
        v.setRenderReso(CNSTscriptingController.getShapeReso());
        v.setDataType(CNSTscriptingController.getDataType());
        return v;
    }

    public static Point2D.Double calculateArcEndCapPosition(double rin, double rout, double waveguideAngle, double waveguideWidth, double waveguideLength) {
        double x2 = (rin + rout) * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle));
        double y2 = (rin + rout) * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(waveguideAngle));
        double xLL = x2 + rout * Math.cos(PhotonicsDiscRingPulleys.degreeToRadians(270.0));
        double yLL = y2 + rout * Math.sin(PhotonicsDiscRingPulleys.degreeToRadians(270.0));
        return new Point2D.Double(xLL + waveguideLength, yLL + waveguideWidth / 2.0);
    }

    public static GArea combineGarea(GArea ga1, GArea ga2, int layer) {
        Area a1 = new Area(ga1.getArea());
        Area a2 = new Area(ga2.getArea());
        a1.add(a2);
        GArea v = new GArea(a1, layer);
        Area a = new Area(v.getArea());
        AffineTransform mirror = new AffineTransform(new double[]{-1.0, 0.0, 0.0, 1.0});
        v.transform(mirror);
        Rectangle2D rec = a1.getBounds2D();
        v.transform(AffineTransform.getTranslateInstance(-rec.getWidth() - 2.0 * rec.getCenterX(), 0.0));
        a1.add(a);
        v = new GArea(a1, layer);
        v.setDataType(CNSTscriptingController.getDataType());
        return v;
    }

    public static GArea mirrorGarea(GArea ga, int layer) {
        Area a1 = new Area(ga.getArea());
        AffineTransform mirror = new AffineTransform(new double[]{-1.0, 0.0, 0.0, 1.0});
        a1.transform(mirror);
        Rectangle2D rec = a1.getBounds2D();
        a1.transform(AffineTransform.getTranslateInstance(-rec.getWidth() - 2.0 * rec.getCenterX(), 0.0));
        GArea v = new GArea(a1, layer);
        v.setDataType(CNSTscriptingController.getDataType());
        return v;
    }

    public static double degreeToRadians(double d) {
        return d * (Math.PI / 180);
    }
}

