/*
 * Decompiled with CFR 0.152.
 */
package CNSTnanoToolbox.advancedCAD;

import CNSTnanoToolbox.AboutActions;
import CNSTnanoToolbox.AboutInterface;
import CNSTnanoToolbox.shapeMethods.LabelColors;
import CNSTnanoToolbox.xml.CNSTdefaultParameters;
import JGDS2.Lib;
import JGDS2.Rect;
import JGDS2.Ref;
import JGDS2.Struct;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.paint.Paint;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javax.imageio.ImageIO;

public class GrayscaleImage2GDSController
implements Initializable,
AboutInterface {
    Stage about = new Stage();
    static File file = null;
    String openDir;
    String saveToDir;
    int displayColor = 0;
    int displayColor2 = 0;
    @FXML
    private TextField tfFileName;
    @FXML
    private TextField tfPixelSize;
    @FXML
    private CheckBox chbBW;
    @FXML
    private Label lImageFileStatus;
    @FXML
    private Label lStatus;

    public void initialize(URL url, ResourceBundle rb) {
        AboutActions.hideAbout(this.about, "About:    Grayscale Image To GDS Module", "This module imports 8-bit JPG image files and converts the data to GDS shapes. JPG Image files are read in a line-by-line fashion, where adjacent pixels are merged together. 8-bit pixel values (0-255) are mapped to respective GDS layer numbers. With the BW checkbox option enabled, all pixel values from the 8-bit image are mapped to GDS layer 1, with pixel value 255 (white) discarded.");
        try {
            CNSTdefaultParameters.getFileParameters();
            this.openDir = CNSTdefaultParameters.openDir;
            this.saveToDir = CNSTdefaultParameters.saveToDir;
        }
        catch (Exception ex) {
            Logger.getLogger(GrayscaleImage2GDSController.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    private void createGDS(ActionEvent event) throws IOException {
        double pixelSize = Double.parseDouble(this.tfPixelSize.getText());
        String fileName = this.tfFileName.getText();
        if (file != null && pixelSize >= 0.001) {
            String imageFileName = file.getPath();
            BufferedImage img = ImageIO.read(new File(imageFileName));
            int typeimg = img.getType();
            if (typeimg == 10) {
                Lib lib = new Lib();
                Struct top = new Struct("top");
                int[] lineOfData = new int[img.getWidth()];
                for (int i = img.getHeight() - 1; i >= 0; --i) {
                    for (int j = 0; j < lineOfData.length; ++j) {
                        lineOfData[j] = img.getData().getSample(j, i, 0);
                    }
                    this.drawLineDataMerge(top, img.getHeight() - 1 - i, pixelSize, lineOfData);
                }
                lib.add(new Ref(top, 0.0, 0.0));
                File f = lib.GDSOut(this.saveToDir + fileName + ".gds");
                this.lStatus.setText("Saved to " + f.getAbsolutePath());
                this.lStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor));
                this.displayColor = this.displayColor == 0 ? 1 : 0;
            } else {
                this.lImageFileStatus.setText("ERROR: IMAGE NOT 8-BIT GRAYSCALE BMP");
                this.lImageFileStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor2));
                this.displayColor2 = this.displayColor2 == 0 ? 1 : 0;
            }
        } else {
            String img2GdsError = GrayscaleImage2GDSController.errorCheckImg2Gds(file, pixelSize);
            this.lImageFileStatus.setText(img2GdsError);
            this.lImageFileStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor2));
            this.displayColor2 = this.displayColor2 == 0 ? 1 : 0;
        }
    }

    @FXML
    private void loadFile(ActionEvent event) {
        FileChooser chooser = new FileChooser();
        chooser.setTitle("Load File - Grayscale Image To GDS Module");
        chooser.setInitialDirectory(new File(this.openDir));
        file = chooser.showOpenDialog((Window)new Stage());
        this.lImageFileStatus.setText("Image File: " + file.getName());
        this.lImageFileStatus.setTextFill((Paint)LabelColors.getTwoLabelColors(this.displayColor2));
        this.displayColor2 = this.displayColor2 == 0 ? 1 : 0;
    }

    public void drawLineDataMerge(Struct top, int y, double pixelSize, int[] lineOfData) {
        int cnt = 1;
        for (int i = 0; i < lineOfData.length - 1; ++i) {
            if (lineOfData[i] == lineOfData[i + 1]) {
                ++cnt;
            } else {
                this.drawRect(top, cnt, i, y, pixelSize, lineOfData[i]);
                cnt = 1;
            }
            if (i != lineOfData.length - 2) continue;
            this.drawRect(top, cnt, i + 1, y, pixelSize, lineOfData[i + 1]);
        }
    }

    public void drawRect(Struct top, int cnt, int i, int y, double pixelSize, int gdsLayer) {
        int xPosition;
        if (this.chbBW.isSelected() && gdsLayer != 255) {
            xPosition = i - cnt + 1;
            gdsLayer = 1;
            top.add(new Rect((double)xPosition * pixelSize, (double)y * pixelSize + pixelSize, (double)xPosition * pixelSize + pixelSize * (double)cnt, (double)y * pixelSize, gdsLayer));
        }
        if (!this.chbBW.isSelected()) {
            xPosition = i - cnt + 1;
            top.add(new Rect((double)xPosition * pixelSize, (double)y * pixelSize + pixelSize, (double)xPosition * pixelSize + pixelSize * (double)cnt, (double)y * pixelSize, gdsLayer));
        }
    }

    public static String errorCheckImg2Gds(File f, double pixelSize) {
        String error = "ERROR: ";
        if (file == null) {
            error = error + "Image File Null - Load Image File! ";
        }
        if (pixelSize < 0.001) {
            error = error + "Pixel Size < 1nm! ";
        }
        return error;
    }

    @FXML
    private void exit(ActionEvent event) {
        System.exit(0);
    }

    @FXML
    private void about(ActionEvent event) {
        AboutActions.showAbout(this.about);
    }
}

