# write data out in a GSAS file format.
# original by A.McGhie with mods by B.Toby

lappend command(writetypes) " Simple gsas with esds (.gsas)"
lappend command(writeproc) writegsasdumpsingle
set command(writegsasdumpsingle) {listok}
lappend command(writetypes) " Multiblock gsas with esds (.gsas)"
lappend command(writeproc) writegsasdump
set command(writegsasdump) {listok}

proc writegsasdumpsingle {datalist} {
    # force a new file each time
    writegsasdump $datalist 1
}

proc writegsasdump {datalist {oneblock 0}} {
    global graph command
    set outlist {}
    set first 1
    foreach data $datalist {
	global $data 
	if {[set ${data}(type)] == "peaks"} {
	    # write a peak file
	    MyMessageBox -title "Not implemented" -type OK -default ok \
		-message "Peaks file not implemented for this format"
	    continue
	}

	if {$command(writeunits) == 0} {
	    set ydata [set ${data}(y)]
	    set xdata [set ${data}(x)]
	    set esddata [set ${data}(esd)]
	} else {
	    set ydata [[set ${data}(yvector)] range 0 end]
	    set xdata [[set ${data}(xvector)] range 0 end]
	    set esddata [[set ${data}(esdvec)] range 0 end]
	}
	# check step size
	set step_size [expr 1.0 * ([lindex $xdata 1] - [lindex $xdata 0]) ]
	set checkstepsize [expr 1.0 * ([lindex $xdata end] - [lindex $xdata 0]) \
			       / ([llength $ydata ] - 1) ]

	if {abs($checkstepsize - $step_size)/$checkstepsize > 0.001 } {
	    MyMessageBox -title "Warning" -type OK -default ok \
		-message "Warning: Step sizes is not uniform ($checkstepsize != $step_size). Use GSAS FXYE format for non-uniform step sizes"
	    continue
	}

	# open a file if needed, get a file name when requested 
	# or for multi-block files
	if {$oneblock || $first} {
	    catch {close $fil}
	    set first 0
	    set filename [file join $command(pwd) ${data}.gsas]
	    if {$command(write_useSaveAs) || ! $oneblock} {
		set filename [tk_getSaveFile -title "Select output file" -parent . \
				  -initialdir [file dirname $filename] \
				  -initialfile [file tail $filename]]
		if {[string trim $filename] == ""} return
	    }
	    set gsas_bank 1
	    set fil [open $filename w]
	    puts $fil "Automatically generated file $data from CMPR"
	} else {
	    incr gsas_bank
#	    set fil [open $filename a]
	}

	set ibank $gsas_bank
	# total number of data points
	set nchan [llength $ydata ]
	# should round down (div by 5 for esd)
	set nrec  [expr round ($nchan / 5)  ]          	
	# starting angle in centa degrees
	set bcoef1 [expr 100.0 * [lindex $xdata 0] ]	
	# step size
	set bcoef2 [expr 100.0 * ([lindex $xdata 1] - [lindex $xdata 0]) ]
	# place holder used twice in BANK lin
	set bcoef3 0 
	set bnk "BANK"
	set const "CONST"
	set endd "ESD"
	# BANK line format
	set line [format "%s %2d %8d%8d %s %10.2f%10.2f%2d%2d %s" $bnk $ibank $nchan $nrec $const $bcoef1 $bcoef2 $bcoef3 $bcoef3 $endd ]
	puts $fil "$line"
	# line for debugging
	#puts "$line" 
	set i 0
	set j 0
	# print out line by line the intensity and the esd.
	while { $i <  $nrec } {
	    incr i
	    set line [format "%8.1f%8.1f%8.1f%8.1f%8.1f%8.1f%8.1f%8.1f%8.1f%8.1f" \
			  [lindex  $ydata $j           ] [lindex  $esddata $j           ] \
			  [lindex  $ydata [expr $j + 1]] [lindex  $esddata [expr $j + 1]] \
			  [lindex  $ydata [expr $j + 2]] [lindex  $esddata [expr $j + 2]] \
			  [lindex  $ydata [expr $j + 3]] [lindex  $esddata [expr $j + 3]] \
			  [lindex  $ydata [expr $j + 4]] [lindex  $esddata [expr $j + 4]]]
	    incr j 5
	    puts $fil "$line"
	}
	# print out last line if nchan div 5 remander eq. zero then last line should be zeros.
	for {set i 1} { $i <= 5 } {incr i} {
	    if { [lindex  $ydata $j] == {} } {
		set y$i  0.0
		set ye$i 0.0
	    } else {
		set y$i  [lindex $ydata $j]
		set ye$i [lindex $esddata $j]
	    }
	    incr j
	}
	set line [format "%8.1f%8.1f%8.1f%8.1f%8.1f%8.1f%8.1f%8.1f%8.1f%8.1f" \
		      $y1 $ye1 $y2 $ye2 $y3 $ye3 $y4 $ye4 $y5 $ye5 ]
	puts $fil "$line"
	lappend outlist "$filename block $gsas_bank"
    }
    close $fil
    return $outlist
}
