# write data out in a XY Fullprof format (INSTRM=10 "x, y, sigma") file format.
# M. Suchomel; minor updates by B. Toby
# Dec 2009

lappend command(writetypes) " Fullprof INSTRM=10 file (.xy)"
lappend command(writeproc) writexy

proc writexy {data} {
    global graph command
    global $data 
    if {[set ${data}(type)] == "peaks"} {
	# write a peak file
	MyMessageBox -title "Not implemented" -type OK -default ok \
		-message "Peaks file not implemented for this format"
	return
    }

    if {$command(writeunits) == 0} {
	set ydata [set ${data}(y)]
	set xdata [set ${data}(x)]
	set esddata [set ${data}(esd)]
    } else {
	set ydata [[set ${data}(yvector)] range 0 end]
	set xdata [[set ${data}(xvector)] range 0 end]
	set esddata [[set ${data}(esdvec)] range 0 end]
    }
    # check step size
    set step_size [expr 1.0 * ([lindex $xdata 1] - [lindex $xdata 0]) ]
    set checkstepsize [expr 1.0 * ([lindex $xdata end] - [lindex $xdata 0]) \
			   / ([llength $ydata ] - 1) ]

    if {abs($checkstepsize - $step_size)/$checkstepsize > 0.001 } {
	MyMessageBox -title "Warning" -type OK -default ok \
	    -message "Warning: Step sizes is not uniform ($checkstepsize != $step_size). CMPR only supports uniform step sizes at present"
	return
    }

    # total number of data points
    set nchan [llength $ydata ]

    # step size
    set step [expr ([lindex $xdata 1] - [lindex $xdata 0]) ]

    # Fullprof keyword
    set type "INTER"
    # internal Fullprof x data multiplier
    set facX 1.0
    # internal Fullprof y data multiplier
    set facY 1.0
    # internal Fullprof flag, Interpol=2 means constant step data
    set interpol 2
    
    # INTER line line format
    set INTERline [format "%s %3.1f %3.1f %2d %3.5f" $type $facX $facY $interpol $step]

    # write a data file in a XY file format
    set filename [file join $command(pwd) ${data}.xy]
    if {$command(write_useSaveAs)} {
	set filename [tk_getSaveFile -title "Select output file" -parent . \
			  -initialdir [file dirname $filename] \
			  -initialfile [file tail $filename]]
	if {[string trim $filename] == ""} return
    }

    set fil [open $filename w]
    puts $fil "XYDATA"
    puts $fil "! Title: [set ${data}(title)]"
    puts $fil "! Automatically generated XY file $data from CMPR"
    puts $fil "! Fullprof format INSTRM=10 (x, y, sigma)"
    puts $fil "$INTERline"       	
    puts $fil "! ---------------------------------------"       	
    puts $fil "! degrees       intensity        sigma"

    #puts "$line" 
    set i 0
    set j 0
    # print out line by line the intensity and the esd.
    while { $i <  $nchan } {
	incr i	
	set line [format "%0.5f%15.4f%15.4f" \
		      [lindex  $xdata $j ] [lindex  $ydata $j ] [lindex  $esddata $j ]]
	incr j 
	puts $fil "$line"
    }
    close $fil
    return $filename
}
