# write a comma-separated (spreadsheet-format) file

lappend command(writetypes) ".cdt (Crysfire)"
lappend command(writeproc) writelistCrysfire

proc writelistCrysfire {data} {
    global graph command
    global $data Revision
    if {[set ${data}(type)] != "peaks"} {
	MyMessageBox -title "Warning" -type OK -default ok \
	    -message "Warning: Crysfile uses peak files only"
	return
    }

    set filename [file join $command(pwd) ${data}.cdt]
    if {$command(write_useSaveAs)} {
	set filename [tk_getSaveFile -title "Select output file" -parent . \
			  -initialdir [file dirname $filename] \
			  -initialfile [file tail $filename]]
	if {[string trim $filename] == ""} return
    }
    set fil [open $filename w]

    fconfigure $fil -translation crlf

    # write a peak file
    puts $fil \
	"\"CRYS v9.30c dataset, saved as filename by CMPR [lindex $Revision 1] on [clock format [clock seconds]]\""
    puts $fil "\"[set ${data}(title)]\""
    puts $fil "\"To use with CRYS versions prior to v9.30, delete these first 3 lines\""
    set npks [llength [set ${data}(x)]]
    puts $fil "\"$data\",$npks,0,0,0,0,[set ${data}(wavelength)],0,1,\"P\""
    foreach x   [set ${data}(x)]  y [set ${data}(y)] {
	puts $fil "0,0,0,0,$x,$y"
    }
    
    close $fil
    return $filename
}
