######################################################################
# create a cell widget in frame topbox
######################################################################
proc makesymbox {topbox lauevar setsetproc} {
    set lauelist {
	{Triclinic}
	"Monoclinic\nY unique"
	"Monoclinic\nZ unique"
	{Orthorhombic}
	{Tetragonal}
	{Cubic}
	{Rhombohedral}
	"Rhombohedral\nHexag. setting"
	{Hexagonal}
    }
    set lauenum {1 2 3 4 6 8 10 12 14 }
    pack [frame $topbox.laue] -side left
    set command "setcellsym \$${lauevar} $setsetproc"
    foreach sym $lauelist laue $lauenum {
	pack [radiobutton $topbox.laue.$laue \
		-variable $lauevar -value $laue -text $sym \
		-command $command \
		-anchor w ] -fill x
    }
}

######################################################################
# set allowed higher symmetry Laue class on current Laue class
######################################################################
proc setsymbox {topbox origlaue} {
    array set laueallow {
	{} {}
	1 {1 2 3 4 6 8 10 12 14} 
	2 {2 4 6 8 10 12 14} 
	3 {3 4 6 8 10 12 14} 
	4 {4 6 8 12 14} 
	6 {6 8} 
	8 8
	10 {8 10}
	12 {8 12}
	14 {8 12 14}
    }
    foreach laue {1 2 3 4 6 8 10 12 14 } {
	$topbox.laue.$laue config -state disabled -fg #888
    }
    foreach laue $laueallow($origlaue) {
	$topbox.laue.$laue config -state normal -fg black
    }
}

######################################################################
# set allowed cell parameters as called by setcellsym
######################################################################
proc setcellbox {fix lock} {
    global cellparm
    set topbox $cellparm(top)
    # reset all entries
    set i -1
    foreach var {a b c alpha beta gamma} {
	incr i
	$topbox.cell.e$var config -state normal -fg black -textvariable cellparm($var)
	$topbox.cell.l$var config -fg black
	# variables to fix
	if {[lindex $fix $i]-0 > 0} {
	    set cellparm($var) [lindex $fix $i]
	    $topbox.cell.e$var config -state disabled -fg #808080
	    $topbox.cell.l$var config -fg #808080
	}
	if {"[lindex $lock $i]" != ""} {
	    $topbox.cell.e$var config -fg #888 -textvariable cellparm([lindex $lock $i])
	    $topbox.cell.l$var config -fg #888
	}
    }
}

######################################################################
# set allowed cell parameters based on Laue class
#      calls setproc (set by call to makesymbox)
######################################################################
proc setcellsym {laue setproc} {
    switch $laue {
	1 { $setproc {0 0 0 0 0 0} {} }
	2 { $setproc {0 0 0 90 0 90} {} }
	3 { $setproc {0 0 0 90 90 0} {} }
	4 { $setproc {0 0 0 90 90 90} {} }
	5 -
	6 { $setproc {0 0 0 90 90 90} {"" a} }
	7 -
	8 { $setproc {0 0 0 90 90 90} {"" a a} }
	9 -
	10 { $setproc {0 0 0 0 0 0} {"" a a "" alpha alpha} }
	11 -
	12 -
	13 -
	14 -
	15 { $setproc {0 0 0 90 90 120} {"" a} }
    }
}

######################################################################
# create a cell parameter widget in frame topbox
######################################################################
proc makecellbox {topbox title} {
    global cellparm
    pack [frame $topbox.cell -bd 4 -relief groove] -fill both -anchor center
    grid [label $topbox.cell.head -text $title] -column 0 -columnspan 3 -row 0
    set row 0
    foreach var {a b c} {
	grid [label $topbox.cell.l$var -anchor e -text "$var"] \
		-column 0 -row [incr row]
	grid [entry $topbox.cell.e$var \
		-width 10 -relief sunken -bd 2 -textvariable cellparm($var)] \
		-column 1 -row $row
    }
    foreach var {alpha beta gamma}  lbl {a b g} {
	grid [label $topbox.cell.l$var -anchor e -font symbol \
		-text "$lbl"] \
		-column 0 -row [incr row]
	grid [entry $topbox.cell.e$var \
		-width 10 -relief sunken -bd 2 -textvariable cellparm($var)] \
		-column 1 -row $row
    }
    grid columnconfig $topbox.cell 0 -pad 10
}

#Centering
set extinctlbl(t1) Centering
set extinctlbl(1) {   None     {A (k+l=2n)}    {B (h+l=2n)}    {C (h+k=2n)} \
	{F (h+k,h+l,k+l=2n)}     {I (h+k+l=2n)}    {R-OBVERSE (-h+k+l=3n)} \
	{R-REVERSE (h-k+l=3n)}    {HEXAGONAL (h-k=3n)} }

# (hk0) ZONE - glides _|_ c
set extinctlbl(t2) "Glides _|_ to C"
set extinctlbl(2) {    none    {A (h=2n)}    {B (k=2n)}    {N (h+k=2n)} \
	{D (h+k=4n;h,k=2n)} }

# (h0l) ZONE - glides _|_ b
set extinctlbl(t3) "Glides _|_ to B"
set extinctlbl(3) {    none    {A (h=2n)}    {C (l=2n)}    {N (h+l=2n)} \
	{D (h+l=4n;h,l=2n)} }

# (0kl) ZONE - glides _|_ a
set extinctlbl(t4) "Glides _|_ to A"
set extinctlbl(4) {    none    {B (k=2n)}    {C (l=2n)}    {N (k+l=2n)} \
	{D (k+l=4n;k,l=2n)} }

# (hhl) ZONE - glides _|_ a+b
set extinctlbl(t5) "Glides _|_ to A+B"
set extinctlbl(5) {    none   {C(N) (l=2n)} {D (2h+l=4n)} }

# (-hhl) ZONE - glides _|_ a-b
set extinctlbl(t6) "Glides _|_ to A-B"
set extinctlbl(6) {    none   {C(N) (l=2n)} {D (2h+l=4n)} }

# (hkh) ZONE - glides _|_ a+c
set extinctlbl(t7) "Glides _|_ to A+C"
set extinctlbl(7) {    none   {B(N) (k=2n)} {D (2h+k=4n)} }

# (-hkh) ZONE - glides _|_ a-c
set extinctlbl(t8) "Glides _|_ to A-C"
set extinctlbl(8) {    none   {B(N) (k=2n)} {D (2h+k=4n)} }

# (hkk) ZONE - glides _|_ b+c
set extinctlbl(t9) "Glides _|_ to B+C"
set extinctlbl(9) {    none   {A(N) (h=2n)} {D (h+2k=4n)} }

# (hk-k) ZONE - glides _|_ b-c
set extinctlbl(t10) "Glides _|_ to B-C"
set extinctlbl(10) {    none  {A(N) (h=2n)} {D (h+2k=4n)} }

# (h00) row - screw axes along a
set extinctlbl(t11) {screw axis || a}
set extinctlbl(11) {    none {21 or 42 (h=2n)} {41 or 43 (h=4n) } }
# (0k0) row - screw axes along b
set extinctlbl(t12) {screw axis || b}
set extinctlbl(12) {    none {21 or 42 (k=2n)} {41 or 43 (k=4n) } }
# (00l) row - screw axes along c
set extinctlbl(t13) {screw axis || c}
set extinctlbl(13) {    none {21 or 42 (l=2n)} {31 32 62 or 64 (l=3n)} \
	{41 or 43 (l=4n)} {61 or 65 (l=6n)} }

proc resetextinctions {} {
    global extinctlbl
    for {set num 1} {$num < 14} {incr num} {
	set extinctlbl(r$num) [lindex $extinctlbl($num) 0]
    }
}
proc symbox {box num} {
    global extinctlbl
    pack [label $box.l -text $extinctlbl(t$num) -width 20] 
    eval tk_optionMenu $box.m extinctlbl(r$num) $extinctlbl($num)
    pack $box.m
}

proc extinctlblset {a b c} {
    global extinctlbl cellparm
    # trigger a recalc of the extinctions
    set cellparm(oldextspg) {}
    set count 0
    for {set num 1} {$num < 14} {incr num} {
	if {$extinctlbl(r$num) != [lindex $extinctlbl($num) 0]} {incr count}
    }
    if {$cellparm(extinctmenuH) != ""} {
	$cellparm(extinctmenuH).ext config -text "$count Set"
    }
    if {$cellparm(extinctmenuE) != ""} {
	$cellparm(extinctmenuE).ext config -text "$count Set"
    }
    return
}

proc extinctmenu {top} {
    catch {destroy $top}
    toplevel $top
    wm title $top "Extinction Conditions"
    set rowlist {0 1 2 3 4}
    set columnlist {1 {11 12 13} {4 3 2} {5 6 7} {8 9 10}}
#    pack [frame $top.0] -side top -fill both
#    pack [frame $top.0.1] -side left -anchor w
#    symbox $top.0.1 1
#    pack [button $top.0.d -text Close -command "destroy $top"] -side right -anchor ne
    foreach row $rowlist {
	pack [frame $top.$row] -side top
	foreach column [lindex $columnlist $row] {
	    pack [frame $top.$row.$column] -side left
	    symbox $top.$row.$column $column
	}
    }
    pack [frame $top.6] -side top -fill both
    pack [button $top.6.d -text Close -command "destroy $top"] \
	    -side right -anchor e
}

