/* strcasestr -- Case insensitive implementation of strstr */

/*
NAME
	strcasestr -- locate first occurance of a substring

SYNOPSIS
	char *strcasestr (char *s1, char *s2)

DESCRIPTION

	Locates the first occurance in the string pointed to by S1 of
	the string pointed to by S2 ignoring cases.  
	Returns a pointer to the substring
	found, or a NULL pointer if not found.  If S2 points to a string
	with zero length, the function returns S1.
	
*/


char * strcasestr (const char *s1, const char *s2) {
  register char *p = s1;
  extern char *strchr ();
  extern int strncasecmp ();
#if __GNUC__==2
  extern __SIZE_TYPE__ strlen ();
#endif
  register int len = strlen (s2);

  for (; (p = strchr (p, *s2)) != 0; p++)
    {
      if (strncasecmp (p, s2, len) == 0)
	{
	  return (p);
	}
    }
  return (0);
}
