      include 'copyrght.def'
C
C subroutines to report results
C------------------------------------------------------------------------
      integer*4 function psl_rephits(option)
C------------------------------------------------------------------------
C report number of entries in bitmap for option=0 or total entries for 
C option = 1
      implicit none
!MS$ATTRIBUTES C, REFERENCE :: psl_rephits
      integer*4 option
C------------------------------------------------------------------------
      include 'bitops.def'
      include 'pdfdefs.par'
      include 'logic.cmn'
      include 'pdf.cmn'

      if (option .eq. 0) then
         psl_rephits = TBLCOUNT(TABLE,N_cards)
      else
         psl_rephits = N_cards
      endif
      return
      end
C------------------------------------------------------------------------
      integer*4 function psl_rephistory(line, string)
C------------------------------------------------------------------------
C 	Sets string to the contents of history line # iline. 
C	Returns 0 if iline is out of range, 1 otherwise.
      implicit none
!MS$ATTRIBUTES C, REFERENCE :: psl_rephistory
      integer*4 line
      character*101 string
C------------------------------------------------------------------------
      include 'pdfdefs.par'
      include 'logic.cmn'
      include 'pdf.cmn'

      integer ln,lench
      if (line .lt. 1 .or. line .gt. cnum) then
         psl_rephistory = 0
      else
         string = context(line)
         ln = lench(string)
         string(ln+1:ln+1) = char(0)
         psl_rephistory = 1
      endif
      return
      end
C------------------------------------------------------------------------
      integer*4 function psl_nexthit(iseq,hitnum,direction)
C------------------------------------------------------------------------
C return the next hit from iseq
      implicit none
!MS$ATTRIBUTES C, REFERENCE :: psl_nexthit
      integer*4 iseq,hitnum,direction
C iseq       current hit number (0 => get first/last hit) 
C direction  0 for forward, 1 for backward
C------------------------------------------------------------------------
      include 'bitops.def'
      include 'pdfdefs.par'
      include 'logic.cmn'
      include 'pdf.cmn'

      integer i,k

      if (iseq .lt. 0) then
         k = 0
         do I=1,N_cards
            if (tblbittest(TABLE,i,N_cards) .eq. 1) then
               k = k + 1 
               if (k .eq. hitnum) then
                  psl_nexthit = i
                  return
               endif
            endif
         enddo
C we did not find a valid entry
         iseq = 0
      endif
      if (direction .eq. 0) then
         if (iseq .eq. 0) hitnum = 0
         do I=1+iseq,N_cards
            if (tblbittest(TABLE,i,N_cards) .eq. 1) then
               hitnum = hitnum + 1 
               psl_nexthit = i
               return
            endif
         enddo
      else
         if (iseq .eq. 0) THEN
            hitnum = TBLCOUNT(TABLE,N_cards) + 1
            k = N_cards
         else
            k = iseq - 1
         endif
         do I=k,1,-1
            if (tblbittest(TABLE,i,N_cards) .ne. 0) then
               hitnum = hitnum - 1 
               psl_nexthit = i
               return
            endif
         enddo
      endif
C not found/no more
      psl_nexthit = -1
      return
      end
C------------------------------------------------------------------------
      integer*4 function psl_reppdf1(nseq, ncrd, ndsp, INT, DSP,
     $     formula, MINNAM, COMMNAM, CHEMNAM,
     $     year, coden, VOLUME, page, AUTHORS)
C------------------------------------------------------------------------
C report the PDF1 information corresponding to entry NSEQ
C------------------------------------------------------------------------
      implicit none
!MS$ATTRIBUTES C, REFERENCE :: psl_reppdf1
      integer*4 nseq, ncrd, ndsp
      integer*4     INT(255)
      REAL*4    DSP(255)
      CHARACTER*256	formula, MINNAM, COMMNAM, CHEMNAM
      integer*4 year
      CHARACTER*6	coden
      CHARACTER*5 VOLUME
      CHARACTER*5 page
      CHARACTER*256 AUTHORS
C------------------------------------------------------------------------
      include 'pdfread.def'

      logical FLAG,PDFTOD
      integer j,k,ln,PDF2T
      INTEGER LENCH
      INTEGER*1  IRELbyte(255)
      INTEGER*2  PDF2T2(255)
      integer npt,dipt,refpt,cdpt

      CHARACTER*20 temp

      CHARACTER*(*) subrnm
      PARAMETER (subrnm='psl_RepPDF1')
C     
      j = nseq
      k = ps_readindex(j,ncrd,npt,dipt,refpt,cdpt)
      if (k .ne. 0) then
         psl_reppdf1 = -1
         write(temp,*) nseq
         ln = lench(temp)
         call errmsg(subrnm,'readindex for entry '//temp(:ln))
         return
      endif
C
      k = ps_readnamlib(npt,chemnam,commnam,minnam,formula)
      if (k .ne. 0) then
         psl_reppdf1 = -2
         write(temp,*) nseq,ncrd
         ln = lench(temp)
         call errmsg(subrnm,'readnamlib for entry '//temp(:ln))
         return
      endif
C
      k = ps_readdilib(dipt,PDF2T2,IRELbyte,ndsp)
      if (k .ne. 0) then
         psl_reppdf1 = -3
         write(temp,*) nseq,ncrd
         ln = lench(temp)
         call errmsg(subrnm,'readdilib for entry '//temp(:ln))
         return
      endif
      do k=1,ndsp
         call byte2long(irelbyte(k), int(k))
         call short2long(PDF2T2(k), PDF2T)
         FLAG = PDFTOD(PDF2T,DSP(k))
      enddo
C
      k = ps_readreflib(refpt, year, coden, volume, page, authors)
      if (k .ne. 0) then
         psl_reppdf1 = -4
         write(temp,*) nseq,ncrd
         ln = lench(temp)
         call errmsg(subrnm,'readreflib for entry '//temp(:ln))
         return
      endif
      psl_reppdf1 = 0
      return
      end

C------------------------------------------------------------------------
      integer*4 function psrepdi(nseq, ndsp, INT, DSP)
C------------------------------------------------------------------------
C report the PDF1 D/I data in PDF units
C------------------------------------------------------------------------
      implicit none
      integer*4 nseq
      integer*4 ndsp
      integer*4     INT(255), DSP(255)
C------------------------------------------------------------------------
      include 'pdfread.def'

      integer j,k,ln,ncrd
      INTEGER LENCH
      INTEGER*1  IRELbyte(255)
      INTEGER*2  PDF2T2(255)
      integer npt,dipt,refpt,cdpt

      CHARACTER*20 temp

      CHARACTER*(*) subrnm
      PARAMETER (subrnm='psRepDI')
C     
      j = nseq
      k = ps_readindex(j,ncrd,npt,dipt,refpt,cdpt)
      if (k .ne. 0) then
         psrepDI = -1
         write(temp,*) nseq
         ln = lench(temp)
         call errmsg(subrnm,'readindex for entry '//temp(:ln))
         return
      endif
C
      k = ps_readdilib(dipt,PDF2T2,IRELbyte,ndsp)
      if (k .ne. 0) then
         psrepdI = -3
         write(temp,*) nseq,ncrd
         ln = lench(temp)
         call errmsg(subrnm,'readdilib for entry '//temp(:ln))
         return
      endif
      do k=1,ndsp
         call byte2long(irelbyte(k), int(k))
         call short2long(PDF2T2(k), DSP(k))
      enddo
C
      psrepdI = 0
      return
      end

C------------------------------------------------------------------------
      integer*4 function psl_reppdf2(nseq, iline, line,
     $     format, filename)
C------------------------------------------------------------------------
C report the PDF2 information corresponding to entry NSEQ
C	Returns the number of lines in the record (nlines) or -1 for 
C	iline=0; returns 81 (number of characters in line or 0 
C	if no more lines (iline> nline).
C------------------------------------------------------------------------
      implicit none
!MS$ATTRIBUTES C, REFERENCE :: psl_reppdf2
      integer*4 nseq, iline
      CHARACTER*81	line
      CHARACTER*21	format
      CHARACTER*81	filename
C------------------------------------------------------------------------
      include 'pdfread.def'

      integer ncrd,npt,dipt,refpt,cdpt
      CHARACTER*20 temp
      integer i,j,k,ln
      integer lench

      CHARACTER*(*) subrnm
      PARAMETER (subrnm='psl_RepPDF2')
C     
      integer nbytes,nlines
      save nlines
      character*80 buffer(135)
      save buffer
      data nlines/0/

      j = nseq
      if (iline .eq. 0) then
         k = ps_readindex(j,ncrd,npt,dipt,refpt,cdpt)
         if (k .ne. 0) then
            psl_reppdf2 = -1
            write(temp,*) nseq
            ln = lench(temp)
            call errmsg(subrnm,'readindex for entry '//temp(:ln))
            return
         endif
         i = ps_readpdf2(cdpt, nbytes, 80*135, buffer, 0)
         nlines = nbytes/80
         psl_reppdf2 = nlines
         if (lench(format) .ge. 1) 
     $        call pdf2fmt(buffer,nlines,filename,format)
      elseif(iline .le. nlines) then
         line = buffer(iline) // char(0)
         psl_reppdf2 = 81
      else
         psl_reppdf2 = 0
      endif
      return
      end
