#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "logiclib.h"

/*  Program report

    This program reports information about a table of entries

  Command syntax:
    report -total            returns the # of entries in the entire database
    report <file> -current   returns the # of entries in the current table
    report <file> -history   returns the history of the current table
*/

int main (int argc, char *argv[])
{
  char string[101];
  if (PSL_INIT() != 0) 
    {
      fprintf(stderr,"error initializing the ICDD database\n");
      return 1;
    }

  if (argc == 2 && !strcmp(argv[1],"-total"))
    {
      INTEGER4 i;
      i = 1;
      printf("%d\n",PSL_REPHITS(&i) );
      return 0;
    }
  if (argc == 3) 
    {
      /*  Load the file argument */
      INTEGER4 ilogic, error;
      ilogic = 4;     /* Replace bitmap */
      error = PSL_READBITMAP(argv[1],&ilogic);
      if (error) 
	{      
	  fprintf(stderr, "error reading subfile %s\n",argv[1]);
	  return 1;
	}
      if (!strcmp(argv[2],"-current"))
	{
	  INTEGER4 i = 0;
	  printf("%d\n",PSL_REPHITS(&i) );
	  return 0;
	}
      else if (!strcmp(argv[2],"-history"))
	{
	  INTEGER4 i = 1;
	  INTEGER4 j;
	  j = PSL_REPHISTORY(&i,string);
	  while (j > 0)
	    {
	      printf("%s\n",string );
	      i++;
	      j = PSL_REPHISTORY(&i,string);
	    }
	  return 0;
	}
    }
  fprintf(stderr, "\nusage:\n");
  fprintf(stderr, "\t report -total\n(or)\t report <file> -current\n(or)\t report <file> -history\n");
  return 1;
}
