/* -------------------------------------------------------- */
/* pdfread.c                                                */
/* functions to read PDF files                              */
/* -------------------------------------------------------- */
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "copyrght.h"
#include "logicmap.h"

FILE * fcdrom[4];		  /* pointers for pdf2 databases */
/* pointers for pdf1 files */
static FILE * findex;                    /* index */
static FILE * fnamlib;                   /* name library */
static FILE * fdilib;                    /* di library */
static FILE * freflib;                   /* ref library */
static FILE * fbitmap;                   /* selected bitmap library */

/* ------------------------- */
/* Open a pdf2 database file */
/* ------------------------- */
INTEGER4 MSFLAG PS_OPENPDF2(
		   const CHAR * filename,  /* filename */
#ifdef _MSC_VER
		      int FORlen1, /* dummy FORTRAN string length */
#endif
		   const CHAR * diskpath,  /* location of disk files */
#ifdef _MSC_VER
		      int FORlen2, /* dummy FORTRAN string length */
#endif
		   const CHAR * cdrompath, /* location of cdrom files */
#ifdef _MSC_VER
		      int FORlen3, /* dummy FORTRAN string length */
#endif
		   const INTEGER4 * unit)      /* Unit number (0-3) */
{
	char tempname[128];
	int i;

	/* first try to open the file on disk using the default name */
	strcpy(tempname,diskpath);
	/* add a ending slash, if needed */
	if (tempname[i = strlen(tempname)] != '/') {
	  tempname[i+1] = 0;
	  tempname[i] = '/';
	}
	strcat(tempname, filename);
	fcdrom[* unit] = fopen(tempname, "rb");
 	/*  printf ("try 1 = %s\n",tempname );  */
	if (fcdrom[* unit] != NULL)  return 0;

	/* no luck, now try to open the file on cdrom using the default name */
	strcpy(tempname,cdrompath);
	/* add a ending slash, if needed */
	if (tempname[i = strlen(tempname)] != '/') {
	  tempname[i+1] = 0;
	  tempname[i] = '/';
	}
	strcat(tempname, filename);
 	/*  printf ("try 2 = %s\n",tempname );   */
	fcdrom[* unit] = fopen(tempname, "rb");
	if (fcdrom[* unit] != NULL)  return 0;

	/* last assume the cdrom path includes the full file name */
	strcpy(tempname,cdrompath);
 	/*  printf ("try 99 = %s\n",tempname );   */
	fcdrom[* unit] = fopen(tempname, "rb");
	if (fcdrom[* unit] != NULL)  return 0;

	return -1;
}

/* -------------------------- */
/* Close a pdf2 database file */
/* -------------------------- */
void MSFLAG PS_CLOSEPDF2(
		    const INTEGER4 * unit)     /* Unit number (0-3) */
{
	if (fcdrom[* unit] != NULL) fclose(fcdrom[* unit]);
	fcdrom[* unit] = NULL;
}

/* ------------------------------------ */
/* Open the pdf1 index file (jcpds.ind) */
/* ------------------------------------ */
INTEGER4 MSFLAG PS_OPENINDEX(
		   const CHAR * diskpath,  /* location of disk files */
#ifdef _MSC_VER
		      int FORlen1, /* dummy FORTRAN string length */
#endif
		   const CHAR * cdrompath
#ifdef _MSC_VER
		      , int FORlen2 /* dummy FORTRAN string length */
#endif
		   ) /* location of cdrom files */

{
	char tempname[128];
	int i;

	/* first try to open the file on disk */
	strcpy(tempname,diskpath);
	/* add a ending slash, if needed */
	if (tempname[i = strlen(tempname)] != '/') {
	  tempname[i+1] = 0;
	  tempname[i] = '/';
	}
	strcat(tempname, "jcpds.ind");
	findex = fopen(tempname, "rb");
/*  	printf ("try 1 = %s\n",tempname );  */
	if (findex != NULL)  return 0;

	/* no luck, now try to open the file on cdrom */
	strcpy(tempname,cdrompath);
	/* add a ending slash, if needed */
	if (tempname[i = strlen(tempname)] != '/') {
	  tempname[i+1] = 0;
	  tempname[i] = '/';
	}
	strcat(tempname, "jcpds.ind");
/*  	printf ("try 2 = %s\n",tempname );   */
	findex = fopen(tempname, "rb");
	if (findex != NULL)  return 0;
	return -1;
}

/* ------------------------- */
/* Close the pdf1 index file */
/* ------------------------- */
void MSFLAG PS_CLOSEINDEX(void)
{
	if (findex != NULL) fclose(findex);
	findex = NULL;
}				


/* ------------------------------------------ */
/* Open the pdf1 name library file (name.lib) */
/* ------------------------------------------ */
INTEGER4 MSFLAG PS_OPENNAMLIB(
		   const CHAR * diskpath,  /* location of disk files */
#ifdef _MSC_VER
		      int FORlen1, /* dummy FORTRAN string length */
#endif
		   const CHAR * cdrompath
#ifdef _MSC_VER
		      , int FORlen2 /* dummy FORTRAN string length */
#endif
		   ) /* location of cdrom files */

{
	char tempname[128];
	int i;

	/* first try to open the file on disk */
	strcpy(tempname,diskpath);
	/* add a ending slash, if needed */
	if (tempname[i = strlen(tempname)] != '/') {
	  tempname[i+1] = 0;
	  tempname[i] = '/';
	}
	strcat(tempname, "name.lib");
	fnamlib = fopen(tempname, "rb");
	if (fnamlib != NULL)  return 0;

	/* no luck, now try to open the file on cdrom */
	strcpy(tempname,cdrompath);
	/* add a ending slash, if needed */
	if (tempname[i = strlen(tempname)] != '/') {
	  tempname[i+1] = 0;
	  tempname[i] = '/';
	}
	strcat(tempname, "name.lib");
	fnamlib = fopen(tempname, "rb");
	if (fnamlib != NULL)  return 0;
	return -1;
}

/* -------------------------------- */
/* Close the pdf1 name library file */
/* -------------------------------- */
void MSFLAG PS_CLOSENAMLIB(void)
{
	if (fnamlib != NULL) fclose(fnamlib);
	fnamlib = NULL;
}				

/* --------------------------------------- */
/* Open the pdf1 d/i library file (di.lib) */
/* --------------------------------------- */
INTEGER4 MSFLAG PS_OPENDILIB(
		   const CHAR * diskpath,  /* location of disk files */
#ifdef _MSC_VER
		      int FORlen1, /* dummy FORTRAN string length */
#endif
		   const CHAR * cdrompath
#ifdef _MSC_VER
		      , int FORlen2 /* dummy FORTRAN string length */
#endif
		   ) /* location of cdrom files */

{
	char tempname[128];
	int i;

	/* first try to open the file on disk */
	strcpy(tempname,diskpath);
	/* add a ending slash, if needed */
	if (tempname[i = strlen(tempname)] != '/') {
	  tempname[i+1] = 0;
	  tempname[i] = '/';
	}
	strcat(tempname, "di.lib");
	fdilib = fopen(tempname, "rb");
	if (fdilib != NULL)  return 0;

	/* no luck, now try to open the file on cdrom */
	strcpy(tempname,cdrompath);
	/* add a ending slash, if needed */
	if (tempname[i = strlen(tempname)] != '/') {
	  tempname[i+1] = 0;
	  tempname[i] = '/';
	}
	strcat(tempname, "di.lib");
	fdilib = fopen(tempname, "rb");
	if (fdilib != NULL)  return 0;
	return -1;
}

/* ------------------------------- */
/* Close the pdf1 d/i library file */
/* ------------------------------- */
void MSFLAG PS_CLOSEDILIB(void)
{
	if (fdilib != NULL) fclose(fdilib);
	fdilib = NULL;
}				


/* ---------------------------------------------- */
/* Open the pdf1 reference library file (ref.lib) */
/* ---------------------------------------------- */
INTEGER4 MSFLAG PS_OPENREFLIB(
		   const CHAR * diskpath,  /* location of disk files */
#ifdef _MSC_VER
		      int FORlen1, /* dummy FORTRAN string length */
#endif
		   const CHAR * cdrompath
#ifdef _MSC_VER
		      , int FORlen2 /* dummy FORTRAN string length */
#endif
		   ) /* location of cdrom files */
{
	char tempname[128];
	int i;

	/* first try to open the file on disk */
	strcpy(tempname,diskpath);
	/* add a ending slash, if needed */
	if (tempname[i = strlen(tempname)] != '/') {
	  tempname[i+1] = 0;
	  tempname[i] = '/';
	}
	strcat(tempname, "ref.lib");
	freflib = fopen(tempname, "rb");
	if (freflib != NULL)  return 0;

	/* no luck, now try to open the file on cdrom */
	strcpy(tempname,cdrompath);
	/* add a ending slash, if needed */
	if (tempname[i = strlen(tempname)] != '/') {
	  tempname[i+1] = 0;
	  tempname[i] = '/';
	}
	strcat(tempname, "ref.lib");
	freflib = fopen(tempname, "rb");
	if (freflib != NULL)  return 0;
	return -1;
}

/* ------------------------------------- */
/* Close the pdf1 reference library file */
/* ------------------------------------- */
void MSFLAG PS_CLOSEREFLIB(void)
{
	if (freflib != NULL) fclose(freflib);
	freflib = NULL;
}				

/* --------------------------------- */
/* Open a bitmap library (.bit) file */
/* --------------------------------- */
INTEGER4 MSFLAG PS_OPENBITLIB(
		   const CHAR * filename,  /* name of file */
#ifdef _MSC_VER
		      int FORlen1, /* dummy FORTRAN string length */
#endif
		   const CHAR * diskpath,  /* location of disk files */
#ifdef _MSC_VER
		      int FORlen2, /* dummy FORTRAN string length */
#endif
		   const CHAR * cdrompath
#ifdef _MSC_VER
		      , int FORlen3 /* dummy FORTRAN string length */
#endif
		   ) /* location of cdrom files */

{
	char tempname[128];
	int i;

	/* first try to open the file on disk */
	strcpy(tempname,diskpath);
	/* add a ending slash, if needed */
	if (tempname[i = strlen(tempname)] != '/') {
	  tempname[i+1] = 0;
	  tempname[i] = '/';
	}
	strcat(tempname,filename);
	fbitmap = fopen(tempname, "rb");
	if (fbitmap != NULL)  return 0;

	/* no luck, now try to open the file on cdrom */
	strcpy(tempname,cdrompath);
	/* add a ending slash, if needed */
	if (tempname[i = strlen(tempname)] != '/') {
	  tempname[i+1] = 0;
	  tempname[i] = '/';
	}
	strcat(tempname,filename);
	fbitmap = fopen(tempname, "rb");
	if (fbitmap != NULL)  return 0;
	return -1;
}

/* ----------------------------- */
/* Close the bitmap library file */
/* ----------------------------- */
void MSFLAG PS_CLOSEBITLIB(void)
{
	if (fbitmap != NULL) fclose(fbitmap);
	fbitmap = NULL;
}				

/* -------------------- */
/* Read a AIDS "record" */
/* -------------------- */
INTEGER4  MSFLAG PS_READPDF2(
		    INTEGER4 * bytepointer,    /* byte offset to desired record */
		    INTEGER4 * nbytes,	   /* number of bytes read */
		    const INTEGER4 * maxbytes, /* max # of bytes to read */
		    CHAR * buffer,	   /* buffer for AIDS record */
#ifdef _MSC_VER
		      int FORlen, /* dummy FORTRAN string length */
#endif
		    const INTEGER4 * unit)     /* Unit number (0-3) */
{
	INTEGER4 i2;

	*nbytes = 0;

	i2 = fseek(fcdrom[* unit], *bytepointer, SEEK_SET);
	if (i2<0) return -1L;
	while (*nbytes < *maxbytes)
	  {
	    i2 = fread(buffer+*nbytes, 1, 80, fcdrom[* unit]);
	    if (i2<80) return -1L;
		*bytepointer += 80;
		*nbytes += 80;
/* 		printf ("card type = %c\n",buffer[(*nbytes)-1] ); */
		if (buffer[(*nbytes)-1] == 'K') return 0L;
	}
	return -2L;
}

/* -------------------------------------- */
/* Read a record from the pdf1 index file */
/* -------------------------------------- */
INTEGER4 MSFLAG PS_READINDEX(
		  INTEGER4 *recpointer, /* sequence # to be read */
		  INTEGER4 *cardnum,    /* JCPDS-ICDD set/card # */
		  INTEGER4 *namept,	    /* pointer to name record */
		  INTEGER4 *dipt,	    /* pointer to d/i record */
		  INTEGER4 *refpt,	    /* pointer to reference record */
		  INTEGER4 * cdpt)	    /* pointer to PDF2 record */
{
  int i2;
  INTEGER4 words[5];
  long bytepointer;
  
  bytepointer = 20 * (-1 + *recpointer); /* (20 bytes/record) */

  i2 = fseek(findex, bytepointer, SEEK_SET);
  if (i2<0) return -1L;

  i2 = fread(words, 1, 20, findex);
  if (i2<20) return -1L;
  *cardnum = words[0];
  *namept = words[1];
  *dipt = words[2];
  *refpt = words[3];
  *cdpt = words[4];
  return 0L;
}

/* ---------------------------------------- */
/* Read a record from the name library file */
/* ---------------------------------------- */
INTEGER4 MSFLAG PS_READNAMLIB(
		   INTEGER4 * bytepointer,  /* byte offset of record to be read */
		   CHAR * line1,
#ifdef _MSC_VER
		   int FORlen1, /* dummy FORTRAN string length */
#endif
		   CHAR * line2,
#ifdef _MSC_VER
		   int FORlen2, /* dummy FORTRAN string length */
#endif
		   CHAR * line3,
#ifdef _MSC_VER
		   int FORlen3, /* dummy FORTRAN string length */
#endif
		   CHAR * line4
#ifdef _MSC_VER
		   , int FORlen4 /* dummy FORTRAN string length */
#endif
		   )
{
  size_t i;
  int i2;
  unsigned INTEGER1 lngths[4];
	
  i2 = fseek(fnamlib, *bytepointer, SEEK_SET);
  if (i2<0) return -1L;

  *bytepointer += fread(lngths, 1 ,4, fnamlib);

  i = lngths[0];
  if (i >0) *bytepointer += fread(line1, 1, i, fnamlib);
  line1[i] = 0;

  i = lngths[1];
  if (i >0) *bytepointer += fread(line2, 1, i, fnamlib);
  line2[i] = 0;

  i = lngths[2];
  if (i >0) *bytepointer += fread(line3, 1, i, fnamlib);
  line3[i] = 0;

  i = lngths[3];
  if (i >0) *bytepointer += fread(line4, 1, i, fnamlib);
  line4[i] = 0;
        
  return 0L;
}   
 
/* --------------------------------------------- */
/* Read a record from the reference library file */
/* --------------------------------------------- */
INTEGER4 MSFLAG PS_READREFLIB(
		     INTEGER4 * bytepointer,  
		     INTEGER4 * year, 
		     CHAR * coden,  
#ifdef _MSC_VER
		      int FORlen1, /* dummy FORTRAN string length */
#endif
		     CHAR * volume, 
#ifdef _MSC_VER
		      int FORlen2, /* dummy FORTRAN string length */
#endif
		     CHAR * page, 
#ifdef _MSC_VER
		      int FORlen3, /* dummy FORTRAN string length */
#endif
		     CHAR * authors
#ifdef _MSC_VER
		      , int FORlen4 /* dummy FORTRAN string length */
#endif
			 )
{
  size_t i;
  int i2;
  unsigned char bytes[5];
	
  i2 = fseek(freflib, *bytepointer, SEEK_SET);
  if (i2<0) return -1L;

  *bytepointer += fread(bytes, 1 ,5, freflib);

  *year = 0L;
  if (bytes[4] !=127) *year = 1900 + bytes[4];
	
  i = bytes[0];
  if (i >0) *bytepointer += fread(coden, 1, i, freflib);
  coden[i] = 0;

  i = bytes[1];
  if (i >0) *bytepointer += fread(volume, 1, i, freflib);
  volume[i] = 0;

  i = bytes[2];
  if (i >0) *bytepointer += fread(page, 1, i, freflib);
  page[i] = 0;

  i = bytes[3];
  if (i >0) *bytepointer += fread(authors, 1, i, freflib);
  authors[i] = 0;
        
  return 0L;
}

/* -------------------------------------- */
/* Read a record from the di library file */
/* -------------------------------------- */
INTEGER4 MSFLAG PS_READDILIB(
		    INTEGER4 * bytepointer,  
		    INTEGER2 *pdfdsp,  
		    unsigned INTEGER1 *inten, 
		    INTEGER4 * ndsp )
{
  size_t i;
  int i2;
  unsigned char byte;
	
  *ndsp = 0;

  i2 = fseek(fdilib, *bytepointer, SEEK_SET);
  if (i2<0) return -1L;
  

  *bytepointer += fread(&byte, 1 ,1, fdilib);

  *ndsp = byte;
  i = 2*byte;
  if (i >0) 
	{
	  *bytepointer += fread(pdfdsp, 1, i, fdilib);
	  i = byte;
	  *bytepointer += fread(inten, 1, i, fdilib);
	}
	return 0L;
}

/* ---------------------------------------- */
/* Read a record from a bitmap library file */
/* ---------------------------------------- */
INTEGER4 MSFLAG PS_READBITLIB(
		  INTEGER4 *recpointer, /* sequence # to be read */
		  INTEGER4 *table,      /* bitmap array */
		  INTEGER4 *nentries)   /* number of entries in database */
{
  int i2;
  long bytepointer;
  size_t nwords; 
  
  nwords = (31+*nentries)/32;
  bytepointer = 4 * nwords * (-1 + *recpointer); /* (4*nwords bytes/record) */

  i2 = fseek(fbitmap, bytepointer, SEEK_SET);
  if (i2<0) return -1L;

  i2 = fread(table, 4, nwords, fbitmap);
  if (i2<nwords) return -1L;
  return 0L;
}

/* save the bitmap on file */
INTEGER4 MSFLAG PS_WRITEMAP(
		   const CHAR * filename,  /* location of disk files */
#ifdef _MSC_VER
		      int FORlen, /* dummy FORTRAN string length */
#endif
		   INTEGER4 *nentries,         /* # of JCPDS-ICDD entries */
		   INTEGER4 *bitmap,	   /* pointer to bitmap array */
		   INTEGER4 *histnum,	   /* number of history records*/
		   CHAR     *history,	   /* array of history records*/
#ifdef _MSC_VER
		      int FORlen1, /* dummy FORTRAN string length */
#endif
		   INTEGER4 *histlen)	   /* length of history array in bytes*/
{
  FILE * filep;
  size_t nwords;
  int i2;

/* open the file */
  filep = fopen(filename, "wb");
  if (filep == NULL) {
    /*fclose(filep); */
    return -1L;
  }

/* Write a record to the pdf1 index file */
  i2 = fwrite(nentries, 4, 1, filep);
  if (i2<1) {
    fclose(filep); 
    return -2L;
  }

/* Write a record to the pdf1 index file */
  nwords = (31+*nentries)/32;
  i2 = fwrite(bitmap, 4, nwords, filep);
  if (i2<nwords) {
    fclose(filep); 
    return -3L;
  }

/* Write a record to the pdf1 index file */
  i2 = fwrite(histnum, 4, 1, filep);
  if (i2<1) {
    fclose(filep); 
    return -4L;
  }

/* Write a record to the pdf1 index file */
  nwords = (31+*nentries)/32;
  i2 = fwrite(history, *histlen, *histnum, filep);
  if (i2<*histnum) {
    fclose(filep); 
    return -5L;
  }

  fclose(filep); 
  return 0;
}			

/* read the bitmap from a file */
INTEGER4 MSFLAG PS_READMAP(
		   const CHAR * filename,  /* location of disk files */
#ifdef _MSC_VER
		      int FORlen, /* dummy FORTRAN string length */
#endif
		   INTEGER4 *nentries,         /* # of JCPDS-ICDD entries */
		   INTEGER4 *bitmap,	   /* pointer to bitmap array */
		   INTEGER4 *histnum,	   /* number of history records*/
		   CHAR     *history,	   /* array of history records*/
#ifdef _MSC_VER
		      int FORlen1, /* dummy FORTRAN string length */
#endif
		   INTEGER4 *histlen)	   /* length of history array in bytes*/
{
  FILE * filep;
  size_t nwords;
  int i2;

/* open the file */
  filep = fopen(filename, "rb");
  if (filep == NULL) {
    /* fclose(filep); */
    return -1L;
  }

/* Read a record to the pdf1 index file */
  i2 = fread(nentries, 4, 1, filep);
  if (i2<1) {
    fclose(filep); 
    return -2L;
  }

/* Read a record to the pdf1 index file */
  nwords = (31+*nentries)/32;
  i2 = fread(bitmap, 4, nwords, filep);
  if (i2<nwords) {
    fclose(filep); 
    return -3L;
  }

/* Read a record to the pdf1 index file */
  i2 = fread(histnum, 4, 1, filep);
  if (i2<1) {
    fclose(filep); 
    return -4L;
  }

/* Read a record to the pdf1 index file */
  nwords = (31+*nentries)/32;
  i2 = fread(history, *histlen, *histnum, filep);
  if (i2<*histnum) {
    fclose(filep); 
    return -5L;
  }

  fclose(filep); 
  return 0;
}			

/* -----------------------------------------  */
/* get the JCPDS database locations and sizes */
/* ------------------------------------------ */
INTEGER4 MSFLAG PS_READDBLOC(
		   CHAR * diskpath,  /* location of disk files */
#ifdef _MSC_VER
		      int FORlen1, /* dummy FORTRAN string length */
#endif
		   CHAR * cdrompath, /* location of cdrom files */
#ifdef _MSC_VER
		      int FORlen2, /* dummy FORTRAN string length */
#endif
		   CHAR * locpath,   /* location of local files */
#ifdef _MSC_VER
		      int FORlen3, /* dummy FORTRAN string length */
#endif
		   INTEGER4 * N_cards,   /* number of entries in DB */
		   INTEGER4 * lastcrd,   /* last (highest #) entry */
		   INTEGER4 * lastsub,   /* # of subfile records */
		   INTEGER4 * N_reg,     /* # of d-space regions */
		   INTEGER4 * N_elemc)   /* # of element count records */

{
  FILE * filep;
  char tempname[128];
  int i;

  /* Obtain the locations of the JCPDS-ICDD database files. 
     In Windows this is done by reading file 
       .\icddloc.txt (in the current default directory) or 
       C:\icddloc.txt
     In Unix this is done by reading file
       ~/.icdd_files_loc (in the user's home area) or if that file is not found
       /usr/local/icdd_files_loc.txt  */

  filep = NULL;

  tempname[0] = 0;
  /* choice #1 -- init location defined by environment var. */
  if (getenv("LOGIC_LOC") != NULL) 
    {
      strcpy(tempname,getenv("LOGIC_LOC"));
      filep = fopen(tempname, "r");
    }
  
  /* choice #2 -- init location in home directory */
  if (getenv("HOME") != NULL && filep == NULL) 
    {
      strcpy(tempname,getenv("HOME"));
      if (tempname[0] != 0) /* skip if HOME is defined as a NULL string */
	{
	  strcat(tempname, "/.icdd_files_loc");
	  filep = fopen(tempname, "r");
	}
    }
  /* choice #3 -- try /usr/local */
  if (filep == NULL) /* no luck so far */
    filep = fopen("/usr/local/icdd_files_loc.txt", "r");
  /* choice #4, must be windows -- how about the current directory? */
  if (filep == NULL) /* no luck so far */
    filep = fopen(".\\icddloc.txt", "r");
  /* choice #5, must be windows -- C:\ */
  if (filep == NULL)
    filep = fopen("C:\\icddloc.txt", "r");
  /* out of options -- bail out*/
  if (filep == NULL) 
    return -1L;
  
  /* get index file location */
  if (fgets(diskpath, 127, filep) == NULL) /* location of disk files */
      return -2L;
  /* Clean up any control characters, if needed */
  for (i=strlen(diskpath)-1; i >= 0; i--) {
    if (diskpath[i] > 32) {
      break;
    } else {
      diskpath[i] = 0;
    }
  }

  /* PDF-2 file location */
  if (fgets(cdrompath, 127, filep) == NULL) /* location of disk files */
      return -2L;
  /* Clean up any control characters, if needed */
  for (i=strlen(cdrompath)-1; i >= 0; i--) {
    if (cdrompath[i] > 32) {
      break;
    } else {
      cdrompath[i] = 0;
    }
  }

  /* get local PDF-2 file location */
  if (fgets(locpath, 127, filep) == NULL) /* location of disk files */
      return -2L;
  /* Clean up any control characters, if needed */
  for (i=strlen(locpath)-1; i >= 0; i--) {
    if (locpath[i] > 32) {
      break;
    } else {
      locpath[i] = 0;
    }
  }

  fclose(filep);

  /* first try to read file sizes from a disk file */
  strcpy(tempname, diskpath);
  /* add a ending slash, if needed */
  if (tempname[i = strlen(tempname)] != '/') {
    tempname[i+1] = 0;
    tempname[i] = '/';
  }
  strcat(tempname, "pdsize.txt");
  filep = fopen(tempname, "r");
    /* no luck, now try to open the file on cdrom */
  if (filep == NULL)
    {
      strcpy(tempname,cdrompath);
      /* add a ending slash, if needed */
      if (tempname[i = strlen(tempname)] != '/') {
	tempname[i+1] = 0;
	tempname[i] = '/';
      }
      strcat(tempname, "pdsize.txt");
      filep = fopen(tempname, "r");
    }

  if (filep == NULL) 
      return -3L;

  if (fscanf(filep, "%ld %ld %ld %ld %ld", 
	     N_cards, lastcrd, lastsub, N_reg, N_elemc
	     ) != 5) return -4L;

  fclose(filep);
  return 0;
}

/* ----------------------------------------------------- */
/* Search for text in the name or reference library file */
/* ----------------------------------------------------- */
INTEGER4 MSFLAG PS_SRCHLIBS(
			      INTEGER4 * nampointer,  /* byte offset in names file */
			      INTEGER4 * refpointer,  /* byte offset in reference file */
			      CHAR ** searchstrings,
			      INTEGER4 * ns,
			      int * fields) {
  char *strcasestr (const char *s1, const char *s2);
  size_t i;
  int i2;
  unsigned INTEGER1 lngths[4];
  char chem[256], common[256], mineral[256], formula[256];
  char coden[6],volume[5],page[5],authors[256];
  int numstrings, searchtype = 1;
  unsigned char bytes[5];

  if (fields[0] || fields[1] || fields[2] || fields[3]) {
    i2 = fseek(fnamlib, *nampointer, SEEK_SET);
    if (i2<0) return -1L;
  }
  if (fields[4] || fields[5]) {
    i2 = fseek(freflib, *refpointer, SEEK_SET);
    if (i2<0) return -1L;
  }

  if (fields[0] || fields[1] || fields[2] || fields[3]) {
    *nampointer += fread(lngths, 1 ,4, fnamlib); /* Load lengths */
  }
  if (fields[4] || fields[5]) {
    *refpointer += fread(bytes, 1 ,5, freflib);
  }

  if ((numstrings = *ns) < 0) {
    numstrings = -numstrings;
    /* -allof (match all) -- loop over all strings, quit on 1st unmatched */
    
    if (fields[0] || fields[1] || fields[2] || fields[3]) {
      i = lngths[0];
      if (i >0) *nampointer += fread(chem, 1, i, fnamlib);
      chem[i] = 0;
      i = lngths[1];
      if (i >0) *nampointer += fread(common, 1, i, fnamlib);
      common[i] = 0;
      i = lngths[2];
      if (i >0) *nampointer += fread(mineral, 1, i, fnamlib);
      mineral[i] = 0;
      i = lngths[3];
      if (i >0) *nampointer += fread(formula, 1, i, fnamlib);
      formula[i] = 0;
    }
    if (fields[4] || fields[5]) {
/*        *year = 0L; */
/*        if (bytes[4] !=127) *year = 1900 + bytes[4]; */
      i = bytes[0];
      if (i >0) *refpointer += fread(coden, 1, i, freflib);
      coden[i] = 0;
      i = bytes[1];
      if (i >0) *refpointer += fread(volume, 1, i, freflib);
      volume[i] = 0;
      i = bytes[2];
      if (i >0) *refpointer += fread(page, 1, i, freflib);
      page[i] = 0;
      i = bytes[3];
      if (i >0) *refpointer += fread(authors, 1, i, freflib);
      authors[i] = 0;
    }

    for (i=0;i<numstrings;i++) {
      if (fields[1] && strcasestr(chem, searchstrings[i]) != NULL) {
	continue;
      } else if (fields[3] && strcasestr(common, searchstrings[i]) != NULL) {
	continue;
      } else if (fields[2] && strcasestr(mineral, searchstrings[i]) != NULL) {
	continue;
      } else if (fields[0] && strcasestr(formula, searchstrings[i]) != NULL) {
	continue;
      } else if (fields[4] && strcasestr(authors, searchstrings[i]) != NULL) {
	continue;
      } else if (fields[5] && strcasestr(coden, searchstrings[i]) != NULL) {
	continue;
      } else {
	return 0L;  /* not found */
      }
    }
    return 1L;  /* found */

  } else {
    /* -oneof (match one) -- loop over all strings, success on 1st match */
    
    if (fields[0] || fields[1] || fields[2] || fields[3]) {
      i = lngths[0];
      if (i >0) *nampointer += fread(chem, 1, i, fnamlib);
      chem[i] = 0;
      for (i=0;i<numstrings;i++) {
	if (fields[1] && strcasestr(chem, searchstrings[i]) != NULL) {
	  return 1L;
	}
      }
      
      i = lngths[1];
      if (i >0) *nampointer += fread(common, 1, i, fnamlib);
      common[i] = 0;
      for (i=0;i<numstrings;i++) {
	if (fields[3] && strcasestr(common, searchstrings[i]) != NULL) {
	  return 1L;
	}
      }
      
      i = lngths[2];
      if (i >0) *nampointer += fread(mineral, 1, i, fnamlib);
      mineral[i] = 0;
      for (i=0;i<numstrings;i++) {
	if (fields[2] && strcasestr(mineral, searchstrings[i]) != NULL) {
	  return 1L;
	}
      }
      
      i = lngths[3];
      if (i >0) *nampointer += fread(formula, 1, i, fnamlib);
      formula[i] = 0;
      for (i=0;i<numstrings;i++) {
	if (fields[0] && strcasestr(formula, searchstrings[i]) != NULL) {
	  return 1L;
	}
      }
    }

    if (fields[4] || fields[5]) {
/*        *year = 0L; */
/*        if (bytes[4] !=127) *year = 1900 + bytes[4]; */
      i = bytes[0];
      if (i >0) *refpointer += fread(coden, 1, i, freflib);
      coden[i] = 0;
      for (i=0;i<numstrings;i++) {
	if (fields[5] && strcasestr(coden, searchstrings[i]) != NULL) {
	  return 1L;
	}
      }

      i = bytes[1];
      if (i >0) *refpointer += fread(volume, 1, i, freflib);
      volume[i] = 0;
      i = bytes[2];
      if (i >0) *refpointer += fread(page, 1, i, freflib);
      page[i] = 0;
      i = bytes[3];
      if (i >0) *refpointer += fread(authors, 1, i, freflib);
      authors[i] = 0;
      for (i=0;i<numstrings;i++) {
	if (fields[4] && strcasestr(authors, searchstrings[i]) != NULL) {
	  return 1L;
	}
      }
    }
    
    return 0L; /*  Not found */
  }
}
