      SUBROUTINE PHOPTI(RAWOPT,CALLNG,STATUS,SETOPT)
C
C          Routine to prepare the Optical Data for photo-typesetting.
C          The raw Optical Data are sent in a 67 character field.
C
C               RAWOPT - Raw Optical Data in AIDS format; this data is
C                        not changed in any way by this program.
C           *** CALLNG - Indicates the calling program.
C
C                        *** NOT USED - KEPT FOR COMPATIBILITY ***
C
C                          = 'AIDS' if AIDS called PHOPTI
C                          = 'MDB'  if a JCPDS MDB routine called
C                        This is used to decide which COMMON value to
C                        use for the output unit for error messages.
C               STATUS -   =0 for successful completion
C                          =1 for error;  in the event of an error return,
C                             the contents of SETOPT are unpredictable.
C                          =2 for warning (used just to get calling routine
C                             to print ID#
C               SETOPT - The converted Optical Data, ready for
C                        typesetting, in the format of the Optical Data
C                        card in the standard JCPDS Phototypesetting Data
C                        Interchange Format.
C
C                             1-10   10  Optical data (ea)
C                            11-20   10  Optical data (nwB)
C                            21-30   10  Optical data (ey)
C                            31-33    3  Optical data (sign)
C                            34-45   12  Optical data (2V)
C                            46-80   35  <blank>
C
C
C          By: Mark Holomany, JCPDS     Date: 2-Feb-1984
C
C
      IMPLICIT  INTEGER (A-Z)
      CHARACTER RAWOPT*(*),CALLNG*(*),SETOPT*(*)
      CHARACTER TOKEN*20, NEWSTR*10
      INTEGER   MAXLEN(5)
      INCLUDE 'ioret.cmn'
C\$INCLUDE:'IORET.CMN'
C
C       ... AIDS IO COMMON
      COMMON/IO/ NTIN, NTOUT, NTPCH,NALT, NCODN,NDABAS,NEXTN,
     *  NSTNAM,NMINGR,NORGGR,IWARN,IERR
      DATA      MAXLEN / 10, 10, 10, 3, 12 /
C
C       ... Make certain SETOPT is at least 80 characters long
      IF(LEN(SETOPT) .LT. 80) THEN
C         CALL ERRTXT ('W',
C     1     'Length of output string is shorter than 80 chars')
         STATUS = 1
         GO TO 9000
      ENDIF
C
C       ... Initialize the scanner program; a ',' will be the delimiter.
      L = LENGTH(RAWOPT)
      CALL SCANIN(RAWOPT(1:L), ',')
C
C       ... Get next field, then identify field tag.  The tag can be
C       ... either: A=, B=, Q=, Sign=, or 2V= .  They MUST appear
C       ... in the above order, eliminating those for which no data is
C       ... available.
      STATUS = 0
      SETOPT = ' '
C      ASSIGN 10 TO NEXT
      NEXT = 10
3000  CALL SCANER(TOKEN,SIZE)
      IF(SIZE .EQ. -1) GO TO 9000
      IF(SIZE .LT.  3) GO TO 8000
      CALL UPPER(TOKEN(1:1))
C      GO TO NEXT
      IF (NEXT .EQ. 10) GOTO 10
      IF (NEXT .EQ. 20) GOTO 20
      IF (NEXT .EQ. 30) GOTO 30
      IF (NEXT .EQ. 40) GOTO 40
      IF (NEXT .EQ. 50) GOTO 50
      IF (NEXT .EQ. 9000) GOTO 9000

      GOTO 10
10    IF(TOKEN(1:1) .EQ. 'A') THEN
         FLDNUM = 1
         CALL CMPRES(TOKEN,SIZE)
C         ASSIGN 20 TO NEXT
         NEXT = 20
         IF(TOKEN(2:2) .NE. '=') GO TO 8000
         IF(SIZE.GT.12) GO TO 8010
         SETOPT(1:10)  = TOKEN(3:SIZE)
         IF(SIZE.GT.11) THEN
C            CALL ERRTXT ('E', 
C     1        'Length of optical data field is >9 characters')
            STATUS = 2
         ENDIF
         GO TO 3000
      ENDIF

20    IF(TOKEN(1:1) .EQ. 'B') THEN
         FLDNUM = 2
         CALL CMPRES(TOKEN,SIZE)
C         ASSIGN 30 TO NEXT
         NEXT = 30
         IF(TOKEN(2:2) .NE. '=') GO TO 8000
         IF(SIZE.GT.12) GO TO 8010
         SETOPT(11:20) = TOKEN(3:SIZE)
         IF(SIZE.GT.11) THEN
C            CALL ERRTXT ('E', 
C     1        'Length of optical data field is >9 characters')
            STATUS = 2
         ENDIF
         GO TO 3000
      ENDIF

30    IF(TOKEN(1:1) .EQ. 'Q') THEN
         FLDNUM = 3
         CALL CMPRES(TOKEN,SIZE)
C         ASSIGN 40 TO NEXT
         NEXT = 40
         IF(TOKEN(2:2) .NE. '=') GO TO 8000
         IF(SIZE.GT.12) GO TO 8010
         SETOPT(21:30) = TOKEN(3:SIZE)
         IF(SIZE.GT.11) THEN
C            CALL ERRTXT ('E', 
C     1        'Length of optical data field is >9 characters')
            STATUS = 2
         ENDIF
         GO TO 3000
      ENDIF

40    IF(TOKEN(1:1) .EQ. 'S') THEN
         FLDNUM = 4
         CALL CMPRES(TOKEN,SIZE)
         CALL UPPER(TOKEN(2:4))
C         ASSIGN 50 TO NEXT
         NEXT = 50
         IF(SIZE.LT.6 .OR. TOKEN(1:5).NE.'SIGN=') GO TO 8000
         IF(SIZE.GT.8) GO TO 8010
         SETOPT(31:33) = TOKEN(6:SIZE)
C-->     IF(SETOPT(31:33) .EQ. '-'  ) SETOPT(31:33) = '$MI'
C-->     IF(SETOPT(31:33) .EQ. '+/-') SETOPT(31:33) = '$PM'

         GO TO 3000
      ENDIF

50    IF(TOKEN(1:1) .EQ. '2') THEN
         FLDNUM = 5
         CALL UPPER(TOKEN(2:2))
C         ASSIGN 9000 TO NEXT
         NEXT = 9000
         IF(SIZE.LT.4 .OR. TOKEN(1:3).NE.'2V=') GO TO 8000
         IF(SIZE.GT.15) THEN
            IF(TOKEN(16:SIZE).NE.' ') GO TO 8010
         ENDIF
         SETOPT(34:45) = TOKEN(4:SIZE)
C
C             ... Convert greeks if there are any
            NG = INDEX (SETOPT(34:45), '$')
            IF(NG .GT. 0) THEN
               CALL PITRAN (SETOPT(NG+34:NG+35), NEWSTR, LENPI)
               SETOPT(NG+33:) = NEWSTR(1:LENPI) // TOKEN(NG+6:)
            ENDIF

      ELSE
C         ASSIGN 10 TO NEXT
         NEXT = 10
         GO TO 8000
      ENDIF

      GO TO 9000
C
C       ... Error within current field.  Print message and continue.
8000  CONTINUE
      LX = MIN0 (SIZE, LEN(TOKEN))
      IF(LX .LE. 0) LX = 3
C      CALL ERRTXT ('E', 
C     1  'Optical Data card segment ''' // TOKEN(1:LX) // ''' in error.')
      STATUS = 1
      GO TO 3000
C
C       ... Field size too large.  Print message and continue.
8010  CONTINUE
C      CALL ERRTXT ('W',
C     1  'Field on Optical Data card longer than max')
CCCCC     1  MAXLEN(FLDNUM),TOKEN(1:MIN0(SIZE,LEN(TOKEN)))
CCCCC1620  FORMAT(' *WARNING*Field on Optical Data card longer than the ',
CCCCC     1  'maximum of ',I2,' chars.' /
CCCCC     2  ' ',9X,'Field including tag: ''',A,'''')
      STATUS = 1
      GO TO 3000

9000  CONTINUE
      RETURN
      END
