	SUBROUTINE FSPLIT (STRING,POS,IL,IR)
C
C	   Routine to find a spot to split the STRING, at or before
C	   position POS, in two at a blank.  IL and IR are returned
C	   as the first non-blank character to the Left and Right,
C	   respectivly, of the split.  If there are no blanks at or
C	   before POS, then IL and IR are returned as 0.  If there 
C	   is no non blank character after the split, IR is returned
C	   as 0.
C
C	   By: Mark Holomany, JCPDS     Date: 12-Apr-1984
C	   Revised:
C	   12-Jan-86 MAH If there are no blanks, break at a dash "-".
C	                 Necessary to correctly set long organic chem names.
C
C
	IMPLICIT INTEGER (A-Z)
	CHARACTER*(*) STRING

C	CALL ESTMOD ('FSPLIT')

	FIRST1 = 0
C
C	...Find last blank
	DO 4002 NBLANK=POS,1,-1
	IF(STRING(NBLANK:NBLANK) .EQ. ' ') THEN
C	   .. Special case if first blank found is in the first half of
C	   .. the string
	   IF( (NBLANK*100)/LEN(STRING) .LT. 51  .AND.  
	1  LEN(STRING) .GT. 10) THEN
C>>>	      CALL ERRTXT ('I', 
C>>>	1     'Special chem name abbreviation - check it')
	      FIRST1 = NBLANK
	      GO TO 10
	   ENDIF
	   GO TO 20
	ENDIF
4002	CONTINUE
C
C	...No blanks ... try for a '-'
10	DO 4005 NDASH=POS,1,-1
	IF(STRING(NDASH:NDASH) .EQ. '-') THEN
C	   .. If a blank was found above, and if that blank occurs beyond
C	   .. the '-' just found, then revert back to using the blank to
C	   .. split the string
	   IF(FIRST1 .GT. NDASH) THEN
	      NBLANK = FIRST1
	      GO TO 20
	   ENDIF
	   IL = NDASH
	   IR = NDASH + 1
	   GO TO 9000
	ENDIF
4005	CONTINUE
	IF(FIRST1 .GT. 0) THEN
	   NBLANK = FIRST1
	   GO TO 20
	ENDIF
C
C	...No blanks OR dashes
	IL = 0
	IR = 0
	GO TO 9000
C
C	...Found a blank
20	IF(NBLANK .EQ. POS) THEN
C	   .. Find next non-blank
	   DO 4003 I=NBLANK+1,LEN(STRING)
	   IF(STRING(I:I) .NE. ' ') THEN
	      IR = I
	      GO TO 30
	   ENDIF
4003	   CONTINUE
	   IR = 0

	ELSE
	   IR = NBLANK + 1
	ENDIF
C
C	...Got IR, now find IL
30	IF(NBLANK .EQ. 1) THEN
	   IL = 0
	ELSE
	   DO 4004 I=NBLANK-1,1,-1
	   IF(STRING(I:I) .NE. ' ') THEN
	      IL = I
	      GO TO 9000
	   ENDIF
4004	   CONTINUE
	   IL = 0
	ENDIF

9000	CONTINUE
C       CALL DESMOD ('FSPLIT')
	RETURN
	END
