	SUBROUTINE ALTRNT (INSTR, OUTSTR, CHAR)
C
C	   Routine to insert alternating single characters like
C	   'CHAR' before each character in INSTR.  The result is
C	   returned in OUTSTR.  Example:
C
C		('0.05', OUTSTR, '#') returns: '#0#.#0#5'
C
C	   In the event of an error, OUTSTR(1:1) is returned = ' '.
C
C	   This routine is used with the Photo-Typesetting programs
C	   to insert super/sub-scripting character codes into the
C	   chem formula, amongst other applications.
C
C	   By: Mark Holomany, JCPDS     Date: 31-Jan-1984
C
C
	IMPLICIT INTEGER (A-Z)
	CHARACTER  INSTR*(*),OUTSTR*(*),CHAR*1

	IF(LEN(OUTSTR) .LT. 2*LEN(INSTR)) THEN
C	   .. error
	   OUTSTR = ' '
	   RETURN
	ENDIF

	DO 10 I=1,LEN(INSTR)
	BEGIN = 2*I - 1
10	OUTSTR(BEGIN:BEGIN+1) = CHAR // INSTR(I:I)

	RETURN
	END
