      include 'copyrght.def'
C
C-----------------------------------------------------------------------
	integer*4 function psl_setbynumber(ilogic, numberlist, numnum)
C locate entries based on number of unique elements in chemical composition 
C-----------------------------------------------------------------------
	implicit none
!MS$ATTRIBUTES C, REFERENCE :: psl_setbynumber
	INTEGER*4 ilogic, numnum
       	INTEGER*4 numberlist(numnum)
C make a bitmap containing entries with numbers in numberlist then apply 
C   to current table using logic:
C
C ilogic determines the logic to be applied to the tables
C	0	 Match with table
C	1	 Add to table
C	2	 Remove new table from old table
C	3	 Remove old table from new table
C 
C returns the number of valid entries located
C-----------------------------------------------------------------------
	include 'bitops.def'
C	include 'pdfread.def'

	include 'pdfdefs.par'

	include 'pdf.cmn'
	include 'logic.cmn'
	integer*4 I,J,K,num
	CHARACTER*100 TRACE
        integer lench
        integer ln

	INTEGER*4 PS_LOOKUP
	CHARACTER*(*) subrnm
	PARAMETER (subrnm='psl_setbynumber')

        nph1 = TBLCLR(TABLE1,N_Cards)
        trace = 'Entry List ='
        num = 0
        DO I=1,numnum
           k = numberlist(i)
	   if (PS_LOOKUP(K,J) .eq. 0) then
              ln = lench(trace)
              write(trace(ln+1:),'(i7,a)') K,','
              CALL TBLBITSET(TABLE1,J,N_cards,1)
           endif
        ENDDO
C return the number of entries that we found
	k = tblcount(table1,N_Cards)
        psl_setbynumber = k
        if (k .eq. 0) return
C remove final comma
        ln = lench(trace)
        trace(ln:ln) = ' '
	CALL TBLLOGIC(ilogic, trace)
	RETURN
        END
C-----------------------------------------------------------------------
	integer*4 function psl_setbyrange(ilogic, num1, num2)
C locate entries based on number of unique elements in chemical composition 
C-----------------------------------------------------------------------
	implicit none
!MS$ATTRIBUTES C, REFERENCE :: psl_setbyrange
	INTEGER*4 ilogic, num1, num2
C make a bitmap containing entries between numbers num1 to num2 then apply 
C   to current table using logic:
C
C ilogic determines the logic to be applied to the tables
C	0	 Match with table
C	1	 Add to table
C	2	 Remove new table from old table
C	3	 Remove old table from new table
C 
C returns the number of vaid entries located
C-----------------------------------------------------------------------
	include 'bitops.def'
C	include 'pdfread.def'

	include 'pdfdefs.par'

	include 'pdf.cmn'
	include 'logic.cmn'
	integer*4 J,K1,k2,num
	CHARACTER*100 TRACE
        integer lench
        integer ln

	INTEGER*4 PS_LOOKUP
	CHARACTER*(*) subrnm
	PARAMETER (subrnm='psl_setbyrange')

        nph1 = TBLCLR(TABLE1,N_Cards)
        trace = 'Entry Range ='
        num = MIN(num1,num2)
        j = PS_LOOKUP(num,k1)
        ln = lench(trace)
        write(trace(ln+1:),'(i8)') num
        num = MAX(num1,num2)
        if (PS_LOOKUP(num,k2) .ne. 0) k2 = k2 - 1
        ln = lench(trace)
        write(trace(ln+1:),'(a,i8)') ' to',num
        do J=k1,k2
           CALL TBLBITSET(TABLE1,J,N_cards,1)
        ENDDO
C return the number of entries that we found
	k1 = tblcount(table1,N_Cards)
        psl_setbyrange = k1
        if (k1 .eq. 0) return
	CALL TBLLOGIC(ilogic, trace)
	RETURN
	END
C========================================================================
      INTEGER*4 FUNCTION PS_LOOKUP(ICARD,ISEQ)
C========================================================================
C Subroutine to look up a JCPDS-ICDD card on the Master index from the
C Card and set number.
C
C 	ICARD (input)	= 10000(set#) + card#
C	ISEQ (output)	sequence number (record # in index file, bitmap #)
C========================================================================
        implicit none
	INTEGER*4 ICARD,ISEQ

	include 'pdfread.def'

C	include 'pdfdefs.par'

	include 'pdf.cmn'

        CHARACTER*(*) subrnm
        PARAMETER (subrnm='ps_lookup')

	INTEGER*4 JCARD,JMIN,JMAX,k,ln
	INTEGER*4 NAMREC,FULREC,DIREC,REFREC
        CHARACTER*20 temp
        INTEGER LENCH

	JMIN  = 0
	JMAX = N_CARDS+1

	DO WHILE(jmin .lt. jmax-1)
	  iseq = (jmin + jmax)/2
          k = ps_readindex(iseq,jcard,namrec,direc,refrec,fulrec)
          if (k .ne. 0) then
             write(temp,*) iseq
             ln = lench(temp)
             call errmsg(subrnm,'readindex for entry '//temp(:ln))
             PS_LOOKUP = -1
             return
          endif
          jcard = abs(jcard)
C did we hit the right record?
	  IF (JCARD .EQ. ICARD) THEN
	    PS_LOOKUP = 0
	    RETURN
C nope, try narrowing the range
	  ELSEIF (JCARD .LT. ICARD) THEN 
C JCARD is low, set the lower search limit to ISEQ
	    JMIN = ISEQ
	  ELSE
C JCARD is high, set the upper search limit to ISEQ
	    JMAX = ISEQ
	  ENDIF
C try again
	ENDDO
C not found -- signal an error and set ISEQ to the closest, but higher value
	ISEQ = JMAX
	PS_LOOKUP = 1
	RETURN
	END


