/* define symbols for C routines that will be called by FORTRAN code */
/*  and FORTRAN routines that will be called in C routines */

/* Note that many compiliers change the name of FORTRAN subroutines.

   The GNU g77 compilier and SGI f77 compiliers add an underscore (_) to 
   the names of FORTRAN subroutines. Except in the case of names that
   already contain an underscore, g77 adds two.
   
   the HP fort77 compilier does not add any underscores  */

/* we also define datatypes for the FORTRAN variable types that we will use
   according to the number of bits used by the compiler */

/* check if we have a valid definition for the naming convention */
#ifdef  BIT16    /* 16-bit ints */
# define VALID1 1
#endif
#ifdef  BIT32    /* 32-bit ints */
# define VALID1 1
#endif
#ifdef  BIT64    /* 64-bit ints */
# define VALID1 1
#endif


#ifndef VALID1
# error "No value for FORTRAN mapping (BIT16, BIT32 or BIT64)"
#endif


/* check if we have a valid definition for the naming convention */
#ifdef  TWOSCORE    /* naming convention in g77 */
# define VALID 1
#endif
#ifdef  ONESCORE    /* naming convention in SGI f77 and gfortran */
# define VALID 1
#endif
#ifdef  NOSCORE     /* naming convention in HP fort77 */
# define VALID 1
#endif

#ifndef VALID
# error "No value for Fortran name mapping (TWOSCORE, ONESCORE or NOSCORE)"
#endif

/* pdfread.c routines (called many places) */

#ifdef  TWOSCORE    /* name conventions in g77 */
#   define PS_OPENPDF2	         ps_openpdf2__
#   define PS_CLOSEPDF2	         ps_closepdf2__
#   define PS_OPENINDEX	         ps_openindex__
#   define PS_CLOSEINDEX         ps_closeindex__
#   define PS_OPENNAMLIB         ps_opennamlib__
#   define PS_CLOSENAMLIB	 ps_closenamlib__
#   define PS_OPENDILIB	         ps_opendilib__
#   define PS_CLOSEDILIB	 ps_closedilib__
#   define PS_OPENREFLIB	 ps_openreflib__
#   define PS_CLOSEREFLIB	 ps_closereflib__
#   define PS_OPENBITLIB	 ps_openbitlib__
#   define PS_CLOSEBITLIB	 ps_closebitlib__
#   define PS_READPDF2	         ps_readpdf2__
#   define PS_READINDEX	         ps_readindex__
#   define PS_READNAMLIB	 ps_readnamlib__
#   define PS_READREFLIB	 ps_readreflib__
#   define PS_READDILIB	         ps_readdilib__
#   define PS_READBITLIB	 ps_readbitlib__
#   define PS_WRITEMAP        	 ps_writemap__
#   define PS_READMAP	         ps_readmap__
#   define PS_READDBLOC	         ps_readdbloc__
#   define PS_SRCHLIBS           ps_srchlibs__
#endif
#ifdef  ONESCORE    /* naming convention in SGI f77 */
#   define PS_OPENPDF2	         ps_openpdf2_
#   define PS_CLOSEPDF2	         ps_closepdf2_
#   define PS_OPENINDEX	         ps_openindex_
#   define PS_CLOSEINDEX         ps_closeindex_
#   define PS_OPENNAMLIB         ps_opennamlib_
#   define PS_CLOSENAMLIB	 ps_closenamlib_
#   define PS_OPENDILIB	         ps_opendilib_
#   define PS_CLOSEDILIB	 ps_closedilib_
#   define PS_OPENREFLIB	 ps_openreflib_
#   define PS_CLOSEREFLIB	 ps_closereflib_
#   define PS_OPENBITLIB	 ps_openbitlib_
#   define PS_CLOSEBITLIB	 ps_closebitlib_
#   define PS_READPDF2	         ps_readpdf2_
#   define PS_READINDEX	         ps_readindex_
#   define PS_READNAMLIB	 ps_readnamlib_
#   define PS_READREFLIB	 ps_readreflib_
#   define PS_READDILIB	         ps_readdilib_
#   define PS_READBITLIB	 ps_readbitlib_
#   define PS_WRITEMAP        	 ps_writemap_
#   define PS_READMAP	         ps_readmap_
#   define PS_READDBLOC	         ps_readdbloc_
#   define PS_SRCHLIBS           ps_srchlibs_
#endif
#ifdef NOSCORE     /* naming convention in HP fort77 */
#ifndef _MSC_VER
#   define PS_OPENPDF2	         ps_openpdf2
#   define PS_CLOSEPDF2	         ps_closepdf2
#   define PS_OPENINDEX	         ps_openindex
#   define PS_CLOSEINDEX         ps_closeindex
#   define PS_OPENNAMLIB         ps_opennamlib
#   define PS_CLOSENAMLIB	 ps_closenamlib
#   define PS_OPENDILIB	         ps_opendilib
#   define PS_CLOSEDILIB	 ps_closedilib
#   define PS_OPENREFLIB	 ps_openreflib
#   define PS_CLOSEREFLIB	 ps_closereflib
#   define PS_OPENBITLIB	 ps_openbitlib
#   define PS_CLOSEBITLIB	 ps_closebitlib
#   define PS_READPDF2	         ps_readpdf2
#   define PS_READINDEX	         ps_readindex
#   define PS_READNAMLIB	 ps_readnamlib
#   define PS_READREFLIB	 ps_readreflib
#   define PS_READDILIB	         ps_readdilib
#   define PS_READBITLIB	 ps_readbitlib
#   define PS_WRITEMAP        	 ps_writemap
#   define PS_READMAP	         ps_readmap
#   define PS_READDBLOC	         ps_readdbloc
#   define PS_SRCHLIBS           ps_srchlibs
#endif
#endif


/* pdfwrite.c (called by FORTRAN in pdencode programs only) */
#ifdef  TWOSCORE    /* naming convention in g77 */
#   define PS_CREATEINDEX	 ps_createindex__
#   define PS_CREATENAMLIB	 ps_createnamlib__
#   define PS_CREATEDILIB	 ps_createdilib__
#   define PS_CREATEREFLIB	 ps_createreflib__
#   define PS_CREATEBITLIB	 ps_createbitlib__
#   define PS_CLOSEBIT	         ps_closebit__
#   define PS_WRITEINDEX	 ps_writeindex__
#   define PS_WRITENAMLIB	 ps_writenamlib__
#   define PS_WRITEREFLIB	 ps_writereflib__
#   define PS_WRITEDILIB	 ps_writedilib__
#   define PS_WRITEBITLIB	 ps_writebitlib__
#endif
#ifdef  ONESCORE    /* naming convention in SGI f77 */
#   define PS_CREATEINDEX	 ps_createindex_
#   define PS_CREATENAMLIB	 ps_createnamlib_
#   define PS_CREATEDILIB	 ps_createdilib_
#   define PS_CREATEREFLIB	 ps_createreflib_
#   define PS_CREATEBITLIB	 ps_createbitlib_
#   define PS_CLOSEBIT	         ps_closebit_
#   define PS_WRITEINDEX	 ps_writeindex_
#   define PS_WRITENAMLIB	 ps_writenamlib_
#   define PS_WRITEREFLIB	 ps_writereflib_
#   define PS_WRITEDILIB	 ps_writedilib_
#   define PS_WRITEBITLIB	 ps_writebitlib_
#endif
#ifdef  NOSCORE     /* naming convention in HP fort77 */
#ifndef _MSC_VER
#   define PS_CREATEINDEX	 ps_createindex
#   define PS_CREATENAMLIB	 ps_createnamlib
#   define PS_CREATEDILIB	 ps_createdilib
#   define PS_CREATEREFLIB	 ps_createreflib
#   define PS_CREATEBITLIB	 ps_createbitlib
#   define PS_CLOSEBIT	         ps_closebit
#   define PS_WRITEINDEX	 ps_writeindex
#   define PS_WRITENAMLIB	 ps_writenamlib
#   define PS_WRITEREFLIB	 ps_writereflib
#   define PS_WRITEDILIB	 ps_writedilib
#   define PS_WRITEBITLIB	 ps_writebitlib
#endif
#endif

/* bitops.c (called by FORTRAN many places) */
#ifdef  TWOSCORE    /* naming convention in g77 */
#   define TBLCLR tblclr_ 
#   define TBLSET tblset_
#   define TBLCOUNT tblcount_
#   define TBLCOPY tblcopy_
#   define TBLOR tblor_
#   define TBLAND tbland_
#   define TBLNOT tblnot_
#   define TBLBITSET tblbitset_
#   define TBLBITTEST tblbittest_
#endif
#ifdef  ONESCORE    /* naming convention in SGI f77 */
#   define TBLCLR tblclr_ 
#   define TBLSET tblset_
#   define TBLCOUNT tblcount_
#   define TBLCOPY tblcopy_
#   define TBLOR tblor_
#   define TBLAND tbland_
#   define TBLNOT tblnot_
#   define TBLBITSET tblbitset_
#   define TBLBITTEST tblbittest_
#endif
#ifdef  NOSCORE     /* naming convention in HP fort77 */
#ifndef _MSC_VER
#   define TBLCLR tblclr
#   define TBLSET tblset
#   define TBLCOUNT tblcount
#   define TBLCOPY tblcopy
#   define TBLOR tblor
#   define TBLAND tbland
#   define TBLNOT tblnot
#   define TBLBITSET tblbitset
#   define TBLBITTEST tblbittest
#endif
#endif

/* FORTRAN Called by C by main logic shell */
#ifdef  TWOSCORE    /* naming convention in g77 */
#   define PSL_INIT     	 psl_init__
#   define PSL_TBLLOAD  	 psl_tblload__
#   define PSL_TBLLIST  	 psl_tbllist__
#   define PSL_ELEMSUB  	 psl_elemsub__
#   define PSL_ELEMCOUNT 	 psl_elemcount__
#   define PSL_SETBYNUMBER 	 psl_setbynumber__
#   define PSL_SETBYRANGE 	 psl_setbyrange__
#   define PSL_PEAKSUB  	 psl_peaksub__
#   define PSL_REPHITS  	 psl_rephits__
#   define PSL_REPHISTORY	 psl_rephistory__
#   define PSL_NEXTHIT  	 psl_nexthit__
#   define PSL_REPPDF1  	 psl_reppdf1__
#   define PSL_REPPDF2  	 psl_reppdf2__
#   define PSL_SAVEBITMAP	 psl_savebitmap__
#   define PSL_READBITMAP	 psl_readbitmap__
#   define PSL_STOREBITMAP	 psl_storebitmap__
#   define PSL_RESTOREBITMAP	 psl_restorebitmap__
#   define PSL_PEAKFROMD    	 psl_peakfromd__
#   define PSL_PEAKTOD		 psl_peaktod__
#   define PSL_STRNGSRCH	 psl_strngsrch__
#endif
#ifdef  ONESCORE    /* naming convention in SGI f77 and gfortran */
#   define PSL_INIT     	 psl_init_
#   define PSL_TBLLOAD  	 psl_tblload_
#   define PSL_TBLLIST  	 psl_tbllist_
#   define PSL_ELEMSUB  	 psl_elemsub_
#   define PSL_ELEMCOUNT 	 psl_elemcount_
#   define PSL_SETBYNUMBER 	 psl_setbynumber_
#   define PSL_SETBYRANGE 	 psl_setbyrange_
#   define PSL_PEAKSUB  	 psl_peaksub_
#   define PSL_REPHITS  	 psl_rephits_
#   define PSL_REPHISTORY	 psl_rephistory_
#   define PSL_NEXTHIT  	 psl_nexthit_
#   define PSL_REPPDF1  	 psl_reppdf1_
#   define PSL_REPPDF2  	 psl_reppdf2_
#   define PSL_SAVEBITMAP	 psl_savebitmap_
#   define PSL_READBITMAP	 psl_readbitmap_
#   define PSL_STOREBITMAP	 psl_storebitmap_
#   define PSL_RESTOREBITMAP	 psl_restorebitmap_
#   define PSL_PEAKFROMD    	 psl_peakfromd_
#   define PSL_PEAKTOD		 psl_peaktod_
#   define PSL_STRNGSRCH	 psl_strngsrch_
#endif
#ifdef  NOSCORE     /* naming convention in HP fort77 */
#   define PSL_INIT     	 psl_init
#   define PSL_TBLLOAD  	 psl_tblload
#   define PSL_TBLLIST  	 psl_tbllist
#   define PSL_ELEMSUB  	 psl_elemsub
#   define PSL_ELEMCOUNT 	 psl_elemcount
#   define PSL_SETBYNUMBER 	 psl_setbynumber
#   define PSL_SETBYRANGE 	 psl_setbyrange
#   define PSL_PEAKSUB  	 psl_peaksub
#   define PSL_REPHITS  	 psl_rephits
#   define PSL_REPHISTORY	 psl_rephistory
#   define PSL_NEXTHIT  	 psl_nexthit
#   define PSL_REPPDF1  	 psl_reppdf1
#   define PSL_REPPDF2  	 psl_reppdf2
#   define PSL_SAVEBITMAP	 psl_savebitmap
#   define PSL_READBITMAP	 psl_readbitmap
#   define PSL_STOREBITMAP	 psl_storebitmap
#   define PSL_RESTOREBITMAP	 psl_restorebitmap
#   define PSL_PEAKFROMD	 psl_peakfromd
#   define PSL_PEAKTOD		 psl_peaktod
#   define PSL_STRNGSRCH	 psl_strngsrch
#endif

#ifdef  BIT16    /* 16-bit ints */
# define CHAR char
# define INTEGER4 long
# define INTEGER2 int
# define INTEGER1 char
# define REAL4 float
# define REAL8 double
#endif
#ifdef  BIT32    /* 32-bit ints */
# define CHAR char
# define INTEGER4 int
# define INTEGER2 short
# define INTEGER1 char
# define REAL4 float
# define REAL8 double
#endif
#ifdef  BIT64    /* 64-bit ints */
# define CHAR char
# define INTEGER4 int
# define INTEGER2 short
# define INTEGER1 char
# define REAL4 float
# define REAL8 double
#endif

/* for Microsoft Visual C++, define the __stdcall prefix */
#ifdef _MSC_VER
#  define MSFLAG __stdcall
#else
#  define MSFLAG 
#endif
