#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "logiclib.h"

/*  Program findnumber

    This program locates the entries that have PDF numbers within 
    a specified range or in a specified list.
    The resulting entries are applied to the specified bitmap using
    the selected boolean operation.

  Command syntax:
        findnumber <file>
	         [-list "<pos1>, <pos2> ..."]
		 [-range <start> <end>]
		 [ -or | -and | -remove | -not ]
    where 
       -list            precedes a list of entry numbers
       -range           precedes a list a starting and ending entry number
       -or -and -remove -not
                        logical options
*/

int main (int argc, char *argv[]) {
  INTEGER4 ilogic, retval, num1, num2;
  int j, jlist, range, error;
  error = 0;
  range = jlist = ilogic = -1;

  if (PSL_INIT() != 0) {
    fprintf(stderr,"error initializing the ICDD database\n");
    return 1;
  }

  j = 2;
  while (j < argc) {
    if (!strcmp(argv[j],"-list")) {
      j++;
      jlist = j;
    } else if (!strcmp(argv[j],"-range")) {
      range = 1;
      if (j+2 >= argc) {
	fprintf(stderr,"missing numbers after -range\n");
	error = 1;
      } else {
	j++;
	num1 = strtol(argv[j], NULL, 10);
	j++;
	num2 = strtol(argv[j], NULL, 10);
      } 
    } else if (!strcmp(argv[j],"-or") || !strcmp(argv[j],"-and") ||
	       !strcmp(argv[j],"-remove") || !strcmp(argv[j],"-not")) {
      if (ilogic != -1) {
	fprintf(stderr,
		"option -or -and -remove or -not repeated\n");
	error = 1;
      }
      if (!strcmp(argv[j],"-and"))
	ilogic = 0;
      else if (!strcmp(argv[j],"-or"))
	ilogic = 1;
      else if (!strcmp(argv[j],"-remove"))
	ilogic = 2;
      else if (!strcmp(argv[j],"-not"))
	ilogic = 3;
    } else {
      fprintf(stderr,"unknown option: %s\n",argv[j]);
      error = 1;
    }
    j++;
  }
  /* check that we have values for everything */
  if ((jlist == -1 && range == -1) || ilogic == -1) {
    fprintf(stderr,"required option missing\n");
    error = 1;
  } else if (jlist != -1 && range != -1) {
    fprintf(stderr,"-list and -range cannot be used together\n");
    error = 1;
  }
  /* now process the list */
  retval = -1;
  if ( jlist != -1  && !error) {
    int i,k;
    INTEGER4 *numlist = NULL;
    INTEGER4 numentries;
    INTEGER4 entry;
    numentries = ParseIntegerList(argv[jlist], &numlist);
    i = 0;
    for (k=0; k<numentries; k++) {
      entry = numlist[k];
      if (k >= 0 && k <= 1999999) {
	numlist[i] = entry;
	i++;
      } else {
	fprintf(stderr,"Ignoring invalid ICDD entry value: %d\n",entry);
      }
    }
    if (!error) {
      /*  Load the starting file */
      INTEGER4 il=4;    /* Replace bitmap */
      error = PSL_READBITMAP(argv[1],&il);
      if (error) {
	fprintf(stderr, "error reading subfile %s\n",argv[1]);
	return 1;
      }
      retval = PSL_SETBYNUMBER(&ilogic, numlist, &numentries);
    }
    if (numlist != NULL) free(numlist);

  } else if ( range != -1 && !error) {

    /*  Load the starting file */
    INTEGER4 il=4;    /* Replace bitmap */
    error = PSL_READBITMAP(argv[1],&il);
    if (error) {
      fprintf(stderr, "error reading subfile %s\n",argv[1]);
      return 1;
    }
    retval = PSL_SETBYRANGE(&ilogic, &num1, &num2);
  }

  if (retval == 0) {
    fprintf(stderr, "No valid entries were found\n");
    return 1;
  }

  if (error) {
    fprintf(stderr, "\nusage:\n");
    fprintf(stderr,
	    "\tfindnumber <file>\n");
    fprintf(stderr,
	    "\t\t[-list \"<ent#1>, <ent#2> ...\" | -range <start> <end>]\n");
    fprintf(stderr,
	    "\t\t[ -or | -and | -remove | -not ]\n");
    return 1;
  }

  error = PSL_SAVEBITMAP(argv[1]);
  if (error) {      
    fprintf(stderr, "error writing subfile %s\n",argv[1]);
  } else {
    INTEGER4 i = 0;
    printf("%d\n",PSL_REPHITS(&i) );
  }
  return 0;
}
