#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "logiclib.h"

/*  Program cmbfiles

    This program combines two files using the selected boolean operation.

  Command syntax:
        findnumber <file1> <file2>
		 [ -or | -and | -remove | -not ]
    where 
       -or -and -remove -not   logical options
       file1 is overwritten
*/

int main (int argc, char *argv[]) {
  INTEGER4 ilogic = -1;
  int error = 0;

  if (argc != 4) {
    error = 1;
  } else if (PSL_INIT() != 0) {
    fprintf(stderr,"error initializing the ICDD database\n");
    return 1;
  }
  

  if (!strcmp(argv[3],"-and"))
    ilogic = 0;
  else if (!strcmp(argv[3],"-or"))
    ilogic = 1;
  else if (!strcmp(argv[3],"-remove"))
    ilogic = 2;
  else if (!strcmp(argv[3],"-not"))
    ilogic = 3;
  else {
    fprintf(stderr,"unknown option: %s\n",argv[3]);
    error = 1;
  }

  /* check that we have a value for logic */
  if (ilogic == -1) {
    fprintf(stderr,"required option missing\n");
    error = 1;
  }

  /*  Load the starting file */
  if (!error) {
    INTEGER4 il=4;    /* Replace bitmap */
    error = PSL_READBITMAP(argv[1],&il);
    if (error) {
      fprintf(stderr, "error reading subfile %s\n",argv[1]);
      return 1;
    }
  }

  if (!error) {
  /*  Load the 2nd file */
    error = PSL_READBITMAP(argv[2],&ilogic);
    if (error) {
      fprintf(stderr, "error reading subfile %s\n",argv[2]);
      return 1;
    }
  }

  if (error) {
    fprintf(stderr, "\nusage:\n");
    fprintf(stderr,
	    "\tcmbfiles <file1> <file2>\n");
    fprintf(stderr,
	    "\t\t[ -or | -and | -remove | -not ]\n");
    return 1;
  }

  error = PSL_SAVEBITMAP(argv[1]);
  if (error) {
    fprintf(stderr, "error writing subfile %s\n",argv[1]);
  } else {
    INTEGER4 i = 0;
    printf("%d\n",PSL_REPHITS(&i) );
  }
  return 0;
}
