      SUBROUTINE SMI10(D,N)
      parameter(nparam=40)
      real*8 D(nparam,nparam),S(nparam),denom
c
      do j=1,n
	do i=1,j
	  d(i,j)=-d(i,j)
	  d(j,i)=d(i,j) 
	enddo
	d(j,j)=1.+d(j,j)
      enddo
      do lr=1,n 
	denom=1.-d(lr,lr)
        if(abs(denom).lt.1.0e-15)then
	  write (*,*) 'Matrix Singular'
	  denom=1.0e-15
	end if
	d(lr,lr)=1.0/denom
        do j=1,n 
          s(j)=d(lr,j) 
          if((j-lr).ne.0) then
	    d(j,lr)=d(j,lr)*d(lr,lr)
	    d(lr,j)=d(j,lr) 
          endif
	enddo
	do j=1,n 
	  if(j.ne.lr)then
	    do i=1,j
	      if(i.ne.lr) then
		d(i,j)=d(i,j)+d(i,lr)*s(j)
		d(j,i)=d(i,j) 
	      endif
	    enddo
	  endif
	enddo
      enddo
      return
      end 
