      SUBROUTINE SGPRNT(SPG,JRT,LAUENO,NAXIS,NCENT,LCENT,NSYM,NPOL
     1  ,CEN,NCV,LPT)

!      INCLUDE '../inclds/COPYRIGT.FOR'

C       This program was developed for
C                    The Division of Chemistry
C                               of
C               The National Research Council of Canada
C                               by
C       Allen C. Larson, 14 Cerrado Loop, Santa Fe, NM 87505, USA

      CHARACTER*20      SPG
      INTEGER*4      JRT(3,5,24)
      REAL*4            CEN(3,4)
      CHARACTER*4      XYZ(12)
      CHARACTER*4      TRA(12)
      CHARACTER*4      OUTL(3,2,3)
      INTEGER*4      KSYM(3)            !Symmetry operator number for output
      CHARACTER*12      LTYP(7)
      CHARACTER*2      NC(2)
      CHARACTER*12      SYST(8)
      CHARACTER*3      POLAR(8)
      CHARACTER*1    NAX(3)
      INTEGER*4      NSYS(14)
      CHARACTER*6      LAUE(14)
      DATA      XYZ      /'-Z  ','-Y  ','-X  ','X-Y ','ERR ','Y-X ',
     1  ' X  ',' Y  ',' Z  ','+X  ','+Y  ','+Z  '/
      DATA      TRA      /'    ','ERR ','1/6 ','1/4 ','1/3 ','ERR ',
     1  '1/2 ','ERR ','2/3 ','3/4 ','5/6 ','ERR '/
      DATA      LTYP      /'  primitive ',' A-centered ',' B-centered ',
     1  ' C-centered ',' I-centered ',' F-centered ',
     1  ' R-centered '/
      DATA      SYST      /'triclinic   ','monoclinic  ','orthorhombic',
     1  'tetragonal  ','trigonal    ','trigonal    ',
     1  'hexagonal   ','cubic       '/
!                   1      2      3      4       5      6       7
      DATA LAUE/'1bar','2/m ','mmm ','4/m ','4/mmm','3bar','3bar m',
     1  '3bar','3barm1','3bar1m','6/m ','6/mmm','m 3 ','m3m'/
!                 8       9       10      11      13     14     15
      DATA POLAR/'x','y','x y','z','x z','y z','xyz','111'/
      DATA NAX/'a','b','c'/
      DATA NSYS/1,2,3,4,4,5,5,6,6,6,7,7,8,8/
      DATA NC/' a',' '/

      MULT = NCV*NSYM*(NCENT+1)
      LSYS = NSYS(LAUENO)
      NPX = 1                                              !Assume X is indeterminate
      NPY = 2                                                !Assume Y is indeterminate
      NPZ = 4                                                !Assume Z is indeterminate
      NPXYZ = 0                                          !Assume no 3-axis along [1,1,1]
      NPYXZ = 1                                        !Assume origin undefined along [1,1,1]
      DO I=1,NSYM                                          !Determine presence of indeterminate origin
        IF ( JRT(1,1,I).LE.0 ) NPX=0                              !Origin is defined along X
        IF ( JRT(2,2,I).LE.0 ) NPY=0                              !Origin is defined along Y
        IF ( JRT(3,3,I).LE.0 ) NPZ=0                              !Origin is defined along Z
        IF ( JRT(1,3,I).GT.0 ) NPXYZ=8                        !There is a 3-axis along [1,1,1]
        IF ( JRT(1,3,I).LT.0 ) NPYXZ=0                        !Origin is defined along [1,1,1]
      END DO
      NPOL = (NPX+NPY+NPZ+NPXYZ*NPYXZ)*(1-NCENT)                  !Set the indeterminate origin flag
      IF ( LPT.LE.0 ) RETURN
      WRITE (LPT,1) SPG,NC(NCENT+1)(1:2-NCENT),LTYP(LCENT)
     1  ,SYST(LSYS),LAUE(LAUENO),MULT
1     FORMAT (/' Space group ',A/
     1  ' The lattice is',A,'centric ',2A,'  Laue symmetry ',A6/
     1  '  Multiplicity of a general site is',I4)
      IF ( NAXIS.GT.0 ) WRITE(LPT,2)NAX(NAXIS)
2     FORMAT ('  The unique axis is ',A1)
      IF ( NCENT.EQ.1 ) WRITE (LPT,'(A)') '  The symmetry of the '//
     1  'point 0,0,0 contains 1bar'
      IF ( NPOL.GT.0 ) WRITE(LPT,3)POLAR(NPOL)
3     FORMAT ('  The location of the origin is arbitrary in ',A)
      WRITE (LPT,4)
4     FORMAT (/' The equivalent positions are:'/)
      KI = 1
      KL = 2
      IF ( LAUENO.GT.5 ) KL=3
      DO I=1,NSYM
        DO J=1,3
          IJ = 2*JRT(J,1,I)+3*JRT(J,2,I)+4*JRT(J,3,I)+5
          IK = JRT(J,4,I)+1
          IF ( IK.GT.1.AND.IJ.GT.5 ) IJ=IJ+3
          OUTL(J,2,KI) = XYZ(IJ)
          OUTL(J,1,KI) = TRA(IK)
        END DO
        KSYM(KI) = I
        KI = KI+1
        IF ( KI.GT.KL ) THEN
          WRITE (LPT,6) (KSYM(K),(OUTL(I1,1,K),OUTL(I1,2,K),I1=1,3),
     1      K=1,KL)
6         FORMAT (3(1X,'(',I2,')',3(1X,2A3):))
          KI = 1
        END IF
      END DO
      IF ( LAUENO.EQ.1 )
     1  WRITE (LPT,6) 1,(OUTL(I,1,1),OUTL(I,2,1),I=1,3)
      WRITE (LPT,5)
5     FORMAT (' ')
      RETURN
      END
