      real*4 function profval(tphi,tthpk,eta,gamma,det,sam,dis,deriv)
      implicit none
c
c Arguments
c
c               profval         !Value of profile function - output
      real*4    tphi            !Two phi value to do evaluation
      real*4    tthpk           !Two theta (Deg) of peak
      real*4    eta             !Pseudo-Voigt mixing coefficient
      real*4    gamma           !peak FWHM
      real*4    det             !Half height of detector
      real*4    sam             !Half height of illuminated region of sample
      real*4    dis             !Sample to detector distance
      real*4    deriv(3)        !Array to be filled with derivatives of
				! profile value with respect to gamma, eta, 
				! and tthpk
c
c Local Variables for Gaussian Integration
c
      integer*4 ifirst/0/       !Non-zero after first entry
      integer*4 ngt             !number of terms in Gaussian quadrature
      integer*4 ngtsav/0/       !number of terms in previous Gaussian table
      integer*4 nfar,ngtc,ngtf
      parameter (ngtc=1000)     ! MUST be even
      parameter (ngtf=6)        ! MUST be even and less than ngtc
      real*4    xp(ngtc,2)      !Gaussian abscissas 
      real*4    wp(ngtc,2)      !Gaussian weights 
      save ngtsav,xp,wp         !Values to be saved across calls
      save ifirst
c        
c Other Local Variables
c
      real*4 cosd,sind,acosd      
      real*4 cg/0.939437279/    !Normalization constant 2*sqrt(ln 2/pi)
      real*4 arg/1.66510922/    ! 4 ln 2
      real*4 cl/0.636619772/    ! 2/pi
      real*8    arg1            ! Scratch variable
      real*8    arg2            ! Scratch Variable
      real*4    emin            !2phi(min)
      real*4    einfl           !2phi(infl)
      real*4    zh,zhp,zht      !h(2phi), h(2phi)*cos(2phi),h(2phi)*cos(2theta)
      real*4    dfunc,wfunc     !D and W
      real*4    delta           !actual value of evaluation for integration
      real*4    sumd            !normalizing constant for integration
      real*4    gaus,alor       !partial sums of Gaussian and Lorentzian comp.
      real*4    del2ti
      real*4    dhdtth          !derivative of h wrt two theta
      real*4    dadtth,dgdtth,dadgamma,dgdgamma
      real*4    dsumdtth,dddtth,dedtth
      real*4    ddeldtth,gpart,apart
      integer*4 k               !loop counter
      save cg,arg,cl
c
c Routine uses Van Laar and Yelon peak shapes - J. Appl. Cryst. 17,47(1984) 
c   as modified by Finger, Cox and Jephcoat, J. Appl. Cryst. 27,892(1992)
c    (Referred to below as FCJ)
c
c
c First time through - get Gaussian intervals and weights for integration
c   far from peak
c
      if(ifirst.eq.0)then
          call gauleg(-1.,1.,xp(1,2),wp(1,2),ngtf)
          ifirst = 1
      endif
c
c calculate 2phi(min) and 2phi(infl) [FCJ, eq. 4 & 5]
c
      arg1=sqrt((dble(det+sam)/dis)**2+1.0d0)*cosd(tthpk)
      arg2=sqrt((dble(det-sam)/dis)**2+1.0d0)*cosd(tthpk)
      if(arg1 .le. 1.0d0)then
	emin=acosd(arg1)
	dedtth = sind(tthpk)*arg1/(sind(emin)*cosd(tthpk))
      else
	emin = 0.0
	dedtth = 0.0
      endif
      if(arg2 .le. 1.0d0)then
	einfl=acosd(arg2)
      else
	einfl = 0.0
      endif             
c
c Gaussian Quadrature - number of points must be large enough so that the
c   interval between 2phi(min) and 2theta must be divided into steps no
c   larger than 0.005 degrees.  LWF  8/10/95
c
c Determine which Gauss-Legendre Table to use
c      
      if(abs(tthpk-tphi)/gamma.gt. 8.0)then
	nfar = 2
	ngt = ngtf
      else
	nfar = 1
c
c Calculate desired number of intervals - MUST BE EVEN
c
        k = max(ngtf,min(int((tthpk - emin) * 100.0)*2,ngtc))
        if(k.ne.ngtsav)then
            call gauleg(-1.,1.,xp(1,1),wp(1,1),k)
            ngtsav = k
        endif
c
	ngt = ngtsav
      endif
c
      gaus = 0.0
      alor = 0.0
      sumd = 0.0
      dgdtth = 0.0
      dgdgamma = 0.0
      dadtth = 0.0
      dadgamma = 0.0
      dsumdtth = 0.0
c
c Convolution integral between a = 2phi(min) and b = 2theta
c
      do k=ngt/2+1,ngt
	delta = emin + (tthpk - emin) * xp(k,nfar)      ! Delta
	del2ti = tphi - delta
	ddeldtth = dedtth + (1.0 - dedtth)*xp(k,nfar)
c
c Calculate vertical coordinate of intersection of diffraction cone with
c      the detector cylinder  [ FCJ eq. 1]
c
	zh = dis*sqrt((cosd(delta)/cosd(tthpk))**2-1.0)
	zhp = zh*cosd(delta)
	zht = zh*cosd(tthpk)
	if(zht.lt.1.0e-15)zht=1.0e-15
	if(zhp.lt.1.0e-15)then
c
c handle case where h*cos(2phi) blows up
c
	  zh = 1.0e-15
	  zhp = zh
	  dhdtth = 0.0
	else
c
c Get derivative of h wrt 2theta and s
c
	  dhdtth = dis**2 * zh**2 * (cosd(delta)**2 * sind(tthpk) 
     1      - sind(delta)*cosd(tthpk)*cosd(delta)*ddeldtth) 
     2      /zht**3
	endif
c
c Calculate W(Delta,2theta)  [ FCJ eq. 7(a) and 7(b) ]
c
	if(delta.gt.einfl)then
	  if (sam .le. det) then
	    wfunc=2.0*sam
	  else
	    wfunc = 2.0 * det
	  endif
	else
	  wfunc=det+sam-zh
	endif
c
c Calculate D(Delta,2theta)  [ FCJ eq. 6 ]
c
	dfunc=wp(k,nfar)*wfunc/(zh*cosd(delta))
	dddtth = wp(k,nfar)*wfunc*(zh*sind(delta)*ddeldtth 
     1   - cosd(delta)*dhdtth)/zhp**2
c
c Only calculate Gaussians to 6 Gamma
c
	if(abs(del2ti/gamma).le. 6.0)then
	  gpart = exp(-(del2ti*arg/gamma)**2)
	  gaus=gaus + dfunc * gpart
	  dgdgamma = dgdgamma + 2.0 * dfunc * gpart * arg**2
     1      * del2ti**2/gamma**3
	  dgdtth = dgdtth + gpart * (dddtth
     1          + 2.0 * dfunc * del2ti * arg**2 * ddeldtth/gamma**2)
	endif
c
c Sum Lorentzian portion
c
	apart = 1.0/(gamma**2+4.0*del2ti**2)
	alor = alor + dfunc * apart
	dadgamma = dadgamma - 2.0 * dfunc * gamma * apart**2
	dadtth = dadtth + dddtth * apart
     1     + 8.0 * dfunc * del2ti * ddeldtth * apart**2
c
c Accumulate Normalization Factor - denominator of FCJ eq. 9.
c
	sumd = sumd + dfunc
	dsumdtth = dsumdtth + dddtth
      end do 
c
c Calculate Derivatives for Normalized Lorentzian and Gaussian parts
c
      dadtth = dadtth * cl * eta * gamma**2
      dgdtth = dgdtth * cg * (1.0 - eta)
c      
c calculate final value and output derivatives wrt gamma, eta, 2theta and S
c
      profval = (cl*eta*gamma**2*alor + cg*(1.-eta)*gaus)/sumd
      deriv(1) = (cl * eta * (2.0 * alor * gamma + gamma**2 * dadgamma)
     1  + cg * (1.0 - eta) * dgdgamma)/sumd
      deriv(2) = (cl * gamma**2 * alor - cg * gaus)/sumd
      deriv(3) = (dadtth+dgdtth-profval*dsumdtth)/sumd
      return
      end 
	REAL FUNCTION COSD(X)
	REAL*4 X
	COSD = COS(X * 3.14159265 / 180.)
	RETURN
	END
	REAL FUNCTION SIND(X)
	REAL*4 X
	SIND = SIN(X * 3.14159265 / 180.)
	RETURN
	END
	REAL*4 FUNCTION ACOSD(X)
	REAL*8 X
	ACOSD = ACOS(X) * 180. / 3.14159265
	RETURN
	END
