      SUBROUTINE SRTLIN(ISTYG)
C
C
C     THIS SUBPROGRAM SORTS THE TWOTHETA-,D- OR Q-VALUES (POSSIBLY
C     TOGETHER WITH INTENSITIES).THE TWOTHETA- OR Q-VALUES ARE PUT IN
C     INCREASING ORDER,THE D-VALUES IN DECREASING ORDER.
C
C     ISTYG=1 - DATA ARE TWOTHETA- OR Q-VALUES (TO PUT IN INCREASING
C               ORDER).
C     ISTYG=0 - DATA ARE D-VALUES (TO PUT IN DECREASING ORDER).
      CHARACTER NAME*80,CARD*80,INTSY*2,IINT*2
      COMMON /LINES / IDOC,INP,IOUT,NCRT,MAX,OBS(40),CEL(10)
      COMMON /CHARCM/ NAME,CARD,INTSY(50)
C
      FAKTOR=1.0
      IF(ISTYG.EQ.0)FAKTOR=-1.0
   20 IEIND=MAX-1
C
      DO 70 I=1,IEIND
      IF(FAKTOR*(OBS(I+1)-OBS(I)) .GT. 0.01) GO TO 70
      OBSTR=OBS(I+1)
      IINT=INTSY(I+1)
      DO 40 J=1,I
      IF(FAKTOR*(OBSTR-OBS(J)) .LT. 0.0) GO TO 50
   40 CONTINUE
C
   50 MEIND=I+1-J
C
      DO 60 M=1,MEIND
      K=I+1-M
      OBS(K+1)=OBS(K)
      INTSY(K+1)=INTSY(K)
   60 CONTINUE
      OBS(J)=OBSTR
      INTSY(J)=IINT
   70 CONTINUE
      DO 80 I=1,IEIND
      IF (ABS(OBS(I+1)-OBS(I) ) .GT. 0.0001) GO TO 80
      WRITE(IOUT,99) OBS(I)
      OBS(I+1)=OBS(MAX)
      INTSY(I+1)=INTSY(MAX)
      MAX=MAX-1
      GO TO 20
   80 CONTINUE
C
      RETURN
   99 FORMAT(41H0XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX   /
     * 17H THE INPUT VALUE  ,F10.5, 15H APPEARS TWICE   /
     * 27H           CHECK YOUR INPUT    /
     * 41H XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX   )
      END
      SUBROUTINE SRTSYM
*  SORTS THE POSSIBLE HIGH-SYMMETRICAL LATTICES ON THE NUMBER
*  OF INDEXED LINES.
*  IF THE NUMBER OF INDEXED LINES IS THE SAME, CHOOSE THE CELL
*  WITH THE SMALLEST VOLUME.
*  PUTS THE BEST LATTICE IN POSITION 1.
*
      LOGICAL ZERREF
      COMMON /HISYM / ZERREF,ISOL,SYMCON(12,6),NMATCH(45)
      NINDXD=0
      N=0
      DO 100 I=1,12
         IF (SYMCON(I,3) .LT. 0.1 ) GO TO 100
         N=N+1
         IND=NINT( SYMCON(I,4) )
         IF (IND .LT. NINDXD) THEN
            GO TO 100
         ELSE IF (IND .GT. NINDXD) THEN
            NINDXD=IND
            KBEST=I
         ELSE IF (IND .EQ. NINDXD) THEN
            IF (SYMCON(I,6) .LT. SYMCON(KBEST,6) ) KBEST=I
         END IF
  100 CONTINUE
      IF (N .GT. 0) THEN
         DO 120 J=1,6
         SYMCON(1,J)=SYMCON(KBEST,J)
  120 CONTINUE
      END IF
      RETURN
      END
      SUBROUTINE SRTZON(NSRT,NR,NZ2)
C--THE SUBROUTINE SORTS ZONES THAT ARE STORED IN ARRAY  *STORE*
C--SORTING WILL BE DONE ON ELEMENT *NSRT*, WHICH CAN BE EITHER 4
C--OR 7. IN THE LATTER CASE WE MAKE A DOUBLE SORT ON ELEMENT 8.
C---------------------------------------------------------------------
C  CHANGED: 250485
C  CHANGED: 270493, ADDED NCRT
C  CHANGED: 071193, DELETED NCRT-OUTPUT
C---------------------------------------------------------------------
      LOGICAL SELF,ENL,TEST,EXCH,ABSNT
      CHARACTER NAME*80,CARD*80,INTSY*2,SNAME*70
      COMMON /CHARCM/ NAME,CARD,INTSY(50)
      COMMON /PARMS / TOL2,TOL3,WAVEL,FMINEQ,FMINIM,SELF,ENL,TEST,LIST,
     *                NSYST(3),OBSMT(40),OBSPT(40),TWTHET(40),TOLG
      COMMON /LINES / IDOC,INP,IOUT,NCRT,MAX,OBS(40),CEL(10)
      COMMON /CONSTS/ NSUMM,RAD,TWORAD,RRAD,HLFLAM,WAVSQR,STORE(200,9)
      IF (ENL) WRITE(IOUT,9910) NAME
      SNAME=NAME
C--FIRST FIND LARGEST ELEMENT
      N=1
  460 U=-100.
      DO 470 M=N,NR
         IF (STORE(M,NSRT) .GT. U) THEN
            U=STORE(M,NSRT)
            NRM=M
         END IF
  470 CONTINUE
C--PUT LARGEST ELEMENT IN PROPER POSITION
      DO 480 M=1,9
         U=STORE(N,M)
         STORE(N,M)=STORE(NRM,M)
  480 STORE(NRM,M)=U
      IF (ENL) WRITE(IOUT,9911) N,(STORE(N,I),I=1,8),TWORAD*STORE(N,9)
      N=N+1
      IF (N .LE. NR) GO TO 460
C-----------------------------------------------------------------------
C--END OF SORT ON QUALITY. NOW SEARCH FOR *EQUAL* ZONES.
C--STORE ONLY THE *UNIQUE* ZONES IN  *STORE*
C  ---------------------------------------------------------------------
      IF (NSRT .EQ. 7) GO TO 580
C--THE *EQUAL* ZONES NEED TO BE THROWN AWAY ONLY ONCE.
      NUNIQ=1
      DO 560 I=2,NR
C--CHECK WHETHER THIS ZONE IS ALREAY PRESENT IN THE  *UNIQUE*  SET.
         ABSNT=.TRUE.
         DO 520 J=1,NUNIQ
            U=.0
            DO 510 K=1,3
  510       U=U+ABS(STORE(I,K)-STORE(J,K))
            IF (U .LT. FMINEQ) ABSNT=.FALSE.
  520    CONTINUE
C--IF ABSENT THEN ADD THIS ZONE
         IF (ABSNT) THEN
            NUNIQ=NUNIQ+1
            DO 530 K=1,9
  530       STORE(NUNIQ,K)=STORE(I,K)
         END IF
  560 CONTINUE
      STORE(NUNIQ+1,1)=.0
      NR=MIN(NUNIQ,(NZ2+2) )
      GO TO 750
C--MAKE THE DOUBLE SORT ON NC (NO HAS BEEN SORTED ON)
  580 NSRT1=NSRT+1
  600 EXCH=.FALSE.
      DO 700 I=1,NR
      IF ( (STORE(I,NSRT)-STORE(I+1,NSRT) ) .GT. 0.1 ) GO TO 700
      IF ( (STORE(I,NSRT1)-STORE(I+1,NSRT1) ) .GT. 0.1 ) THEN
         DO 610 K=1,9
            U=STORE(I+1,K)
            STORE(I+1,K)=STORE(I,K)
  610       STORE(I,K)=U
         EXCH=.TRUE.
      END IF
  700 CONTINUE
      IF (EXCH) GO TO 600
      NR=MIN( NR,(NZ2+2) )
  750 WRITE(IOUT,9912) NAME
C     WRITE(NCRT,9914) SNAME
      WRITE(IOUT,9911) (I,(STORE(I,J),J=1,8),TWORAD*STORE(I,9),I=1,NR)
C     WRITE(NCRT,9911) (I,(STORE(I,J),J=1,8),TWORAD*STORE(I,9),I=1,NR)
      WRITE(IOUT,9913)
      RETURN
 9910 FORMAT(///,20X,A80 / 1H ,40(3H---) /
     *       ' ZONES AFTER EVALUATION, IN DESCENDING ORDER OF ' ,
     1  ' RELIABILITY'///
     2  ' NEWNR    A       B     FMAAS       QUALITY   OLDNR CENTER ',
     3  ' NOBS  NCALC  ZEROSHIFT' / )
 9911 FORMAT(1H , I4, 3F8.1,2X,F14.1, 4F6.0, F10.4)
 9912 FORMAT(///,20X,A80 / 1H ,40(3H---) /
     1       38H0ZONES SELECTED FOR FURTHER REFINEMENT  ///
     2 ' NEWNR    A       B     FMAAS       QUALITY   OLDNR CENTER ',
     3 ' NOBS  NCALC  ZEROSHIFT ')
 9913 FORMAT(////47H NOTE--SOME OF THESE ZONES ARE PROBABLY CORRECT,
     *56H EVEN IF THE PROGRAM FAILS TO BUILD A PLAUSIBLE LATTICE ,
     *11H FROM THEM.)
 9914 FORMAT(///,A70 / 1H ,35(2H--) /
     1  20X, 38H ZONES SELECTED FOR FURTHER REFINEMENT  //
     2 ' NEWNR    A       B     FMAAS       QUALITY  OLDNR CENTER ',
     3 ' NOBS  NCALC ZEROSHIFT')
      END
      SUBROUTINE SYMPRT
C  SYMPRT WILL PRINT THE LIST OF ALL LINES OF A SYMMETRIC LATTICE,
C  E.G. A TETRAGONAL,HEXAGONAL OR CUBIC LATTICE.
      CHARACTER NAME*80,CARD*80,SNAME*70,INTSY*2
      LOGICAL ZERREF
      COMMON /LINES / IDOC,INP,IOUT,NCRT,MAX,OBS(40),CEL(10)
      COMMON /CHARCM/ NAME,CARD,INTSY(50)
      COMMON /CONSTS/ NSUMM,RAD,TWORAD,RRAD,HLFLAM,WAVSQR,STORE(200,9)
      COMMON /HISYM / ZERREF,ISOL,SYMCON(12,6),NMATCH(45)
      SNAME=NAME
      WRITE(IOUT,9950) NAME
      WRITE(NSUMM,9982) SNAME
      ISOL=1
      CALL REFSYM
      CALL LISTM
      QX=SYMCON(1,1)
      QZ=SYMCON(1,2)
      NSYM=NINT(SYMCON(1,3) )
      A=100./SQRT(QX)
      C=100./SQRT(QZ)
      IF (NSYM .EQ. 3) THEN
         WRITE(IOUT ,9943) QX,A
         WRITE(NSUMM,9943) QX,A
C        WRITE(NCRT ,9943) QX,A
      ELSE IF (NSYM .EQ. 4) THEN
         WRITE(IOUT ,9944) QX,QZ,A,C
         WRITE(NSUMM,9944) QX,QZ,A,C
C        WRITE(NCRT ,9944) QX,QZ,A,C
      ELSE IF (NSYM .EQ. 5) THEN
        A=200./SQRT(3.*QX)
        WRITE(IOUT ,9945) QX,QZ,A,C
        WRITE(NSUMM,9945) QX,QZ,A,C
C       WRITE(NCRT ,9945) QX,QZ,A,C
      ELSE IF (NSYM .EQ. 6) THEN
        A=200./SQRT(3.*QX)
        WRITE(IOUT ,9946) QX,QZ,A,C
        WRITE(NSUMM,9946) QX,QZ,A,C
C       WRITE(NCRT ,9946) QX,QZ,A,C
      END IF
      WRITE(IOUT ,9947) SYMCON(1,6), SYMCON(1,5)
      WRITE(NSUMM,9947) SYMCON(1,6), SYMCON(1,5)
C     WRITE(NCRT ,9947) SYMCON(1,6), SYMCON(1,5)
      WRITE(NSUMM,9960) SNAME
      WRITE(IOUT ,9961) NAME
      WRITE(IOUT,9948)
      WRITE(NSUMM,9948)
      RETURN
 9943 FORMAT(2X/' CUBIC  INDEXING '/
     1       ' THE RECIPROCAL CONSTANT (QX) IS  ',F10.2 /
     2  ' THE DIRECT CONSTANT IS    A=',F10.4 )
 9944 FORMAT(2X/' TETRAGONAL INDEXING '/
     1       ' RECIPROCAL CONSTANTS (QX,QZ) ARE ',2F10.2 /
     2  ' THE DIRECT CONSTANTS ARE  A=',F10.4,'  C=',F10.4 )
 9945 FORMAT(2X/' RHOMBOHEDRAL INDEXING ON HEXAGONAL AXES '/
     1       ' RECIPROCAL CONSTANTS (QX,QZ) ARE ',2F10.2 /
     2  ' THE DIRECT CONSTANTS ARE  A=',F10.4,'  C=',F10.4 )
 9946 FORMAT(2X/' HEXAGONAL INDEXING  '/
     1       ' RECIPROCAL CONSTANTS (QX,QZ) ARE ',2F10.2 /
     2  ' THE DIRECT CONSTANTS ARE  A=',F10.4,'  C=',F10.4 )
 9947 FORMAT(' VOLUME = ',F9.1 ,'   ZEROSHIFT=',F8.4 )
 9948 FORMAT(// 5X,12(4HWWWW)/
     *  '     W   WARNING:  THE TRUE CELL CAN BE A           W' /
     1  '     W           SIMPLE SUB- OR SUPERLATTICE        W' /
     2  '     W             OF THE CELL GIVEN HERE.          W' /
     3  5X,12(4HWWWW)  )
 9950 FORMAT(1H1,20X,A80/ 40(3H---) )
 9960 FORMAT(//,1X,A70)
 9961 FORMAT(//,1X,A80)
 9982 FORMAT(2X///1H ,A70/35(2H--)/' INDEXED ON HIGH-SYMMETRY LATTICE')
      END
      SUBROUTINE SYMTST
C  SUBROUTINE SYMTEST TRIES TO FIND OUT WHETHER THE LATTICES FOUND
C  ARE LATTICES OF A HIGHER SYMMETRY IN DISGUISE.
C  CHANGED:  15 OCT. 1985,  REFINING HIGH-SYMM. LATTICES
C  CHANGED:  270493  ADDED NCRT+OUTPUT
C  CHANGED:  071193  DELETED NCRT-OUTPUT
      CHARACTER*12  TEXT(2)
      INTEGER  H
      LOGICAL SELF,ENL,TEST,ZERREF
      COMMON /LINES / IDOC,INP,IOUT,NCRT,MAX,OBS(40),CEL(10)
      COMMON /PARMS / TOL2,TOL3,WAVEL,FMINEQ,FMINIM,SELF,ENL,TEST,LIST,
     *                NSYST(3),OBSMT(40),OBSPT(40),TWTHET(40),TOLG
      COMMON /CONSTS/ NSUMM,RAD,TWORAD,RRAD,HLFLAM,WAVSQR,STORE(200,9)
      COMMON /HISYM / ZERREF,ISOL,SYMCON(12,6),NMATCH(45)
      DATA TEXT/' IS PROBABLY','   MIGHT BE '/
      NPASS=0
      SYMCON(ISOL,3)=0
      A=CEL(1)
      B=CEL(2)
      C=CEL(3)
      E=CEL(5)
      DIFMIN=FMINEQ
      IF (CEL(4)+ABS(CEL(6)) .GT. FMINEQ) GO TO 3010
C-----------------------------------------------------------------------
C  THE MONOCLINIC LATTICES ARE TESTED BETWEEN HERE AND LABEL 1000,
C  THE ORTHORHOMBIC LATTICES ARE TESTED BETWEEN LABELS 1000 AND 3000,
C  THE TRICLINIC LATTICES ARE TESTED AFTER LABEL 3000.
C-----------------------------------------------------------------------
   5  DIFMIN=3.0*DIFMIN
      NPASS=NPASS+1
      IF ( E .LT. FMINEQ) GO TO 1000
C  THE NEXT PART   FINDS OUT WHETHER A MONOCLINIC LATTICE IS A DISGUISED
C  RHOMBOHEDRIC LATTICE.
      IF (ABS(E-2.*B) .GT. DIFMIN) GO TO 20
      IF (ABS(C-3.*B) .GT. DIFMIN) GO TO 10
      X=(B+C+E)/18.
      Z=A-X
      GO TO 200
   10 IF (ABS(A-3.*B) .GT. DIFMIN) GO TO 20
      X=(A+B+E)/18.
      Z=C-X
      GO TO 200
   20 IF (ABS(A+B-C) .GT. DIFMIN) GO TO 30
      IF (ABS(2.*ABS(B-A)-E).GT.DIFMIN) GO TO 30
      X=(C-A)/6.+B/6.
      Z=(C+2.*A-2.*B)/3.
      GO TO 200
   30 IF (ABS(B+C-4.*A).GT. DIFMIN) GO TO 40
      IF (ABS(E-ABS(B-C)) .GT. DIFMIN) GO TO 40
      Z=(C-A)/3.
      X=B/6.+(4.*A-C)/6.
      GO TO 200
   40 IF (ABS(2.*C-3.*E).GT.DIFMIN) GO TO 50
      IF (ABS(2.*B+E-6.*A).GT. DIFMIN*FLOAT(NPASS) ) GO TO 50
      Z=(C+E)/15.
      X=(A-Z)/2+B/6.
      GO TO 200
   50 IF (ABS(2.*A-3.*E) .GT. DIFMIN) GO TO 60
      IF (ABS(2.*B+E-6.*C).GT. DIFMIN*FLOAT(NPASS) ) GO TO 60
      Z=(A+E)/15.
      X=(C-Z)/2. +B/6.
      GO TO 200
   60 IF (NPASS .EQ. 1) GO TO 5
      GO TO 3010
  200 IF (Z .LT. 1.) RETURN
      WRITE(IOUT,900)  (CEL(J),J=1,6)
      WRITE(NSUMM,930) (CEL(J),J=1,6)
C     WRITE(NCRT ,930) (CEL(J),J=1,6)
      A=200./SQRT(B)
      C=100./SQRT(Z)
      WRITE(IOUT ,901) TEXT(NPASS), X,Z, A, C
      WRITE(NSUMM,931) TEXT(NPASS), X,Z, A, C
C     WRITE(NCRT ,931) TEXT(NPASS), X,Z, A, C
      IF (CEL(9) .LT. 6) THEN
         X=4.*X
         A=0.5*A
         WRITE(IOUT ,902) X,A
         WRITE(NSUMM,902) X,A
C        WRITE(NCRT ,902) X,A
      END IF
      SYMCON(ISOL,1)=X
      SYMCON(ISOL,2)=Z
      SYMCON(ISOL,3)=5
C
C  THE VALUES OF SYMCON(I,3) ARE RESERVED AS FOLLOWS: 3 FOR CUBIC,
C  4 FOR TETRAGONAL, 5 FOR RHOMBOHEDRAL AND 6 FOR HEXAGONAL LATTICES.
C
      CALL REFSYM
      RETURN
C
C-----------------------------------------------------------------------
C                ORTHORHOMBIC LATTICES FROM HERE TO 3000
C-----------------------------------------------------------------------
C
 1000 DO 1200 I=1,2
      J=3-I
      G=CEL(J)
      H=INT(A/G+0.5 )
      K=INT(B/G+0.5 )
      L=INT(C/G+0.5 )
      IH=0
      IK=0
      IL=0
      IF (ABS(A-G*FLOAT(H)) .LT. DIFMIN) IH=1
      IF (ABS(B-G*FLOAT(K) ) .LT. DIFMIN) IK=1
      IF (ABS(C-G*FLOAT(L) ) .LT. DIFMIN) IL=1
      II=IH+IK+IL -2
      IF (II) 1200,1020,1010
 1010 WRITE(IOUT,900)  (CEL(J),J=1,6)
      WRITE(NSUMM,930)  (CEL(J),J=1,6)
      X=100./SQRT(G)
      WRITE(IOUT, 911) TEXT(NPASS),G,X
      WRITE(NSUMM,941) TEXT(NPASS),G,X
C     WRITE(NCRT ,941) TEXT(NPASS),G,X
C  LATTICE IS CUBIC
      SYMCON(ISOL,1)=G
      SYMCON(ISOL,2)=G
      SYMCON(ISOL,3)=3
      CALL REFSYM
      RETURN
 1020 IF (IK*IL .EQ. 0) GO TO 1050
      N=L/K
      X=B
      Z=A
      GO TO 1150
 1050 IF (IH*IL .EQ. 0) GO TO 1100
      N=L/H
      X=A
      Z=B
      GO TO 1150
 1100 N=H/K
      X=B
      Z=C
 1150 WRITE(IOUT,900)  (CEL(J),J=1,6)
      WRITE(NSUMM,930)  (CEL(J),J=1,6)
C     WRITE(NCRT ,930)  (CEL(J),J=1,6)
      A=100./SQRT(X)
      C=100./SQRT(Z)
      IF (N-3) 1160,1170,1180
 1160 WRITE(IOUT ,912) TEXT(NPASS),X,Z, A,C
      WRITE(NSUMM,942) TEXT(NPASS),X,Z, A,C
C     WRITE(NCRT ,942) TEXT(NPASS),X,Z, A,C
C  LATTICE IS TETRAGONAL
      SYMCON(ISOL,1)=X
      SYMCON(ISOL,2)=Z
      SYMCON(ISOL,3)=4
      CALL REFSYM
      RETURN
 1170 A=2.0*A/SQRT(3.0)
      WRITE(IOUT ,913) TEXT(NPASS),X,Z,A,C
      WRITE(NSUMM,943) TEXT(NPASS),X,Z,A,C
C     WRITE(NCRT ,943) TEXT(NPASS),X,Z,A,C
C  LATTICE IS HEXAGONAL
      SYMCON(ISOL,1)=X
      SYMCON(ISOL,2)=Z
      SYMCON(ISOL,3)=6
      CALL REFSYM
      RETURN
 1180 WRITE(IOUT ,914) TEXT(NPASS),N
      WRITE(NSUMM,944) TEXT(NPASS),N
C     WRITE(NCRT ,944) TEXT(NPASS),N
C  LATTICE IS A FREAK
      RETURN
 1200 CONTINUE
C---------------------------------------------------------------------
C       TRICLINIC LATTICES ARE CHECKED FOR EQUALITY OF CONSTANTS
C               OR SIMPLE INTEGER RATIOS BETWEEN THEM.
C---------------------------------------------------------------------
 3010 AA=OBS(MAX)
      Z=0.
      DIFMIN=FMINEQ
      DO 3020 J=1,6
      X=ABS(CEL(J))
      IF (X .LT. FMINEQ) GO TO 3020
      IF (X .LT. AA) AA=X
C  FINDS THE SMALLEST NON-ZERO VALUE OF THE CONSTANT, AA.
      IF (X .GT. Z ) Z=X
C  AND THE LARGEST VALUE,  Z.
 3020 CONTINUE
      DO 3050 I=1,3
      X=AA/FLOAT(I)
      IF (X .LT. 0.5*FMINIM) RETURN
      L=INT(Z/X +0.5)
      X=Z/FLOAT(L)
C  REFINES THE VALUE OF THE CONSTANT BY USING THE LARGEST MULTIPLE.
      N=0
      DO 3030 J=1,6
         G=ABS(CEL(J))
         L=NINT(G/X)
         IF (ABS(G-X*FLOAT(L)) .LE. DIFMIN) N=N+1
 3030 CONTINUE
      IF (N .EQ. 6) GO TO 3100
 3050 CONTINUE
      RETURN
 3100 WRITE(IOUT,900) (CEL(J),J=1,6)
      WRITE(NSUMM,930) (CEL(J),J=1,6)
C     WRITE(NCRT ,930) (CEL(J),J=1,6)
      Z=100./SQRT(X)
      WRITE(IOUT ,911) TEXT(NPASS),X,Z
      WRITE(NSUMM,941) TEXT(NPASS),X,Z
C     WRITE(NCRT ,941) TEXT(NPASS),X,Z
C  LATTICE IS CUBIC
      SYMCON(ISOL,1)=X
      SYMCON(ISOL,2)=X
      SYMCON(ISOL,3)=3
      CALL REFSYM
      RETURN
  900 FORMAT(2X/52H THE LATTICE WITH THE RECIPROCAL LATTICE CONSTANTS  ,
     * 6F9.2 )
  901 FORMAT(1H ,A12, 24H RHOMBOHEDRAL, WITH THE   ,
     *45H (HEXAGONAL) RECIPROCAL LATTICE CONSTANTS  X=,F9.1,4H  Z=,F9.1/
     * 29H AND THE DIRECT CONSTANTS  A=, F7.2,4H  C=,F7.2 )
  902 FORMAT(21H PROBABLY X SHOULD BE, F10.1,8H  AND A   ,F8.2)
  911 FORMAT(1H ,A12,44H CUBIC WITH A RECIPROCAL LATTICE CONSTANT OF  ,
     *        F10.1,33H AND A DIRECT LATTICE CONSTANT OF , F10.2)
  912 FORMAT(1H ,A12,42H TETRAGONAL WITH THE RECIPROCAL CONSTANTS  ,
     * 2F10.1,29H AND THE DIRECT CONSTANTS  A=, F7.2,4H  C=,F7.2 )
  913 FORMAT(1H ,A12,41H HEXAGONAL WITH THE RECIPROCAL CONSTANTS   ,
     * 2F10.1,29H AND THE DIRECT CONSTANTS  A=, F7.2,4H  C=,F7.2 )
  914 FORMAT(1H ,A12,43H A FREAK. THERE IS A RATIO IN THE CONSTANTS   ,
     * 32H OF THE RECIPROCAL  LATTICE OF   ,I3)
  930 FORMAT(2X/52H THE LATTICE WITH THE RECIPROCAL LATTICE CONSTANTS  /
     * 6F9.2 )
  931 FORMAT(1H ,A12,' RHOMBOHEDRAL, WITH THE  (HEXAGONAL) RECIPROCAL'/
     * ' LATTICE CONSTANTS  X=',F9.1,4H  Z=,F9.1/
     * 29H AND THE DIRECT CONSTANTS  A=, F7.2,4H  C=,F7.2 )
  941 FORMAT(1H ,A12,44H CUBIC WITH A RECIPROCAL LATTICE CONSTANT OF  /
     *        F10.1,33H AND A DIRECT LATTICE CONSTANT OF , F10.2)
  942 FORMAT(1H ,A12,42H TETRAGONAL WITH THE RECIPROCAL CONSTANTS  /
     * 2F10.1,29H AND THE DIRECT CONSTANTS  A=, F7.2,4H  C=,F7.2 )
  943 FORMAT(1H ,A12,41H HEXAGONAL WITH THE RECIPROCAL CONSTANTS   /
     * 2F10.1,29H AND THE DIRECT CONSTANTS  A=, F7.2,4H  C=,F7.2 )
  944 FORMAT(1H ,A12,43H A FREAK. THERE IS A RATIO IN THE CONSTANTS   /
     * 32H OF THE RECIPROCAL  LATTICE OF   ,I3)
      END
      FUNCTION TETCAL(Q)
C--THIS FUNCTION CALCULATES THETA FROM Q
      COMMON /CONSTS/ NSUMM,RAD,TWORAD,RRAD,HLFLAM,WAVSQR,STORE(200,9)
      ARG=HLFLAM*SQRT(Q)
      IF (ARG .GT. 1.0) THEN
         ARG=1.
         PRINT 1,Q
      END IF
      TETCAL=ASIN(ARG)
      RETURN
    1 FORMAT(' Q-VALUE TOO BIG FOR TETCAL, Q=',F10.2)
      END
      SUBROUTINE TEXT1(NN,HULP,NOAR,NCAR)
C  OUTPUT OF THE PROBABILITY FOR DIFFERENT FORMULATIONS OF THE ZONES
C  ONLY USED AS TEST OUTPUT
      DIMENSION  HULP(6),NOAR(6),NCAR(6)
      COMMON /LINES / IDOC,INP,IOUT,NCRT,MAX,OBS(40),CEL(10)
      WRITE(IOUT,1)
      DO 50 J=1,6
      GO TO (11,12,13,14,15,16), J
   11 WRITE(IOUT,21) NOAR(J),NCAR(J),HULP(J)
      GO TO 40
   12 WRITE(IOUT,22) NOAR(J),NCAR(J),HULP(J)
      GO TO 40
   13 WRITE(IOUT,23) NOAR(J),NCAR(J),HULP(J)
      GO TO 40
   14 WRITE(IOUT,24) NOAR(J),NCAR(J),HULP(J)
      GO TO 40
   15 WRITE(IOUT,25) NOAR(J),NCAR(J),HULP(J)
      GO TO 40
   16 WRITE(IOUT,26) NOAR(J),NCAR(J),HULP(J)
   40 IF (J .EQ.NN) WRITE(IOUT,2)
   50 CONTINUE
      RETURN
    1 FORMAT(51H0 NO  NC    FORMULATION OF ZONE            QUALITY /)
    2 FORMAT(1H+,53X,13H  ** USED **  )
   21 FORMAT(1H ,I3,I4,32H     A  AND  B  DOUBLED          , F12.2)
   22 FORMAT(1H ,I3,I4,32H     B  DOUBLED                  , F12.2)
   23 FORMAT(1H ,I3,I4,32H     A  DOUBLED                  , F12.2)
   24 FORMAT(1H ,I3,I4,32H     UNCHANGED ZONE              , F12.2)
   25 FORMAT(1H ,I3,I4,32H     A AND B DOUBLED, CENTERED   , F12.2)
   26 FORMAT(1H ,I3,I4,32H     UNCHANGED ZONE,  CENTERED   , F12.2)
      END
      SUBROUTINE THREED
C  THIS SUBROUTINE TRIES TO FIND THE ANGLE BETWEEN TWO INTERSECTING
C     ZONES (FOUND IN THE PRECEDING PART OF THE PROGRAM)
      DIMENSION SOM(10),ISOM(10),BE(10),IBE(10)
      INTEGER H
      LOGICAL SELF,ENL,TEST
      COMMON /LINES / IDOC,INP,IOUT,NCRT,MAX,OBS(40),CEL(10)
      COMMON /PARMS / TOL2,TOL3,WAVEL,FMINEQ,FMINIM,SELF,ENL,TEST,LIST,
     *                NSYST(3),OBSMT(40),OBSPT(40),TWTHET(40),TOLG
      COMMON /TEMRES/ LINCO,NQ2,NINDEX,INDEX(40),ROSTER(150,12)
      COMMON /COUNTM/ ITL(-2500:2500)
      F3=6.0/TOL3
      RF3=TOL3/6.0
      IF (TEST) WRITE(IOUT,1)  F3
      NEWNR=0
      DO 1000 J=4,LINCO,4
      LASTNR=NEWNR
      A=ROSTER(J,1)
      B=ROSTER(J,2)
      C=ROSTER(J,3)
      E=ROSTER(J,5)
      F=ROSTER(J,6)
      NEWNR=NINT( ROSTER(J,8) )
      NC=0
      W=SQRT( (4.*A*C-E*E)*(4.*A*B-F*F) )
      BIGD=(W-E*F)/(2.05*A)
      LIMH=NINT(F3*BIGD)
      IF ( LIMH .GT. 2500) LIMH=2500
      IF (TEST) WRITE(IOUT,5) NEWNR,A,B,C,E,F,LIMH
C     WRITE(NCRT,5) NEWNR,A,B,C,E,F,LIMH
      DO 10 I=-2500,2500
   10 ITL(I)=0
      DO 20 I=1,10
         ISOM(I)=0
         SOM(I)=0.0
         IBE(I)=0
         BE(I)=0.0
   20 CONTINUE
      MIN=4+MAX/10
      NR=1
      IF (ABS(E)+ABS(F) .GT. 1.0) GO TO  200
C  TRICLINIC LATTICES ARE TREATED BETWEEN LABELS 200 AND 300,
C  THE 'MONOCLINIC' LATTICES CAN BE TREATED IN A SIMPLE  WAY:
      DO 100 L=1,2
         DO 90 K=1,2
            X=B*FLOAT(K*K)+C*FLOAT(L*L)
            Z=F3/FLOAT(K*L)
            DO 80 H=0,2
               Y=X+A*FLOAT(H*H)
               DO 70 M=1,MAX
                  IT=NINT( Z*ABS(OBS(M)-Y) )
                  IF (IT.LT.LIMH) ITL(IT)=ITL(IT)+1
   70          CONTINUE
   80       CONTINUE
   90    CONTINUE
  100 CONTINUE
      KG=LIMH-5
      KST=2
      DO 110 I=0,2
  110 ITL(0)=ITL(0)+ITL(I)
      ITL(0)=2*ITL(0)
      IF (ITL(0) .LT. MIN) GO TO 300
      ISOM(NR)=ITL(0)
      SOM(NR)=0.0
      GO TO 300
C  TRICLINIC LATTICES ARE TREATED HERE.
  200 KG=INT(F3*(W+E*F)/(2.05*A) )
      IF (KG .GT. 2500) KG=2500
      DO 290 L=1,2
         RL=L
         DO 280 K=-2,+2
            IF (K .EQ. 0) GO TO 280
            RK=K
            X=RK*RK*B+RL*RL*C
            V=RK*F+RL*E
            Z=F3/(RK*RL)
            DO 270 H=-2,+2
               Y=X+A*FLOAT(H*H)+V*FLOAT(H)
               DO 260 M=1,MAX
                  IT=NINT( Z*(OBS(M)-Y) )
                  IF (ABS(IT) .LE. KG)  ITL(IT)=ITL(IT)+1
  260          CONTINUE
  270       CONTINUE
  280    CONTINUE
  290 CONTINUE
      KST=-KG
      KG=KG-5
  300 CONTINUE
C  NOW FIND THE MOST FREQUENT VALUES OF  * D *
      IF (TEST) WRITE(IOUT,2)
      DO 400 H=KST,KG
         K=0
         M=H+5
         DO 310 L=H,M
  310    K=K+ITL(L)
         IF (K .LE. MIN ) GO TO 400
         IF (TEST) WRITE(IOUT,3) H,K
         DO 350 N=1,NR
            IF (K .LE. ISOM(N) ) GO TO  350
            DO 340 NC=N,NR
               I=NR+N-NC
               ISOM(I+1)=ISOM(I)
  340          SOM(I+1)  =SOM(I)
            ISOM(N)=K
            NR=NR+1
            IF (NR .GT. 8) NR=8
            V=0.
            DO 345 L=H,M
  345       V=V+L*ITL(L)
            SOM(N)=RF3*( V/FLOAT(K) )
            GO TO 380
  350    CONTINUE
  380    IF (ISOM(4)  .GT. MIN) MIN=ISOM(4)
  400 CONTINUE
      IF (TEST) WRITE(IOUT,4) (SOM(I),ISOM(I),I=1,NR)
C WE HAVE FOUND THE VALUES OF D AND STORED THEM IN  SOM IN DESCENDING
C ORDER OF FREQUENCY  (K).
C  WE NOW TRY TO ELIMINATE 'EQUAL' VALUES OF D
      IF (ISOM(1) .LT.MIN) GO TO 1000
C  IF NO ANSWER HAS BEEN FOUND WE ARE READY
      DO 450 H=1,NR-1
         DO 440 K=H+1,NR
            IF (ABS(SOM(H)  -SOM(K)  ).GT. FMINEQ ) GO TO 440
            IF (ISOM(K) .LT. 1) GO TO 440
            X=ISOM(H)
            Y=ISOM(K)
            SOM(H)=(X*SOM(H)+Y*SOM(K))/(X+Y)
            ISOM(K)=0
  440    CONTINUE
  450 CONTINUE
C THE BEST FOUR VALUES OF D ARE STORED,FIRST IN BE
      N=0
      MIN=ISOM(1)-5
      DO 480 H=1,NR
         IF (ISOM(H) .LE. MIN) GO TO 480
         N=N+1
         IBE(N)=ISOM(H)
         BE(N)  =SOM(H)
         IF (N.EQ.4) GO TO 500
  480 CONTINUE
  500 LN=0
      IF (NEWNR .EQ. LASTNR) LN=5
      L=10*NEWNR+LN
C  WE HAVE ADDED 5 TO THE NUMBERS OF THE 'EQUAL' ZONES.
      DO 550 H=1,N
         M=J+H-1
         DO 540 K=1,6
 540     ROSTER(M,K)=ROSTER(J,K)
         ROSTER(M,4)=BE(H)
         ROSTER(M,7)=IBE(H)
         ROSTER(M,8)=L+H
  550 CONTINUE
 1000 CONTINUE
      RETURN
    1 FORMAT(32H0TEST OUTPUT FROM  ** THREED **  ,'THE FACTOR F3=',F6.3)
    2 FORMAT(12H0POSITION NR )
    3 FORMAT(1H ,I8,I3)
    4 FORMAT(20H ARRAYS SOM AND ISOM /  (F11.2,I4 ) )
    5 FORMAT(18H ZONE COMBINATION ,I2,3F8.2,5X,3HXXX,2F8.2,
     1  2X,'LIMH=',I4  )
      END
      SUBROUTINE TIMER(N)
C  TIMER SUBROUTINES ARE INSTALLATION DEPENDENT. YOU MAY ENTER YOUR OWN
C  SUBROUTINE HERE, OR CALL YOUR OWN SUBROUTINE.
C     CALL ZTIMER(N)
      RETURN
      END
      SUBROUTINE UNTCEL(WMOL,DOBS,VOLUM,ISW)
C-----------------------------------------------------------------------
C  THIS SUBROUTINE CALCULATES THE DIRECT CONSTANTS FROM THE CONSTANTS
C  OF THE RECIPROCAL LATTICE.
C  IF THE MOLECULAR WEIGHT AND THE DENSITY HAVE BEEN GIVEN,
C  IT ALSO CALCULATES THE X-RAY DENSITY,DX,  AND THE NUMBER OF MOLECULES
C  PER UNIT CELL,  N.
C-----------------------------------------------------------------------
      DIMENSION          REC(3,6),REEL(3,6),WAAR(6)
      COMMON /LINES / IDOC,INP,IOUT,NCRT,MAX,OBS(40),CEL(10)
C
C     WRITE(NCRT,'('' TRANSFORMATION OF RECIPROCAL CELL TO'',
C    * '' DIRECT CELL'' /)' )
C     WRITE(NCRT, 9930) (CEL(J),J=1,6)
      DO 1100 J=1,6
 1100 WAAR(J)= CEL(J)
      DO 1220 J=1,3
      REC(1,J)=SQRT(WAAR(J))
      REC(1,J+3)=REC(1,J)
 1220 CONTINUE
      DO 1230 J=1,3
      W=WAAR(J+3)/(REC(1,J+1)*REC(1,J+2)*2.0)
      REC(2,J+3)=W
      REC(2,J)=W
      REC(3,J+3)=SQRT(1.0-W*W)
      REC(3,J)=REC(3,J+3)
 1230 CONTINUE
      DO 1240 J=1,3
      W=(REC(2,J+1)*REC(2,J+2)-REC(2,J))/(REC(3,J+1)*REC(3,J+2))
      REEL(2,J+3)=W
      REEL(2,J)=W
      REEL(3,J)=SQRT(1.0-W*W)
      REEL(3,J+3)=REEL(3,J)
 1240 CONTINUE
      FNNN=REEL(3,1)*REEL(3,2)*REC(3,3)
      DO 1250 J=1,3
      CEL(J)=REEL(3,J)/(FNNN*REC(1,J))*100.0
 1250 CONTINUE
      DO 1260 J=4,6
      CEL(J)=90.0-57.29578*ATAN(REEL(2,J)/REEL(3,J))
 1260 CONTINUE
      VOLUM=FNNN*CEL(1)*CEL(2)*CEL(3)
      IF (ISW .EQ. 0) RETURN
      CEL(7)=VOLUM
      WRITE(IOUT ,9930) (CEL(J),J=1,6) ,VOLUM
C     WRITE(NSUMM,9930) (CEL(J),J=1,6) ,VOLUM
C     WRITE(NCRT ,9930) (CEL(J),J=1,6) ,VOLUM
      IF (WMOL .LT. 0.1) RETURN
      PARTD=WMOL/(0.6025*VOLUM)
      IF (DOBS .LT. 0.1) GO TO 1270
      J=IFIX(DOBS/PARTD)
      DMAX=1000.
C  J IS A GOOD APPROXIMATION OF THE NUMBER OF MOLECULES PER UNIT CELL.
C  TRY A FEW VALUES AROUND J  AND RETAIN THE ONE WITH THE CALCULATED
C  DENSITY THAT FITS BEST.
      DO 1265 I=1,4
      DX=FLOAT(I+J-2)*PARTD
      DELTA=ABS(DOBS-DX)
      IF (DELTA .GT. DMAX) GO TO 1265
      DMAX=DELTA
      N=I+J-2
 1265 CONTINUE
      DX=PARTD*FLOAT(N)
      WRITE(IOUT,9931)  N,DX,DOBS
      RETURN
 1270 WRITE(IOUT,9932) PARTD
      RETURN
 9930 FORMAT(1H ,6F9.3,  F12.2)
 9931 FORMAT(1H , 5H   Z=,I2,6H   DX=, F7.4, 8H   DOBS=, F7.4 )
 9932 FORMAT(1H ,11H   DCALC=Z*, F8.4)
      END
      SUBROUTINE WISSEL(I,J)
      COMMON /LINES / IDOC,INP,IOUT,NCRT,MAX,OBS(40),CEL(10)
      A=CEL(I)
      CEL(I)=CEL(J)
       CEL(J)=A
      A=CEL(I+3)
      CEL(I+3)=CEL(J+3)
      CEL(J+3)=A
      RETURN
      END
      SUBROUTINE WRISP(NPOS,VAR,ICODE)
C  THE FUNCTION OF  WRISP  IS TO WRITE THE Q-VALUES OF THE CALCULATED
C  LINES IN A NEAT SCHEME, RECOGNISABLE FOR THOSE WHO  KNOW HOW TO
C  HANDLE THESE SCHEMES.
C     IT WRITES  VAR  (THE Q-VALUE) IN THE FORMAT F8.1, PRECEDED BY
C  (NPOS-1)*9 SPACES.   IF THE CALCULATED VALUE OF Q CORRESPONDS TO
C  AN OBSERVED VALUE, AN X IS ADDED LATER.
C
C  THE PARAMETERS OF WRISP ARE:
C  1. NPOS     = POSITION OF Q-VALUE
C  2. VAR      = VALUE OF Q
C  3. ICODE    = CODE TO TELL WRISP WHAT  TO DO
C  ICODE=0  PUT VAR IN POSITION
C       =1  PUT X IN POSITION.
C       =2  PRINT THE LINE WITH Q-VALUES.
C
C  A LINEAR ARRAY  *ITXT(133)*, REPRESENTING ONE LINE ON THE PRINTER,
C  IS FILLED WITH CHARACTERS.  WHEN THE LINE IS COMPLETELY READY,
C  IT IS PRINTED.
C
C  THIS PARTICULAR FORM OF WRISP TAKES A LITTLE BIT OF COMPUTING TIME
C  BUT IT IS KIND TO THE PRINTER.  IT SHOULD BE USED WHEN YOU HAVE A
C  RELATIVELY FAST COMPUTER AND A SLOW PRINTER (E.G. A SLOW TERMINAL
C  ON A FAST COMPUTER).
C
      CHARACTER*1 IBLANK,IX,IPNT,ISTAR
      CHARACTER*1 IFIGRS(10),ITXT(133)
      COMMON /LINES / IDOC,INP,IOUT,NCRT,MAX,OBS(40),CEL(10)
      DATA IBLANK/' '/,IX/'X'/,IPNT/'.'/,IFIGRS(1)/'0'/,IFIGRS(2)/'1'/,
     * IFIGRS(3)/'2'/,IFIGRS(4)/'3'/,IFIGRS(5)/'4'/,IFIGRS(6)/'5'/,
     2 IFIGRS(7)/'6'/,IFIGRS(8)/'7'/,IFIGRS(9)/'8'/,IFIGRS(10)/'9'/
      DATA NUSED/0/,ISTAR/'*'/
      IF (NUSED .GT. 0) GO TO 20
      GO TO 400
   20 NUSED=NUSED+1
      IF (ICODE-1) 100,200,300
C
  100 IF (NPOS .LE. 14) GO TO 150
C  ONLY 132 PRINT POSITIONS AVAILABLE,  15*9=135!
      WRITE(IOUT,9990)ITXT
      NPOS=1
      DO 110 K=1,133
  110 ITXT(K)=IBLANK
  150 N=9*(NPOS-1)
      IF (VAR .GT. 0.1) GO TO 156
      DO 152 I=3,9
      K=N+I
  152 ITXT( K )=ISTAR
      ITXT(N+6)=IFIGRS(1)
      GO TO 180
  156 NR=IFIX(VAR*10.0+0.5)
      IREST=NR/10
      NFIG=NR-10*IREST
      ITXT(N+8)=IFIGRS(NFIG+1)
      ITXT(N+7)=IPNT
      NR=IREST
      DO 160 I=1,6
      INR=7-I
      IREST=NR/10
      NFIG=NR-10*IREST
      NR=IREST
      K=N+INR
      ITXT(  K  )=IFIGRS(NFIG+1)
      IF (NR .EQ. 0) GO TO 180
  160 CONTINUE
  180 RETURN
C
  200 N=9*NPOS
      ITXT(N)=IX
      RETURN
C
  300 WRITE(IOUT,9990)ITXT
      NPOS=1
C
  400 ITXT(1)=IFIGRS(1)
      DO 410 K=2,133
  410 ITXT(K)=IBLANK
      IF (NUSED .EQ. 0) GO TO 20
      RETURN
 9990 FORMAT(133A1)
      END
      SUBROUTINE ZERCHK
C  THIS SUBROUTINE TRIES TO FIND SPECIMEN DISPLACEMENT ERRORS OR
C  ERRORS IN THE CALIBRATION OF THE ZERO POINT OF THE DATA.
C
      LOGICAL SELF,ENL,TEST
      DIMENSION TTT(40),QPT(40),QMT(40)
      DIMENSION Q(40),NFT(21),DEL(21),NR(21)
      COMMON /LINES / IDOC,INP,IOUT,NCRT,MAX,OBS(40),CEL(10)
      COMMON /PARMS / TOL2,TOL3,WAVEL,FMINEQ,FMINIM,SELF,ENL,TEST,LIST,
     *                NSYST(3),OBSMT(40),OBSPT(40),TWTHET(40),TOLG
      WRITE(IOUT,1)
      WRITE(IOUT,2)
      HRAD=ATAN(1.)/90.
      SWAVEL=WAVEL/200.
      DO 20 M=1,MAX
   20 TTT(M)=TWTHET(M)-0.11
      DO 100  I=1,21
      K=I-11
C     WRITE(IOUT, 5) K
      NR(I)=K
      DO 30 M=1,MAX
      TTT(M)=TTT(M)+0.01
      SIT=SIN(HRAD*TTT(M))/SWAVEL
      W=SIT*SIT
      Q(M)=W
      TTP=TTT(M)+TOLG
      SIT=SIN(HRAD*TTP)/SWAVEL
      QPT(M)=SIT*SIT
      QMT(M)=2.*W-QPT(M)
   30 CONTINUE
C     WRITE(IOUT,6) (Q(M), Q(M+10), Q(M+20), Q(M+30), M=1,10)
      QMAX= QPT(MAX)+10.
      NFIT=0
      SUMDEL=0.
      DO 90 M=1,6
      IF (4.*Q(M) .GT. QMAX) GO TO 95
      DO 60 J=1,5
      II=J+1
      FIII=II*II
      QQ= FIII*Q(M)
      IF (QQ .GT. QMAX) GO TO 90
      DO 50 K=1,MAX
      IF (QPT(K) .LT. QQ) GO TO 50
      IF (QMT(K) .GT. QQ) GO TO 60
C  NOW QQ FITS A Q-VALUE.
      NFIT=NFIT+1
      SUMDEL=SUMDEL+ABS(QQ-Q(K))/FIII
C     WRITE(IOUT, 7) Q(M), II,  Q(K) ,SUMDEL
   50 CONTINUE
   60 CONTINUE
   90 CONTINUE
   95 DEL(I)=SUMDEL
      NFT(I)=NFIT
  100 CONTINUE
      WRITE(IOUT, 8)
      WRITE(IOUT,3) NR,NFT,DEL
      WRITE(IOUT, 9)
      WRITE(IOUT, 9)
      N=0
      DO 200 I=1,21
      IF (NFT(I) .LE. N) GO TO 200
      M=I
      N=NFT(I)
      DIF=DEL(I)
  200 CONTINUE
C     WRITE(IOUT,4)M,N, DIF
      RETURN
    1 FORMAT(50H0  THE PURPOSE OF SUBROUTINE ZERCHK IS TO FIND OUT,
     2       50H WHETHER THERE ARE SPECIMEN DISPLACEMENT ERRORS OR/
     3       50H ZERO ERRORS IN THE DATA.  WE TRY TO CHECK THESE B,
     4       51HY LOOKING FOR HIGHER ORDERS OF THE LOW-ANGLE LINES./
     5       50H   THEREFORE WE APPLY A ZERO-CORRECTION TO ALL LIN,
     6       50HES AND FIND THE NUMBER OF HIGHER ORDERS.          /
     7       50H THE NUMBER OF HIGHER ORDERS IS PRINTED TOGETHER  ,
     8       50HWITH THEIR MEAN DEVIATION.                        /
     9       50H THE BEST ZERO CORRECTION IS PROBABLY THE ONE THAT,
     O       51H GIVES THE LARGEST NUMBER OF HIGHER ORDERS WITH THE/
     A       50H SMALLEST MEAN DEVIATION.  THE PROGRAM DOES NOT AP,
     B       50HPLY THIS CORRECTION AS IT IS NOT ALWAYS MEANINGFUL/
     C       50H BECAUSE THE AMOUNT OF USEFUL DATA IS SO SMALL.   )
    2 FORMAT(50H0  IT IS ENTIRELY YOUR RESPONSABILITY TO DECIDE WH,
     2       50HETHER THE BEST ZERO CORRECTION IS A REASONABLE ONE/
     3       50H FOR YOUR EXPERIMENTAL CONDITIONS.                /
     4       50H YOU CAN APPLY YOUR CHOSEN CORRECTION BY ENTERING ,
     5       50HIT AS THE FIRST PARAMETER ON THE SECOND PARAMETER /
     6       50H CARD AND RERUNNING THE PROGRAM.                  )
    3 FORMAT(15H SHIFTS (X0.01), 21I5/ 15H NR OF FITS    , 21I5/
     2       15H MEAN DELTA Q  , 21F5.1 //
     3       56H IF YOU  WANT TO APPLY A ZERO CORRECTION TO ALL TWOTHETA
     4 ,     55H VALUES, YOU CAN DO THIS ON THE SECOND PARAMETER CARD.
     5  /    56H THIS IS NOT NECESSARY IF YOU USED AN INTERNAL STANDARD
     6  ,    11HCORRECTLY.  )
C   4 FORMAT(1H ,2I3, F8.3)
C   5 FORMAT(23H SHIFT IN HUNDREDTHS=  , I3)
C   6 FORMAT(    1H , 4F10.1  )
C   7 FORMAT(1H ,F10.1, I5,2F10.1)
    8 FORMAT(56H ALL INPUT TWO THETA VALUES WERE SHIFTED BY A NUMBER OF
     2 ,     55HHUNDREDTHS OF A DEGREE TWO THETA, AS INDICATED BELOW.
     3 /     56H THE NEW VALUES WERE TESTED ON THE OCCURRENCE OF SECOND-
     4  ,  '  AND HIGHER ORDER LINES.  THE NUMBER OF FITS AND THE ' /
     5  ,    ' MEAN DEVIATION ARE GIVEN BELOW. ' /
     6  ,    ' THE RESULTS MAY GIVE AN INDICATION OF A SPECIMEN '
     7  ,    'DISPLACEMENT CORRECTION OR A ZERO ERROR.    '   )
    9 FORMAT(56H WARNING.  MESSING AROUND WITH MEDIOCRE DATA IS NO  (REP
     2  ,    56HEAT NO) SUBSTITUTE FOR GOOD EXPERIMENTAL METHODS.
     3  /    ' -------------------------------------------------------',
     4       '-------------------------------------------------------' )
      END
