        PROGRAM GETVOIGT
 
C       TO CONVERT PSEUDO-VOIGT PARAMETERS FWHM AND ETA INTO VOIGT INTEGRAL BREADTHS
C       FOR THE GAUSSIAN AND LORENTZIAN COMPONENTS
 
C       MOST OF THIS CODE WAS WRITTEN BY DAVOR BALZAR (NIST)
 
C        WRITE (6,1)
1       FORMAT (' ENTER FWHM, ERRFWHM, ETA, ERRETA: ',$)
        READ (5,2) FWHM,ERRFWHM,ETA,ERRETA
2       FORMAT (4F10.5)
 
      CALL PSEUDO_VOIGT(FWHM,ERRFWHM,ETA,ERRETA,      ! INPUT
     &                      BC,BEC,BG,BEG)            ! OUTPUT
        WRITE (6,3) BC,BEC,BG,BEG
C3       FORMAT (' BC,BEC,BG,BEG = '4F10.5)
3       FORMAT (4F10.5)
        STOP
        END
 
      FUNCTION PHI_PSEUDO_VOIGT(ETA)
C * THE RATIO FWHM/BETA
C * DE KEIJSER ET AL. J.APPL.CRYST. 16(1983)309. EQ. (29)
C * ETA IS A MIXING PARAMETER: ETA=1 CAUCHY, ETA=0 GAUSS
      PARAMETER (PI=3.1415926536)
C
      IF (ETA .LT. 0.0) ETA=0.0
      IF (ETA .GT. 1.0) ETA=1.0
      TEMP = SQRT(PI/LOG(2.))/2.
      PHI_PSEUDO_VOIGT = 1./(TEMP+(PI/2.-TEMP)*ETA)
      END
C *
      FUNCTION PHI_PSEUDO_VOIGT_DERIV(ETA)
C * DERIVATIVE OF PHI_PSEUDO_VOIGT()
      PARAMETER (PI=3.1415926536)
C
      PHI_PSEUDO_VOIGT_DERIV = PHI_PSEUDO_VOIGT(ETA)**2 *
     &                         (PI/2. - SQRT(PI/LOG(2.))/2.)
      END
C *
C *
C * THE RATIO OF GAUSS INTEGRAL BREADTH TO THE TOTAL INTEGRAL BREADTH
C * OF THE VOIGT FUNCTION (DE KEIJSER ET AL. J.APPL.CRYST. 15(1982)308.)
      FUNCTION BETAG_OVER_BETA(K)
      REAL K
      PARAMETER (PI=3.1415926536)
      PARAMETER (EPSIL = 1.0E-35)
C
      ARG = K
      TEMP = -0.5*ARG*SQRT(PI)+0.5*SQRT(PI*ARG**2+4.)-0.234*ARG*
     1           EXP(-2.176*ARG)
      IF (TEMP .GT. EPSIL) THEN
        BETAG_OVER_BETA = TEMP
       ELSE
        BETAG_OVER_BETA = 0.0
      END IF
      RETURN
      END
C *
      FUNCTION BETAG_OVER_BETA_DERIV(K)
C * DERIVATIVE OF BETAG_OVER_BETA()
      REAL K
      PARAMETER (PI=3.1415926536)
C
      BETAG_OVER_BETA_DERIV = -0.5*SQRT(PI)+PI*K/(2.*SQRT(PI*K**2+4.))-
     &  0.234*EXP(-2.176*K)+0.509184*K*EXP(-2.176*K)
      RETURN
      END
C *
      FUNCTION BETAG_ZERO_CORRECTION(BG_OVER_B,BC,BG)
      IF (BG_OVER_B .NE. 0.0) THEN
        BETAG_ZERO_CORRECTION = BG/BG_OVER_B
       ELSE
        BETAG_ZERO_CORRECTION = BC
      END IF
      RETURN
      END
C *
      REAL FUNCTION K_VOIGT(PHI)
C * CHARACTERISTIC RATIO k OF THE VOIGT FUNCTION AS A FUNCTION OF PHI=FWHM/BETA
C * FOLLOWING AHTEE ET AL. J.APPL.CRYST. 17(1984)352 & LANGFORD, NIST 846 (1993)
      REAL K_PLUS,K_MINUS
      PARAMETER (A=0.9039645)
      PARAMETER (B=0.7699548)
      PARAMETER (C=1.364216)
      PARAMETER (D=1.136195)
      PARAMETER (E=0.9394372)
C
      TEMP_B = C*PHI-A*E
      TEMP_A = B*E-D*PHI
      TEMP_D = (TEMP_B)**2 - 4.*TEMP_A*(E-PHI)
      IF (TEMP_D .GT. 0.0) THEN
C * THERE ARE TWO SOLUTIONS
        K_PLUS = (TEMP_B + SQRT(TEMP_D)) / (2.*TEMP_A)
        K_MINUS = (TEMP_B - SQRT(TEMP_D)) / (2.*TEMP_A)
       ELSE IF (TEMP_D .EQ. 0.0) THEN
        K_VOIGT = TEMP_B / (2.*TEMP_A)
        RETURN
       ELSE     ! COMPLEX SOLUTION FOR A VERY NARROW RANGE
        K_VOIGT = TEMP_B / (2.*TEMP_A)
        RETURN
      END IF
      IF (K_PLUS .LE. 0.0) THEN
        K_VOIGT = K_MINUS
       ELSE
C * PROBLEMS ARE HERE - HOW TO DISTINGUISH TWO SOLUTIONS
C *     ALWAYS TAKE K_MINUS AND TAKE CARE OF PROBLEMS IN
C *         PSEUDO_VOIGT() & PEARSON_VII()
        K_VOIGT = K_MINUS
      END IF
      RETURN
      END
C *
      REAL FUNCTION K_VOIGT_DERIV(PHI)
C * DERIVATIVE OF K_VOIGT() DOESN'T WORK VERY WELL
C *           -- GIVES UNREASONABLY LARGE ERRORS
C *              CURRENTLY NOT CALLED FROM TRANSF_TO_VOIGT()
      PARAMETER (A=0.9039645)
      PARAMETER (B=0.7699548)
      PARAMETER (C=1.364216)
      PARAMETER (D=1.136195)
      PARAMETER (E=0.9394372)
C
      TEMP_B = C*PHI-A*E
      TEMP_A = B*E-D*PHI
      TEMP_D = (TEMP_B)**2 - 4.*TEMP_A*(E-PHI)
      IF (TEMP_D .GT. 0.0) THEN
C * THERE ARE TWO SOLUTIONS
        DERIV_PLUS = ((2.*C*TEMP_B-4.*D*(PHI-E)+4.*TEMP_A) /
     &       (2.*SQRT(TEMP_D)) + C) / (2.*TEMP_A) +
     &       D*(SQRT(TEMP_D)+TEMP_B) / (2.*TEMP_A**2)
        DERIV_MINUS = (-1.*(2.*C*TEMP_B-4.*D*(PHI-E)+4.*TEMP_A) /
     &       (2.*SQRT(TEMP_D)) + C) / (2.*TEMP_A) +
     &       D*(-SQRT(TEMP_D)+TEMP_B) / (2.*TEMP_A**2)
       ELSE IF (TEMP_D .EQ. 0.0) THEN
        K_VOIGT_DERIV = C / (2.*TEMP_A) + D*TEMP_B / (2.*TEMP_A**2)
        RETURN
       ELSE     ! COMPLEX SOLUTION FOR A VERY NARROW RANGE
        K_VOIGT_DERIV = C / (2.*TEMP_A) + D*TEMP_B / (2.*TEMP_A**2)
        RETURN
      END IF
C * PROBLEMS ARE HERE - HOW TO DISTINGUISH TWO SOLUTIONS
        K_VOIGT_DERIV = DERIV_MINUS
      RETURN
      END
C *
      FUNCTION B_C_OVER_B_PV(ETA)
C * DIRECTLY CALCULATES THE RATIO BETA_CAUCHY/BETA FROM ETA
C * DE KEIJSER ET AL. J.APPL.CRYST. 16(1983)309. EQ. (31)
      PARAMETER (B0=0.017475)
      PARAMETER (B1=1.500484)
      PARAMETER (B2=-0.534156)
C
      B_C_OVER_B_PV = B0+B1*ETA+B2*ETA**2
      RETURN
      END
C *
      FUNCTION B_C_OVER_B_PV_DERIV(ETA)
C * DERIVATIVE OF B_C_OVER_B_PV()
      PARAMETER (B1=1.500484)
      PARAMETER (B2=-0.534156)
C
      B_C_OVER_B_PV_DERIV = B1+2.*B2*ETA
      RETURN
      END
C *
      FUNCTION B_G_OVER_B_PV(ETA)
C * DIRECTLY CALCULATES THE RATIO BETA_GAUSS/BETA FROM ETA
C * DE KEIJSER ET AL. J.APPL.CRYST. 16(1983)309. EQ. (32)
      PARAMETER (C0=0.184446)
      PARAMETER (C12=0.812692)
      PARAMETER (C1=-0.659603)
      PARAMETER (C2=0.445542)
      PARAMETER (C=-0.998497)
C
      B_G_OVER_B_PV = C0+C12*SQRT(1.+C*ETA)+C1*ETA+C2*ETA**2
      RETURN
      END
C *
      FUNCTION B_G_OVER_B_PV_DERIV(ETA)
C * DERIVATIVE OF B_G_OVER_B_PV()
      PARAMETER (C12=0.812692)
      PARAMETER (C1=-0.659603)
      PARAMETER (C2=0.445542)
      PARAMETER (C=-0.998497)
C
      IF (ETA .LT. 0.) ETA=0.
      IF (ETA .GT. 1.) ETA=1.
      B_G_OVER_B_PV_DERIV = C1+2.*C2*ETA+
     &              C*C12/(2.*SQRT(1.+C*ETA))
      RETURN
      END
C *
      FUNCTION B_C_OVER_B_PVII(M)
C * DIRECTLY CALCULATES THE RATIO BETA_CAUCHY/BETA FROM M
C * DE KEIJSER ET AL. J.APPL.CRYST. 16(1983)309. EQ. (33)
      REAL M
      PARAMETER (E1=0.750445)
      PARAMETER (E2=0.247681)
C
      IF (M .LT. 1.0) M=1.0
      IF (M .GT. 30.0) M=30.0
      B_C_OVER_B_PVII = E1/M+E2/M**2
      RETURN
      END
C *
      FUNCTION B_C_OVER_B_PVII_DERIV(M)
C * DERIVATIVE OF B_C_OVER_B_PVII()
      REAL M
      PARAMETER (E1=0.750445)
      PARAMETER (E2=0.247681)
C
      IF (M .LT. 1.0) M=1.0
      IF (M .GT. 30.0) M=30.0
      B_C_OVER_B_PVII_DERIV = -1.*(E1/M**2+2.*E2/M**3)
      RETURN
      END
C *
      FUNCTION B_G_OVER_B_PVII(M)
C * DIRECTLY CALCULATES THE RATIO BETA_GAUSS/BETA FROM M
C * DE KEIJSER ET AL. J.APPL.CRYST. 16(1983)309. EQ. (34)
      REAL M
      PARAMETER (F0=1.092228)
      PARAMETER (F1=-1.163332)
      PARAMETER (F2=1.316944)
      PARAMETER (F3=-1.131115)
C
      IF (M .LT. 1.0) M=1.0
      IF (M .GT. 30.0) M=30.0
      B_G_OVER_B_PVII = F0+F1/M+F2/M**2+F3/M**3
      RETURN
      END
C *
      FUNCTION B_G_OVER_B_PVII_DERIV(M)
C * DERIVATIVE OF B_G_OVER_B_PVII()
      REAL M
      PARAMETER (F1=-1.163332)
      PARAMETER (F2=1.316944)
      PARAMETER (F3=-1.131115)
C
      IF (M .LT. 1.0) M=1.0
      IF (M .GT. 30.0) M=30.0
      B_G_OVER_B_PVII_DERIV = -1.*(F1/M**2+2.*F2/M**3+3.*F3/M**4)
      RETURN
      END
C *
      SUBROUTINE TRANSF_TO_VOIGT(IFUNCTION,PARAMETER,PARAMETER_ERROR, ! INPUT
 
     &                           PHI,PHI_ERROR,FWHM,FWHM_ERROR,       ! INPUT
     &                    BETA_C,BETA_C_ERROR,BETA_G,BETA_G_ERROR)    ! OUTPUT
C * WILL FIND BETA_C & BETA_G WITH ASSOCIATED ERRORS FROM PHI & FWHM
C * IFUNCTION -- WE NEED IT ONLY FOR K_ERROR
C *           = 1 PSEUDO-VOIGT, PARAMETER = ETA
C *           = 2 PEARSON-VII , PARAMETER = M
      REAL K,K_ERROR,K_VOIGT
      PARAMETER (PI=3.1415926536)
C
C * CHECK FOR IRREGULAR PHI AND PRINT WARNING IF NECESSARY
      PHI_MIN = 2./PI                     ! PHI MUST FALL
      PHI_MAX = 2.*SQRT(LOG(2.0)/PI)      ! IN BETWEEN
      IF (PHI .LT. PHI_MIN) THEN
!        WRITE (9,2035)
        PHI = PHI_MIN
      END IF
2035  FORMAT (//
     &   ' *** WARNING: PHI LESS THAN THE CAUCHY LIMIT',/,
     &   15X,' SET TO  2/PI')
      IF (PHI .GT. PHI_MAX) THEN
!        WRITE (9,2036)
        PHI = PHI_MAX
      END IF
2036  FORMAT (//
     &   ' *** WARNING: PHI GREATER THAN THE GAUSS LIMIT',/,
     &   15X,' SET TO  2 SQRT(LN(2)/PI)')
C *
      BETA = FWHM / PHI
      BETA_ERROR = SQRT((FWHM_ERROR/PHI)**2+(BETA/PHI*PHI_ERROR)**2)
      K = K_VOIGT(PHI)
C *    ! ERRORS UNREASONABLY LARGE
C *      K_ERROR = ABS(K_VOIGT_DERIV(PHI))*PHI_ERROR
C *    CALCULATE ERRORS FROM THE ALTERNATE ALGORITHMS
!      SELECT CASE (IFUNCTION)
!       CASE (1)               ! PSEUDO-VOIGT
      IF (IFUNCTION .EQ. 1) THEN
        K_ERROR = SQRT((K/B_C_OVER_B_PV(PARAMETER)*
     &         B_C_OVER_B_PV_DERIV(PARAMETER)*PARAMETER_ERROR)**2 +
     &                 (K/B_G_OVER_B_PV(PARAMETER)*
     &         B_G_OVER_B_PV_DERIV(PARAMETER)*PARAMETER_ERROR)**2)
!       CASE (2)               ! PEARSON-VII
      ELSE
        K_ERROR = SQRT((K/B_C_OVER_B_PVII(PARAMETER)*
     &         B_C_OVER_B_PVII_DERIV(PARAMETER)*PARAMETER_ERROR)**2 +
     &                 (K/B_G_OVER_B_PVII(PARAMETER)*
     &         B_G_OVER_B_PVII_DERIV(PARAMETER)*PARAMETER_ERROR)**2)
!      END SELECT
      ENDIF
      BETA_G = BETA * BETAG_OVER_BETA(K)
      BETA_G_ERROR = SQRT((BETA_G/BETA*BETA_ERROR)**2 +
     &                    (BETA*BETAG_OVER_BETA_DERIV(K)*K_ERROR)**2)
      BETA_C = SQRT(PI) * BETA_G * K
      BETA_C_ERROR = SQRT((SQRT(PI)*K*BETA_G_ERROR)**2 +
     &                    (SQRT(PI)*BETA_G*K_ERROR)**2)
      END
C *
      SUBROUTINE PSEUDO_VOIGT(FWHM,FWHM_ERROR,ETA,ETA_ERROR,           ! INPUT
     &                        BETA_C,BETA_C_ERROR,BETA_G,BETA_G_ERROR) ! OUTPUT
      REAL K,K_CRITICAL
      PARAMETER (PI=3.1415926536)
      PARAMETER (K_CRITICAL=15.)
C
      PHI = PHI_PSEUDO_VOIGT(ETA)
      PHI_ERROR = ABS(PHI_PSEUDO_VOIGT_DERIV(ETA)*ETA_ERROR)
C * GET THE PARAMETERS OF THE CORRESPONDING VOIGT FUNCTION
      CALL TRANSF_TO_VOIGT(1,ETA,ETA_ERROR,                           ! INPUT
     &                     PHI,PHI_ERROR,FWHM,FWHM_ERROR,             ! INPUT
     &                     BETA_C,BETA_C_ERROR,BETA_G,BETA_G_ERROR)   ! OUTPUT
C * CHECK FOR K > K_CRITICAL -- IT MIGHT MEAN PROBLEMS
C *                             THEN, CALCULATE THROUGH THE ALTERNATE ALGORITHM
      K = BETA_C/(SQRT(PI)*BETA_G)
      IF (K .GT. K_CRITICAL) THEN
        BETA_C = FWHM/PHI * B_C_OVER_B_PV(ETA)
        BETA_C_ERROR = SQRT((FWHM_ERROR/PHI*B_C_OVER_B_PV(ETA))**2 +
     &                 (FWHM/PHI**2*B_C_OVER_B_PV(ETA)*PHI_ERROR)**2 +
     &                 (FWHM/PHI*B_C_OVER_B_PV_DERIV(ETA)*ETA_ERROR)**2)
        BETA_G = FWHM/PHI * B_G_OVER_B_PV(ETA)
        BETA_G_ERROR = SQRT((FWHM_ERROR/PHI*B_G_OVER_B_PV(ETA))**2 +
     &                 (FWHM/PHI**2*B_G_OVER_B_PV(ETA)*PHI_ERROR)**2 +
     &                 (FWHM/PHI*B_G_OVER_B_PV_DERIV(ETA)*ETA_ERROR)**2)
      END IF
      END
C *
