      real*4 function getval(piz,twoth,deriv)
      implicit none
      integer nparam
      parameter(nparam=40)
      real*4 piz(nparam),deriv(nparam),dderiv(nparam)
      real*4 twoth,astart,astep,aend,sam,det,cg,cl,arg,del2t1
      real*4 gamma,eta,zz,dadp,dgdp,dgdeta,dgdgamma,dadgamma,dadeta
      real*4 profval,dis,gaus,alor,pi,temp
      integer iasymm,no,np,i
      common /a/astart,astep,aend,dis,det,iasymm,np,no
      INTEGER*4 isel(nparam)
      common /b/isel
      REAL WAVE1,WAVE2,RATIO21	   
      common /c/ WAVE1,WAVE2,RATIO21
c	 
      DATA CG,CL,ARG,pi/0.939437279,0.636619772,1.66510922,3.14159265/ 
C 
C     CALCULATIONS FOR NO OBSERVATIONS ACCORDING TO MODEL SUPPLIED
c
C     SYMMETRIC PEAK FUNCTION 
C     FITS TO GAUSS-LORENTZ WERTHEIM APPROXIMATION
C     PIZ ARE PARAMETERS.
C     PIZ(1) AND  PIZ(2) ARE BACKGD ON LOW AND HIGH SIDES
C     PIZ(3) AND  PIZ(4) ARE GAMMA AND ETA
C     LINEAR INTERPOLATION OF LOW AND HIGH BACKGROUND 
C 
C 
      logical Kalpha12
      real deg2T2rad,pos2,int2
      deg2T2rad = pi/360.

      if (wave1 .gt. 0 .and. wave2 .gt. wave1 .and. RATIO21 .gt. 0) then
         Kalpha12 = .TRUE.
      else
         Kalpha12 = .FALSE.
      endif

      GAMMA=PIZ(3)
      ETA=PIZ(4)
c
C     modified for Van Laar and Yelon peak shapes - JAC 17,47(1984) 
C 
c---- det and sam are 1/2 detector slit and sample widths respectively (mm)
c---- dis is sample-detector distance 
c
c Get background and derivatives for this point
c
      zz=piz(1)+(piz(2)-piz(1))*(twoth-astart) / (aend - astart)
      deriv(1) = 1.0 - (twoth - astart) / (aend - astart)
      deriv(2) = (twoth - astart) / (aend - astart)
c
c initialize derivatives wrt eta, gamma, and sam
c
      deriv(3) = 0.0
      deriv(4) = 0.0
      deriv(np) = 0.0
 400  if(iasymm.eq.1)then
c
        getval = ZZ
        sam = piz(np-1)
        det = piz(np)
	deriv(np-1) = 0.0
	deriv(np) = 0.0
        DO I=5,NP-2*iasymm,2
	  temp = PROFVAL(TWOTH,PIZ(I+1),ETA,GAMMA,det,sam,dis,dderiv)
	  if(temp.lt.0.0) THEN
             iasymm = 0
             go to 400
          ENDIF
	  getval=getval + PIZ(I)*ASTEP*temp/gamma
	  deriv(3) = deriv(3) + piz(i)*astep*(gamma*dderiv(1)-temp)
     1		/gamma**2
	  deriv(4) = deriv(4) + piz(i)*astep*dderiv(2)/gamma
	  deriv(i) = astep*temp/gamma
	  deriv(i+1) = astep*dderiv(3)*piz(i)/gamma
c no derivative wrt 'sam' in 'profval' - do numerically
C if sam & det are both refined -- constrain them together
          if (isel(np-1) .NE. 0 .AND. isel(np).NE. 0) THEN
             deriv(np-1) = deriv(np-1) + astep*piz(i)/gamma*
     1            (PROFVAL(TWOTH,PIZ(I+1),ETA,GAMMA,det,
     $            sam+0.01,dis+0.01,dderiv) - temp)*100.0
          ELSEif (isel(np-1) .NE. 0) THEN
             deriv(np-1) = deriv(np-1) + astep*piz(i)/gamma*
     1            (PROFVAL(TWOTH,PIZ(I+1),ETA,GAMMA,det,
     $            sam+0.01,dis,dderiv) - temp)*100.0
          ELSEif (isel(np).NE. 0) THEN
             deriv(np) = deriv(np) + astep*piz(i)/gamma*
     1            (PROFVAL(TWOTH,PIZ(I+1),ETA,GAMMA,det,
     $            sam,dis+0.01,dderiv) - temp)*100.0
          ENDIF
C**********************************************************************
          if (Kalpha12) THEN
             pos2 = asin(sin(PIZ(I+1)*deg2t2rad)*WAVE2/WAVE1)/deg2t2rad
             int2 = RATIO21 * piz(i)
             write (*,*) twoth, PIZ(I+1),pos2
             temp = PROFVAL(TWOTH,pos2,ETA,GAMMA,det,sam,dis,dderiv)
             getval=getval + INT2*ASTEP*temp/gamma
             deriv(3) = deriv(3) + int2*astep*(gamma*dderiv(1)-temp)
     1		/gamma**2
	  deriv(4) = deriv(4) + int2*astep*dderiv(2)/gamma
	  deriv(i) = astep*temp/gamma
	  deriv(i+1) = astep*dderiv(3)*int2/gamma
c no derivative wrt 'sam' in 'profval' - do numerically
C if sam & det are both refined -- constrain them together
          if (isel(np-1) .NE. 0 .AND. isel(np).NE. 0) THEN
             deriv(np-1) = deriv(np-1) + astep*int2/gamma*
     1            (PROFVAL(TWOTH,PIZ(I+1),ETA,GAMMA,det,
     $            sam+0.01,dis+0.01,dderiv) - temp)*100.0
          ELSEif (isel(np-1) .NE. 0) THEN
             deriv(np-1) = deriv(np-1) + astep*int2/gamma*
     1            (PROFVAL(TWOTH,PIZ(I+1),ETA,GAMMA,det,
     $            sam+0.01,dis,dderiv) - temp)*100.0
          ELSEif (isel(np).NE. 0) THEN
             deriv(np) = deriv(np) + astep*int2/gamma*
     1            (PROFVAL(TWOTH,PIZ(I+1),ETA,GAMMA,det,
     $            sam,dis+0.01,dderiv) - temp)*100.0
          ENDIF
          ENDIF
C**********************************************************************
	enddo
      else
c
c Section with no asymmetry below
c
        getval=ZZ
        DO I=5,NP,2
          DEL2T1=TWOTH-PIZ(I+1)
          IF(ABS(DEL2T1/GAMMA).LE.2.0) then
	    gaus=cg*(1.-eta)*exp(-(del2t1*arg/gamma)**2)
	    dgdeta = - cg*exp(-(del2t1*arg/gamma)**2)
	    dgdgamma = 2.0 * gaus * (del2t1 * arg)**2/gamma**3
	    dgdp = (2.0 * arg**2 * del2t1 * gaus)/gamma**2
	  else
	    dgdeta = 0.0
	    dgdgamma = 0.0
	    dgdp = 0.0
            gaus = 0.0
	  endif
          alor=cl*eta/(1.+(2.0*del2t1/gamma)**2)
          dadeta = cl/(1.+(2.0*del2t1/gamma)**2)
	  dadgamma = 8.0 * cl * eta * del2t1**2 * gamma
     1		/(4.0*del2t1**2 + gamma**2)**2
	  dadp = 8.0 * cl * eta * gamma**2 * del2t1
     1	    /(gamma**2 + 4.0 * del2t1**2)**2
	  getval = getval + PIZ(I)*ASTEP*(GAUS+ALOR)/GAMMA
	  deriv(i) = astep*(gaus+alor)/gamma
	  deriv(i+1) = piz(i)*astep*(dadp+dgdp)/gamma
	  deriv(3) = deriv(3) + piz(i)*astep*(gamma*(dadgamma+dgdgamma)
     1	    - alor - gaus)/gamma**2
	  deriv(4) = deriv(4)+piz(i)*astep*(dadeta+dgdeta)/gamma
C**********************************************************************
          if (Kalpha12) THEN
C     convert 2theta to kalpha2
             pos2 = asin(sin(PIZ(I+1)*deg2t2rad)*WAVE2/WAVE1)/deg2t2rad
             int2 = RATIO21 * piz(i)
           write (*,*) twoth, PIZ(I+1),pos2
             DEL2T1=TWOTH-pos2
             IF(ABS(DEL2T1/GAMMA).LE.2.0) then
                gaus=cg*(1.-eta)*exp(-(del2t1*arg/gamma)**2)
                dgdeta = - cg*exp(-(del2t1*arg/gamma)**2)
                dgdgamma = 2.0 * gaus * (del2t1 * arg)**2/gamma**3
                dgdp = (2.0 * arg**2 * del2t1 * gaus)/gamma**2
             else
                dgdeta = 0.0
                dgdgamma = 0.0
                dgdp = 0.0
                gaus = 0.0
             endif
             alor=cl*eta/(1.+(2.0*del2t1/gamma)**2)
             dadeta = cl/(1.+(2.0*del2t1/gamma)**2)
             dadgamma = 8.0 * cl * eta * del2t1**2 * gamma
     1            /(4.0*del2t1**2 + gamma**2)**2
             dadp = 8.0 * cl * eta * gamma**2 * del2t1
     1            /(gamma**2 + 4.0 * del2t1**2)**2
             getval = getval + INT2*ASTEP*(GAUS+ALOR)/GAMMA
             deriv(i) = deriv(i) + astep*(gaus+alor)/gamma
             deriv(i+1) = deriv(i+1) + int2*astep*(dadp+dgdp)/gamma
             deriv(3) = deriv(3) + int2*astep*(gamma*(dadgamma+dgdgamma)
     1            - alor - gaus)/gamma**2
             deriv(4) = deriv(4) + int2*astep*(dadeta+dgdeta)/gamma
          ENDIF
C**********************************************************************
        enddo
      endif
      return
      end 
