# tcl/tk script to run indexing programs. Runs in background and pops up a window
# when the program completes
package require Tk
#package require tkcon
#tkcon show
wm title . "Autoindexing Complete"
wm withdraw .
update
gets stdin summfile
#puts $summfile
set msg "Background autoindexing runs are complete. Output for each run can be found in [pwd] with the following files:\n\n"
set lines 1
while {[gets stdin item] >= 0} {
    #puts $item
    foreach {img fileroot out} $item {}
    if {[catch {
	puts "exec $img < ${fileroot}.inp > ${fileroot}.out"
	exec $img < ${fileroot}.inp > ${fileroot}.out
	append msg "  [file tail $img]: [file tail $out]\n"
	incr lines 3
	catch {file delete ${fileroot}.inp}
    } errmsg]} {
	append msg "\nThe run of [file tail $img] has hit an error: $errmsg. Output may be in $out and [file join [pwd] ${fileroot}.out]\n\n"
	incr lines 5
	wm title . "Error" 
    }
}
append msg "\nUse the \"Review Output\" button in the Index tab to load file [file tail $summfile] see these results."
#text .msg -height $lines -width 40 -relief flat -wrap word -font {Times 18}
#.msg insert end $msg
	frame .msg
	grid [text  .msg.t  \
		-height 10 -width 55 -relief flat -wrap word -font {Times 18} \
		-yscrollcommand ".msg.rscr set" \
		] -row 1 -column 0 -sticky news
	grid [scrollbar .msg.rscr  -command ".msg.t yview" \
		] -row 1 -column 1 -sticky ns
	# give extra space to the text box
	grid columnconfigure .msg 0 -weight 1
	grid rowconfigure .msg 1 -weight 1
	.msg.t insert end $msg
pack .msg -side top -fill both -expand 1
button .ok -width 6 -text OK -under 0 -command "destroy ."
pack .ok -side bottom
set x [expr [winfo screenwidth .]/4]
set y [expr [winfo screenheight .]/4]
wm geom . +$x+$y
wm deiconify .

