#-----------------------------------------------------------------
# read XDA data files
#------- define a command line option -----------------------------
# command line option 
lappend command(cmdopt) -xda
# proc to use 
set command(-xda)  readXDAdata
#--------define a dialog box entry
# menu label
lappend command(readtypes) "XDA data"
# proc for this entry
lappend command(readproc) ReadXDA
# allowed data types
if {$tcl_platform(platform) == "windows"} {
    lappend command(filterlist) {xda}
} else {
    lappend command(filterlist) {xda XDA}
}
# definitions for these data types
set command(ReadXDA_xda_type) "XDA data"
set command(ReadXDA_XDA_type) "XDA data"


proc ReadXDA {file} {
    global command
    if {$file == ""} return
    pleasewait "reading file $file"
    set ret [readXDAdata $file]
    donewait
    if {$ret != ""} {return $ret}
    showlastentry $command(read_filelist)
}

proc readXDAdata {filename} {

    #puts "opening XDA file $filename"
    global graph

    set lnum 0
    # signal errors by quitting
    if [catch {
	set fp [open $filename r]

	# Read up to the first 4 lines of the file and test if 
	# they are the start, stop and step
	
	set npts {}
	for {set i 0} {$i<4} {incr i} {
	    incr lnum
	    set eof [gets $fp line]
	    if {$eof < 0} {return "early end-of-file"} 
	    # use the first line as the title whatever it is
	    set start [lindex $line 0]
	    set last [lindex $line 1]
	    set step [lindex $line 2]
	    if ![catch {set npts [expr 1. + ($last - $start)/$step]}] {
		break
	    }
	}
	if {$npts == ""} {
	    return "Scan range not found in the first 4 lines"
	}
	
	if {$npts > 60000 || $npts < 2} {
	    return "There are $npts points -- something is wrong!"
	}

	# Great!! Now we are positioned to read the data.

	# Initialize the data structure.
	set data [file root [file tail $filename]] 
	# eliminate spaces from the name
	regsub -all " " $data "_" data
	set data [initdata $data]
	global ${data}
	set ${data}(xlabel) "2theta"
	set ${data}(xunits) "2theta"
	set ${data}(ylabel) "counts"
	
	# No missing points
	set ${data}(skip) 0
	set ptsread 0

	# Now, read the rest of the file.
	# until we get to the last data point, an end-of-file or error
	set i 0
	while {[gets $fp line] >= 0} {
	    incr lnum
	    if {$lnum > $::command(maxlines)} {
		return "Read > $::command(maxlines) lines. Something is wrong or change command(maxlines)!"
	    }
	    # assume a space between counts
	    foreach count $line {
		if {$count >= 0} {
		    lappend ${data}(x) [expr $start + ($ptsread-1.)*$step]
		    lappend ${data}(y) [expr $count]
		    lappend ${data}(esd) [expr sqrt(1.*$count)]
		} else {
		    # there are skipped points
		    set ${data}(skip) 1
		}
		incr ptsread
	    }
	}
	if {$ptsread != $npts} {return "$ptsread were read, but expected $npts points!"}
    } errmsg] {
	# try to process the data we have read
	catch {resetdata $data}
	return "XDA error. Error reading line $lnum: $errmsg"
    }
    resetdata $data
    lappend graph(plotlist) $data
    catch {close $fp} test
    #puts "$ptsread valid points read"
    return {}
}
