# $Revision: 421 $ $Date: 2010-09-03 14:58:59 -0500 (Fri, 03 Sep 2010) $
#-----------------------------------------------------------------
# Extract data from GSAS experiments by opening .EXP files 

set command(xunits) 0
set command(yunits) 0

#
# try a few locations for the gsas dump program, if it is not already defined
# is gsaspath defined?
if {[catch {set gsaspath}]} {set gsaspath {}}
catch {lappend gsaspath [file join $env(GSAS) exe]}
lappend gsaspath [file join [file dirname $scriptdir] gsas exe] \
    [file normalize [file join [file dirname $scriptdir] .. gsas exe]] \
    [file normalize [file join [file dirname $scriptdir] .. .. gsas exe]] \
    /usr/local/gsas/exe c:/gsas/exe ~/gsas/exe
# look for tcldump
if [catch {set command(gsasdump)}] {
    foreach loc $gsaspath {
	if {$tcl_platform(platform) == "windows"} {
	  set exefile [file join $loc tcldump.exe]
	} else {
	  set exefile [file join $loc tcldump]
	}
	if [file executable $exefile] {
	    set command(gsasdump) $exefile
	    break
	}
    }
}
# nope, try hstdmp
if [catch {set command(gsasdump)}] {
    foreach loc $gsaspath {
	if {$tcl_platform(platform) == "windows"} {
	  set exefile [file join $loc hstdmp.exe]
	} else {
	  set exefile [file join $loc hstdmp]
	}
	if [file executable $exefile] {
	    set command(gsasdump) $exefile
	    break
	}
    }
}

if [catch {set command(gsasdump)}] {set command(gsasdump) {}}

#------- define a command line option -----------------------------
# define these options only if a GSAS "dump" program can be located
if [file executable $command(gsasdump)] {
    #------- define a command line option -----------------------------
    # command line option 
    # proc to use 
    #--------define a dialog box entry
    # menu label
    lappend command(readtypes) "GSAS EXP File"
    # proc for this entry
    lappend command(readproc) ReadGSASEXP
    # allowed data types
    lappend command(filterlist) EXP
    # definitions for these data types
    set command(ReadGSASEXP_EXP_type) "GSAS experiment"
}

proc ReadGSASEXP {file} {
    global command
    if {$file == ""} return
    if ![file isfile $file] {return "file $file is invalid"}
    catch {destroy .gsas}
    toplevel .gsas
    pack [label .gsas.top -text "Reading $file"\
	    -anchor center] -side top -fill x
    pack [frame .gsas.g -bd 2 -relief groove] -side top -fill x
    grid [label .gsas.g.top -text "Select histogram(s)"] \
	    -row 0 -column 0 -columnspan 9
    set col -1
    set row 1
    set command(gsashistlist) [EXPmap $file]
    # create a list of checkbuttons
    foreach i $command(gsashistlist) {
	grid [checkbutton .gsas.g.$i -text "$i  " \
		-variable command(gsashist$i)] \
		-column [incr col] -row $row -sticky w
	if {[llength $command(gsashistlist)] == 1} {set command(gsashist$i) 1}
	if {$col >= 9} {
	    set col -1
	    incr row
	}
    }
    if {[file root [file tail $command(gsasdump)]] == "tcldump"} {
	pack [frame .gsas.u -bd 2 -relief groove] -side top -fill x
	grid [label .gsas.u.x0 -text "X units"] -column 0 -row 0
	grid [radiobutton .gsas.u.x1 -text "As collected" \
		-variable command(xunits) -value 0] -column 1 -row 1
	grid [radiobutton .gsas.u.x2 -text "d-space" \
		-variable command(xunits) -value 1] -column 2 -row 1
	grid [radiobutton .gsas.u.x3 -text "Q" \
		-variable command(xunits) -value 2] -column 3 -row 1
	grid [label .gsas.u.y0 -text "Y units"] -column 0 -row 2
	grid [radiobutton .gsas.u.y1 -text "As collected" \
		-variable command(yunits) -value 0] -column 1 -row 3
	grid [radiobutton .gsas.u.y2 -text "Normalized" \
		-variable command(yunits) -value 1] -column 2 -row 3
    }
    pack [button .gsas.done -text OK -command "destroy .gsas"] -side bottom
    putontop .gsas
    tkwait window .gsas
    afterputontop
    foreach i $command(gsashistlist) {
	if {$command(gsashist$i)} {
	    pleasewait "reading file $file\nhistogram $i"
	    set ret [readgsasexp $file $i]
	    donewait
	    if {$ret != ""} {return $ret}
	}
    }
    showlastentry $command(read_filelist)
}

# EXPmap returns a list of powder histograms
proc EXPmap {expfile} {
    # $expfile is the path to the data file.
    if [catch {set fil [open "$expfile" r]}] {
	tk_dialog .expFileErrorMsg "File Open Error" \
		"Unable to open file $expfile" error 0 "Exit" ; return {}
    }
    set len [gets $fil line]
    if {[string length $line] != $len} {
	tk_dialog .expConvErrorMsg "old tcl" \
		"You are using an old version of Tcl/Tk and your .EXP file has binary characters; run convstod or upgrade" \
		error 0 "Exit"
	return {}
    }
    if {$len > 160} {
	# a UNIX-type file
	set i1 0
	set i2 79
	while {$i2 < $len} {
	    set nline [string range $line $i1 $i2]
	    incr i1 80
	    incr i2 80
	    set key [string range $nline 0 11]
	    set exparray($key) [string range $nline 12 end]
	}
    } else {
	while {$len > 0} {
	    set key [string range $line 0 11]
	    set exparray($key) [string range $line 12 end]
	    set len [gets $fil line]
	}
    }
    close $fil

    # now get the histogram types
    set nhist [string trim [readexp { EXPR  NHST }]]
    set n 0
    set expmap(powderlist) {}
    for {set i 0} {$i < $nhist} {incr i} {
	set ihist [expr $i + 1]
	if {[expr $i % 12] == 0} {
	    incr n
	    set line [readexp " EXPR  HTYP$n"]
	    if {$line == ""} {
		set msg "No HTYP$n entry for Histogram $ihist. This is an invalid .EXP file"
		tk_dialog .badexp "Error in EXP" $msg error 0 Exit 
		return $expmap(powderlist)
	    }
	    set j 0
	} else {
	    incr j
	}
	set expmap(htype_$ihist) [lindex $line $j]
	# at least for now, ignore non-powder histograms
	if {[string range $expmap(htype_$ihist) 0 0] == "P"} {
	    lappend expmap(powderlist) $ihist
	}
    }
    return $expmap(powderlist)
}

# return the value for a ISAM key
proc readexp {key} {
    upvar exparray exparray
    # truncate long keys & pad short ones
    set key [string range "$key        " 0 11]
    if [catch {set val $exparray($key)}] {
	return ""
    }
    return $val
}

# select histogram number
# make peaks with tick marks
proc readgsasexp {file {hst 1}} {
    global command graph
    # signal errors by quitting
    if [catch {
	set curdir [pwd]
	if {$file == ""} return
	cd [file dirname $file]
	set expnam [file tail [file root $file]]
	if {[file root [file tail $command(gsasdump)]] == "hstdmp"} {
	    set input [open "hstdmp.inp" w]
	    puts $input "o"
	    puts $input "$hst"
	    puts $input "1"
	    puts $input "99999"
	    puts $input "0"
	    puts $input "0"
	    close $input
	    #trap an error
	    if [catch {
		exec $command(gsasdump) $expnam < hstdmp.inp > hstdmp.out
	    } err] {
		return "Error running hstdmp. Error message: $err"
	    }    
	    set input [open "hstdmp.out" r]
	    # parse the output from hstdmp
	    set num -1
	    set xlist {}
	    set obslist {}
	    set calclist {}
	    set difflist {}
	    set esdlist {}
	    set units {}
	    # define a list of reflection positions for each phase
	    for {set i 1} {$i < 10} {incr i} {
		set reflns($i) {}
		set reflns(flag$i) 0
	    }
	    set i 0
	    while {[gets $input line] >= 0} {
		#	    puts $line
		incr i
		# run update every tenth point
		#	if {$i > 10} {set i 0; update}
		if [scan $line %d num] {
		    if {$num > 0} {
			scan [string range $line 8 end] %e%e%e%e%e%e \
				X Iobs Icalc Ispec fixB fitB
			#puts "$X [string range $line 7 7]"
			set pointflag [string range $line 7 7]
			# eliminate excluded points
			if {$Ispec > 0.0} {
			    lappend xlist $X
			    lappend esdlist 1
			    lappend obslist $Iobs
			    lappend calclist $Icalc
			    lappend difflist [expr $Iobs - $Icalc]
			}
			# add peaks to peak lists
			if [regexp {[1-9]} $pointflag ph] {lappend reflns($ph) $X}
		    } 
		} else {
		    regexp {Time|Theta|keV} $line units
		}
	    }
	    close $input
	    file delete hstdmp.inp hstdmp.out
	    set lasthst $hst
	    #  ok we've got it read
	    foreach type {obs calc dif} \
		    var {obslist calclist difflist} {
			set data ${expnam}_${hst}_$type
			# eliminate spaces from the name
			regsub -all " " $data "_" data
			set data [initdata $data]
		global $data
		set ${data}(x) $xlist
		set ${data}(y) [set $var]
		set ${data}(esd) $esdlist
		if {$units == "Theta"} {
		    set ${data}(xlabel) "2theta"
		    set ${data}(xunits) "2theta"
		} elseif {$units == "Time"} {
		    set ${data}(xlabel) "microsec"
		    set ${data}(xunits) "TOF"
		} elseif {$units == "keV"} {
		    set ${data}(xlabel) "keV"
		    set ${data}(xunits) "EDSKEV"
		}
		set ${data}(ylabel) "scaled counts"
		resetdata $data
		lappend graph(plotlist) $data
	    }
	    for {set i 1} {$i < 10} {incr i} {
		if {[llength $reflns($i)] > 0} {
		    set data [file root [file tail $file]]_${hst}_ref$i
		    # eliminate spaces from the name
		    regsub -all " " $data "_" data
		    set data [initpeaks $data]
		    global $data
		    set ${data}(x) $reflns($i)	    
		    if {$units == "Theta"} {
			set ${data}(xlabel) "2theta"
			set ${data}(xunits) "2theta"
		    } elseif {$units == "Time"} {
			set ${data}(xlabel) "microsec"
			set ${data}(xunits) "TOF"
		    } elseif {$units == "keV"} {
			set ${data}(xlabel) "keV"
			set ${data}(xunits) "EDSKEV"
		    }
		    set ${data}(ylabel) "arbitrary"
		    resetdata $data
		}
	    }
	} elseif {[file root [file tail $command(gsasdump)]] == "tcldump"} {
	    set input [open "tcldump.inp" w]
	    puts $input "$hst"
	    # x units 
	    puts $input "$command(xunits)" 
	    # y units
	    puts $input "$command(yunits)" 
	    # format (if implemented someday)
	    puts $input "0" 
	    close $input
	    # initalize arrays
	    set X {}
	    set OBS {}
	    set CALC {}
	    set BKG {}
	    eval [exec $command(gsasdump) $expnam < tcldump.inp]
	    catch {file delete tcldump.inp}
	    if {$X == ""} {
		return "Error in tcldump reading Histogram $hst"
	    }
	    set esdlist {}
	    foreach val $WGT {
		if {$val > 0} {
		    lappend esdlist [expr 1. / sqrt($val)]
		} else {
		    lappend esdlist 0
		}
	    }
	    set difflist {}
	    foreach o $OBS c $CALC {
		lappend difflist [expr $o - $c]
	    }
	    foreach type {obs calc bck dif} \
		    var {OBS CALC BKG difflist} {
			set data ${expnam}_${hst}_$type
			# eliminate spaces from the name
			regsub -all " " $data "_" data
			set data [initdata $data]
		global $data
		set ${data}(x) $X
		set ${data}(y) [set $var]
		set ${data}(esd) $esdlist
		if {$xunits == "Theta"} {
		    set ${data}(xlabel) "2theta"
		    set ${data}(xunits) "2theta"
		} elseif {$xunits == "Time"} {
		    set ${data}(xlabel) "microsec"
		    set ${data}(xunits) "TOF"
		} elseif {$xunits == "keV"} {
		    set ${data}(xlabel) "keV"
		    set ${data}(xunits) "EDSKEV"
		} else {
		    set ${data}(xlabel) $xunits
		    set ${data}(xunits) $xunits
		}
		set ${data}(ylabel) $yunits
		resetdata $data
		lappend graph(plotlist) $data
	    }
	    for {set i 1} {$i < 10} {incr i} {
		if {[llength $reflns($i)] > 0} {
		    set data [file root [file tail $file]]_${hst}_ref$i
		    # eliminate spaces from the name
		    regsub -all " " $data "_" data
		    set data [initpeaks $data]
		    global $data
		    set ${data}(x) $reflns($i)	    
		    if {$xunits == "Theta"} {
			set ${data}(xlabel) "2theta"
			set ${data}(xunits) "2theta"
		    } elseif {$xunits == "Time"} {
			set ${data}(xlabel) "microsec"
			set ${data}(xunits) "TOF"
		    } elseif {$xunits == "keV"} {
			set ${data}(xlabel) "keV"
			set ${data}(xunits) "EDSKEV"
		    } else {
			set ${data}(xlabel) $xunits
			set ${data}(xunits) $xunits
		    }
		    set ${data}(ylabel) $yunits
		    resetdata $data
		}
	    }
	}
	cd $curdir	
    } errmsg] {
	cd $curdir
	return "GSAS EXP error. Error reading: $errmsg"
    }
}
