#-----------------------------------------------------------------
# read SIETRONICS (Siroquant CPI) ASCII data files
#------- define a command line option -----------------------------
# command line option 
lappend command(cmdopt) -cpi
# proc to use 
set command(-cpi) readCPIdata
#--------define a dialog box entry
# menu label
lappend command(readtypes) "Siroquant CPI (SIETRONICS)"
# proc for this entry
lappend command(readproc) ReadCPI
# allowed data types
lappend command(filterlist) {cpi}
# definitions for these data types
set command(ReadCPI_cpi_type) "Siroquant CPI data"

proc ReadCPI {file} {
    global command
    if {$file == ""} return
    pleasewait "reading file $file"
    set ret [readCPIdata $file]
    donewait
    if {$ret != ""} {return $ret}
    showlastentry $command(read_filelist)
}

proc readCPIdata {filename} {

    #puts "opening Siroquant CPI file $filename"
    global graph

    set lnum 0
    # signal errors by quitting
    if [catch {
	set fp [open $filename r]

	incr lnum
	set eof [gets $fp line]
	if {$eof < 0} {return "early end-of-file"} 
	if {[string trim $line] != "SIETRONICS XRD SCAN"} {
	    return {first line not "SIETRONICS XRD SCAN"}
	}

	# Now, read the start, step and end angle
	incr lnum
	set eof [gets $fp line]
	if {$eof < 0} {return "early end-of-file"} 
	set start [string trim $line]
	incr lnum
	set eof [gets $fp line]
	if {$eof < 0} {return "early end-of-file"} 
	set last [string trim $line]
	incr lnum
	set eof [gets $fp line]
	if {$eof < 0} {return "early end-of-file"} 
	set step [string trim $line]
	# check for valid numbers
	if [catch {set npts [expr round(1. + ($last - $start)/$step)]}] {
	    return "Invalid scan range: $start, $step, $last"
	}
	if {$lnum > $::command(maxlines)} {
	    return "Read > $::command(maxlines) lines. Something is wrong or change command(maxlines)!"
	}

	incr lnum
	set eof [gets $fp anode]
	if {$eof < 0} {return "early end-of-file"} 
	incr lnum
	set eof [gets $fp line]
	if {$eof < 0} {return "early end-of-file"} 
	set wave [string trim $line]

	incr lnum
	set eof [gets $fp line]
	if {$eof < 0} {return "early end-of-file"} 
	incr lnum
	set eof [gets $fp line]
	if {$eof < 0} {return "early end-of-file"} 
	if {[string trim $line] != "1"} {
	    return {line not "1"}
	}

	incr lnum
	set eof [gets $fp title]
	if {$eof < 0} {return "early end-of-file"} 
	incr lnum
	set eof [gets $fp line]
	if {$eof < 0} {return "early end-of-file"} 
	if {[string trim $line] != "SCANDATA"} {
	    return {line not "SCANDATA"}
	}

	# Great!! Now we are positioned to read the data.

	# Initialize the data structure.
	set data [file root [file tail $filename]] 
	# eliminate spaces from the name
	regsub -all " " $data "_" data
	set data [initdata $data]
	global ${data}
	if {[string trim $anode] == "Xx" && $wave > 2.5} {
	    set ${data}(xlabel) "keV"
	    set ${data}(xunits) "EDSKEV"	    
	} else {
	    set ${data}(xlabel) "2theta"
	    set ${data}(xunits) "2theta"
	}
	set ${data}(ylabel) "counts"
	set ${data}(wavelength) $wave
	
	# No missing points
	set ${data}(skip) 0
	set ${data}(title) $title
	set ptsread 0

	# Now, read the rest of the file.
	# until we get to the last data point, an end-of-file or error
	set i 0
	while {[gets $fp line] >= 0} {
	    incr lnum
	    if {$lnum > $::command(maxlines)} {
		return "Read > $::command(maxlines) lines. Something is wrong or change command(maxlines)!"
	    }
	    set count [string trim $line]
	    if {$count >= 0} {
		lappend ${data}(x) [expr $start + ($ptsread-1.)*$step]
		lappend ${data}(y) [expr $count]
		lappend ${data}(esd) [expr sqrt(1.*$count)]
	    } else {
		# there are skipped points
		set ${data}(skip) 1
	    }
	    incr ptsread
	}
	if {$ptsread != $npts} {return "$ptsread were read, but expected $npts points!"}
    } errmsg] {
	# try to process the data we have read
	catch {resetdata $data}
	return "Siroquant CPI error. Error reading line $lnum: $errmsg"
    }
    resetdata $data
    lappend graph(plotlist) $data
    catch {close $fp} test
    #puts "$ptsread valid points read"
    return {}
}
