#-----------------------------------------------------------------
# read mda data from EPICS
#     customized for 11-BM
# $Revision: 421 $ $Date: 2010-09-03 14:58:59 -0500 (Fri, 03 Sep 2010) $
#------- define a command line option -----------------------------
# command line option 
#lappend command(cmdopt) -epics -epics
# proc to use 
#set command(-EPICS) readEPICSdata
#set command(-epics) readEPICSdata
#--------define a dialog box entry
# menu label
lappend command(readtypes) "11-BM MDA data"
# proc for this entry
lappend command(readproc) ReadEPICS11BM
# are the MDA processing programs anywhere to be found?
set dirlist [list {} $scriptdir [file join $scriptdir mdautils]]
if {$tcl_platform(platform) != "windows"} {
    lappend dirlist "/usr/local/bin" "~/bin" 
    foreach dir $dirlist {
	set command(mda_fltr) [auto_execok [file join $dir mda2ascii]]
	if {$command(mda_fltr) != ""} break
    }
} else {
    lappend dirlist "C:/MDAUTILS"  "~/MDAUTILS"
    foreach dir $dirlist {
	set command(mda_fltr) [auto_execok [file join $dir mda2ascii.exe]]
	if {$command(mda_fltr) != ""} break
    }
}
 
# allowed data types
if {$command(mda_fltr) != ""} {
    lappend command(filterlist) {asc mda}
} else {
    lappend command(filterlist) {asc}
}

# DEFINITIONS for these data types
#set command(ReadEPICS_ascii_type) "EPICS scan file"
#set command(ReadEPICS_asc_type) "EPICS scan file"
#set command(ReadEPICS_mda_type) "EPICS scan file"

proc ReadEPICS11BM {file} {
    global command
    if {$file == ""} return
#    pleasewait "reading file $file"
    set ret [readEPICS11mda $file]; # MDA2ASCII output
#    donewait
    if {$ret != ""} {return $ret}
    showlastentry $command(read_filelist)
}

#--------------------------------------------------------------------------
set command(MonitorMode) 1
set command(chooseMon) (none)
set command(MonitorScale) 1.0
set command(xcutoff) 0.5
set command(MinMonFrac) 0.25
trace variable command(MonitorMode) w 11BMDisableMonitorBoxes
trace variable command(chooseMon) w 11BMDisableMonitorBoxes
proc 11BMDisableMonitorBoxes {args} {
    global command
    if {! [winfo exists .ask]} return
    if {$command(chooseMon) == "(none)"} {
	.ask.4a.c.a config -state disabled
	.ask.4a.b config -state disabled
	.ask.4a.b1 config -state disabled
    } else {
	.ask.4a.c.a config -state normal
	.ask.4a.b config -state normal
	.ask.4a.b1 config -state normal
    }
    if {$command(chooseMon) == "(none)" || $command(MonitorMode)} {
	.ask.4a.c.b config -state disabled
    } else {
	.ask.4a.c.b config -state normal
    }
}

# load data from EPICS via MDA2ASCII or using MDA2ASCII as a filter
proc readEPICS11mda {filename} {
    global graph command
    # zero shifts -- pre 2008
    array set zeroshift {
	1 10
	2 8
	3 6
	4 4
	5 2
	6 0
	7 -2
	8 -4
	9 -6
	10 -8
	11 -10
	12 -12
    }
    set year 0
    set clockCol 2
    set BeamCol 5
    # signal errors by quitting
    if {[string tolower [file extension $filename]] == ".mda" && \
	    $command(mda_fltr) != ""} {
	set opencmd "| $command(mda_fltr) -o- $filename"
    } else {
	set opencmd $filename
    }
    set flnm [file tail $filename]
    set scnnm {?}

    if [catch {
	#puts "opening EPICS file $filename"
	set fl [open $opencmd r]
	set lnum 0
	set command(mode) 0
	set scan 0
	set mode step

	set ptsread 0
	# read the header
	set line {}
	while {[string trim $line] != "# 1-D Scan Values"} {
	    if {[gets $fl line] < 0} {return "Unexpected end of file"}
	    incr lnum
	    # store the extra PV info
	    if {[string range $line 0 9] == "# Extra PV"} {
		set ln [string range $line 10 end]
		set PVnum [string trim [lindex [split $ln ":"] 0]]
		set pos [string first {:} $ln]
		incr pos
		set ln [string range $ln $pos end]
		set key [string trim [lindex [split $ln ,] 0]]		
		set PV($key) $ln
		if {[regexp {scanNumber.*"([0-9]+)".*} $ln x y]} {set scnnm $y}
	    }
	    if {[string first "# Scan time" $line] != -1} {
		set pos [string first = $line]
		incr pos
		set end [string last . $line]
		incr end -1
		set date [string range $line $pos $end]
		set year [clock format [clock scan $date] -format %Y ]
	    }
	    # parse put the column labels
	    if {[string trim $line] == "# Column Descriptions:"} {
		if {[gets $fl line] < 0} {return "Unexpected end of file"}
		incr lnum
		while {[set col [lindex $line 1]] != ""} {
		    # is this a slew scan? (not very well flagged at present)
		    if {[regexp {Positioner.*FLY.*} $line]} {set mode slew}
		    set x {[}; set delim {]}; # workaround for emacs indent bug
		    set pos [string first $delim $line]
		    incr pos
		    set lbl [string trim [lindex [split [string range $line $pos end] ,] 0]]
		    if {$lbl == ""} {set lbl "Index"}
		    lappend collist $lbl
		    if {[gets $fl line] < 0} {return "Unexpected end of file"}
		}
	    }
	}
	if {$year == 0} {
	    return "Error: year not read"
	} elseif {$year >= 2008} {
	    foreach num [array names zeroshift] {
		set zeroshift($num)  [expr {($num-1)*2}]
	    }
	}
	# slew scan, extract the start position & step
	if {$mode == "slew"} {
	    set scanstart {}
	    set scanstep {}
	    # format as of 2/1/07
	    foreach key [array names PV *slew*] {
		if {[string first start_tth $PV($key)] != -1} {
		    regexp {.*"(\-?[0-9]+\.?[0-9]*)".*} $PV($key) x scanstart
		}
		if {[string first minimal_step $PV($key)] != -1} {
		    regexp {.*"(\-?[0-9]+\.?[0-9]*)".*} $PV($key) x scanstep_min
		}
		if {[string first step_size_input $PV($key)] != -1} {
		    regexp {.*"(\-?[0-9]+\.?[0-9]*)".*} $PV($key) x scanstep
		}
	    }
	    # original format
	    if {$scanstart == "" || $scanstep == ""} {
		foreach key [array names PV] {
		    if {$key == "11bmb:m28.RBV"} {
			regexp {.*"([0-9]+\.?[0-9]*)".*} $PV($key) x scanstart
		    }
		    if {$key == "11bmb:3820:Prescale"} {
			regexp {.*"([0-9]+\.?[0-9]*)".*} $PV($key) x prescale
			# convert preset to step size
			set scanstep [expr {0.0001 * int($prescale)}]
			set scanstep_min $scanstep
		    }
		}
	    }
	    if {$scanstart == "" || $scanstep == ""} {
		return "Error parsing slew scan step info"
	    }
	}
    } errmsg] {
	return $errmsg
    }


    # set defaults 
    if {$mode == "slew"} {
	# use larger of input scanstep & minimum value
	if {$scanstep_min > $scanstep} {set scanstep $scanstep_min}
	# don't use 1st column in slew scan file
	set collist [lreplace $collist 1 1 2theta]
    }
    set command(chooseX)  [lindex $collist 1]
    set command(chooseMon)  [lindex $collist 3]
    
    # make a window to select x & y
    catch {toplevel .ask}
    eval destroy [winfo children .ask]
    if {$mode == "slew"} {
	wm title .ask "11-BM Slew Scan"
    } else {
	wm title .ask "11-BM Step Scan"
    }
    pack [label .ask.1 \
	      -text "Choose the entries to read"] -side top
    pack [frame .ask.2] -side top
    pack [label .ask.2.a -text "X-axis"] -side left
    eval tk_optionMenu .ask.2.b command(chooseX) $collist
    pack .ask.2.b -side left
    set n 0
    set jj 0
    set indexlist {}
    set lbllist {}
    set num {}
    foreach var $collist {
	if {$mode == "slew"} {
	    regexp {mca([0-9]+)\.VAL} $var junk num
	} else {
	    regexp {scaler1\.S([0-9]+)} $var junk num
	}
	if {$num == ""} {
	    incr n
	    continue
	}
	if {$num >= 11} {
	    lappend indexlist $n
	    incr jj
	    lappend lbllist Channel$jj
	}
	incr n
    }
    
    pack [frame .ask.3] -side top
    pack [label .ask.3.a -text "X min"] -side left
    pack [entry .ask.3.b -width 6 -textvariable command(xcutoff)] -side left
    
    pack [frame .ask.4] -side top
    pack [label .ask.4.a -text "Monitor"] -side left
    eval tk_optionMenu .ask.4.b command(chooseMon) [concat (none) $collist]
    pack .ask.4.b -side left
    pack [frame .ask.4a] -side top
    pack [label .ask.4a.a -text "Scale Monitor to:" -anchor w] -side top -anchor w
    pack [radiobutton .ask.4a.b -text "cps @ 100 mA" \
	      -variable command(MonitorMode) -value 2] -side top -anchor w
    pack [radiobutton .ask.4a.b1 -text "First monitor value" \
	      -variable command(MonitorMode) -value 1] -side top -anchor w
    pack [frame .ask.4a.c] -side top
    pack [radiobutton .ask.4a.c.a -text "or value:" \
	      -variable command(MonitorMode) -value 0] -side left 
    #	pack [label .ask.4a.c.a -text "(or) value:"] -side left
    pack [entry .ask.4a.c.b -width 10 -textvariable command(MonitorScale)] -side left
    pack [frame .ask.6 -relief groove -bd 2] -side top -expand yes -fill both
    pack [label .ask.6.a -text "Drop points where monitor drops" -anchor w] -side top -anchor w
    pack [label .ask.6.b -text "below " -anchor w] -side left -anchor w
    pack [entry .ask.6.c -width 5 -textvariable command(MinMonFrac)] -side left
    pack [label .ask.6.d -text " times the initial monitor" -anchor w] -side left -anchor w
    pack [frame .ask.5 -relief groove -bd 2] -side top -expand yes -fill both
    pack [checkbutton .ask.5.b -text "Calibrate & Scale" \
	      -variable command(Calibrate11BM) \
	      -command "Read11Calibrate .ask.5.a" \
	     ] -side top -anchor w
    11BMDisableMonitorBoxes
    Read11Calibrate .ask.5.a

    pack [frame .ask.c] -side top
    set command(cancel) 0
    pack [button .ask.c.a -text "Read" -command "destroy .ask"] -side left	
    pack [button .ask.c.c -text "Cancel" -command "set command(cancel) 1; destroy .ask"] -side left	
    putontop .ask
    tkwait window .ask
    afterputontop
    if {$command(cancel)} {return "Read cancelled"}

    pleasewait "reading file..."
    update idletasks

    set MinMon ""
    set command(clock) 2
    set startclock 0
    if [catch {
	set command(Xcol) [lsearch $collist $command(chooseX)]
	set command(Mcol) [lsearch $collist $command(chooseMon)]
	set FirstMonitorVal $command(MonitorScale)
	if {$command(MonitorMode)} {
	    set FirstMonitorVal ""
	} 

	foreach n $indexlist {
	    set xlist($n) {}
	    set ylist($n) {}
	    set esdlist($n) {}
	}

	set i -1
	while {[gets $fl line] >= 0} {
	    incr i
	    incr lnum
	    # rescue the incompetent
	    if {$lnum > 10*$::command(maxlines)} {
		return "Read > 10*$::command(maxlines) lines. Something is wrong or change command(maxlines)!"
	    }

	    # reading the data
	    set x [lindex $line $command(Xcol)] 
	    # kludge a slew scan correction for the scan var
	    if {$mode == "slew" && $command(chooseX) == "2theta"} {
		set x [expr {$scanstart + $i * $scanstep}]
	    }
	    if {$x != ""} {
		set mon [lindex $line $command(Mcol)]
		# is this the first valid monitor, set the minimum allowed
		set clock [lindex $line $command(clock)]
		if {$MinMon == "" && $mon != ""} {
		    set MinMon [expr {$command(MinMonFrac) * $mon}]
		    set startclock $clock
		} elseif {$i <= 10 && $clock < $startclock} {
		    set MinMon [expr {$command(MinMonFrac) * $mon}]
		    set startclock $clock
		}
		# drop points below the minimum monitor
		if {$MinMon != "" && $mon != ""} {
		    if {$mon < $MinMon} continue
		}
		# is this the first valid point and are we scaling by monitor?
		if {$command(chooseMon) != "(none)" && \
			$FirstMonitorVal == "" && $mon != ""} {
		    if {$command(MonitorMode) == 1} {
			set FirstMonitorVal $mon
			# save this as the default for subsequent files
			set command(MonitorMode) 0
			set command(MonitorScale) $mon		    
		    } else {
			set counttime [expr {[lindex $line $clockCol] / 50000000.}]
			set current [expr {([lindex $line $BeamCol]/$counttime \
						- 500) / 5000}] 
			set FirstMonitorVal [expr {
						    $mon * 100. / ($current * $counttime)
						 }]
		    }
		}
		if {$command(chooseMon) != "(none)"} {
		    catch {
			set scale [expr {(1.0* $FirstMonitorVal) / $mon}]
		    }
		} else {
		    set scale 1.
		}
		set jj 0
		foreach n $indexlist {
		    incr jj
		    set y [lindex $line $n]
		    if {$y != ""} {
			set esd 1
			catch {
			    # avoid zero & negative I values
			    if {$y > 0} {
				set esd [expr {sqrt($y)}]
			    }
			    if {$command(Calibrate11BM)} {
				set y [expr {$y * $scale * $command(11BMscale$jj)}]
				set esd [expr {$esd * $scale * $command(11BMscale$jj)}]
				set newx [expr {$x + $zeroshift($jj) - $command(11BMzero$jj)}]
			    } else {
				set y [expr {$y * $scale}]
				set esd [expr {$esd * $scale}]
				set newx [expr {$x + $zeroshift($jj)}]
			    }
			    if {$newx >= $command(xcutoff)} {
				lappend xlist($n) $newx
				lappend ylist($n) $y
				lappend esdlist($n) $esd
			    }
			}
		    }
		}
		incr ptsread
	    }
	}
    } errmsg] {
	# try to process the data we have read
	append errmsg " "
    } else {
	set errmsg ""
    }
    if {$ptsread > 0} {
	catch {
	    set jj 0 
	    foreach n $indexlist lbl $lbllist {
		incr jj
		set data [file root [file tail $filename]]_$jj
		# eliminate spaces from the name
		regsub -all " " $data "_" data
		set data [initdata $data]
		global $data
		set ${data}(skip) 1
		set ${data}(xlabel) $command(chooseX)
		set ${data}(xunits) $command(chooseX)
		if {$command(MonitorMode) == 2} {
		    set ${data}(ylabel) "$lbl (cps @ 100 mA)"
		} else {
		    set ${data}(ylabel) $lbl
		}
		set ${data}(title) "file $flnm scan $scnnm"
		if {$command(chooseMon) != "(none)"} {
		    append set ${data}(title) " Monitor ($command(chooseMon)) corrected"
		}
		set ${data}(x) $xlist($n)
		set ${data}(y) $ylist($n)
		set ${data}(esd) $esdlist($n)
		catch {set ${data}(wavelength) $command(11BMwave$jj)}
		resetdata $data
		lappend graph(plotlist) $data
		#puts "$data: $ptsread valid points read"
	    }
	} err
	append errmsg $err
    }
    donewait
    catch {close $fl} test
    if {$errmsg != ""} {
	return "EPICS error. Error reading line $lnum: $errmsg"
    }
    return {}
}
#set zeros {0.0077 0.0013 -0.0041 0.0148 0.0079 -0.0091 -0.0039 0.0095 0.0087 0.0147 0.0072 0.025}
#set scale {0.9868 0.9756 1.0523 0.8291 1.0417 0.9088 0.9143 1.1020 1.1560 0.9969 1.0547 1.0782}
#set lambda {0.401758 0.401731 0.401763 0.401732 0.401766 0.401743 0.401763 0.401735 0.401756 0.401717 0.401753 0.401719}
#set i 0
#foreach z $zeros s $scale l $lambda {
#    incr i
#    set command(11BMwave$i) $l
#    set command(11BMscale$i) $s
#    set command(11BMzero$i) $z
#}
#unset zeros scale lambda

proc Read11Calibrate {frame} {
    global command scriptdir
    catch {destroy $frame}
    if {$command(Calibrate11BM)} {
	pack [frame $frame] -side top
	grid [label $frame.w0 -text wavelength] -row 0 -column 1
	grid [label $frame.s0 -text scale] -row 0 -column 2
	grid [label $frame.z0 -text "zero offset"] -row 0 -column 3
	for {set i 1} {$i <= 12} {incr i} {
	    grid [label $frame.n$i -text $i] -column 0 -row $i
	    grid [entry $frame.w$i -textvariable command(11BMwave$i) -width 10\
		     ] -column 1 -row $i
	    grid [entry $frame.s$i -textvariable command(11BMscale$i) -width 8\
		     ] -column 2 -row $i
	    grid [entry $frame.z$i -textvariable command(11BMzero$i) -width 9\
		     ] -column 3 -row $i
	}
	set types {{ {11BM Calibration Files} {*.calib}}}
	if {[file exists [file join $scriptdir readexp.tcl]]} {
	    lappend types { {GSAS Experiment File} {*.EXP}}
	}
	lappend types { All {.*}}
	set filename [tk_getOpenFile -filetypes $types \
			  -title "Select 11-BM Calibration File"]
	if {$filename == "" || ![file exists $filename]} {return}
	if {[file extension $filename] == ".EXP"} {
	    global exparray expmap
	    source  [file join $scriptdir readexp.tcl]
	    expload $filename
	    mapexp
	    set fp [open [file root $filename].calib w]
	    puts $fp "# calibration from $filename"
	    foreach h $expmap(powderlist) {
		puts $fp "[histinfo $h lam1], [histinfo $h zero], [histinfo $h scale]"
	    }
	    close $fp
	    unset exparray expmap
	    set filename [file root $filename].calib
	}
	set fp [open $filename r]
	gets $fp title
	set sum 0
	for {set i 1} {$i <= 12} {incr i} {
	    gets $fp line
	    foreach {l z s} [regsub -all "," $line " "] {}
	    set command(11BMwave$i) $l
	    set command(11BMscale$i) $s
	    set sum [expr {$sum + $s}]
	    set command(11BMzero$i) [expr {$z/100.}]
	}
	close $fp
	for {set i 1} {$i <= 12} {incr i} {
	    set command(11BMscale$i) [expr {$sum / ($command(11BMscale$i) * 12)}]
	}
    }
}
