#--------------------------------------------------------------------
# GUI for editing a file contents
# $Revision: 434 $ $Date: 2010-09-15 23:03:59 -0500 (Wed, 15 Sep 2010) $

# queue a command to execute later
lappend command(ExecuteLater) SetupEditFile
# debug commands
#lappend command(ExecuteLater) "package require tkcon; tkcon show"
#append command(finalcommand) {;$command(notebook) raise editfile}


proc SetupEditFile {} {
    global scriptdir menulist helplist
    lappend menulist(compute) EditFile
    lappend menulist(pages) EditFile
    set helplist(EditFile) {
	Edit the information in a loaded file
    }
}

# create the page (once)
proc MakeEditFile {page} {
    global command

    grid [frame $page.a -borderwidth 3 -relief groove] -column 1 -row 0 -sticky nsew
    pack [label $page.a.t1 -text {Select dataset to edit}] -side top
    pack [frame $page.a.2 ] -side top 

    grid columnconfig $page 2 -weight 1
    grid rowconfig $page 1 -weight 1

    set command(edit_page) $page
    set command(edit_box1) $page.a1
    set command(edit_box2) $page.a2
    grid [frame $command(edit_box1) -borderwidth 3 -relief groove] \
	-column 1 -row 1 -sticky nsew
    grid rowconfig $page.a1 99 -weight 1
    grid [frame $command(edit_box2)  -borderwidth 3 -relief groove]\
	-column 2 -row 0 -rowspan 2 -sticky news
    trace variable command(editlist) w setupeditlist
    global DataVariable
    trace variable DataVariable w EditDataList
    set command(InhibitDataVariableTrace) 1
    set command(DataVariableChanged) {}
}

proc EditDataList {var elem mode} {
    global command DataVariable DataVariableAction
    if {$command(InhibitDataVariableTrace)} return
    foreach {data arrelem index widget} $DataVariableAction($elem) {}
    global $data
    if {[catch {expr $DataVariable($elem)} err]} {
	$widget config -fg red
    } else {
	$widget config -fg black
	set ${data}($arrelem) [lreplace [set ${data}($arrelem)] $index $index $DataVariable($elem)]
	set command(DataVariableChanged) $data
	after idle UpdateDataSet
    }
}

proc UpdateDataSet {} {
    global command
    set data $command(DataVariableChanged)
    if {$data == ""} return
    set command(DataVariableChanged) {}
    resetdata $data
}

# "cleanup" the page each time it is selected
proc PostPageEditFile {page}  {
    global graph command

    eval destroy [winfo children $page.a.2]

    set filelist {}
    foreach data $graph(datalist) {
	lappend filelist $data
    }
    if {$filelist == ""} {
	label $page.a.2.a -text {No files read in} -bg yellow
    } else {
	eval tk_optionMenu $page.a.2.a command(editlist) $filelist
	set command(editlist) {}
    }
    pack $page.a.2.a -side top
    set box $command(edit_box1)
    eval destroy [winfo children $box]
    set bx $command(edit_box2)
    eval destroy [winfo children $bx]
}

proc FillEditFileBox {} {
    global command
    set bx $command(edit_box2)
    eval destroy [winfo children $bx]

    grid [frame $bx.l] -column 0 -row 1 -sticky new
    grid [canvas $bx.c -scrollregion {0 0 500 500} -width 0 -height 100 \
	      -xscrollcommand "$bx.x set"] \
	-column 1 -row 1 -sticky news

    grid columnconfigure $bx 1 -weight 1
    grid rowconfigure $bx 1 -weight 1

    grid [scrollbar $bx.x -orient horizontal -command "$bx.c xview"] \
	-column 1 -row 2 -sticky ew
    grid [scrollbar $bx.y] -column 2 -row 1 -sticky ns

    frame [set command(pointsframe) $bx.c.fr]
    $bx.c create window 0 0 -anchor nw -window $command(pointsframe)
    set ps $command(pointsframe)
    grid [entry $command(pointsframe).temp]
    update idletasks
    set n [expr {([winfo height $bx.c] -  [winfo height $bx.x]) /
		 [winfo height $ps.temp] }]
    if {$command(vallength) < $n} {set n $command(vallength)}
    set command(valbox) $n
    destroy $ps.temp

    set data $command(editlist)
    global $data
    if {[set ${data}(type)] == "peaks"} {
	set command(varlist) {x y dspaces widths etas bkgs heights h k l extinctions}
	set titlelist {position Intensity d-space width eta background height h k l ext}
    } else {
	set command(varlist) {x y esd}
	set titlelist {position Intensity s.u.(Int)}
    }
    set i 0
    foreach title $titlelist {
	incr i
	grid [label $ps.h$i -text $title] -column $i -row 0
    }
    for {set i 1} {$i <= $n} {incr i} {
	grid [label $bx.l.$i -width 4 -anchor c] -column 0 -row $i
#	grid [label $ps.l$i -width 4 -anchor c] -column 0 -row $i
	set col 0
	foreach var $command(varlist) {
	    incr col
	    set w 10
	    if {$col >= 8} {set w 4}
	    grid [entry $ps.e${i}_$var -width $w \
		      -textvariable DataVariable(${i}_$var) ] \
		-column $col -row $i
	}
    }

    update idletasks
    # set x the scrollbar length
    set w [lindex [grid bbox $bx.c.fr] 2]
    $bx.c config -scrollregion "0 0 $w 0"
    # position to the head of the box 
    Respond2EditFileScroll moveto 0.0
    $bx.y config -command Respond2EditFileScroll
    # size the number line
    for {set i 0} {$i <= $n} {incr i} {
	grid rowconf $bx.l $i -minsize [lindex [grid bbox $ps 0 $i] 3]
    }
}

proc Respond2EditFileScroll {cmd value {unit ""}} {
    global command
    set bx $command(edit_box2)
    set ps $command(pointsframe)
    set n $command(valbox) 
    set last [expr {$command(vallength)-$n}]
    if {$::tcl_platform(platform) == "windows"} {
	# on windows the scroll drag seems to not reach the full range
	# rescale accordingly
	catch {
	    set value [expr {$value * $command(vallength) * 1. / $last}]
	}	
    }
    if {$unit == ""} {
	set ofst [expr {int(.5 + $last*$value)}]
    } elseif {$unit == "units"} {
#	set c [$ps.l1 cget -text]
	set c [$bx.l.1 cget -text]
	if {[catch {expr $c}]} {set c 1}
	set ofst [expr {$c + $value - 1}]
    } elseif {$unit == "pages"} {
#	set c [$ps.l1 cget -text]
	set c [$bx.l.1 cget -text]
	if {[catch {expr $c}]} {set c 1}
	set ofst [expr {$c + $value*($n-1) - 1}]
    } else {
	puts "Unknown unit = $unit, $value"
    }
    if {$ofst < 0} {set ofst 0}
    if {$ofst > $last} {set ofst $last}
    # fill the box contents
    set data $command(editlist)
    global $data
    global  DataVariable DataVariableAction
    set command(InhibitDataVariableTrace) 1
    for {set i 1} {$i <= $n} {incr i} {
	set index [expr {$ofst + $i - 1}]
#	$ps.l$i config -text [expr {$index + 1}]
	$bx.l.$i config -text [expr {$index + 1}]
	foreach var $command(varlist) {
       	    set DataVariable(${i}_$var) [lindex [set ${data}($var)] $index]
	    set DataVariableAction(${i}_$var) [list ${data} $var $index $ps.e${i}_$var]
	}
    }
    set command(InhibitDataVariableTrace) 0
    set bx $command(edit_box2)
    $bx.y set [expr (1.*$ofst)/$command(vallength)] \
	[expr ($ofst + $n + 0.)/$command(vallength)]
}

# set the data file when the select button is used
proc setupeditlist {a b c} {
    global command graph
    set box $command(edit_box1)
    eval destroy [winfo children $box]

    set bx $command(edit_box2)

    if {$command(editlist) == ""} return
    set data $command(editlist)
    global $data
    set row 0
    grid [label $box.a0 -text "" -anchor c -bg yellow] \
	-column 0 -row $row -sticky ew -columnspan 2
    incr row
    grid [label $box.a$row -text "title" -anchor c] \
	-column 0 -row $row -sticky ew
    grid [entry $box.b$row -textvariable ${data}(title) -width 25] \
	-column 1 -row $row -sticky ew
    incr row
    grid [label $box.a$row -text "X units" -anchor c] \
	-column 0 -row $row -sticky ew
    tk_optionMenu $box.b$row ${data}(xunits) 2theta Q dspace TOF EDSKEV
    grid $box.b$row -column 1 -row $row -sticky w
    incr row
    grid [label $box.a$row -text "X axis label" -anchor c] \
	-column 0 -row $row -sticky ew
    grid [entry $box.b$row -textvariable ${data}(xlabel) -width 12] \
	-column 1 -row $row -sticky w
    incr row
    grid [label $box.a$row -text "Y axis label" -anchor c] \
	-column 0 -row $row -sticky ew
    grid [entry $box.b$row -textvariable ${data}(ylabel) -width 12] \
	-column 1 -row $row -sticky w
    incr row
    grid [label $box.a$row -text "wavelength" -anchor c] \
	-column 0 -row $row -sticky ew
    grid [entry $box.b$row -textvariable ${data}(wavelength) -width 12] \
	-column 1 -row $row -sticky w
    incr row
    grid [label $box.a$row -text "wavelength2" -anchor c] \
	-column 0 -row $row -sticky ew
    grid [entry $box.b$row -textvariable ${data}(wavelength2) -width 12] \
	-column 1 -row $row -sticky w
    set command(vallength) [llength [set ${data}(x)]]
    if {[set ${data}(type)] == "peaks"} {
	$box.a0 config -text "Peaks file \"$data\""
	incr row
	grid [frame $box.cell -bd 3] -column 0 -columnspan 2 -row $row -sticky ew
	foreach var {a b c} num {1 2 3} {
	    grid [label $box.cell.$var -text $var -anchor e] \
		-column 0 -row $num -sticky ew
	    grid [entry $box.cell.e$var -textvariable ${data}($var) -width 10] \
		-column 1 -row $num -sticky w
	}
	foreach var {alpha beta gamma} num {1 2 3} {
	    grid [label $box.cell.$var -text $var -anchor e] \
		-column 2 -row $num -sticky ew
	    grid [entry $box.cell.b$var -textvariable ${data}($var) -width 10] \
		-column 3 -row $num -sticky w
	}
    } else {
	$box.a0 config -text "XY file \"$data\""
    }
    FillEditFileBox
    incr row
    grid rowconfig $box $row -weight 1
    incr row
    grid [button $box.del -text "Delete Dataset" \
	      -command DeleteEditData] -column 0 -columnspan 2 -row $row
    incr row
    grid [button $box.ren1 -text "Rename\nDataset to" \
	      -command RenameEditData] -column 0 -row $row
    grid [entry $box.ren2 -textvariable command(newname) -width 25] \
	-column 1 -row $row -sticky ew
}

proc DeleteEditData {args} {
    global command
    set data $command(editlist)
    global $data
    if {[MyMessageBox -parent . -title "OK to delete?" \
	     -message "OK to delete dataset \"$data\"?" \
	     -icon warning -type {Yes No} -default yes] \
	    != "yes"} return
    deletedata $data
    PostPageEditFile $command(edit_page)
}

proc RenameEditData {args} {
    global command
    set data $command(editlist)
    set newdata $command(newname)
	regsub -all  {\.} $newdata {} newdata
	regsub -all  {[\*\+-]} $newdata {_} newdata
	regsub -all " " $newdata "_" newdata
    global $data
    if {[MyMessageBox -parent . -title "OK to rename?" \
	     -message "OK to rename dataset \"$data\" to \"$newdata\"?" \
	     -icon warning -type {Yes No} -default yes] \
	    != "yes"} return
    copydata $data $newdata
    # destroy the current entry widgets
    PostPageEditFile $command(edit_page)
    deletedata $data
    # reset the page menu
    PostPageEditFile $command(edit_page)
}
