# search for a file with the ICDD database location
# assume that the index files are in a subdirectory of the logic directory
set logicloc {}
set filelist {}
# assemble search path
catch {lappend filelist $::env(LOGIC_LOC)}
catch {lappend filelist [file join $::env(HOME) .icdd_files_loc]}
lappend filelist /usr/local/icdd_files_loc.txt ./icddloc.txt C:/icddloc.txt
# look through the search path
foreach file $filelist {
    if {[file exists $file]} {
	set fp [open $file r]
	# the first line contains the location of the logic database files
	set diskpath [gets $fp]
	close $fp
	set logicloc [file dirname $diskpath]
	break
    }
}

# save it

set filelist [list [file join $logicloc logicGUI.tcl]]
lappend filelist [list [file join $::scriptdir logic logicGUI.tcl]]
lappend filelist [list [file join $::scriptdir ../logic logicGUI.tcl]]
foreach file $filelist {
    if {[file exists $file]} {
	namespace eval logicGUI {
	    set settings(home) [file dirname $::file]
	}
	source $file
	break
    }
}

# queue a command to execute later
lappend command(ExecuteLater) SetupLogic

proc SetupLogic {} {
    global scriptdir interp menulist helplist
    # was the loading of logic successful?

    set status {}
    catch {set status $logic::status}
    if {$status != "OK"} return

    # define the commands needed for the panel
    lappend menulist(compute) Logic
    lappend menulist(pages) Logic
    set helplist(Logic) {
	Search ICDD Database and import data as stick plots
    }
    # initialize variables
}

# create the Logic page (gets done once)
proc MakeLogic {page} {
    global graph 

    pleasewait "Loading Logic software"
    grid [frame $page.a] -row 0 -column 0 -sticky news
    grid [frame $page.b] -row 1 -column 0 -sticky news

    # name the index window
    set ::logicGUI::settings(indexwin) $page.b
    ::logicGUI::CreateLogicEmbWin $page.a
    donewait
}

# update the panel
proc PostPageLogic {page}  {
}
