# write data out in XDA file format.
# blame A.McGhie if it does not work. Not B.Toby
# 04/11/2000

lappend command(writetypes) " XDA (.xda)"
lappend command(writeproc) writexdadump

proc writexdadump {data} {
    global graph command
    global $data 
    set filename [file join $command(pwd) ${data}.xda]
    if {$command(write_useSaveAs)} {
	set filename [tk_getSaveFile -title "Select output file" -parent . \
			  -initialdir [file dirname $filename] \
			  -initialfile [file tail $filename]]
	if {[string trim $filename] == ""} return
    }
    set fil [open $filename w]

    if {$command(writeunits) == 0} {
	set ydata [set ${data}(y)]
	set xdata [set ${data}(x)]
    } else {
	set ydata [[set ${data}(yvector)] range 0 end]
	set xdata [[set ${data}(xvector)] range 0 end]
    }
    if {[set ${data}(type)] == "peaks"} {
	# write a peak file
	MyMessageBox -title "Not implemented" -type OK -default ok \
		-message "Peaks file not implemented for this format"
    } else {
	# write a data file in a gsas format
	puts $fil "Automatically generated file $data from CMPR"
	set line [clock format [clock seconds] -format "%d-%b-%Y %H:%M:%S %A %B %Y -- %j Days"]
	puts $fil "$line"

        # total number of data points
        set nchan [llength $ydata ]
	# should round down (div by 5 for esd)
	set nrec  [expr round ($nchan / 10)  ]          	
	# starting angle in centa degrees
        set start_tt [expr 1.0 * [lindex  $xdata 0] ]
	set end_tt [expr 1.0 * [lindex  $xdata end] ]
	# step size
        set step_size [expr 1.0 * ([lindex $xdata 1] - [lindex $xdata 0]) ]
        set counts_sec 1.0 
	set checkstepsize [expr 1.0 * ([lindex $xdata end] - [lindex $xdata 0]) / ($nchan - 1) ]
	if { $checkstepsize != $step_size } {
	    MyMessageBox -title "Warning" -type OK -default ok \
		    -message "Warning: Step sizes are not correct. $checkstepsize != $step_size"
	}
	# line format
	set line [format "%10.4f%10.4f%10.4f%10.4f" $start_tt $end_tt $step_size $counts_sec ]
	puts $fil "$line"
	# line for debugging
	# puts "$line" 
	set i 0
	set j 0
	# print ou line by line the intensity and the esd.
	while { $i <  $nrec } {
	    incr i
	    set line [format "%7d%7d%7d%7d%7d%7d%7d%7d%7d%7d" \
	 [expr	round ([lindex  $ydata $j           ])] \
	 [expr	round (	[lindex  $ydata [expr $j + 1]])] \
	 [expr	round (	[lindex  $ydata [expr $j + 2]])] \
	 [expr	round (	[lindex  $ydata [expr $j + 3]])] \
	 [expr	round (	[lindex  $ydata [expr $j + 4]])] \
	 [expr	round (	[lindex  $ydata [expr $j + 5]])] \
	 [expr	round (	[lindex  $ydata [expr $j + 6]])] \
	 [expr	round (	[lindex  $ydata [expr $j + 7]])] \
	 [expr	round (	[lindex  $ydata [expr $j + 8]])] \
	 [expr	round (	[lindex  $ydata [expr $j + 9]])] ]

           incr j 10
           puts $fil "$line"
         }
         # print out last line if nchan div 5 remander eq. zero then last line should be zeros.
	 
         for {set i 1} { $i <= 10 } {incr i} {
           if { [lindex $ydata $j] != {} } {
              set y1  [lindex $ydata $j]
              incr j
	      set line [format "%7i" [expr	round ($y1)] ]
              puts -nonewline $fil "$line" 
	   }
         }
    }
    
    close $fil
    return $filename
}
