# write data out in a XYE (TOPAS) file format.
# M. Suchomel; minor updates by B. Toby
# Dec 2009

lappend command(writetypes) " TOPAS file with x,y,esd (.xye)"
lappend command(writeproc) writexye

proc writexye {data} {
    global graph command
    global $data 
    if {[set ${data}(type)] == "peaks"} {
	# write a peak file
	MyMessageBox -title "Not implemented" -type OK -default ok \
		-message "Peaks file not implemented for this format"
	return
    }

    if {$command(writeunits) == 0} {
	set ydata [set ${data}(y)]
	set xdata [set ${data}(x)]
	set esddata [set ${data}(esd)]
    } else {
	set ydata [[set ${data}(yvector)] range 0 end]
	set xdata [[set ${data}(xvector)] range 0 end]
	set esddata [[set ${data}(esdvec)] range 0 end]
    }
    # check step size -- I don't think this is needed for topas (BHT)
    #    set step_size [expr 1.0 * ([lindex $xdata 1] - [lindex $xdata 0]) ]
    #    set checkstepsize [expr 1.0 * ([lindex $xdata end] - [lindex $xdata 0]) \
	#			   / ([llength $ydata ] - 1) ]

    #if {abs($checkstepsize - $step_size)/$checkstepsize > 0.001 } {
    #	MyMessageBox -title "Warning" -type OK -default ok \
	#	    -message "Warning: Step sizes is not uniform ($checkstepsize != $step_size). CMPR only supports uniform step sizes at present"
    #	return
    #    }

    # write a data file in a xye file format
    set filename [file join $command(pwd) ${data}.xye]
    if {$command(write_useSaveAs)} {
	set filename [tk_getSaveFile -title "Select output file" -parent . \
			  -initialdir [file dirname $filename] \
			  -initialfile [file tail $filename]]
	if {[string trim $filename] == ""} return
    }
    set fil [open $filename w]
    puts $fil "/* Automatically generated XYE file $data from CMPR"
    puts $fil [set ${data}(title)]
    puts $fil "*/"

    ## total number of data points
    set nrec  [llength $ydata ]          	
    
    #puts "$line" 
    set i 0
    set j 0
    # print out line by line the intensity and the esd.
    while { $i <  $nrec } {
	incr i	
	set line [format "%10.5f%15.4f%15.4f" \
		      [lindex  $xdata $j ] [lindex  $ydata $j ] [lindex  $esddata $j ]]
	incr j 
	puts $fil "$line"
    
    }

    close $fil
    return $filename
}
