# write one or more comma-separated (spreadsheet-format) files

lappend command(writetypes) ".csv (Spreadsheet)"
lappend command(writeproc) writelistcsv
set command(writelistcsv) {listok}
proc writelistcsv {datalist} {
    global graph command
    set outlist {}
    foreach data $datalist {
	global $data 
	set filename [file join $command(pwd) ${data}.csv]
	if {$command(write_useSaveAs)} {
	    set filename [tk_getSaveFile -title "Select output file" -parent . \
			      -initialdir [file dirname $filename] \
			      -initialfile [file tail $filename]]
	    if {[string trim $filename] == ""} return
	}
	set fil [open $filename w]
	
	if {[set ${data}(type)] == "peaks"} {
	    # write a peak file
	    puts $fil "CMPR peaks file"
	    puts $fil [set ${data}(title)]
	    if {[set ${data}(xunits)] == "dspace"} {
		puts $fil "dspace, intensity, width, background, eta"
	    } elseif {[set ${data}(xunits)] == "Q"} {
		puts $fil "Q, intensity, width, background, eta"
	    } elseif {[set ${data}(xunits)] == "TOF"} {
		puts $fil "TOF, intensity, width, background, eta"
	    } else {
		set wave [set ${data}(wavelength)]
		puts $fil "2theta, intensity, width, height, background, eta, wave=$wave"
	    } 
	    foreach x   [set ${data}(x)] \
		y   [set ${data}(y)] \
		wid [set ${data}(widths)] \
		eta [set ${data}(etas)] \
		h [set ${data}(heights)] \
		bkg [set ${data}(bkgs)] {
		puts $fil "$x, $y, $wid, $h, $bkg, $eta"
		}
	} else {
	    # write a data file
	    puts $fil "twotheta, intensity, esd"
	    if {$command(writeunits) == 0} {
		foreach x   [set ${data}(x)] \
		    y   [set ${data}(y)] \
		    esd [set ${data}(esd)] {
			puts $fil "$x, $y, $esd"
		    }
	    } else {
		foreach x   [[set ${data}(xvector)] range 0 end] \
		    y   [[set ${data}(yvector)] range 0 end] \
		    esd [[set ${data}(esdvec)]  range 0 end] {
			puts $fil "$x, $y, $esd"
		    }
	    }
	}
	close $fil
	lappend outlist $filename
    }
    return $outlist
}
