# write data out in JADE text ascii .mdi file formats
#-------------------------------------------- 
#Version Oct 6 2010 M. Suchomel
# new features, added fconfigure to force windows friendly crlf end of line
#Version Oct 19 2010 M. Suchomel
# Prompt for wavelength if field empty, general cleaning
# tested on MacOS 10.5, RedHat, Windows XP
#-------------------------------------------- 
# Example of JADE MDI file format
#01/07/10 16:53  DIF Automatically generated file 11bmb_4618 from CMPR
# 0.499  0.001  1 L1 0.412245  69.993  69495 
# 89  93.1  93.2  91.7  94.6  91.9  89.5  90.7 
# 86.4  83.4  84.1  88.5  80.9  81.5  87.1  86 ....
#-------------------------------------------- 

lappend command(writetypes) "JADE ascii (.mdi)"
lappend command(writeproc) writeJADEmdi

proc writeJADEmdi {data} {
    global graph command
    global $data 
    
    if {[set ${data}(type)] == "peaks"} {
        write a peak file
        MyMessageBox -title "Not implemented" -type OK -default ok \
        	-message "Peaks file not implemented for this format"
        return
    }

    if {$command(writeunits) == 0} {
    	set ydata [set ${data}(y)]
    	set xdata [set ${data}(x)]
    	set esddata [set ${data}(esd)]
        } else {
    	set ydata [[set ${data}(yvector)] range 0 end]
    	set xdata [[set ${data}(xvector)] range 0 end]
    	set esddata [[set ${data}(esdvec)] range 0 end]
    }

	# check step size
	set step_size [expr 1.0 * ([lindex $xdata 1] - [lindex $xdata 0]) ]
	set checkstepsize [expr 1.0 * ([lindex $xdata end] - [lindex $xdata 0]) \
			       / ([llength $ydata ] - 1) ]

	if {abs($checkstepsize - $step_size)/$checkstepsize > 0.001 } {
	    MyMessageBox -title "Warning" -type OK -default ok \
		-message "Warning: Step sizes is not uniform ($checkstepsize != $step_size)!"
	    continue
    }

    # set file name 
    set filename [file join $command(pwd) ${data}_JADE.mdi]
    if {$command(write_useSaveAs)} {
    	set filename [tk_getSaveFile -title "Select output file" -parent . \
    			  -initialdir [file dirname $filename] \
    			  -initialfile [file tail $filename]]
    	if {[string trim $filename] == ""} return
    }

    set fil [open $filename w]
    
    # use windows friendly end of line character   
    fconfigure $fil -translation crlf
    
	# total number of data points
	set nchan [llength $ydata ]
	
	# determine file line number, step size 2theta range
    # should round down (div by 8 for # of columns)
    set nrec  [expr round ($nchan / 8) ]    
	set itt [lindex $xdata 0]
    set ssize [expr ([lindex $xdata 1] - [lindex $xdata 0])]
    set ftt [lindex  $xdata [expr $nchan - 1]]
    
	# set timestamp to time of mdi file write
	# could change to copy orignal file timestamp? 
    set timestamp [clock format [clock seconds] -format {%D %R}]
    
	# Prompt for wavelength if field empty
    if {[set ${data}(xunits)] == "2theta"} {
    	while {[catch "expr [set ${data}(wavelength)]"]} {
    	    catch {destroy .wave}
    	    toplevel .wave
    	    wm title .wave "Get wavelength"
    	    pack [label .wave.0 -text \
    		    "Enter a wavelength for dataset $data"]
    	    pack [frame .wave.1] -side top -expand yes -fill both
    	    pack [label .wave.1.a -text Wavelength] -side left 
    	    pack [entry .wave.1.b -textvariable ${data}(wavelength)] -side left 
    	    pack [button .wave.2 -text OK -command "destroy .wave"] -side top 
    	    # reuse the last value as the next default
    	    catch {set [set data](wavelength) $command(lastwavelength)}	    
    	    grab .wave
    	    tkwait window .wave
    	    set command(lastwavelength) [set ${data}(wavelength)]
	   }
    }

	# format wavelength field
    set lambda [format "%0.6f" [set ${data}(wavelength)]]

    # header line 1
    set header [format "%s  DIF %s " $timestamp [set ${data}(title)]]
    puts $fil "$header"    
    # header line 2
    set header [format "%0.4f  %0.4f  1  L1 %s %0.4f %0.0f" $itt $ssize $lambda $ftt $nchan]
    puts $fil "$header"

    # initialize line & column counters
    set i 0
    set j 0
    
    # print out file line by line, intensity value only
	while { $i < $nrec } {
	    set line [format "%8.1f%8.1f%8.1f%8.1f%8.1f%8.1f%8.1f%8.1f" \
			  [lindex  $ydata $j           ] [lindex  $ydata [expr $j + 1]] \
			  [lindex  $ydata [expr $j + 2]] [lindex  $ydata [expr $j + 3]] \
			  [lindex  $ydata [expr $j + 4]] [lindex  $ydata [expr $j + 5]] \
			  [lindex  $ydata [expr $j + 6]] [lindex  $ydata [expr $j + 7]]]
        puts $fil "$line"
	    incr j 8
	    incr i
	}

    # print out last line (with no padding zeros at end of file).        
    while { $j < $nchan } {
        set line [format "%8.1f" [lindex $ydata $j]]
        puts -nonewline $fil "$line"
        incr j
    }

    close $fil
    return $filename
}		
