# $Revision: 457 $ $Date: 2010-10-22 16:43:18 -0500 (Fri, 22 Oct 2010) $

set helplist(Write) {\
Used to write one or more datasets in a variety 
of formats.

The box at the top shows the directory where 
files will be written. Note that forward slash 
characters (/) are used, even for Win-95 and -NT.

Refer to the HTML documentation for information 
about adding support for new formats.
}

lappend menulist(file) Write
lappend menulist(pages) Write
set command(writetypes) ""
set command(writeproc) ""

proc MakeWrite {page}  {
    global command
    pack [frame $page.a] -side left -fill both -anchor n
    pack [label $page.a.1a -text {Select dataset(s)}] -side top
    pack [label $page.a.1b -text {to write:}] -side top
    pack [frame $page.a.2 ] -side top
    set command(write_filelist) $page.a.2
    makeselectbox $page.a.2
    pack [frame $page.c] -side left -fill both -anchor n
    grid [frame $page.c.a -bd 2 -relief groove] -column 0 -row 0 -columnspan 2
    grid [label $page.c.a.l0 -text "Directory"] -column 0 -row 0 -sticky w
    grid [entry $page.c.a.e0 -textvariable command(pwd) -width 30] \
	    -column 0 -row 1 -columnspan 2
    grid [button $page.c.a.b0 -text Browse \
	    -command {set command(pwd) [getDirectory $command(pwd)]}\
	    ] -column 1 -row 0 -sticky e

    pack [frame $page.b] -side left -fill x -anchor n
    pack [frame $page.b.1 -bd 4 -relief groove] -side top -fill x -anchor n
    pack [label $page.b.1.0 -text "Values to write"] -side top
    pack [radiobutton $page.b.1.1 \
		-variable command(writeunits) -value 0 -text Original \
		-anchor w] -side top -fill x
    pack [radiobutton $page.b.1.2 \
		-variable command(writeunits) -value 1 -text "As modified" \
		-anchor w] -side top -fill x
    pack [frame $page.b.2 -bd 4 -relief groove] -side top -fill x -anchor n
    pack [checkbutton $page.b.2.0 \
	      -variable command(write_useSaveAs) \
	      -text "Prompt for file name"] -side top -fill x
    set num 1
    grid [label $page.c.l$num -text "File format"] -column 0 -row $num -sticky n
	grid [canvas $page.c.fmtbox \
	    -scrollregion {0 0 5000 500} -width 250 -height 250 \
	    -yscrollcommand "$page.c.yscroll set" -bg lightgrey] \
	    -sticky  news -row 1 -column 1
    grid [scrollbar $page.c.yscroll -orient vertical \
	    -command "$page.c.fmtbox yview"] \
	    -sticky ns -row 1 -column 2
    set writeformatbox [frame $page.c.fmtbox.f]
    $page.c.fmtbox create window 0 0 -anchor nw  -window $writeformatbox
    grid [frame $page.c.thing -bd 2 -relief groove] -column 3 -row 0 -sticky new
    grid columnconfigure $page 3 -weight 1
    set num 1
    foreach type $command(writetypes) \
	    cmd $command(writeproc) {
			grid [radiobutton $writeformatbox.$num \
				-variable command(writetype) -value $cmd -text $type \
				] -column 1 -row $num -sticky w
			if {$num == 1} {$writeformatbox.$num invoke}
			incr num
    }
    update
    #puts  [grid bbox $writeformatbox]
    $page.c.fmtbox config -scrollregion [grid bbox $writeformatbox]
    $page.c.fmtbox config -width [lindex  [grid bbox $writeformatbox] 2]
    grid rowconfigure $page.c $num -weight 1
    pack [button $page.a.do -command "WriteFiles $page.a.2" \
	    -text "Write Selected Datasets"] -side bottom -anchor c
#    $page.b.1 invoke
}

set command(pwd) [pwd]

proc PostPageWrite {page} {
    updateselectbox $page.a.2
} 

proc  WriteFiles {box} {
    global command
    if {$command(writetype) == ""} return
    # force a new file, if this is multiblock
    set command(gsas_filename) {}
    set writeproc $command(writetype)
    # get the files to write
    set datalist {}
    foreach num [$box.1 curselection ] {
	lappend datalist [$box.1 get $num]
    }
    if {[llength $datalist] == 0} {
	tk_dialog .msg "No files created" \
		"No files created" "" 0 OK
	return
    }
    # can the write routine handle a list of files?
    set listok 0
    catch {if {[lsearch $command($writeproc) listok] != -1} {set listok 1}}
    set filelist {}
    catch {
	if {$listok} {
	    set fileout [$writeproc $datalist]
	    foreach file $fileout {
		append filelist "\n  " $file
	    }
	} else {
	    foreach data $datalist {
		set file [$writeproc $data]
		if {[string trim $file] != ""} {append filelist "\n  " $file}
	    }
	}
    } msg
    if {[string trim $msg] == "" && $filelist == ""} {
	tk_dialog .msg "No files created" \
		"No files created" "" 0 OK
    } elseif {$msg == ""} {
	MyMessageBox -title "Files created" -type OK -default ok \
	    -message "Files created: $filelist"
    } elseif {$filelist == ""} {
	MyMessageBox -title "No Files Created" -type OK -default ok \
	    -message "No files created\nError(s): $msg"
    } else {
	MyMessageBox -title "Some Files Created" -type OK -default ok \
	    -message "Error(s): $msg\nSome Files created: $filelist"
    }
}
#------------------------------------------------------------------------------
# get a directory name
#------------------------------------------------------------------------------
proc getDirectory {"path {}"} {
    global DirMenuButton tcl_platform
    set frm .file
    catch {destroy $frm}
    toplevel $frm
    wm title $frm "Select a directory"
    pack [frame [set frmA $frm.1] -bd 2 -relief groove] -padx 3 -pady 3 -side left
    # create a file box
    set bx $frmA
    grid [label $bx.0 -text "Select a directory to use"] \
	    -column 0 -row 0 -columnspan 2
    grid [frame $bx.top] -column 0 -row 1 -columnspan 2
    pack [label $bx.top.a -text "Directory" ] -side left 
    if {[string trim $path] == ""} {
	set path [pwd]
    } elseif {$tcl_platform(platform) == "windows"} {
	# change backslashes to something sensible
	regsub -all {\\} $path / path
	# allow entry of D: for D:/ and D:TEST for d:/TEST
	if {[string first : $path] != -1 && \
		[string first :/ $path] == -1} {
	    regsub : $path :/ path
	}
    }
    set FileDirButtonMenu [tk_optionMenu $bx.top.d DirMenuButton $path]
    pack $bx.top.d -side left
    set DirMenuButton $path
    # the icon below is from tk8.0/tkfbox.tcl
    set upfolder [image create bitmap -data {
#define updir_width 28
#define updir_height 16
static char updir_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x80, 0x1f, 0x00, 0x00, 0x40, 0x20, 0x00, 0x00,
   0x20, 0x40, 0x00, 0x00, 0xf0, 0xff, 0xff, 0x01, 0x10, 0x00, 0x00, 0x01,
   0x10, 0x02, 0x00, 0x01, 0x10, 0x07, 0x00, 0x01, 0x90, 0x0f, 0x00, 0x01,
   0x10, 0x02, 0x00, 0x01, 0x10, 0x02, 0x00, 0x01, 0x10, 0x02, 0x00, 0x01,
   0x10, 0xfe, 0x07, 0x01, 0x10, 0x00, 0x00, 0x01, 0x10, 0x00, 0x00, 0x01,
   0xf0, 0xff, 0xff, 0x01};}]

    set cmd {set DirMenuButton [file dirname [set DirMenuButton]];}
    append cmd "DirSelChoose $bx $FileDirButtonMenu"
    pack [button $bx.top.b -image $upfolder \
	    -command $cmd]
    listbox $bx.files -relief raised -bd 2 \
	    -yscrollcommand "$bx.scroll set" \
	    -height 15 -width 0
    scrollbar $bx.scroll -command "$bx.files yview"
    DirSelChoose $bx $FileDirButtonMenu
    bind $bx.files <ButtonRelease-1> "DirSelRelease $bx $FileDirButtonMenu"
    grid $bx.files -column 0 -row 2 -sticky news
    grid columnconfig $bx 0 -weight 1
    grid rowconfig $bx 2 -weight 1
    grid $bx.scroll -column 1 -row 2 -sticky ns
    grid [button $bx.c -command "destroy .file" -text OK] -column 0 -row 3 -columnspan 2
    # force the window to stay on top
    putontop $frm
    tkwait window $frm
    afterputontop
    return $DirMenuButton
}

# set the box or file in the selection window
proc DirSelRelease {frm FileDirButtonMenu} {
    global DirMenuButton
    set files $frm.files
    set select [$files curselection]
    if {$select == ""} return
#    set select [lindex [$files get $select] 0]
    set select [$files get $select]
    if {[string range $select end end] == "/"} {
	set l [string length $select]
	set select [string range $select 0 [incr l -1]]
    }
    if {$select == "<Parent>"} {
	set DirMenuButton [file dirname $DirMenuButton]
	DirSelChoose $frm $FileDirButtonMenu
    } elseif [file isdirectory \
	    [set newfile [file join [set DirMenuButton] $select]]] {
	if {$select != "."} {
	    set DirMenuButton $newfile
	    DirSelChoose $frm $FileDirButtonMenu
	}
    }
    return
}

# fill the files & dates & Directory selection box with current directory,
# also called when selection box is created to fill it
proc DirSelChoose {frm FileDirButtonMenu} {
    global DirMenuButton
    set files $frm.files
    $files delete 0 end
    $files insert end "<Parent>"
    set filelist [glob -nocomplain \
	    [file join [set DirMenuButton] *] ]
    foreach file [lsort -dictionary $filelist] {
	if {[file isdirectory $file]} {
	    $files insert end "[file tail $file]/"
	}
    }
    $files insert end "---------"
    # show all the files, even if we do noththing with them
    foreach file [lsort -dictionary $filelist] {
	if {![file isdirectory $file]} {
	    $files insert end [file tail $file]
	}
    }
    $FileDirButtonMenu delete 0 end
    set list ""
    set dir ""
    foreach subdir [file split [set DirMenuButton]] {
	set dir [file join $dir $subdir]
	if {[file exists $dir]} {lappend list $dir}
    }
    # for windows, add the list of local drives
    if {$::tcl_platform(platform) == "windows"} {
	foreach item [file volumes] {
	    lappend list $item
	}
    }

    foreach path $list {
	$FileDirButtonMenu add command -label $path \
		-command "[list set DirMenuButton $path]; \
		DirSelChoose $frm $FileDirButtonMenu"
    }
    return
}

proc putontop {w} {
    # center window $w above its parent and make it stay on top
    set wp [winfo parent $w]
    wm transient $w [winfo toplevel $wp]
    wm withdraw $w
    update idletasks
    # center the new window in the middle of the parent
    set x [expr [winfo x $wp] + [winfo width $wp]/2 - \
	    [winfo reqwidth $w]/2 - [winfo vrootx $wp]]
    if {$x < 0} {set x 0}
    set xborder 10
    if {$x+[winfo reqwidth $w] +$xborder > [winfo screenwidth $w]} {
	incr x [expr \
		[winfo screenwidth $w] - ($x+[winfo reqwidth $w] + $xborder)]
    }
    set y [expr [winfo y $wp] + [winfo height $wp]/2 - \
	    [winfo reqheight $w]/2 - [winfo vrooty $wp]]
    if {$y < 0} {set y 0}
    set yborder 25
    if {$y+[winfo reqheight $w] +$yborder > [winfo screenheight $w]} {
	incr y [expr \
		[winfo screenheight $w] - ($y+[winfo reqheight $w] + $yborder)]
    }
    wm geom $w +$x+$y
    wm deiconify $w

    global makenew
    set makenew(OldFocus) [focus]
    catch {
	set makenew(OldGrab) [grab current $w]
	if {$makenew(OldGrab) != ""} {
	    set makenew(GrabStatus) [grab status $makenew(OldGrab)]
	}
	grab $w
    }
}

proc afterputontop {} {
    # restore focus
    global makenew
    catch {focus $makenew(OldFocus)}
    if {$makenew(OldGrab) != ""} {
	catch {
	    if {$makenew(GrabStatus) == "global"} {
		grab -global $makenew(OldGrab)
	    } else {
		grab $makenew(OldGrab)
	    }
        }
    }
}
